/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.renderer;

import java.util.ArrayList;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.renderer.RenderingUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;

public interface ClassifierNamePolicy {
    public String renderClassifier(ClassifierDescriptor var1, DescriptorRenderer var2);

    public static final class FULLY_QUALIFIED
    implements ClassifierNamePolicy {
        public static final FULLY_QUALIFIED INSTANCE = new FULLY_QUALIFIED();

        private FULLY_QUALIFIED() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final String renderClassifier(ClassifierDescriptor classifier, DescriptorRenderer renderer) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)classifier, (String)"classifier");
            Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
            if (classifier instanceof TypeParameterDescriptor) {
                Name name = ((TypeParameterDescriptor)classifier).getName();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"getName(...)");
                return renderer.renderName(name, false);
            }
            FqNameUnsafe fqNameUnsafe = DescriptorUtils.getFqName((DeclarationDescriptor)var1_1);
            Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"getFqName(...)");
            return var2_2.renderFqName(fqNameUnsafe);
        }
    }

    public static final class SHORT
    implements ClassifierNamePolicy {
        public static final SHORT INSTANCE = new SHORT();

        private SHORT() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final String renderClassifier(ClassifierDescriptor classifier, DescriptorRenderer renderer) {
            void var2_2;
            Intrinsics.checkNotNullParameter((Object)classifier, (String)"classifier");
            Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
            if (classifier instanceof TypeParameterDescriptor) {
                Name name = ((TypeParameterDescriptor)classifier).getName();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"getName(...)");
                return renderer.renderName(name, false);
            }
            ArrayList<Name> qualifiedNameElements = new ArrayList<Name>();
            DeclarationDescriptor current = classifier;
            do {
                qualifiedNameElements.add(current.getName());
            } while ((current = current.getContainingDeclaration()) instanceof ClassDescriptor);
            return RenderingUtilsKt.renderFqName(CollectionsKt.asReversedMutable((List)((List)var2_2)));
        }
    }

    public static final class SOURCE_CODE_QUALIFIED
    implements ClassifierNamePolicy {
        public static final SOURCE_CODE_QUALIFIED INSTANCE = new SOURCE_CODE_QUALIFIED();

        private SOURCE_CODE_QUALIFIED() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final String renderClassifier(ClassifierDescriptor classifier, DescriptorRenderer renderer) {
            void var1_1;
            void var2_2;
            Intrinsics.checkNotNullParameter((Object)classifier, (String)"classifier");
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"renderer");
            return this.qualifiedNameForSourceCode((ClassifierDescriptor)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private final String qualifiedNameForSourceCode(ClassifierDescriptor descriptor2) {
            void var2_2;
            Name name = descriptor2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"getName(...)");
            String nameString = RenderingUtilsKt.render(name);
            if (descriptor2 instanceof TypeParameterDescriptor) {
                return nameString;
            }
            DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
            String qualifier = this.qualifierName(declarationDescriptor);
            if (qualifier != null && !Intrinsics.areEqual((Object)qualifier, (Object)"")) {
                void var1_1;
                return (String)var1_1 + '.' + nameString;
            }
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        private final String qualifierName(DeclarationDescriptor descriptor2) {
            DeclarationDescriptor declarationDescriptor = descriptor2;
            if (declarationDescriptor instanceof ClassDescriptor) {
                return this.qualifiedNameForSourceCode((ClassifierDescriptor)descriptor2);
            }
            if (declarationDescriptor instanceof PackageFragmentDescriptor) {
                void var1_1;
                FqNameUnsafe fqNameUnsafe = ((PackageFragmentDescriptor)var1_1).getFqName().toUnsafe();
                Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"toUnsafe(...)");
                return RenderingUtilsKt.render(fqNameUnsafe);
            }
            return null;
        }
    }
}

