/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.protobuf;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import kotlin.reflect.jvm.internal.impl.protobuf.FieldSet;

class SmallSortedMap<K extends Comparable<K>, V>
extends AbstractMap<K, V> {
    private final int maxArraySize;
    private List<Entry> entryList;
    private Map<K, V> overflowEntries;
    private boolean isImmutable;
    private volatile EntrySet lazyEntrySet;

    static <FieldDescriptorType extends FieldSet.FieldDescriptorLite<FieldDescriptorType>> SmallSortedMap<FieldDescriptorType, Object> newFieldMap(int arraySize) {
        int n;
        return new SmallSortedMap<FieldDescriptorType, Object>(n){
            {
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void makeImmutable() {
                if (!this.isImmutable()) {
                    List value;
                    for (int i = 0; i < this.getNumArrayEntries(); ++i) {
                        Map.Entry entry = this.getArrayEntryAt(i);
                        if (!((FieldSet.FieldDescriptorLite)entry.getKey()).isRepeated()) continue;
                        value = (List)entry.getValue();
                        entry.setValue(Collections.unmodifiableList(value));
                    }
                    for (Map.Entry entry : this.getOverflowEntries()) {
                        void var3_6;
                        if (!((FieldSet.FieldDescriptorLite)entry.getKey()).isRepeated()) continue;
                        value = (List)entry.getValue();
                        entry.setValue(Collections.unmodifiableList(var3_6));
                    }
                }
                super.makeImmutable();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private SmallSortedMap(int arraySize) {
        void var1_1;
        this.maxArraySize = var1_1;
        this.entryList = Collections.emptyList();
        this.overflowEntries = Collections.emptyMap();
    }

    public void makeImmutable() {
        if (!this.isImmutable) {
            this.overflowEntries = this.overflowEntries.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(this.overflowEntries);
            this.isImmutable = true;
        }
    }

    public boolean isImmutable() {
        return this.isImmutable;
    }

    public int getNumArrayEntries() {
        return this.entryList.size();
    }

    /*
     * WARNING - void declaration
     */
    public Map.Entry<K, V> getArrayEntryAt(int index) {
        void var1_1;
        return this.entryList.get((int)var1_1);
    }

    public Iterable<Map.Entry<K, V>> getOverflowEntries() {
        if (this.overflowEntries.isEmpty()) {
            return EmptySet.iterable();
        }
        return this.overflowEntries.entrySet();
    }

    @Override
    public int size() {
        return this.entryList.size() + this.overflowEntries.size();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsKey(Object o) {
        void var1_1;
        Comparable key = (Comparable)o;
        return this.binarySearchInArray(key) >= 0 || this.overflowEntries.containsKey(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V get(Object o) {
        void var1_1;
        Comparable key = (Comparable)o;
        int index = this.binarySearchInArray(key);
        if (index >= 0) {
            void var2_2;
            return this.entryList.get((int)var2_2).getValue();
        }
        return this.overflowEntries.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V put(K key, V value) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.checkMutable();
        int index = this.binarySearchInArray(key);
        if (index >= 0) {
            return this.entryList.get(index).setValue(value);
        }
        this.ensureEntryArrayMutable();
        int insertionPoint = -(index + 1);
        if (insertionPoint >= this.maxArraySize) {
            return this.getOverflowEntriesMutable().put(key, value);
        }
        if (this.entryList.size() == this.maxArraySize) {
            Entry lastEntryInArray = this.entryList.remove(this.maxArraySize - 1);
            this.getOverflowEntriesMutable().put(lastEntryInArray.getKey(), lastEntryInArray.getValue());
        }
        this.entryList.add((int)var3_3, new Entry(this, (Comparable)var1_1, (Object)var2_2));
        return null;
    }

    @Override
    public void clear() {
        this.checkMutable();
        if (!this.entryList.isEmpty()) {
            this.entryList.clear();
        }
        if (!this.overflowEntries.isEmpty()) {
            this.overflowEntries.clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V remove(Object o) {
        void var1_1;
        this.checkMutable();
        Comparable key = (Comparable)o;
        int index = this.binarySearchInArray(key);
        if (index >= 0) {
            void var2_2;
            return this.removeArrayEntryAt((int)var2_2);
        }
        if (this.overflowEntries.isEmpty()) {
            return null;
        }
        return this.overflowEntries.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private V removeArrayEntryAt(int index) {
        void var1_2;
        this.checkMutable();
        Object removed = this.entryList.remove(index).getValue();
        if (!this.overflowEntries.isEmpty()) {
            void var2_3;
            Iterator<Map.Entry<K, V>> iterator2 = this.getOverflowEntriesMutable().entrySet().iterator();
            this.entryList.add(new Entry(this, iterator2.next()));
            var2_3.remove();
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    private int binarySearchInArray(K key) {
        void var2_2;
        int left = 0;
        int right = this.entryList.size() - 1;
        if (right >= 0) {
            int cmp = key.compareTo((Object)this.entryList.get(right).getKey());
            if (cmp > 0) {
                return -(right + 2);
            }
            if (cmp == 0) {
                return right;
            }
        }
        while (left <= right) {
            int mid = (left + right) / 2;
            int cmp = key.compareTo((Object)this.entryList.get(mid).getKey());
            if (cmp < 0) {
                right = mid - 1;
                continue;
            }
            if (cmp > 0) {
                left = mid + 1;
                continue;
            }
            return mid;
        }
        return (int)(-(var2_2 + true));
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.lazyEntrySet == null) {
            this.lazyEntrySet = new EntrySet();
        }
        return this.lazyEntrySet;
    }

    private void checkMutable() {
        if (this.isImmutable) {
            throw new UnsupportedOperationException();
        }
    }

    private SortedMap<K, V> getOverflowEntriesMutable() {
        this.checkMutable();
        if (this.overflowEntries.isEmpty() && !(this.overflowEntries instanceof TreeMap)) {
            this.overflowEntries = new TreeMap();
        }
        return (SortedMap)this.overflowEntries;
    }

    private void ensureEntryArrayMutable() {
        this.checkMutable();
        if (this.entryList.isEmpty() && !(this.entryList instanceof ArrayList)) {
            this.entryList = new ArrayList<Entry>(this.maxArraySize);
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Object access$500(SmallSortedMap x0, int x1) {
        void var1_1;
        return x0.removeArrayEntryAt((int)var1_1);
    }

    private static class EmptySet {
        private static final Iterator<Object> ITERATOR = new Iterator<Object>(){

            @Override
            public final boolean hasNext() {
                return false;
            }

            @Override
            public final Object next() {
                throw new NoSuchElementException();
            }

            @Override
            public final void remove() {
                throw new UnsupportedOperationException();
            }
        };
        private static final Iterable<Object> ITERABLE = new Iterable<Object>(){

            @Override
            public final Iterator<Object> iterator() {
                return ITERATOR;
            }
        };

        static <T> Iterable<T> iterable() {
            return ITERABLE;
        }
    }

    private class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private int pos = -1;
        private boolean nextCalledBeforeRemove;
        private Iterator<Map.Entry<K, V>> lazyOverflowIterator;

        private EntryIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pos + 1 < SmallSortedMap.this.entryList.size() || this.getOverflowIterator().hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            this.nextCalledBeforeRemove = true;
            if (++this.pos < SmallSortedMap.this.entryList.size()) {
                return (Map.Entry)SmallSortedMap.this.entryList.get(this.pos);
            }
            return this.getOverflowIterator().next();
        }

        @Override
        public void remove() {
            if (!this.nextCalledBeforeRemove) {
                throw new IllegalStateException("remove() was called before next()");
            }
            this.nextCalledBeforeRemove = false;
            SmallSortedMap.this.checkMutable();
            if (this.pos < SmallSortedMap.this.entryList.size()) {
                SmallSortedMap.access$500(SmallSortedMap.this, this.pos--);
                return;
            }
            this.getOverflowIterator().remove();
        }

        private Iterator<Map.Entry<K, V>> getOverflowIterator() {
            if (this.lazyOverflowIterator == null) {
                this.lazyOverflowIterator = SmallSortedMap.this.overflowEntries.entrySet().iterator();
            }
            return this.lazyOverflowIterator;
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public int size() {
            return SmallSortedMap.this.size();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object o) {
            void var1_1;
            void var2_2;
            Object value;
            Map.Entry entry = (Map.Entry)o;
            Object existing = SmallSortedMap.this.get(entry.getKey());
            return existing == (value = entry.getValue()) || existing != null && var2_2.equals(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean add(Map.Entry<K, V> entry) {
            if (!this.contains(entry)) {
                void var1_1;
                SmallSortedMap.this.put((Comparable)entry.getKey(), var1_1.getValue());
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean remove(Object o) {
            Map.Entry entry = (Map.Entry)o;
            if (this.contains(entry)) {
                void var1_1;
                SmallSortedMap.this.remove(var1_1.getKey());
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            SmallSortedMap.this.clear();
        }
    }

    private static class Entry
    implements Comparable<Entry>,
    Map.Entry<K, V> {
        private final K key;
        private V value;
        final /* synthetic */ SmallSortedMap this$0;

        /*
         * WARNING - void declaration
         */
        Entry(SmallSortedMap smallSortedMap, Map.Entry<K, V> copy) {
            this(smallSortedMap, (Comparable)copy.getKey(), var2_2.getValue());
            void var2_2;
        }

        /*
         * WARNING - void declaration
         */
        Entry(K key, V value) {
            void var3_3;
            void var2_2;
            this.this$0 = var1_1;
            this.key = var2_2;
            this.value = var3_3;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int compareTo(Entry other) {
            void var1_1;
            return this.getKey().compareTo(var1_1.getKey());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V setValue(V newValue) {
            void var2_2;
            void var1_1;
            this.this$0.checkMutable();
            Object oldValue = this.value;
            this.value = var1_1;
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry other = (Map.Entry)o;
            Entry entry = this;
            if (entry.equals(entry.key, other.getKey())) {
                void var1_1;
                Entry entry2 = this;
                if (entry2.equals(entry2.value, var1_1.getValue())) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            String string = String.valueOf(String.valueOf(this.key));
            String string2 = String.valueOf(String.valueOf(this.value));
            return new StringBuilder(1 + string.length() + string2.length()).append(string).append("=").append(string2).toString();
        }

        /*
         * WARNING - void declaration
         */
        private boolean equals(Object o1, Object o2) {
            void var2_2;
            void var1_1;
            if (o1 == null) {
                return o2 == null;
            }
            return var1_1.equals(var2_2);
        }
    }
}

