/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.protobuf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import kotlin.reflect.jvm.internal.impl.protobuf.ByteString;
import kotlin.reflect.jvm.internal.impl.protobuf.CodedInputStream;
import kotlin.reflect.jvm.internal.impl.protobuf.LiteralByteString;

class RopeByteString
extends ByteString {
    private static final int[] minLengthByDepth;
    private final int totalLength;
    private final ByteString left;
    private final ByteString right;
    private final int leftLength;
    private final int treeDepth;
    private int hash = 0;

    /*
     * WARNING - void declaration
     */
    private RopeByteString(ByteString left, ByteString right) {
        void var2_2;
        void var1_1;
        this.left = left;
        this.right = right;
        this.leftLength = left.size();
        this.totalLength = this.leftLength + right.size();
        this.treeDepth = Math.max(var1_1.getTreeDepth(), var2_2.getTreeDepth()) + 1;
    }

    /*
     * WARNING - void declaration
     */
    static ByteString concatenate(ByteString left, ByteString right) {
        ByteString byteString;
        RopeByteString leftRope;
        RopeByteString ropeByteString = leftRope = left instanceof RopeByteString ? (RopeByteString)left : null;
        if (right.size() != 0) {
            ByteString result;
            if (result.size() == 0) {
                result = right;
            } else {
                int newLength = result.size() + right.size();
                if (newLength < 128) {
                    result = RopeByteString.concatenateBytes(result, right);
                } else if (leftRope != null && leftRope.right.size() + right.size() < 128) {
                    LiteralByteString newRight = RopeByteString.concatenateBytes(leftRope.right, right);
                    result = new RopeByteString(leftRope.left, newRight);
                } else if (leftRope != null && leftRope.left.getTreeDepth() > leftRope.right.getTreeDepth() && leftRope.getTreeDepth() > right.getTreeDepth()) {
                    void var2_2;
                    RopeByteString newRight = new RopeByteString(leftRope.right, right);
                    result = new RopeByteString(var2_2.left, newRight);
                } else {
                    void var1_1;
                    void var3_3;
                    int newDepth = Math.max(result.getTreeDepth(), right.getTreeDepth()) + 1;
                    result = var3_3 >= minLengthByDepth[newDepth] ? new RopeByteString(result, right) : Balancer.access$100(new Balancer(), result, (ByteString)var1_1);
                }
            }
        }
        return byteString;
    }

    /*
     * WARNING - void declaration
     */
    private static LiteralByteString concatenateBytes(ByteString left, ByteString right) {
        void var3_3;
        void var2_2;
        void var1_1;
        ByteString byteString;
        int leftSize = left.size();
        int rightSize = right.size();
        byte[] bytes = new byte[leftSize + rightSize];
        byteString.copyTo(bytes, 0, 0, leftSize);
        var1_1.copyTo(bytes, 0, (int)var2_2, (int)var3_3);
        return new LiteralByteString(bytes);
    }

    @Override
    public int size() {
        return this.totalLength;
    }

    @Override
    protected int getTreeDepth() {
        return this.treeDepth;
    }

    @Override
    protected boolean isBalanced() {
        return this.totalLength >= minLengthByDepth[this.treeDepth];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void copyToInternal(byte[] target, int sourceOffset, int targetOffset, int numberToCopy) {
        void var3_3;
        void var1_1;
        void var2_2;
        if (sourceOffset + numberToCopy <= this.leftLength) {
            this.left.copyToInternal(target, sourceOffset, targetOffset, numberToCopy);
            return;
        }
        if (sourceOffset >= this.leftLength) {
            this.right.copyToInternal(target, sourceOffset - this.leftLength, targetOffset, numberToCopy);
            return;
        }
        int leftLength = this.leftLength - sourceOffset;
        this.left.copyToInternal(target, (int)var2_2, targetOffset, leftLength);
        this.right.copyToInternal((byte[])var1_1, 0, (int)(var3_3 + leftLength), numberToCopy - leftLength);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void writeToInternal(OutputStream out, int sourceOffset, int numberToWrite) throws IOException {
        void var3_3;
        void var1_1;
        void var2_2;
        if (sourceOffset + numberToWrite <= this.leftLength) {
            this.left.writeToInternal(out, sourceOffset, numberToWrite);
            return;
        }
        if (sourceOffset >= this.leftLength) {
            this.right.writeToInternal(out, sourceOffset - this.leftLength, numberToWrite);
            return;
        }
        int numberToWriteInLeft = this.leftLength - sourceOffset;
        this.left.writeToInternal(out, (int)var2_2, numberToWriteInLeft);
        this.right.writeToInternal((OutputStream)var1_1, 0, (int)(var3_3 - numberToWriteInLeft));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toString(String charsetName) throws UnsupportedEncodingException {
        void var1_1;
        return new String(this.toByteArray(), (String)var1_1);
    }

    @Override
    public boolean isValidUtf8() {
        int n;
        int leftPartial = this.left.partialIsValidUtf8(0, 0, this.leftLength);
        return (n = this.right.partialIsValidUtf8(n, 0, this.right.size())) == 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int partialIsValidUtf8(int state, int offset, int length) {
        void var3_3;
        void var1_1;
        void var2_2;
        int n = offset + length;
        if (n <= this.leftLength) {
            return this.left.partialIsValidUtf8(state, offset, length);
        }
        if (offset >= this.leftLength) {
            return this.right.partialIsValidUtf8(state, offset - this.leftLength, length);
        }
        int leftLength = this.leftLength - offset;
        int leftPartial = this.left.partialIsValidUtf8(state, (int)var2_2, leftLength);
        return this.right.partialIsValidUtf8((int)var1_1, 0, (int)(var3_3 - leftLength));
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object other) {
        void var1_1;
        void var2_2;
        int cachedOtherHash;
        if (other == this) {
            return true;
        }
        if (!(other instanceof ByteString)) {
            return false;
        }
        ByteString otherByteString = (ByteString)other;
        if (this.totalLength != otherByteString.size()) {
            return false;
        }
        if (this.totalLength == 0) {
            return true;
        }
        if (this.hash != 0 && (cachedOtherHash = otherByteString.peekCachedHashCode()) != 0 && this.hash != var2_2) {
            return false;
        }
        return this.equalsFragments((ByteString)var1_1);
    }

    private boolean equalsFragments(ByteString other) {
        int thisOffset = 0;
        PieceIterator thisIter = new PieceIterator(this);
        LiteralByteString thisString = (LiteralByteString)thisIter.next();
        int thatOffset = 0;
        PieceIterator thatIter = new PieceIterator(other);
        LiteralByteString thatString = (LiteralByteString)thatIter.next();
        int pos = 0;
        while (true) {
            int thisRemaining = ((ByteString)thisString).size() - thisOffset;
            int thatRemaining = ((ByteString)thatString).size() - thatOffset;
            int bytesToCompare = Math.min(thisRemaining, thatRemaining);
            boolean bl = thisOffset == 0 ? thisString.equalsRange(thatString, thatOffset, bytesToCompare) : thatString.equalsRange(thisString, thisOffset, bytesToCompare);
            if (!bl) {
                return false;
            }
            if ((pos += bytesToCompare) >= this.totalLength) {
                if (pos == this.totalLength) {
                    return true;
                }
                throw new IllegalStateException();
            }
            if (bytesToCompare == thisRemaining) {
                thisOffset = 0;
                thisString = (LiteralByteString)thisIter.next();
            } else {
                thisOffset += bytesToCompare;
            }
            if (bytesToCompare == thatRemaining) {
                thatOffset = 0;
                thatString = (LiteralByteString)thatIter.next();
                continue;
            }
            thatOffset += bytesToCompare;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int h = this.hash;
        if (h == 0) {
            h = this.totalLength;
            if ((h = this.partialHash(h, 0, this.totalLength)) == 0) {
                h = 1;
            }
            this.hash = h;
        }
        return (int)var1_1;
    }

    @Override
    protected int peekCachedHashCode() {
        return this.hash;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int partialHash(int h, int offset, int length) {
        void var3_3;
        void var1_1;
        void var2_2;
        int n = offset + length;
        if (n <= this.leftLength) {
            return this.left.partialHash(h, offset, length);
        }
        if (offset >= this.leftLength) {
            return this.right.partialHash(h, offset - this.leftLength, length);
        }
        int leftLength = this.leftLength - offset;
        int leftPartial = this.left.partialHash(h, (int)var2_2, leftLength);
        return this.right.partialHash((int)var1_1, 0, (int)(var3_3 - leftLength));
    }

    @Override
    public CodedInputStream newCodedInput() {
        return CodedInputStream.newInstance(new RopeInputStream());
    }

    @Override
    public ByteString.ByteIterator iterator() {
        return new RopeByteIterator();
    }

    static {
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        int f1 = 1;
        int f2 = 1;
        while (f2 > 0) {
            numbers.add(f2);
            int temp = f1 + f2;
            f1 = f2;
            f2 = temp;
        }
        numbers.add(Integer.MAX_VALUE);
        minLengthByDepth = new int[numbers.size()];
        for (int i = 0; i < minLengthByDepth.length; ++i) {
            RopeByteString.minLengthByDepth[i] = (Integer)numbers.get(i);
        }
    }

    private class RopeInputStream
    extends InputStream {
        private PieceIterator pieceIterator;
        private LiteralByteString currentPiece;
        private int currentPieceSize;
        private int currentPieceIndex;
        private int currentPieceOffsetInRope;
        private int mark;

        public RopeInputStream() {
            this.initialize();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int read(byte[] b, int offset, int length) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (b == null) {
                throw new NullPointerException();
            }
            if (offset < 0 || length < 0 || length > b.length - offset) {
                throw new IndexOutOfBoundsException();
            }
            return this.readSkipInternal((byte[])var1_1, (int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public long skip(long length) {
            void var1_1;
            if (length < 0L) {
                throw new IndexOutOfBoundsException();
            }
            if (length > Integer.MAX_VALUE) {
                length = Integer.MAX_VALUE;
            }
            return this.readSkipInternal(null, 0, (int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private int readSkipInternal(byte[] b, int offset, int length) {
            void var3_3;
            int bytesRemaining;
            int count;
            for (bytesRemaining = length; bytesRemaining > 0; bytesRemaining -= count) {
                this.advanceIfCurrentPieceFullyRead();
                if (this.currentPiece == null) {
                    if (bytesRemaining != length) break;
                    return -1;
                }
                int n = this.currentPieceSize - this.currentPieceIndex;
                count = Math.min(n, bytesRemaining);
                if (b != null) {
                    this.currentPiece.copyTo(b, this.currentPieceIndex, offset, count);
                    offset += count;
                }
                this.currentPieceIndex += count;
            }
            return (int)(var3_3 - bytesRemaining);
        }

        @Override
        public int read() throws IOException {
            this.advanceIfCurrentPieceFullyRead();
            if (this.currentPiece == null) {
                return -1;
            }
            return this.currentPiece.byteAt(this.currentPieceIndex++) & 0xFF;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int available() throws IOException {
            void var1_1;
            int bytesRead = this.currentPieceOffsetInRope + this.currentPieceIndex;
            return ((ByteString)RopeByteString.this).size() - var1_1;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public void mark(int readAheadLimit) {
            this.mark = this.currentPieceOffsetInRope + this.currentPieceIndex;
        }

        @Override
        public synchronized void reset() {
            this.initialize();
            this.readSkipInternal(null, 0, this.mark);
        }

        private void initialize() {
            this.pieceIterator = new PieceIterator(RopeByteString.this);
            this.currentPiece = this.pieceIterator.next();
            this.currentPieceSize = ((ByteString)this.currentPiece).size();
            this.currentPieceIndex = 0;
            this.currentPieceOffsetInRope = 0;
        }

        private void advanceIfCurrentPieceFullyRead() {
            if (this.currentPiece != null && this.currentPieceIndex == this.currentPieceSize) {
                this.currentPieceOffsetInRope += this.currentPieceSize;
                this.currentPieceIndex = 0;
                if (this.pieceIterator.hasNext()) {
                    this.currentPiece = this.pieceIterator.next();
                    this.currentPieceSize = ((ByteString)this.currentPiece).size();
                    return;
                }
                this.currentPiece = null;
                this.currentPieceSize = 0;
            }
        }
    }

    private class RopeByteIterator
    implements ByteString.ByteIterator {
        private final PieceIterator pieces;
        private ByteString.ByteIterator bytes;
        int bytesRemaining;

        private RopeByteIterator() {
            this.pieces = new PieceIterator(RopeByteString.this);
            this.bytes = ((ByteString)this.pieces.next()).iterator();
            this.bytesRemaining = ((ByteString)RopeByteString.this).size();
        }

        @Override
        public boolean hasNext() {
            return this.bytesRemaining > 0;
        }

        @Override
        public Byte next() {
            return this.nextByte();
        }

        @Override
        public byte nextByte() {
            if (!this.bytes.hasNext()) {
                this.bytes = ((ByteString)this.pieces.next()).iterator();
            }
            --this.bytesRemaining;
            return this.bytes.nextByte();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class PieceIterator
    implements Iterator<LiteralByteString> {
        private final Stack<RopeByteString> breadCrumbs = new Stack();
        private LiteralByteString next;

        /*
         * WARNING - void declaration
         */
        private PieceIterator(ByteString root) {
            void var1_1;
            this.next = this.getLeafByLeft((ByteString)var1_1);
        }

        private LiteralByteString getLeafByLeft(ByteString root) {
            ByteString byteString;
            ByteString pos = root;
            while (pos instanceof RopeByteString) {
                RopeByteString rbs = (RopeByteString)pos;
                this.breadCrumbs.push(rbs);
                byteString = ((RopeByteString)byteString).left;
            }
            return (LiteralByteString)byteString;
        }

        /*
         * WARNING - void declaration
         */
        private LiteralByteString getNextNonEmptyLeaf() {
            void var1_1;
            PieceIterator pieceIterator;
            LiteralByteString result;
            do {
                if (this.breadCrumbs.isEmpty()) {
                    return null;
                }
                pieceIterator = this;
            } while ((result = pieceIterator.getLeafByLeft(pieceIterator.breadCrumbs.pop().right)).isEmpty());
            return var1_1;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public LiteralByteString next() {
            void var1_1;
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            LiteralByteString result = this.next;
            this.next = this.getNextNonEmptyLeaf();
            return var1_1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class Balancer {
        private final Stack<ByteString> prefixesStack = new Stack();

        private Balancer() {
        }

        /*
         * WARNING - void declaration
         */
        private ByteString balance(ByteString left, ByteString right) {
            void var1_1;
            this.doBalance(left);
            this.doBalance(right);
            ByteString partialString = this.prefixesStack.pop();
            while (!this.prefixesStack.isEmpty()) {
                void var2_2;
                ByteString newLeft = this.prefixesStack.pop();
                partialString = new RopeByteString((ByteString)var2_2, partialString);
            }
            return var1_1;
        }

        private void doBalance(ByteString root) {
            String string;
            if (root.isBalanced()) {
                this.insert(root);
                return;
            }
            if (root instanceof RopeByteString) {
                RopeByteString rbs = (RopeByteString)root;
                this.doBalance(rbs.left);
                this.doBalance(((RopeByteString)((Object)string)).right);
                return;
            }
            string = String.valueOf(String.valueOf(string.getClass()));
            throw new IllegalArgumentException(new StringBuilder(49 + string.length()).append("Has a new type of ByteString been created? Found ").append(string).toString());
        }

        /*
         * WARNING - void declaration
         */
        private void insert(ByteString byteString) {
            void var1_1;
            int depthBin = this.getDepthBinForLength(byteString.size());
            int binEnd = minLengthByDepth[depthBin + 1];
            if (this.prefixesStack.isEmpty() || this.prefixesStack.peek().size() >= binEnd) {
                this.prefixesStack.push(byteString);
                return;
            }
            int binStart = minLengthByDepth[depthBin];
            ByteString newTree = this.prefixesStack.pop();
            while (!this.prefixesStack.isEmpty() && this.prefixesStack.peek().size() < binStart) {
                ByteString left = this.prefixesStack.pop();
                newTree = new RopeByteString(left, newTree);
            }
            newTree = new RopeByteString(newTree, (ByteString)var1_1);
            while (!this.prefixesStack.isEmpty()) {
                void var3_5;
                int n = this.getDepthBinForLength(newTree.size());
                int left = minLengthByDepth[n + 1];
                if (this.prefixesStack.peek().size() >= left) break;
                ByteString left2 = this.prefixesStack.pop();
                newTree = new RopeByteString((ByteString)var3_5, newTree);
            }
            this.prefixesStack.push(newTree);
        }

        /*
         * WARNING - void declaration
         */
        private int getDepthBinForLength(int length) {
            void var1_1;
            int depth = Arrays.binarySearch(minLengthByDepth, length);
            if (depth < 0) {
                depth = -(depth + 1);
                --depth;
            }
            return (int)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ ByteString access$100(Balancer x0, ByteString x1, ByteString x2) {
            void var2_2;
            void var1_1;
            return x0.balance((ByteString)var1_1, (ByteString)var2_2);
        }
    }
}

