/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.protobuf;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import kotlin.reflect.jvm.internal.impl.protobuf.ByteString;
import kotlin.reflect.jvm.internal.impl.protobuf.Internal;
import kotlin.reflect.jvm.internal.impl.protobuf.LazyStringList;
import kotlin.reflect.jvm.internal.impl.protobuf.UnmodifiableLazyStringList;

public class LazyStringArrayList
extends AbstractList<String>
implements RandomAccess,
LazyStringList {
    public static final LazyStringList EMPTY = new LazyStringArrayList().getUnmodifiableView();
    private final List<Object> list;

    public LazyStringArrayList() {
        this.list = new ArrayList<Object>();
    }

    /*
     * WARNING - void declaration
     */
    public LazyStringArrayList(LazyStringList from) {
        void var1_1;
        this.list = new ArrayList<Object>(from.size());
        this.addAll((Collection<? extends String>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String get(int index) {
        void var3_4;
        void var2_2;
        ByteString bs;
        Object o = this.list.get(index);
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof ByteString) {
            bs = (ByteString)o;
            String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
                this.list.set(index, s);
            }
            return s;
        }
        byte[] ba = (byte[])bs;
        String s = Internal.toStringUtf8(ba);
        if (Internal.isValidUtf8((byte[])var2_2)) {
            void var1_1;
            this.list.set((int)var1_1, s);
        }
        return var3_4;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String set(int index, String s) {
        void var2_3;
        void var1_1;
        Object object = this.list.set((int)var1_1, var2_3);
        return LazyStringArrayList.asString(object);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void add(int index, String element) {
        void var2_2;
        void var1_1;
        this.list.add((int)var1_1, var2_2);
        ++this.modCount;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAll(Collection<? extends String> c) {
        void var1_1;
        LazyStringArrayList lazyStringArrayList = this;
        return lazyStringArrayList.addAll(lazyStringArrayList.size(), (Collection<? extends String>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAll(int index, Collection<? extends String> c) {
        void var1_1;
        void var2_2;
        void collection;
        collection = c instanceof LazyStringList ? ((LazyStringList)c).getUnderlyingElements() : collection;
        boolean ret = this.list.addAll(index, (Collection<Object>)var2_2);
        ++this.modCount;
        return (boolean)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String remove(int index) {
        void var1_2;
        Object o = this.list.remove(index);
        ++this.modCount;
        return LazyStringArrayList.asString(var1_2);
    }

    @Override
    public void clear() {
        this.list.clear();
        ++this.modCount;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void add(ByteString element) {
        void var1_1;
        this.list.add(var1_1);
        ++this.modCount;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteString getByteString(int index) {
        void var3_3;
        void var2_2;
        Object o = this.list.get(index);
        ByteString b = LazyStringArrayList.asByteString(o);
        if (b != var2_2) {
            void var1_1;
            this.list.set((int)var1_1, b);
        }
        return var3_3;
    }

    private static String asString(Object o) {
        Object object;
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof ByteString) {
            return ((ByteString)o).toStringUtf8();
        }
        return Internal.toStringUtf8((byte[])object);
    }

    private static ByteString asByteString(Object o) {
        Object object;
        if (o instanceof ByteString) {
            return (ByteString)o;
        }
        if (o instanceof String) {
            return ByteString.copyFromUtf8((String)o);
        }
        return ByteString.copyFrom((byte[])object);
    }

    @Override
    public List<?> getUnderlyingElements() {
        return Collections.unmodifiableList(this.list);
    }

    @Override
    public LazyStringList getUnmodifiableView() {
        return new UnmodifiableLazyStringList(this);
    }
}

