/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.protobuf;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import kotlin.reflect.jvm.internal.impl.protobuf.CodedInputStream;
import kotlin.reflect.jvm.internal.impl.protobuf.Internal;
import kotlin.reflect.jvm.internal.impl.protobuf.LiteralByteString;
import kotlin.reflect.jvm.internal.impl.protobuf.RopeByteString;

public abstract class ByteString
implements Iterable<Byte> {
    public static final ByteString EMPTY = new LiteralByteString(new byte[0]);

    ByteString() {
    }

    public abstract ByteIterator iterator();

    public abstract int size();

    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - void declaration
     */
    public static ByteString copyFrom(byte[] bytes, int offset, int size) {
        void var3_3;
        void var2_2;
        void var1_1;
        byte[] byArray;
        byte[] copy = new byte[size];
        System.arraycopy(byArray, (int)var1_1, copy, 0, (int)var2_2);
        return new LiteralByteString((byte[])var3_3);
    }

    public static ByteString copyFrom(byte[] bytes) {
        byte[] byArray;
        return ByteString.copyFrom(bytes, 0, byArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static ByteString copyFromUtf8(String text) {
        try {
            return new LiteralByteString(text.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            void var0_1;
            throw new RuntimeException("UTF-8 not supported?", (Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public ByteString concat(ByteString other2) {
        void var1_1;
        int otherSize;
        int thisSize = this.size();
        if ((long)thisSize + (long)(otherSize = other2.size()) >= Integer.MAX_VALUE) {
            void var3_4;
            void var2_3;
            void other2 = var2_3;
            var2_3 = var3_4;
            throw new IllegalArgumentException(new StringBuilder(53).append("ByteString would be too long: ").append((int)other2).append("+").append((int)var2_3).toString());
        }
        return RopeByteString.concatenate(this, (ByteString)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static ByteString copyFrom(Iterable<ByteString> byteStrings) {
        ByteString byteString;
        void var1_1;
        ArrayList<void> collection;
        if (!(byteStrings instanceof Collection)) {
            collection = new ArrayList<void>();
            for (ByteString byteString2 : byteStrings) {
                void var2_2;
                collection.add(var2_2);
            }
        } else {
            ByteString i$;
            collection = (ArrayList<void>)((Object)i$);
        }
        ByteString result = collection.isEmpty() ? EMPTY : ByteString.balancedConcat(collection.iterator(), var1_1.size());
        return byteString;
    }

    /*
     * WARNING - void declaration
     */
    private static ByteString balancedConcat(Iterator<ByteString> iterator2, int length) {
        ByteString byteString;
        ByteString result;
        assert (length > 0);
        if (length == 1) {
            result = iterator2.next();
        } else {
            void var3_3;
            void var2_2;
            void var1_1;
            int halfLength = length >>> 1;
            ByteString left = ByteString.balancedConcat((Iterator<ByteString>)((Object)result), halfLength);
            ByteString right = ByteString.balancedConcat((Iterator<ByteString>)((Object)result), (int)(var1_1 - var2_2));
            result = var3_3.concat(right);
        }
        return byteString;
    }

    /*
     * WARNING - void declaration
     */
    public void copyTo(byte[] target22, int sourceOffset, int targetOffset, int numberToCopy) {
        byte[] target22;
        if (sourceOffset < 0) {
            int target22 = sourceOffset;
            throw new IndexOutOfBoundsException(new StringBuilder(30).append("Source offset < 0: ").append(target22).toString());
        }
        if (targetOffset < 0) {
            int target22 = targetOffset;
            throw new IndexOutOfBoundsException(new StringBuilder(30).append("Target offset < 0: ").append(target22).toString());
        }
        if (numberToCopy < 0) {
            int target22 = numberToCopy;
            throw new IndexOutOfBoundsException(new StringBuilder(23).append("Length < 0: ").append(target22).toString());
        }
        if (sourceOffset + numberToCopy > this.size()) {
            int target22 = sourceOffset + numberToCopy;
            throw new IndexOutOfBoundsException(new StringBuilder(34).append("Source end offset < 0: ").append(target22).toString());
        }
        if (targetOffset + numberToCopy > target22.length) {
            int target22 = targetOffset + numberToCopy;
            throw new IndexOutOfBoundsException(new StringBuilder(34).append("Target end offset < 0: ").append(target22).toString());
        }
        if (numberToCopy > 0) {
            void var3_8;
            void var2_7;
            void var1_1;
            this.copyToInternal((byte[])var1_1, (int)var2_7, (int)var3_8, numberToCopy);
        }
    }

    protected abstract void copyToInternal(byte[] var1, int var2, int var3, int var4);

    /*
     * WARNING - void declaration
     */
    public byte[] toByteArray() {
        void var2_2;
        void var1_1;
        int size = this.size();
        if (size == 0) {
            return Internal.EMPTY_BYTE_ARRAY;
        }
        byte[] result = new byte[size];
        this.copyToInternal(result, 0, 0, (int)var1_1);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    void writeTo(OutputStream out2, int sourceOffset, int numberToWrite) throws IOException {
        if (sourceOffset < 0) {
            int out2 = sourceOffset;
            throw new IndexOutOfBoundsException(new StringBuilder(30).append("Source offset < 0: ").append(out2).toString());
        }
        if (numberToWrite < 0) {
            int out2 = numberToWrite;
            throw new IndexOutOfBoundsException(new StringBuilder(23).append("Length < 0: ").append(out2).toString());
        }
        if (sourceOffset + numberToWrite > this.size()) {
            int out2 = sourceOffset + numberToWrite;
            throw new IndexOutOfBoundsException(new StringBuilder(39).append("Source end offset exceeded: ").append(out2).toString());
        }
        if (numberToWrite > 0) {
            void var3_6;
            void var2_5;
            void var1_1;
            this.writeToInternal((OutputStream)var1_1, (int)var2_5, (int)var3_6);
        }
    }

    abstract void writeToInternal(OutputStream var1, int var2, int var3) throws IOException;

    public abstract String toString(String var1) throws UnsupportedEncodingException;

    /*
     * WARNING - void declaration
     */
    public String toStringUtf8() {
        try {
            return this.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            void var1_1;
            throw new RuntimeException("UTF-8 not supported?", (Throwable)var1_1);
        }
    }

    public abstract boolean isValidUtf8();

    protected abstract int partialIsValidUtf8(int var1, int var2, int var3);

    public abstract CodedInputStream newCodedInput();

    public static Output newOutput() {
        return new Output(128);
    }

    protected abstract int getTreeDepth();

    protected abstract boolean isBalanced();

    protected abstract int peekCachedHashCode();

    protected abstract int partialHash(int var1, int var2, int var3);

    public String toString() {
        return String.format("<ByteString@%s size=%d>", Integer.toHexString(System.identityHashCode(this)), this.size());
    }

    public static final class Output
    extends OutputStream {
        private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
        private final int initialCapacity;
        private final ArrayList<ByteString> flushedBuffers;
        private int flushedBuffersTotalBytes;
        private byte[] buffer;
        private int bufferPos;

        /*
         * WARNING - void declaration
         */
        Output(int initialCapacity) {
            void var1_1;
            if (initialCapacity < 0) {
                throw new IllegalArgumentException("Buffer size < 0");
            }
            this.initialCapacity = initialCapacity;
            this.flushedBuffers = new ArrayList();
            this.buffer = new byte[var1_1];
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final synchronized void write(int b) {
            void var1_1;
            if (this.bufferPos == this.buffer.length) {
                this.flushFullBuffer(1);
            }
            this.buffer[this.bufferPos++] = (byte)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final synchronized void write(byte[] b, int offset, int length) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (length <= this.buffer.length - this.bufferPos) {
                System.arraycopy(b, offset, this.buffer, this.bufferPos, length);
                this.bufferPos += length;
                return;
            }
            int copySize = this.buffer.length - this.bufferPos;
            System.arraycopy(b, offset, this.buffer, this.bufferPos, copySize);
            offset += copySize;
            this.flushFullBuffer(length -= copySize);
            System.arraycopy(var1_1, (int)var2_2, this.buffer, 0, length);
            this.bufferPos = var3_3;
        }

        public final synchronized ByteString toByteString() {
            this.flushLastBuffer();
            return ByteString.copyFrom(this.flushedBuffers);
        }

        /*
         * WARNING - void declaration
         */
        private byte[] copyArray(byte[] buffer, int length) {
            void var3_3;
            void var2_2;
            void var1_1;
            byte[] result = new byte[length];
            System.arraycopy(buffer, 0, result, 0, Math.min(((void)var1_1).length, (int)var2_2));
            return var3_3;
        }

        public final synchronized int size() {
            return this.flushedBuffersTotalBytes + this.bufferPos;
        }

        public final String toString() {
            return String.format("<ByteString.Output@%s size=%d>", Integer.toHexString(System.identityHashCode(this)), this.size());
        }

        /*
         * WARNING - void declaration
         */
        private void flushFullBuffer(int minSize) {
            void var1_1;
            this.flushedBuffers.add(new LiteralByteString(this.buffer));
            this.flushedBuffersTotalBytes += this.buffer.length;
            int newSize = Math.max(this.initialCapacity, Math.max(minSize, this.flushedBuffersTotalBytes >>> 1));
            this.buffer = new byte[var1_1];
            this.bufferPos = 0;
        }

        /*
         * WARNING - void declaration
         */
        private void flushLastBuffer() {
            if (this.bufferPos < this.buffer.length) {
                if (this.bufferPos > 0) {
                    void var1_1;
                    Output output = this;
                    byte[] bufferCopy = output.copyArray(output.buffer, this.bufferPos);
                    this.flushedBuffers.add(new LiteralByteString((byte[])var1_1));
                }
            } else {
                this.flushedBuffers.add(new LiteralByteString(this.buffer));
                this.buffer = EMPTY_BYTE_ARRAY;
            }
            this.flushedBuffersTotalBytes += this.bufferPos;
            this.bufferPos = 0;
        }
    }

    public static interface ByteIterator
    extends Iterator<Byte> {
        public byte nextByte();
    }
}

