/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.name;

import kotlin._Assertions;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.text.StringsKt;

@SourceDebugExtension(value={"SMAP\nClassId.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassId.kt\norg/jetbrains/kotlin/name/ClassId\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,141:1\n1#2:142\n226#3:143\n226#3:144\n*S KotlinDebug\n*F\n+ 1 ClassId.kt\norg/jetbrains/kotlin/name/ClassId\n*L\n37#1:143\n47#1:144\n*E\n"})
public final class ClassId {
    public static final Companion Companion = new Companion(null);
    private final FqName packageFqName;
    private final FqName relativeClassName;
    private final boolean isLocal;

    /*
     * WARNING - void declaration
     */
    public ClassId(FqName packageFqName, FqName relativeClassName, boolean isLocal) {
        boolean bl;
        void var3_5;
        void var2_4;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)relativeClassName, (String)"relativeClassName");
        this.packageFqName = var1_1;
        this.relativeClassName = var2_4;
        this.isLocal = var3_5;
        boolean bl2 = bl = !this.relativeClassName.isRoot();
        if (_Assertions.ENABLED && !bl) {
            String string = "Class name must not be root: " + this.packageFqName + (this.isLocal ? " (local)" : "");
            throw new AssertionError((Object)string);
        }
    }

    public final FqName getPackageFqName() {
        return this.packageFqName;
    }

    public final FqName getRelativeClassName() {
        return this.relativeClassName;
    }

    public final boolean isLocal() {
        return this.isLocal;
    }

    /*
     * WARNING - void declaration
     */
    public ClassId(FqName packageFqName, Name topLevelName) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)topLevelName, (String)"topLevelName");
        FqName fqName = FqName.topLevel((Name)var2_2);
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"topLevel(...)");
        this((FqName)var1_1, fqName, false);
    }

    public final Name getShortClassName() {
        Name name = this.relativeClassName.shortName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"shortName(...)");
        return name;
    }

    /*
     * WARNING - void declaration
     */
    public final ClassId getOuterClassId() {
        FqName fqName = this.relativeClassName.parent();
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"parent(...)");
        FqName parent = fqName;
        boolean bl = !fqName.isRoot();
        if (bl) {
            void var1_1;
            return new ClassId(this.packageFqName, (FqName)var1_1, this.isLocal);
        }
        return null;
    }

    public final boolean isNestedClass() {
        return !this.relativeClassName.parent().isRoot();
    }

    /*
     * WARNING - void declaration
     */
    public final ClassId createNestedClassId(Name name) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        FqName fqName = this.relativeClassName.child((Name)var1_1);
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"child(...)");
        return new ClassId(this.packageFqName, fqName, this.isLocal);
    }

    public final FqName asSingleFqName() {
        if (this.packageFqName.isRoot()) {
            return this.relativeClassName;
        }
        return new FqName(this.packageFqName.asString() + '.' + this.relativeClassName.asString());
    }

    /*
     * WARNING - void declaration
     */
    public final String asString() {
        void var2_2;
        StringBuilder stringBuilder;
        if (this.packageFqName.isRoot()) {
            return ClassId.asString$escapeSlashes(this.relativeClassName);
        }
        StringBuilder $this$asString_u24lambda_u243 = stringBuilder = new StringBuilder();
        String string = this.packageFqName.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        stringBuilder.append(StringsKt.replace$default((String)string, (char)'.', (char)'/', (boolean)false, (int)4, null));
        $this$asString_u24lambda_u243.append("/");
        var2_2.append(ClassId.asString$escapeSlashes(this.relativeClassName));
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    public final String toString() {
        if (this.packageFqName.isRoot()) {
            return "/" + this.asString();
        }
        return this.asString();
    }

    public final int hashCode() {
        int n = this.packageFqName.hashCode();
        n = n * 31 + this.relativeClassName.hashCode();
        n = n * 31 + Boolean.hashCode(this.isLocal);
        return n;
    }

    public final boolean equals(Object other) {
        ClassId classId;
        if (this == other) {
            return true;
        }
        if (!(other instanceof ClassId)) {
            return false;
        }
        classId = classId;
        if (!Intrinsics.areEqual((Object)this.packageFqName, (Object)classId.packageFqName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.relativeClassName, (Object)classId.relativeClassName)) {
            return false;
        }
        return this.isLocal == classId.isLocal;
    }

    private static final String asString$escapeSlashes(FqName $this$asString_u24escapeSlashes) {
        String string;
        String string2 = $this$asString_u24escapeSlashes.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        String res = string2;
        if (StringsKt.contains$default((CharSequence)string2, (char)'/', (boolean)false, (int)2, null)) {
            return "`" + (String)res + '`';
        }
        return string;
    }

    @JvmStatic
    public static final ClassId topLevel(FqName topLevelFqName) {
        FqName fqName;
        return Companion.topLevel(fqName);
    }

    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final ClassId topLevel(FqName topLevelFqName) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)topLevelFqName, (String)"topLevelFqName");
            FqName fqName = topLevelFqName.parent();
            Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"parent(...)");
            Name name = var1_1.shortName();
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"shortName(...)");
            return new ClassId(fqName, name);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @JvmOverloads
        public final ClassId fromString(String string, boolean isLocal) {
            void var2_2;
            void var1_1;
            String className;
            String packageName;
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            int tickIndex = StringsKt.indexOf$default((CharSequence)string, (char)'`', (int)0, (boolean)false, (int)6, null);
            int lastSlashIndex = StringsKt.lastIndexOf$default((CharSequence)string, (String)"/", (int)(tickIndex == -1 ? string.length() : tickIndex), (boolean)false, (int)4, null);
            if (lastSlashIndex == -1) {
                packageName = "";
                className = StringsKt.replace$default((String)string, (String)"`", (String)"", (boolean)false, (int)4, null);
            } else {
                void var3_3;
                String string2 = className.substring(0, lastSlashIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                packageName = StringsKt.replace$default((String)string2, (char)'/', (char)'.', (boolean)false, (int)4, null);
                String string3 = className.substring((int)(var3_3 + true));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                className = StringsKt.replace$default((String)string3, (String)"`", (String)"", (boolean)false, (int)4, null);
            }
            return new ClassId(new FqName(packageName), new FqName((String)var1_1), (boolean)var2_2);
        }

        public static /* synthetic */ ClassId fromString$default(Companion companion, String string, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.fromString(string, bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

