/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization;

import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.UtfEncodingKt;

public class BitEncoding {
    private static final boolean FORCE_8TO7_ENCODING;

    private BitEncoding() {
    }

    private static void addModuloByte(byte[] data, int increment) {
        if (data == null) {
            BitEncoding.$$$reportNull$$$0(4);
        }
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            data[i] = (byte)(data[i] + increment & 0x7F);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] decodeBytes(String[] data) {
        void var1_2;
        String[] stringArray;
        if (data == null) {
            BitEncoding.$$$reportNull$$$0(7);
        }
        if (data.length > 0 && !data[0].isEmpty()) {
            char possibleMarker = data[0].charAt(0);
            if (possibleMarker == '\u0000') {
                byte[] byArray = UtfEncodingKt.stringsToBytes(BitEncoding.dropMarker(data));
                if (byArray == null) {
                    BitEncoding.$$$reportNull$$$0(8);
                }
                return byArray;
            }
            if (possibleMarker == '\uffff') {
                data = BitEncoding.dropMarker(data);
            }
        }
        byte[] bytes = BitEncoding.combineStringArrayIntoBytes(stringArray);
        BitEncoding.addModuloByte(bytes, 127);
        return BitEncoding.decode7to8((byte[])var1_2);
    }

    private static String[] dropMarker(String[] data) {
        String[] stringArray;
        if (data == null) {
            BitEncoding.$$$reportNull$$$0(9);
        }
        String[] stringArray2 = (String[])data.clone();
        String[] result = stringArray2;
        stringArray2[0] = result[0].substring(1);
        if (stringArray == null) {
            BitEncoding.$$$reportNull$$$0(10);
        }
        return stringArray;
    }

    private static byte[] combineStringArrayIntoBytes(String[] data) {
        String[] stringArray;
        if (data == null) {
            BitEncoding.$$$reportNull$$$0(11);
        }
        int resultLength = 0;
        String[] stringArray2 = data;
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            String s = stringArray2[i];
            assert (s.length() <= 65535) : "String is too long: " + s.length();
            resultLength += s.length();
        }
        byte[] result = new byte[resultLength];
        int p = 0;
        String[] stringArray3 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String s = stringArray3[i];
            int n3 = s.length();
            for (int i2 = 0; i2 < n3; ++i2) {
                result[p++] = (byte)s.charAt(i2);
            }
        }
        return stringArray2;
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] decode7to8(byte[] data) {
        void var2_2;
        if (data == null) {
            BitEncoding.$$$reportNull$$$0(13);
        }
        int resultLength = 7 * data.length / 8;
        byte[] result = new byte[resultLength];
        int byteIndex = 0;
        int bit = 0;
        for (int i = 0; i < resultLength; ++i) {
            int firstPart = (data[byteIndex] & 0xFF) >>> bit;
            int secondPart = (data[++byteIndex] & (1 << bit + 1) - 1) << 7 - bit;
            result[i] = (byte)(firstPart + secondPart);
            if (bit == 6) {
                ++byteIndex;
                bit = 0;
                continue;
            }
            ++bit;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        String use8to7;
        try {
            use8to7 = System.getProperty("kotlin.jvm.serialization.use8to7");
        }
        catch (SecurityException securityException) {
            use8to7 = null;
        }
        FORCE_8TO7_ENCODING = "true".equals(var0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                n2 = 2;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlin/reflect/jvm/internal/impl/metadata/jvm/deserialization/BitEncoding";
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "kotlin/reflect/jvm/internal/impl/metadata/jvm/deserialization/BitEncoding";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "encodeBytes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "encode8to7";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "splitBytesToStringArray";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "decodeBytes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "dropMarker";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "combineStringArrayIntoBytes";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "decode7to8";
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "encodeBytes";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "encode8to7";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addModuloByte";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "splitBytesToStringArray";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "decodeBytes";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "dropMarker";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "combineStringArrayIntoBytes";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "decode7to8";
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
            }
        }
        throw runtimeException;
    }
}

