/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.metadata.deserialization;

import java.util.ArrayList;
import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@SourceDebugExtension(value={"SMAP\nBinaryVersion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BinaryVersion.kt\norg/jetbrains/kotlin/metadata/deserialization/BinaryVersion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,101:1\n5343#2,7:102\n*S KotlinDebug\n*F\n+ 1 BinaryVersion.kt\norg/jetbrains/kotlin/metadata/deserialization/BinaryVersion\n*L\n73#1:102,7\n*E\n"})
public abstract class BinaryVersion {
    public static final Companion Companion = new Companion(null);
    private final int[] numbers;
    private final int major;
    private final int minor;
    private final int patch;
    private final List<Integer> rest;

    /*
     * WARNING - void declaration
     */
    public BinaryVersion(int ... numbers) {
        List list;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)numbers, (String)"numbers");
        this.numbers = var1_1;
        Integer n = ArraysKt.getOrNull((int[])this.numbers, (int)0);
        this.major = n != null ? n : -1;
        Integer n2 = ArraysKt.getOrNull((int[])this.numbers, (int)1);
        this.minor = n2 != null ? n2 : -1;
        Integer n3 = ArraysKt.getOrNull((int[])this.numbers, (int)2);
        int n4 = this.patch = n3 != null ? n3 : -1;
        if (this.numbers.length > 3) {
            if (this.numbers.length > 1024) {
                throw new IllegalArgumentException("BinaryVersion with length more than 1024 are not supported. Provided length " + this.numbers.length + '.');
            }
            list = CollectionsKt.toList((Iterable)ArraysKt.asList((int[])this.numbers).subList(3, this.numbers.length));
        } else {
            list = CollectionsKt.emptyList();
        }
        this.rest = list;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int[] toArray() {
        return this.numbers;
    }

    /*
     * WARNING - void declaration
     */
    protected final boolean isCompatibleTo(BinaryVersion ourVersion) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)ourVersion, (String)"ourVersion");
        if (this.major == 0) {
            return ourVersion.major == 0 && this.minor == ourVersion.minor;
        }
        return this.major == ourVersion.major && this.minor <= var1_1.minor;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isAtLeast(BinaryVersion version) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return this.isAtLeast(version.major, version.minor, var1_1.patch);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isAtLeast(int major, int minor, int patch) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.major > major) {
            return true;
        }
        if (this.major < var1_1) {
            return false;
        }
        if (this.minor > minor) {
            return true;
        }
        if (this.minor < var2_2) {
            return false;
        }
        return this.patch >= var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isAtMost(int major, int minor, int patch) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.major < major) {
            return true;
        }
        if (this.major > var1_1) {
            return false;
        }
        if (this.minor < minor) {
            return true;
        }
        if (this.minor > var2_2) {
            return false;
        }
        return this.patch <= var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        void var2_2;
        List versions;
        int[] $this$takeWhile$iv = this.toArray();
        ArrayList<Integer> list$iv = new ArrayList<Integer>();
        int n = $this$takeWhile$iv.length;
        for (int i = 0; i < n; ++i) {
            int item$iv;
            int n2 = item$iv = $this$takeWhile$iv[i];
            if (!(item$iv != -1)) break;
            list$iv.add(item$iv);
        }
        if ((versions = (List)var2_2).isEmpty()) {
            return "unknown";
        }
        return CollectionsKt.joinToString$default((Iterable)((Iterable)var1_1), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object other) {
        void var1_1;
        return other != null && Intrinsics.areEqual(this.getClass(), other.getClass()) && this.major == ((BinaryVersion)other).major && this.minor == ((BinaryVersion)other).minor && this.patch == ((BinaryVersion)other).patch && Intrinsics.areEqual(this.rest, ((BinaryVersion)var1_1).rest);
    }

    public int hashCode() {
        int n;
        int result = this.major;
        result += result * 31 + this.minor;
        result += result * 31 + this.patch;
        n = result + (n * 31 + ((Object)this.rest).hashCode());
        return n;
    }

    @SourceDebugExtension(value={"SMAP\nBinaryVersion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BinaryVersion.kt\norg/jetbrains/kotlin/metadata/deserialization/BinaryVersion$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,101:1\n1557#2:102\n1628#2,3:103\n37#3,2:106\n*S KotlinDebug\n*F\n+ 1 BinaryVersion.kt\norg/jetbrains/kotlin/metadata/deserialization/BinaryVersion$Companion\n*L\n97#1:102\n97#1:103,3\n98#1:106,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

