/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin.header;

import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.load.java.JvmAnnotationNames;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.load.kotlin.header.KotlinClassHeader;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.BitEncoding;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmMetadataVersion;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ClassLiteralValue;

public class ReadKotlinClassHeaderAnnotationVisitor
implements KotlinJvmBinaryClass.AnnotationVisitor {
    private static boolean IGNORE_OLD_METADATA;
    private static final Map<ClassId, KotlinClassHeader.Kind> HEADER_KINDS;
    private int[] metadataVersionArray = null;
    private String extraString = null;
    private int extraInt = 0;
    private String packageName = null;
    private String[] data = null;
    private String[] strings = null;
    private String[] incompatibleData = null;
    private KotlinClassHeader.Kind headerKind = null;
    private String[] serializedIrFields = null;

    public KotlinClassHeader createHeaderWithDefaultMetadataVersion() {
        return this.createHeader(JvmMetadataVersion.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    public KotlinClassHeader createHeader(JvmMetadataVersion metadataVersionFromLanguageVersion) {
        void var1_1;
        void var2_2;
        if (this.headerKind == null || this.metadataVersionArray == null) {
            return null;
        }
        JvmMetadataVersion metadataVersion = new JvmMetadataVersion(this.metadataVersionArray, (this.extraInt & 8) != 0);
        if (!metadataVersion.isCompatible(metadataVersionFromLanguageVersion)) {
            this.incompatibleData = this.data;
            this.data = null;
        } else if (this.shouldHaveData() && this.data == null) {
            return null;
        }
        byte[] serializedIr = null;
        if (this.serializedIrFields != null) {
            serializedIr = BitEncoding.decodeBytes(this.serializedIrFields);
        }
        return new KotlinClassHeader(this.headerKind, (JvmMetadataVersion)var2_2, this.data, this.incompatibleData, this.strings, this.extraString, this.extraInt, this.packageName, (byte[])var1_1);
    }

    private boolean shouldHaveData() {
        return this.headerKind == KotlinClassHeader.Kind.CLASS || this.headerKind == KotlinClassHeader.Kind.FILE_FACADE || this.headerKind == KotlinClassHeader.Kind.MULTIFILE_CLASS_PART;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(ClassId classId, SourceElement source) {
        void var2_2;
        FqName fqName;
        if (classId == null) {
            ReadKotlinClassHeaderAnnotationVisitor.$$$reportNull$$$0(0);
        }
        if (source == null) {
            ReadKotlinClassHeaderAnnotationVisitor.$$$reportNull$$$0(1);
        }
        if ((fqName = classId.asSingleFqName()).equals(JvmAnnotationNames.METADATA_FQ_NAME)) {
            return new KotlinMetadataArgumentVisitor();
        }
        if (var2_2.equals(JvmAnnotationNames.SERIALIZED_IR_FQ_NAME)) {
            return new KotlinSerializedIrArgumentVisitor();
        }
        if (IGNORE_OLD_METADATA) {
            return null;
        }
        if (this.headerKind != null) {
            return null;
        }
        KotlinClassHeader.Kind newKind = HEADER_KINDS.get(classId);
        if (newKind != null) {
            void var1_1;
            this.headerKind = var1_1;
            return new OldDeprecatedAnnotationArgumentVisitor();
        }
        return null;
    }

    @Override
    public void visitEnd() {
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ KotlinClassHeader.Kind access$302(ReadKotlinClassHeaderAnnotationVisitor x0, KotlinClassHeader.Kind x1) {
        void var1_1;
        x0.headerKind = var1_1;
        return x0.headerKind;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int[] access$402(ReadKotlinClassHeaderAnnotationVisitor x0, int[] x1) {
        void var1_1;
        x0.metadataVersionArray = var1_1;
        return x0.metadataVersionArray;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$502(ReadKotlinClassHeaderAnnotationVisitor x0, String x1) {
        void var1_1;
        x0.extraString = var1_1;
        return x0.extraString;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$602(ReadKotlinClassHeaderAnnotationVisitor x0, int x1) {
        void var1_1;
        x0.extraInt = var1_1;
        return x0.extraInt;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$702(ReadKotlinClassHeaderAnnotationVisitor x0, String x1) {
        void var1_1;
        x0.packageName = var1_1;
        return x0.packageName;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String[] access$802(ReadKotlinClassHeaderAnnotationVisitor x0, String[] x1) {
        void var1_1;
        x0.data = var1_1;
        return x0.data;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String[] access$902(ReadKotlinClassHeaderAnnotationVisitor x0, String[] x1) {
        void var1_1;
        x0.strings = var1_1;
        return x0.strings;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String[] access$1002(ReadKotlinClassHeaderAnnotationVisitor x0, String[] x1) {
        void var1_1;
        x0.serializedIrFields = var1_1;
        return x0.serializedIrFields;
    }

    static {
        try {
            IGNORE_OLD_METADATA = "true".equals(System.getProperty("kotlin.ignore.old.metadata"));
        }
        catch (AccessControlException accessControlException) {
            IGNORE_OLD_METADATA = false;
        }
        HEADER_KINDS = new HashMap<ClassId, KotlinClassHeader.Kind>();
        HEADER_KINDS.put(ClassId.topLevel(new FqName("kotlin.jvm.internal.KotlinClass")), KotlinClassHeader.Kind.CLASS);
        HEADER_KINDS.put(ClassId.topLevel(new FqName("kotlin.jvm.internal.KotlinFileFacade")), KotlinClassHeader.Kind.FILE_FACADE);
        HEADER_KINDS.put(ClassId.topLevel(new FqName("kotlin.jvm.internal.KotlinMultifileClass")), KotlinClassHeader.Kind.MULTIFILE_CLASS);
        HEADER_KINDS.put(ClassId.topLevel(new FqName("kotlin.jvm.internal.KotlinMultifileClassPart")), KotlinClassHeader.Kind.MULTIFILE_CLASS_PART);
        HEADER_KINDS.put(ClassId.topLevel(new FqName("kotlin.jvm.internal.KotlinSyntheticClass")), KotlinClassHeader.Kind.SYNTHETIC_CLASS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "classId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "source";
            }
        }
        objectArray[1] = "kotlin/reflect/jvm/internal/impl/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor";
        objectArray[2] = "visitAnnotation";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static abstract class CollectStringArrayAnnotationVisitor
    implements KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor {
        private final List<String> strings = new ArrayList<String>();

        /*
         * WARNING - void declaration
         */
        @Override
        public void visit(Object value) {
            if (value instanceof String) {
                void var1_1;
                this.strings.add((String)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitEnum(ClassId enumClassId, Name enumEntryName) {
            void var2_2;
            if (enumClassId == null) {
                CollectStringArrayAnnotationVisitor.$$$reportNull$$$0(0);
            }
            if (var2_2 == null) {
                CollectStringArrayAnnotationVisitor.$$$reportNull$$$0(1);
            }
        }

        @Override
        public void visitClassLiteral(ClassLiteralValue classLiteralValue) {
            if (classLiteralValue == null) {
                CollectStringArrayAnnotationVisitor.$$$reportNull$$$0(2);
            }
        }

        @Override
        public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(ClassId classId) {
            if (classId == null) {
                CollectStringArrayAnnotationVisitor.$$$reportNull$$$0(3);
            }
            return null;
        }

        @Override
        public void visitEnd() {
            CollectStringArrayAnnotationVisitor collectStringArrayAnnotationVisitor = this;
            collectStringArrayAnnotationVisitor.visitEnd(collectStringArrayAnnotationVisitor.strings.toArray(new String[0]));
        }

        protected abstract void visitEnd(String[] var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enumClassId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enumEntryName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classLiteralValue";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classId";
                }
            }
            objectArray2[1] = "kotlin/reflect/jvm/internal/impl/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$CollectStringArrayAnnotationVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitEnum";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClassLiteral";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAnnotation";
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class KotlinSerializedIrArgumentVisitor
    implements KotlinJvmBinaryClass.AnnotationArgumentVisitor {
        private KotlinSerializedIrArgumentVisitor() {
        }

        @Override
        public void visit(Name name, Object value) {
        }

        @Override
        public void visitClassLiteral(Name name, ClassLiteralValue classLiteralValue) {
            if (classLiteralValue == null) {
                KotlinSerializedIrArgumentVisitor.$$$reportNull$$$0(0);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor visitArray(Name name) {
            void var1_1;
            String string;
            String string2 = string = name != null ? name.asString() : null;
            if ("b".equals(var1_1)) {
                return this.serializedIrArrayVisitor();
            }
            return null;
        }

        private KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor serializedIrArrayVisitor() {
            return new CollectStringArrayAnnotationVisitor(this){
                final /* synthetic */ KotlinSerializedIrArgumentVisitor this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                protected void visitEnd(String[] result) {
                    void var1_1;
                    if (result == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ReadKotlinClassHeaderAnnotationVisitor.access$1002(this.this$1.ReadKotlinClassHeaderAnnotationVisitor.this, (String[])var1_1);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "kotlin/reflect/jvm/internal/impl/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$KotlinSerializedIrArgumentVisitor$1", "visitEnd"));
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitEnum(Name name, ClassId enumClassId, Name enumEntryName) {
            void var3_3;
            if (enumClassId == null) {
                KotlinSerializedIrArgumentVisitor.$$$reportNull$$$0(1);
            }
            if (var3_3 == null) {
                KotlinSerializedIrArgumentVisitor.$$$reportNull$$$0(2);
            }
        }

        @Override
        public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(Name name, ClassId classId) {
            if (classId == null) {
                KotlinSerializedIrArgumentVisitor.$$$reportNull$$$0(3);
            }
            return null;
        }

        @Override
        public void visitEnd() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classLiteralValue";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enumClassId";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enumEntryName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classId";
                }
            }
            objectArray2[1] = "kotlin/reflect/jvm/internal/impl/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$KotlinSerializedIrArgumentVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClassLiteral";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitEnum";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAnnotation";
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class OldDeprecatedAnnotationArgumentVisitor
    implements KotlinJvmBinaryClass.AnnotationArgumentVisitor {
        private OldDeprecatedAnnotationArgumentVisitor() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visit(Name name, Object value) {
            void var1_1;
            if (name == null) {
                return;
            }
            String string = name.asString();
            if ("version".equals(string)) {
                if (value instanceof int[]) {
                    ReadKotlinClassHeaderAnnotationVisitor.access$402(ReadKotlinClassHeaderAnnotationVisitor.this, (int[])value);
                    return;
                }
            } else if ("multifileClassName".equals(var1_1)) {
                void var2_2;
                ReadKotlinClassHeaderAnnotationVisitor.access$502(ReadKotlinClassHeaderAnnotationVisitor.this, value instanceof String ? (String)var2_2 : null);
            }
        }

        @Override
        public void visitClassLiteral(Name name, ClassLiteralValue classLiteralValue) {
            if (classLiteralValue == null) {
                OldDeprecatedAnnotationArgumentVisitor.$$$reportNull$$$0(0);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor visitArray(Name name) {
            void var1_1;
            String string;
            String string2 = string = name != null ? name.asString() : null;
            if ("data".equals(string) || "filePartClassNames".equals(string)) {
                return this.dataArrayVisitor();
            }
            if ("strings".equals(var1_1)) {
                return this.stringsArrayVisitor();
            }
            return null;
        }

        private KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor dataArrayVisitor() {
            return new CollectStringArrayAnnotationVisitor(this){
                final /* synthetic */ OldDeprecatedAnnotationArgumentVisitor this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                protected void visitEnd(String[] data) {
                    void var1_1;
                    if (data == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ReadKotlinClassHeaderAnnotationVisitor.access$802(this.this$1.ReadKotlinClassHeaderAnnotationVisitor.this, (String[])var1_1);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "kotlin/reflect/jvm/internal/impl/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$OldDeprecatedAnnotationArgumentVisitor$1", "visitEnd"));
                }
            };
        }

        private KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor stringsArrayVisitor() {
            return new CollectStringArrayAnnotationVisitor(this){
                final /* synthetic */ OldDeprecatedAnnotationArgumentVisitor this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                protected void visitEnd(String[] data) {
                    void var1_1;
                    if (data == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    ReadKotlinClassHeaderAnnotationVisitor.access$902(this.this$1.ReadKotlinClassHeaderAnnotationVisitor.this, (String[])var1_1);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "kotlin/reflect/jvm/internal/impl/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$OldDeprecatedAnnotationArgumentVisitor$2", "visitEnd"));
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitEnum(Name name, ClassId enumClassId, Name enumEntryName) {
            void var3_3;
            if (enumClassId == null) {
                OldDeprecatedAnnotationArgumentVisitor.$$$reportNull$$$0(1);
            }
            if (var3_3 == null) {
                OldDeprecatedAnnotationArgumentVisitor.$$$reportNull$$$0(2);
            }
        }

        @Override
        public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(Name name, ClassId classId) {
            if (classId == null) {
                OldDeprecatedAnnotationArgumentVisitor.$$$reportNull$$$0(3);
            }
            return null;
        }

        @Override
        public void visitEnd() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classLiteralValue";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enumClassId";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enumEntryName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classId";
                }
            }
            objectArray2[1] = "kotlin/reflect/jvm/internal/impl/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$OldDeprecatedAnnotationArgumentVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClassLiteral";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitEnum";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAnnotation";
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class KotlinMetadataArgumentVisitor
    implements KotlinJvmBinaryClass.AnnotationArgumentVisitor {
        private KotlinMetadataArgumentVisitor() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visit(Name name, Object value) {
            void var1_1;
            if (name == null) {
                return;
            }
            String string = name.asString();
            if ("k".equals(string)) {
                if (value instanceof Integer) {
                    ReadKotlinClassHeaderAnnotationVisitor.access$302(ReadKotlinClassHeaderAnnotationVisitor.this, KotlinClassHeader.Kind.getById((Integer)value));
                    return;
                }
            } else if ("mv".equals(string)) {
                if (value instanceof int[]) {
                    ReadKotlinClassHeaderAnnotationVisitor.access$402(ReadKotlinClassHeaderAnnotationVisitor.this, (int[])value);
                    return;
                }
            } else if ("xs".equals(string)) {
                if (value instanceof String && !((String)value).isEmpty()) {
                    ReadKotlinClassHeaderAnnotationVisitor.access$502(ReadKotlinClassHeaderAnnotationVisitor.this, (String)value);
                    return;
                }
            } else if ("xi".equals(string)) {
                if (value instanceof Integer) {
                    ReadKotlinClassHeaderAnnotationVisitor.access$602(ReadKotlinClassHeaderAnnotationVisitor.this, (Integer)value);
                    return;
                }
            } else if ("pn".equals(var1_1) && value instanceof String && !((String)value).isEmpty()) {
                void var2_2;
                ReadKotlinClassHeaderAnnotationVisitor.access$702(ReadKotlinClassHeaderAnnotationVisitor.this, (String)var2_2);
            }
        }

        @Override
        public void visitClassLiteral(Name name, ClassLiteralValue classLiteralValue) {
            if (classLiteralValue == null) {
                KotlinMetadataArgumentVisitor.$$$reportNull$$$0(0);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor visitArray(Name name) {
            void var1_1;
            String string;
            String string2 = string = name != null ? name.asString() : null;
            if ("d1".equals(string)) {
                return this.dataArrayVisitor();
            }
            if ("d2".equals(var1_1)) {
                return this.stringsArrayVisitor();
            }
            return null;
        }

        private KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor dataArrayVisitor() {
            return new CollectStringArrayAnnotationVisitor(this){
                final /* synthetic */ KotlinMetadataArgumentVisitor this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                protected void visitEnd(String[] result) {
                    void var1_1;
                    if (result == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ReadKotlinClassHeaderAnnotationVisitor.access$802(this.this$1.ReadKotlinClassHeaderAnnotationVisitor.this, (String[])var1_1);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "kotlin/reflect/jvm/internal/impl/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$KotlinMetadataArgumentVisitor$1", "visitEnd"));
                }
            };
        }

        private KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor stringsArrayVisitor() {
            return new CollectStringArrayAnnotationVisitor(this){
                final /* synthetic */ KotlinMetadataArgumentVisitor this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                protected void visitEnd(String[] result) {
                    void var1_1;
                    if (result == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    ReadKotlinClassHeaderAnnotationVisitor.access$902(this.this$1.ReadKotlinClassHeaderAnnotationVisitor.this, (String[])var1_1);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "kotlin/reflect/jvm/internal/impl/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$KotlinMetadataArgumentVisitor$2", "visitEnd"));
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitEnum(Name name, ClassId enumClassId, Name enumEntryName) {
            void var3_3;
            if (enumClassId == null) {
                KotlinMetadataArgumentVisitor.$$$reportNull$$$0(1);
            }
            if (var3_3 == null) {
                KotlinMetadataArgumentVisitor.$$$reportNull$$$0(2);
            }
        }

        @Override
        public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(Name name, ClassId classId) {
            if (classId == null) {
                KotlinMetadataArgumentVisitor.$$$reportNull$$$0(3);
            }
            return null;
        }

        @Override
        public void visitEnd() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classLiteralValue";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enumClassId";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enumEntryName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classId";
                }
            }
            objectArray2[1] = "kotlin/reflect/jvm/internal/impl/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$KotlinMetadataArgumentVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClassLiteral";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitEnum";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAnnotation";
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

