/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.NotFoundClasses;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.load.java.components.DescriptorResolverUtils;
import kotlin.reflect.jvm.internal.impl.load.kotlin.AbstractBinaryClassAnnotationAndConstantLoader;
import kotlin.reflect.jvm.internal.impl.load.kotlin.BinaryClassAnnotationAndConstantLoaderImpl;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinClassFinder;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmMetadataVersion;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.constants.AnnotationValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ByteValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ClassLiteralValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValueFactory;
import kotlin.reflect.jvm.internal.impl.resolve.constants.EnumValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ErrorValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.KClassValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.LongValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ShortValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UByteValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UIntValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ULongValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UShortValue;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotationDeserializer;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.text.StringsKt;

public final class BinaryClassAnnotationAndConstantLoaderImpl
extends AbstractBinaryClassAnnotationAndConstantLoader<AnnotationDescriptor, ConstantValue<?>> {
    private final ModuleDescriptor module;
    private final NotFoundClasses notFoundClasses;
    private final AnnotationDeserializer annotationDeserializer;
    private JvmMetadataVersion jvmMetadataVersion;

    /*
     * WARNING - void declaration
     */
    public BinaryClassAnnotationAndConstantLoaderImpl(ModuleDescriptor module, NotFoundClasses notFoundClasses, StorageManager storageManager, KotlinClassFinder kotlinClassFinder) {
        void var2_2;
        void var1_1;
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)notFoundClasses, (String)"notFoundClasses");
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        Intrinsics.checkNotNullParameter((Object)kotlinClassFinder, (String)"kotlinClassFinder");
        super((StorageManager)var3_3, kotlinClassFinder);
        this.module = var1_1;
        this.notFoundClasses = var2_2;
        this.annotationDeserializer = new AnnotationDeserializer(this.module, this.notFoundClasses);
        this.jvmMetadataVersion = JvmMetadataVersion.INSTANCE;
    }

    @Override
    public final JvmMetadataVersion getJvmMetadataVersion() {
        return this.jvmMetadataVersion;
    }

    /*
     * WARNING - void declaration
     */
    public final void setJvmMetadataVersion(JvmMetadataVersion jvmMetadataVersion) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)jvmMetadataVersion, (String)"<set-?>");
        this.jvmMetadataVersion = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final AnnotationDescriptor loadAnnotation(ProtoBuf.Annotation proto, NameResolver nameResolver) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"nameResolver");
        return this.annotationDeserializer.deserializeAnnotation((ProtoBuf.Annotation)var1_1, (NameResolver)var2_2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected final ConstantValue<?> loadConstant(String desc, Object initializer) {
        void var1_1;
        Comparable<Byte> comparable;
        block11: {
            void var2_2;
            block8: {
                void var2_3;
                block10: {
                    int intValue;
                    block9: {
                        Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
                        Intrinsics.checkNotNullParameter((Object)initializer, (String)"initializer");
                        if (!StringsKt.contains$default((CharSequence)"ZBCS", (CharSequence)desc, (boolean)false, (int)2, null)) break block8;
                        intValue = (Integer)initializer;
                        String string = desc;
                        switch (string.hashCode()) {
                            case 66: {
                                if (string.equals("B")) break;
                                throw new AssertionError((Object)desc);
                            }
                            case 67: {
                                if (!string.equals("C")) {
                                    throw new AssertionError((Object)desc);
                                }
                                break block9;
                            }
                            case 83: {
                                if (!string.equals("S")) {
                                    throw new AssertionError((Object)desc);
                                }
                                break block10;
                            }
                            case 90: {
                                if (!string.equals("Z")) throw new AssertionError((Object)desc);
                                comparable = intValue != 0;
                                break block11;
                            }
                        }
                        comparable = (byte)intValue;
                        break block11;
                    }
                    comparable = Character.valueOf((char)intValue);
                    break block11;
                }
                comparable = (short)var2_3;
                break block11;
                throw new AssertionError((Object)desc);
            }
            comparable = var2_2;
        }
        void normalizedValue = comparable;
        return ConstantValueFactory.INSTANCE.createConstantValue(var1_1, this.module);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final ConstantValue<?> transformToUnsignedConstant(ConstantValue<?> constant) {
        void var1_1;
        Intrinsics.checkNotNullParameter(constant, (String)"constant");
        ConstantValue<?> constantValue = constant;
        if (constantValue instanceof ByteValue) {
            return new UByteValue(((Number)((ByteValue)constant).getValue()).byteValue());
        }
        if (constantValue instanceof ShortValue) {
            return new UShortValue(((Number)((ShortValue)constant).getValue()).shortValue());
        }
        if (constantValue instanceof IntValue) {
            return new UIntValue(((Number)((IntValue)constant).getValue()).intValue());
        }
        if (constantValue instanceof LongValue) {
            return new ULongValue(((Number)((LongValue)constant).getValue()).longValue());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final KotlinJvmBinaryClass.AnnotationArgumentVisitor loadAnnotation(ClassId annotationClassId, SourceElement source, List<AnnotationDescriptor> result) {
        void var2_2;
        void var3_3;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)annotationClassId, (String)"annotationClassId");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        ClassDescriptor annotationClass = this.resolveClass(annotationClassId);
        return new AbstractAnnotationArgumentVisitor(this, annotationClass, (ClassId)var1_1, (List<AnnotationDescriptor>)var3_3, (SourceElement)var2_2){
            private final HashMap<Name, ConstantValue<?>> arguments;
            final /* synthetic */ BinaryClassAnnotationAndConstantLoaderImpl this$0;
            final /* synthetic */ ClassDescriptor $annotationClass;
            final /* synthetic */ ClassId $annotationClassId;
            final /* synthetic */ List<AnnotationDescriptor> $result;
            final /* synthetic */ SourceElement $source;
            {
                void var1_1;
                void var3_3;
                void var2_2;
                this.this$0 = $receiver;
                this.$annotationClass = var2_2;
                this.$annotationClassId = var3_3;
                this.$result = $result;
                this.$source = $source;
                super((BinaryClassAnnotationAndConstantLoaderImpl)var1_1);
                this.arguments = new HashMap<K, V>();
            }

            /*
             * WARNING - void declaration
             */
            public final void visitConstantValue(Name name, ConstantValue<?> value) {
                Intrinsics.checkNotNullParameter(value, (String)"value");
                if (name != null) {
                    void var2_2;
                    void var1_1;
                    ((Map)this.arguments).put(var1_1, var2_2);
                }
            }

            /*
             * WARNING - void declaration
             */
            public final void visitArrayValue(Name name, ArrayList<ConstantValue<?>> elements) {
                Intrinsics.checkNotNullParameter(elements, (String)"elements");
                if (name == null) {
                    return;
                }
                ValueParameterDescriptor parameter = DescriptorResolverUtils.getAnnotationParameterByName((Name)name, this.$annotationClass);
                if (parameter != null) {
                    Map map = this.arguments;
                    List<ConstantValue<?>> list = kotlin.reflect.jvm.internal.impl.utils.CollectionsKt.compact(elements);
                    KotlinType kotlinType = parameter.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
                    elements = ConstantValueFactory.INSTANCE.createArrayValue(list, kotlinType);
                    map.put(name, elements);
                    return;
                }
                if (this.this$0.isImplicitRepeatableContainer(this.$annotationClassId) && Intrinsics.areEqual((Object)((Name)name).asString(), (Object)"value")) {
                    void $this$mapTo$iv;
                    Iterator<T> iterator2;
                    Iterator<T> $this$filterIsInstanceTo$iv$iv;
                    Iterable iterable = (Iterable)elements;
                    name = iterable;
                    Collection destination$iv$iv = new ArrayList<E>();
                    $this$filterIsInstanceTo$iv$iv = $this$filterIsInstanceTo$iv$iv.iterator();
                    while ($this$filterIsInstanceTo$iv$iv.hasNext()) {
                        T element$iv$iv = $this$filterIsInstanceTo$iv$iv.next();
                        if (!(element$iv$iv instanceof AnnotationValue)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    iterable = (List)((Object)iterator2);
                    Collection destination$iv = this.$result;
                    for (Object item$iv : $this$mapTo$iv) {
                        void var1_1;
                        item$iv = (AnnotationValue)item$iv;
                        iterable = destination$iv;
                        iterable.add((AnnotationDescriptor)var1_1.getValue());
                    }
                }
            }

            public final void visitEnd() {
                if (this.this$0.isRepeatableWithImplicitContainer(this.$annotationClassId, (Map)this.arguments)) {
                    return;
                }
                if (this.this$0.isImplicitRepeatableContainer(this.$annotationClassId)) {
                    return;
                }
                this.$result.add(new AnnotationDescriptorImpl(this.$annotationClass.getDefaultType(), (Map)this.arguments, this.$source));
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final ConstantValue<?> createConstant(Name name, Object value) {
        void var2_2;
        ConstantValue constantValue = ConstantValueFactory.INSTANCE.createConstantValue(var2_2, this.module);
        if (constantValue == null) {
            void var1_1;
            constantValue = ErrorValue.Companion.create("Unsupported annotation argument: " + var1_1);
        }
        return constantValue;
    }

    /*
     * WARNING - void declaration
     */
    private final ClassDescriptor resolveClass(ClassId classId) {
        void var1_1;
        return FindClassInModuleKt.findNonGenericClassAcrossDependencies(this.module, (ClassId)var1_1, this.notFoundClasses);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ConstantValue access$createConstant(BinaryClassAnnotationAndConstantLoaderImpl $this, Name name, Object value) {
        void var2_2;
        void var1_1;
        return $this.createConstant((Name)var1_1, var2_2);
    }

    private abstract class AbstractAnnotationArgumentVisitor
    implements KotlinJvmBinaryClass.AnnotationArgumentVisitor {
        final /* synthetic */ BinaryClassAnnotationAndConstantLoaderImpl this$0;

        /*
         * WARNING - void declaration
         */
        public AbstractAnnotationArgumentVisitor(BinaryClassAnnotationAndConstantLoaderImpl this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        public abstract void visitConstantValue(Name var1, ConstantValue<?> var2);

        public abstract void visitArrayValue(Name var1, ArrayList<ConstantValue<?>> var2);

        /*
         * WARNING - void declaration
         */
        @Override
        public void visit(Name name, Object value) {
            void var2_2;
            void var1_1;
            this.visitConstantValue(name, BinaryClassAnnotationAndConstantLoaderImpl.access$createConstant(this.this$0, (Name)var1_1, var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitClassLiteral(Name name, ClassLiteralValue value) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.visitConstantValue((Name)var1_1, new KClassValue((ClassLiteralValue)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitEnum(Name name, ClassId enumClassId, Name enumEntryName) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)enumClassId, (String)"enumClassId");
            Intrinsics.checkNotNullParameter((Object)enumEntryName, (String)"enumEntryName");
            this.visitConstantValue((Name)var1_1, new EnumValue((ClassId)var2_2, (Name)var3_3));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor visitArray(Name name) {
            void var1_1;
            return new KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor(this.this$0, (Name)var1_1, this){
                private final ArrayList<ConstantValue<?>> elements;
                final /* synthetic */ BinaryClassAnnotationAndConstantLoaderImpl this$0;
                final /* synthetic */ Name $name;
                final /* synthetic */ AbstractAnnotationArgumentVisitor this$1;
                {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    this.$name = var2_2;
                    this.this$1 = var3_3;
                    this.elements = new ArrayList<E>();
                }

                /*
                 * WARNING - void declaration
                 */
                public final void visit(Object value) {
                    void var1_1;
                    this.elements.add(BinaryClassAnnotationAndConstantLoaderImpl.access$createConstant(this.this$0, this.$name, var1_1));
                }

                /*
                 * WARNING - void declaration
                 */
                public final void visitEnum(ClassId enumClassId, Name enumEntryName) {
                    void var2_2;
                    void var1_1;
                    Intrinsics.checkNotNullParameter((Object)enumClassId, (String)"enumClassId");
                    Intrinsics.checkNotNullParameter((Object)enumEntryName, (String)"enumEntryName");
                    this.elements.add(new EnumValue((ClassId)var1_1, (Name)var2_2));
                }

                /*
                 * WARNING - void declaration
                 */
                public final void visitClassLiteral(ClassLiteralValue value) {
                    void var1_1;
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    this.elements.add(new KClassValue((ClassLiteralValue)var1_1));
                }

                /*
                 * WARNING - void declaration
                 */
                public final KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(ClassId classId) {
                    void var2_2;
                    void var1_1;
                    Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
                    ArrayList<E> list = new ArrayList<E>();
                    SourceElement sourceElement = SourceElement.NO_SOURCE;
                    Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"NO_SOURCE");
                    KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = this.this$0.loadAnnotation(classId, sourceElement, (List<AnnotationDescriptor>)list);
                    Intrinsics.checkNotNull((Object)annotationArgumentVisitor);
                    KotlinJvmBinaryClass.AnnotationArgumentVisitor visitor2 = annotationArgumentVisitor;
                    return new KotlinJvmBinaryClass.AnnotationArgumentVisitor((KotlinJvmBinaryClass.AnnotationArgumentVisitor)var1_1, this, (ArrayList<AnnotationDescriptor>)var2_2){
                        private final /* synthetic */ KotlinJvmBinaryClass.AnnotationArgumentVisitor $$delegate_0;
                        final /* synthetic */ KotlinJvmBinaryClass.AnnotationArgumentVisitor $visitor;
                        final /* synthetic */ visitArray.1 this$0;
                        final /* synthetic */ ArrayList<AnnotationDescriptor> $list;
                        {
                            void var1_1;
                            void var3_3;
                            void var2_2;
                            this.$visitor = $visitor;
                            this.this$0 = var2_2;
                            this.$list = var3_3;
                            this.$$delegate_0 = var1_1;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void visit(Name name, Object value) {
                            void var2_2;
                            void var1_1;
                            this.$$delegate_0.visit((Name)var1_1, var2_2);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void visitClassLiteral(Name name, ClassLiteralValue value) {
                            void var2_2;
                            void var1_1;
                            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                            this.$$delegate_0.visitClassLiteral((Name)var1_1, (ClassLiteralValue)var2_2);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void visitEnum(Name name, ClassId enumClassId, Name enumEntryName) {
                            void var3_3;
                            void var2_2;
                            void var1_1;
                            Intrinsics.checkNotNullParameter((Object)enumClassId, (String)"enumClassId");
                            Intrinsics.checkNotNullParameter((Object)enumEntryName, (String)"enumEntryName");
                            this.$$delegate_0.visitEnum((Name)var1_1, (ClassId)var2_2, (Name)var3_3);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(Name name, ClassId classId) {
                            void var2_2;
                            void var1_1;
                            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
                            return this.$$delegate_0.visitAnnotation((Name)var1_1, (ClassId)var2_2);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor visitArray(Name name) {
                            void var1_1;
                            return this.$$delegate_0.visitArray((Name)var1_1);
                        }

                        public final void visitEnd() {
                            this.$visitor.visitEnd();
                            visitArray.1.access$getElements$p(this.this$0).add(new AnnotationValue((AnnotationDescriptor)CollectionsKt.single((List)this.$list)));
                        }
                    };
                }

                public final void visitEnd() {
                    this.this$1.visitArrayValue(this.$name, this.elements);
                }

                public static final /* synthetic */ ArrayList access$getElements$p(visitArray.1 $this) {
                    return $this.elements;
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(Name name, ClassId classId) {
            void var3_3;
            void var1_1;
            void var2_2;
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            ArrayList list = new ArrayList();
            SourceElement sourceElement = SourceElement.NO_SOURCE;
            Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"NO_SOURCE");
            KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = this.this$0.loadAnnotation(classId, sourceElement, list);
            Intrinsics.checkNotNull((Object)annotationArgumentVisitor);
            KotlinJvmBinaryClass.AnnotationArgumentVisitor visitor2 = annotationArgumentVisitor;
            return new KotlinJvmBinaryClass.AnnotationArgumentVisitor((KotlinJvmBinaryClass.AnnotationArgumentVisitor)var2_2, this, (Name)var1_1, (ArrayList<AnnotationDescriptor>)var3_3){
                private final /* synthetic */ KotlinJvmBinaryClass.AnnotationArgumentVisitor $$delegate_0;
                final /* synthetic */ KotlinJvmBinaryClass.AnnotationArgumentVisitor $visitor;
                final /* synthetic */ AbstractAnnotationArgumentVisitor this$0;
                final /* synthetic */ Name $name;
                final /* synthetic */ ArrayList<AnnotationDescriptor> $list;
                {
                    void var1_1;
                    void var3_3;
                    void var2_2;
                    this.$visitor = $visitor;
                    this.this$0 = var2_2;
                    this.$name = var3_3;
                    this.$list = $list;
                    this.$$delegate_0 = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void visit(Name name, Object value) {
                    void var2_2;
                    void var1_1;
                    this.$$delegate_0.visit((Name)var1_1, var2_2);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void visitClassLiteral(Name name, ClassLiteralValue value) {
                    void var2_2;
                    void var1_1;
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    this.$$delegate_0.visitClassLiteral((Name)var1_1, (ClassLiteralValue)var2_2);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void visitEnum(Name name, ClassId enumClassId, Name enumEntryName) {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    Intrinsics.checkNotNullParameter((Object)enumClassId, (String)"enumClassId");
                    Intrinsics.checkNotNullParameter((Object)enumEntryName, (String)"enumEntryName");
                    this.$$delegate_0.visitEnum((Name)var1_1, (ClassId)var2_2, (Name)var3_3);
                }

                /*
                 * WARNING - void declaration
                 */
                public final KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(Name name, ClassId classId) {
                    void var2_2;
                    void var1_1;
                    Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
                    return this.$$delegate_0.visitAnnotation((Name)var1_1, (ClassId)var2_2);
                }

                /*
                 * WARNING - void declaration
                 */
                public final KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor visitArray(Name name) {
                    void var1_1;
                    return this.$$delegate_0.visitArray((Name)var1_1);
                }

                public final void visitEnd() {
                    this.$visitor.visitEnd();
                    this.this$0.visitConstantValue(this.$name, new AnnotationValue((AnnotationDescriptor)CollectionsKt.single((List)this.$list)));
                }
            };
        }
    }
}

