/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.structure;

import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClass;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClassifierType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaMember;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaMethod;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaValueParameter;
import kotlin.reflect.jvm.internal.impl.name.FqName;

public final class JavaLoadingKt {
    public static final boolean isObjectMethodInInterface(JavaMember $this$isObjectMethodInInterface) {
        JavaMember javaMember;
        Intrinsics.checkNotNullParameter((Object)$this$isObjectMethodInInterface, (String)"<this>");
        return $this$isObjectMethodInInterface.getContainingClass().isInterface() && $this$isObjectMethodInInterface instanceof JavaMethod && JavaLoadingKt.isObjectMethod((JavaMethod)javaMember);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isObjectMethod(JavaMethod method) {
        String string = method.getName().asString();
        switch (string.hashCode()) {
            case 147696667: {
                if (string.equals("hashCode")) return method.getValueParameters().isEmpty();
                return false;
            }
            case -1295482945: {
                if (string.equals("equals")) JavaMethod javaMethod;
                return JavaLoadingKt.isMethodWithOneObjectParameter(javaMethod);
                return false;
            }
            case -1776922004: {
                if (!string.equals("toString")) return false;
                return method.getValueParameters().isEmpty();
            }
        }
        return false;
    }

    private static final boolean isMethodWithOneObjectParameter(JavaMethod method) {
        method = method.getValueParameters();
        JavaValueParameter javaValueParameter = (JavaValueParameter)CollectionsKt.singleOrNull(method);
        method = javaValueParameter != null ? javaValueParameter.getType() : null;
        JavaClassifierType javaClassifierType = method instanceof JavaClassifierType ? (JavaClassifierType)method : null;
        if (javaClassifierType == null) {
            return false;
        }
        method = javaClassifierType;
        FqName classifier = javaClassifierType.getClassifier();
        if (classifier instanceof JavaClass) {
            FqName fqName;
            FqName classFqName = ((JavaClass)((Object)classifier)).getFqName();
            return classFqName != null && Intrinsics.areEqual((Object)fqName.asString(), (Object)"java.lang.Object");
        }
        return false;
    }
}

