/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.components;

import java.util.Map;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.JvmAnnotationNames;
import kotlin.reflect.jvm.internal.impl.load.java.components.JavaAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.components.JavaDeprecatedAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.components.JavaRetentionAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.components.JavaTargetAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.LazyJavaResolverContext;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaAnnotation;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaAnnotationOwner;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;

public final class JavaAnnotationMapper {
    public static final JavaAnnotationMapper INSTANCE = new JavaAnnotationMapper();
    private static final Name DEPRECATED_ANNOTATION_MESSAGE;
    private static final Name TARGET_ANNOTATION_ALLOWED_TARGETS;
    private static final Name RETENTION_ANNOTATION_VALUE;
    private static final Map<FqName, FqName> kotlinToJavaNameMap;

    private JavaAnnotationMapper() {
    }

    public final Name getDEPRECATED_ANNOTATION_MESSAGE$descriptors_jvm() {
        return DEPRECATED_ANNOTATION_MESSAGE;
    }

    public final Name getTARGET_ANNOTATION_ALLOWED_TARGETS$descriptors_jvm() {
        return TARGET_ANNOTATION_ALLOWED_TARGETS;
    }

    public final Name getRETENTION_ANNOTATION_VALUE$descriptors_jvm() {
        return RETENTION_ANNOTATION_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    public final AnnotationDescriptor mapOrResolveJavaAnnotation(JavaAnnotation annotation, LazyJavaResolverContext c, boolean isFreshlySupportedAnnotation) {
        void var3_3;
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        ClassId classId = annotation.getClassId();
        FqName fqName = JvmAnnotationNames.TARGET_ANNOTATION;
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"TARGET_ANNOTATION");
        if (Intrinsics.areEqual((Object)classId, (Object)ClassId.Companion.topLevel(fqName))) {
            return new JavaTargetAnnotationDescriptor(annotation, c);
        }
        FqName fqName2 = JvmAnnotationNames.RETENTION_ANNOTATION;
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"RETENTION_ANNOTATION");
        if (Intrinsics.areEqual((Object)classId, (Object)ClassId.Companion.topLevel(fqName2))) {
            return new JavaRetentionAnnotationDescriptor(annotation, c);
        }
        FqName fqName3 = JvmAnnotationNames.DOCUMENTED_ANNOTATION;
        Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"DOCUMENTED_ANNOTATION");
        if (Intrinsics.areEqual((Object)classId, (Object)ClassId.Companion.topLevel(fqName3))) {
            return new JavaAnnotationDescriptor(c, annotation, StandardNames.FqNames.mustBeDocumented);
        }
        FqName fqName4 = JvmAnnotationNames.DEPRECATED_ANNOTATION;
        Intrinsics.checkNotNullExpressionValue((Object)fqName4, (String)"DEPRECATED_ANNOTATION");
        if (Intrinsics.areEqual((Object)classId, (Object)ClassId.Companion.topLevel(fqName4))) {
            return null;
        }
        return new LazyJavaAnnotationDescriptor((LazyJavaResolverContext)var2_2, (JavaAnnotation)var1_1, (boolean)var3_3);
    }

    public static /* synthetic */ AnnotationDescriptor mapOrResolveJavaAnnotation$default(JavaAnnotationMapper javaAnnotationMapper, JavaAnnotation javaAnnotation, LazyJavaResolverContext lazyJavaResolverContext, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return javaAnnotationMapper.mapOrResolveJavaAnnotation(javaAnnotation, lazyJavaResolverContext, bl);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final AnnotationDescriptor findMappedJavaAnnotation(FqName kotlinName, JavaAnnotationOwner annotationOwner, LazyJavaResolverContext c) {
        void var3_3;
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)kotlinName, (String)"kotlinName");
        Intrinsics.checkNotNullParameter((Object)annotationOwner, (String)"annotationOwner");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        if (Intrinsics.areEqual((Object)kotlinName, (Object)StandardNames.FqNames.deprecated)) {
            FqName fqName = JvmAnnotationNames.DEPRECATED_ANNOTATION;
            Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"DEPRECATED_ANNOTATION");
            JavaAnnotation javaAnnotation = annotationOwner.findAnnotation(fqName);
            if (javaAnnotation != null) return new JavaDeprecatedAnnotationDescriptor(javaAnnotation, c);
            if (annotationOwner.isDeprecatedInJavaDoc()) {
                return new JavaDeprecatedAnnotationDescriptor(javaAnnotation, c);
            }
        }
        FqName fqName = kotlinToJavaNameMap.get(kotlinName);
        if (fqName == null) return null;
        FqName javaName = fqName;
        JavaAnnotation javaAnnotation = var2_2.findAnnotation(javaName);
        if (javaAnnotation == null) return null;
        JavaAnnotation annotation = javaAnnotation;
        AnnotationDescriptor annotationDescriptor = JavaAnnotationMapper.mapOrResolveJavaAnnotation$default(INSTANCE, (JavaAnnotation)var1_1, (LazyJavaResolverContext)var3_3, false, 4, null);
        return annotationDescriptor;
    }

    static {
        Name name = Name.identifier("message");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
        DEPRECATED_ANNOTATION_MESSAGE = name;
        Name name2 = Name.identifier("allowedTargets");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        TARGET_ANNOTATION_ALLOWED_TARGETS = name2;
        Name name3 = Name.identifier("value");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
        RETENTION_ANNOTATION_VALUE = name3;
        Pair[] pairArray = new Pair[3];
        Pair[] pairArray2 = pairArray;
        pairArray[0] = TuplesKt.to((Object)StandardNames.FqNames.target, (Object)JvmAnnotationNames.TARGET_ANNOTATION);
        pairArray2[1] = TuplesKt.to((Object)StandardNames.FqNames.retention, (Object)JvmAnnotationNames.RETENTION_ANNOTATION);
        pairArray2[2] = TuplesKt.to((Object)StandardNames.FqNames.mustBeDocumented, (Object)JvmAnnotationNames.DOCUMENTED_ANNOTATION);
        kotlinToJavaNameMap = MapsKt.mapOf((Pair[])pairArray2);
    }
}

