/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java;

import java.util.List;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.load.java.BuiltinSpecialProperties;
import kotlin.reflect.jvm.internal.impl.load.java.JvmAbi;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;
import kotlin.text.StringsKt;

@SourceDebugExtension(value={"SMAP\npropertiesConventionUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 propertiesConventionUtil.kt\norg/jetbrains/kotlin/load/java/PropertiesConventionUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n774#2:103\n865#2,2:104\n*S KotlinDebug\n*F\n+ 1 propertiesConventionUtil.kt\norg/jetbrains/kotlin/load/java/PropertiesConventionUtilKt\n*L\n90#1:103\n90#1:104,2\n*E\n"})
public final class PropertiesConventionUtilKt {
    public static final Name propertyNameByGetMethodName(Name methodName) {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Name name = PropertiesConventionUtilKt.propertyNameFromAccessorMethodName$default(methodName, "get", false, null, 12, null);
        if (name == null) {
            Name name2;
            name = PropertiesConventionUtilKt.propertyNameFromAccessorMethodName$default(name2, "is", false, null, 8, null);
        }
        return name;
    }

    /*
     * WARNING - void declaration
     */
    public static final Name propertyNameBySetMethodName(Name methodName, boolean withIsPrefix) {
        void var1_1;
        Name name;
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        return PropertiesConventionUtilKt.propertyNameFromAccessorMethodName$default(name, "set", false, var1_1 != false ? "is" : null, 4, null);
    }

    public static final List<Name> propertyNamesBySetMethodName(Name methodName) {
        Name name;
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Object[] objectArray = new Name[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = PropertiesConventionUtilKt.propertyNameBySetMethodName(methodName, false);
        objectArray2[1] = PropertiesConventionUtilKt.propertyNameBySetMethodName(name, true);
        return CollectionsKt.listOfNotNull((Object[])objectArray2);
    }

    /*
     * WARNING - void declaration
     */
    private static final Name propertyNameFromAccessorMethodName(Name methodName, String prefix, boolean removePrefix, String addPrefix) {
        void var1_1;
        void var2_2;
        if (methodName.isSpecial()) {
            return null;
        }
        String string = methodName.getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdentifier(...)");
        String identifier = string;
        if (!StringsKt.startsWith$default((String)string, (String)prefix, (boolean)false, (int)2, null)) {
            return null;
        }
        if (identifier.length() == prefix.length()) {
            return null;
        }
        char c = identifier.charAt(prefix.length());
        boolean bl = 'a' <= c ? c < '{' : false;
        if (bl) {
            return null;
        }
        if (addPrefix != null) {
            void var3_3;
            if (_Assertions.ENABLED && !removePrefix) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            return Name.identifier((String)var3_3 + StringsKt.removePrefix((String)identifier, (CharSequence)prefix));
        }
        if (var2_2 == false) {
            Name name;
            return name;
        }
        String name = CapitalizeDecapitalizeKt.decapitalizeSmartForCompiler(StringsKt.removePrefix((String)identifier, (CharSequence)((CharSequence)var1_1)), true);
        if (!Name.isValidIdentifier(name)) {
            return null;
        }
        return Name.identifier(name);
    }

    static /* synthetic */ Name propertyNameFromAccessorMethodName$default(Name name, String string, boolean bl, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        return PropertiesConventionUtilKt.propertyNameFromAccessorMethodName(name, string, bl, string2);
    }

    /*
     * WARNING - void declaration
     */
    public static final List<Name> getPropertyNamesCandidatesByAccessorName(Name name) {
        Name name2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = name.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String nameAsString = string;
        if (JvmAbi.isGetterName(string)) {
            return CollectionsKt.listOfNotNull((Object)PropertiesConventionUtilKt.propertyNameByGetMethodName(name));
        }
        if (JvmAbi.isSetterName((String)var1_1)) {
            return PropertiesConventionUtilKt.propertyNamesBySetMethodName(name);
        }
        return BuiltinSpecialProperties.INSTANCE.getPropertyNameCandidatesBySpecialGetterName(name2);
    }
}

