/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.components;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.builtins.jvm.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectAnnotationSource;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectKotlinClassKt;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.SignatureSerializer;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectClassUtilKt;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ClassLiteralValue;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;

final class ReflectClassStructure {
    public static final ReflectClassStructure INSTANCE = new ReflectClassStructure();

    private ReflectClassStructure() {
    }

    /*
     * WARNING - void declaration
     */
    public final void loadClassAnnotations(Class<?> klass, KotlinJvmBinaryClass.AnnotationVisitor visitor2) {
        void var2_2;
        Iterator iterator2;
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        iterator2 = ArrayIteratorKt.iterator((Object[])((Class)((Object)iterator2)).getDeclaredAnnotations());
        while (iterator2.hasNext()) {
            void var3_3;
            Annotation annotation = (Annotation)iterator2.next();
            Intrinsics.checkNotNull((Object)annotation);
            this.processAnnotation(visitor2, (Annotation)var3_3);
        }
        var2_2.visitEnd();
    }

    /*
     * WARNING - void declaration
     */
    public final void visitMembers(Class<?> klass, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)memberVisitor, (String)"memberVisitor");
        this.loadMethodAnnotations(klass, memberVisitor);
        this.loadConstructorAnnotations(klass, memberVisitor);
        this.loadFieldAnnotations((Class<?>)var1_1, (KotlinJvmBinaryClass.MemberVisitor)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private final void loadMethodAnnotations(Class<?> klass, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Iterator iterator2 = ArrayIteratorKt.iterator((Object[])klass.getDeclaredMethods());
        while (iterator2.hasNext()) {
            void var3_3;
            KotlinJvmBinaryClass.MethodAnnotationVisitor visitor2;
            Method method = (Method)iterator2.next();
            Name name = Name.identifier(method.getName());
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
            Intrinsics.checkNotNull((Object)method);
            if (memberVisitor.visitMethod(name, SignatureSerializer.INSTANCE.methodDesc(method)) == null) continue;
            Annotation[][] annotationArray = ArrayIteratorKt.iterator((Object[])method.getDeclaredAnnotations());
            while (annotationArray.hasNext()) {
                Annotation annotation = (Annotation)annotationArray.next();
                KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor = visitor2;
                Intrinsics.checkNotNull((Object)annotation);
                this.processAnnotation(annotationVisitor, annotation);
            }
            Annotation[][] annotationArray2 = var3_3.getParameterAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)annotationArray2, (String)"getParameterAnnotations(...)");
            annotationArray = annotationArray2;
            int n = ((Object[])annotationArray).length;
            for (int i = 0; i < n; ++i) {
                int parameterIndex = i;
                Object object = annotationArray[i];
                object = ArrayIteratorKt.iterator((Object[])object);
                while (object.hasNext()) {
                    KotlinJvmBinaryClass.AnnotationArgumentVisitor it;
                    Annotation annotation = (Annotation)object.next();
                    Class annotationType = JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation));
                    ClassId classId = ReflectClassUtilKt.getClassId(annotationType);
                    Intrinsics.checkNotNull((Object)annotation);
                    if (visitor2.visitParameterAnnotation(parameterIndex, classId, new ReflectAnnotationSource(annotation)) == null) continue;
                    INSTANCE.processAnnotationArguments(it, annotation, annotationType);
                }
            }
            visitor2.visitEnd();
        }
    }

    private final void loadConstructorAnnotations(Class<?> klass, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Iterator iterator2 = ArrayIteratorKt.iterator((Object[])klass.getDeclaredConstructors());
        while (iterator2.hasNext()) {
            KotlinJvmBinaryClass.MethodAnnotationVisitor visitor2;
            Constructor constructor = (Constructor)iterator2.next();
            Intrinsics.checkNotNull((Object)constructor);
            if (memberVisitor.visitMethod(SpecialNames.INIT, SignatureSerializer.INSTANCE.constructorDesc(constructor)) == null) continue;
            Iterator iterator3 = ArrayIteratorKt.iterator((Object[])constructor.getDeclaredAnnotations());
            while (iterator3.hasNext()) {
                Annotation annotation = (Annotation)iterator3.next();
                KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor = visitor2;
                Intrinsics.checkNotNull((Object)annotation);
                this.processAnnotation(annotationVisitor, annotation);
            }
            Annotation[][] parameterAnnotations = constructor.getParameterAnnotations();
            Intrinsics.checkNotNull((Object)parameterAnnotations);
            if (!(((Object[])parameterAnnotations).length == 0)) {
                Annotation[][] annotationArray;
                int shift = annotationArray.getParameterTypes().length - ((Object[])parameterAnnotations).length;
                annotationArray = parameterAnnotations;
                int n = ((Object[])annotationArray).length;
                for (int i = 0; i < n; ++i) {
                    int parameterIndex = i;
                    Object object = annotationArray[i];
                    object = ArrayIteratorKt.iterator((Object[])object);
                    while (object.hasNext()) {
                        Annotation annotation = (Annotation)object.next();
                        Class annotationType = JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation));
                        ClassId classId = ReflectClassUtilKt.getClassId(annotationType);
                        Intrinsics.checkNotNull((Object)annotation);
                        KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = visitor2.visitParameterAnnotation(parameterIndex + shift, classId, new ReflectAnnotationSource(annotation));
                        if (annotationArgumentVisitor == null) continue;
                        KotlinJvmBinaryClass.AnnotationArgumentVisitor it = annotationArgumentVisitor;
                        INSTANCE.processAnnotationArguments(it, annotation, annotationType);
                    }
                }
            }
            visitor2.visitEnd();
        }
    }

    private final void loadFieldAnnotations(Class<?> klass, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Iterator iterator2 = ArrayIteratorKt.iterator((Object[])klass.getDeclaredFields());
        while (iterator2.hasNext()) {
            KotlinJvmBinaryClass.AnnotationVisitor visitor2;
            Iterator iterator3;
            Field field = (Field)iterator2.next();
            Name name = Name.identifier(field.getName());
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
            Intrinsics.checkNotNull((Object)field);
            if (memberVisitor.visitField(name, SignatureSerializer.INSTANCE.fieldDesc(field), null) == null) continue;
            iterator3 = ArrayIteratorKt.iterator((Object[])((Field)((Object)iterator3)).getDeclaredAnnotations());
            while (iterator3.hasNext()) {
                Annotation annotation = (Annotation)iterator3.next();
                Intrinsics.checkNotNull((Object)annotation);
                this.processAnnotation(visitor2, annotation);
            }
            visitor2.visitEnd();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void processAnnotation(KotlinJvmBinaryClass.AnnotationVisitor visitor2, Annotation annotation) {
        Class annotationType = JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation));
        KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = visitor2.visitAnnotation(ReflectClassUtilKt.getClassId(annotationType), new ReflectAnnotationSource(annotation));
        if (annotationArgumentVisitor != null) {
            void var3_3;
            void var2_2;
            void var1_1;
            KotlinJvmBinaryClass.AnnotationArgumentVisitor it = annotationArgumentVisitor;
            INSTANCE.processAnnotationArguments((KotlinJvmBinaryClass.AnnotationArgumentVisitor)var1_1, (Annotation)var2_2, (Class<?>)var3_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void processAnnotationArguments(KotlinJvmBinaryClass.AnnotationArgumentVisitor visitor2, Annotation annotation, Class<?> annotationType) {
        void var1_1;
        Iterator iterator2 = ArrayIteratorKt.iterator((Object[])annotationType.getDeclaredMethods());
        while (iterator2.hasNext()) {
            Object object;
            Method method = (Method)iterator2.next();
            try {
                Intrinsics.checkNotNull((Object)method.invoke((Object)annotation, new Object[0]));
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            Object value = object;
            Name name = Name.identifier(method.getName());
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
            this.processAnnotationArgumentValue(visitor2, name, value);
        }
        var1_1.visitEnd();
    }

    /*
     * WARNING - void declaration
     */
    private final ClassLiteralValue classLiteralValue(Class<?> $this$classLiteralValue) {
        void var2_2;
        void var1_1;
        ClassId kotlinClassId;
        PrimitiveType primitiveType;
        Class<?> currentClass = $this$classLiteralValue;
        int dimensions = 0;
        while (currentClass.isArray()) {
            ++dimensions;
            currentClass = currentClass.getComponentType();
        }
        if (currentClass.isPrimitive()) {
            if (Intrinsics.areEqual(currentClass, Void.TYPE)) {
                FqName fqName = StandardNames.FqNames.unit.toSafe();
                Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"toSafe(...)");
                return new ClassLiteralValue(ClassId.Companion.topLevel(fqName), dimensions);
            }
            PrimitiveType primitiveType2 = JvmPrimitiveType.get(currentClass.getName()).getPrimitiveType();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)primitiveType2), (String)"getPrimitiveType(...)");
            primitiveType = primitiveType2;
            if (dimensions > 0) {
                return new ClassLiteralValue(ClassId.Companion.topLevel(primitiveType.getArrayTypeFqName()), dimensions - 1);
            }
            return new ClassLiteralValue(ClassId.Companion.topLevel(primitiveType.getTypeFqName()), dimensions);
        }
        ClassId javaClassId = ReflectClassUtilKt.getClassId(primitiveType);
        ClassId classId = JavaToKotlinClassMap.INSTANCE.mapJavaToKotlin(javaClassId.asSingleFqName());
        if (classId == null) {
            classId = kotlinClassId;
        }
        kotlinClassId = classId;
        return new ClassLiteralValue((ClassId)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private final void processAnnotationArgumentValue(KotlinJvmBinaryClass.AnnotationArgumentVisitor visitor2, Name name, Object value) {
        void var3_6;
        void var4_11;
        KotlinJvmBinaryClass.AnnotationArgumentVisitor v;
        Class<?> clazz = value.getClass();
        if (Intrinsics.areEqual(clazz, Class.class)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type java.lang.Class<*>");
            visitor2.visitClassLiteral(name, this.classLiteralValue((Class)value));
            return;
        }
        if (ReflectKotlinClassKt.access$getTYPES_ELIGIBLE_FOR_SIMPLE_VISIT$p().contains(clazz)) {
            visitor2.visit(name, value);
            return;
        }
        if (ReflectClassUtilKt.isEnumClassOrSpecializedEnumEntryClass(clazz)) {
            clazz = clazz.isEnum() ? clazz : clazz.getEnclosingClass();
            Intrinsics.checkNotNull(clazz);
            ClassId classId = ReflectClassUtilKt.getClassId(clazz);
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Enum<*>");
            Name name2 = Name.identifier(((Enum)value).name());
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
            visitor2.visitEnum(name, classId, name2);
            return;
        }
        if (Annotation.class.isAssignableFrom(clazz)) {
            Class<?>[] classArray = clazz.getInterfaces();
            Intrinsics.checkNotNullExpressionValue(classArray, (String)"getInterfaces(...)");
            Class annotationClass = (Class)ArraysKt.single((Object[])classArray);
            Intrinsics.checkNotNull((Object)annotationClass);
            KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = visitor2.visitAnnotation(name, ReflectClassUtilKt.getClassId(annotationClass));
            if (annotationArgumentVisitor == null) {
                return;
            }
            v = annotationArgumentVisitor;
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Annotation");
            this.processAnnotationArguments(v, (Annotation)value, annotationClass);
            return;
        }
        if (((Class)((Object)v)).isArray()) {
            Object[] objectArray;
            KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor annotationArrayArgumentVisitor = visitor2.visitArray((Name)objectArray);
            if (annotationArrayArgumentVisitor == null) {
                return;
            }
            KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor v2 = annotationArrayArgumentVisitor;
            Class<?> componentType = ((Class)((Object)v)).getComponentType();
            if (componentType.isEnum()) {
                Intrinsics.checkNotNull(componentType);
                ClassId enumClassId = ReflectClassUtilKt.getClassId(componentType);
                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Array<*>");
                for (Object element : (Object[])value) {
                    Intrinsics.checkNotNull((Object)element, (String)"null cannot be cast to non-null type kotlin.Enum<*>");
                    Name name3 = Name.identifier(((Enum)element).name());
                    Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
                    v2.visitEnum(enumClassId, name3);
                }
            } else if (Intrinsics.areEqual(componentType, Class.class)) {
                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Array<*>");
                for (Object element : (Object[])value) {
                    Intrinsics.checkNotNull((Object)element, (String)"null cannot be cast to non-null type java.lang.Class<*>");
                    v2.visitClassLiteral(this.classLiteralValue((Class)element));
                }
            } else if (Annotation.class.isAssignableFrom(componentType)) {
                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Array<*>");
                for (Object element : (Object[])value) {
                    KotlinJvmBinaryClass.AnnotationArgumentVisitor vv;
                    Intrinsics.checkNotNull(componentType);
                    if (v2.visitAnnotation(ReflectClassUtilKt.getClassId(componentType)) == null) continue;
                    Intrinsics.checkNotNull((Object)element, (String)"null cannot be cast to non-null type kotlin.Annotation");
                    this.processAnnotationArguments(vv, (Annotation)element, componentType);
                }
            } else {
                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Array<*>");
                for (Object element : (Object[])value) {
                    v2.visit(element);
                }
            }
            v2.visitEnd();
            return;
        }
        throw new UnsupportedOperationException("Unsupported annotation argument value (" + var4_11 + "): " + var3_6);
    }
}

