/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageViewDescriptor;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.DescriptorKindExclude;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.DescriptorKindFilter;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScopeImpl;
import kotlin.reflect.jvm.internal.impl.utils.CollectionsKt;

public class SubpackagesScope
extends MemberScopeImpl {
    private final ModuleDescriptor moduleDescriptor;
    private final FqName fqName;

    /*
     * WARNING - void declaration
     */
    public SubpackagesScope(ModuleDescriptor moduleDescriptor, FqName fqName) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        this.moduleDescriptor = var1_1;
        this.fqName = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected final PackageViewDescriptor getPackage(Name name) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (name.isSpecial()) {
            return null;
        }
        FqName fqName = this.fqName.child(name);
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"child(...)");
        PackageViewDescriptor packageViewDescriptor = this.moduleDescriptor.getPackage(fqName);
        if (packageViewDescriptor.isEmpty()) {
            return null;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Collection<DeclarationDescriptor> getContributedDescriptors(DescriptorKindFilter kindFilter, Function1<? super Name, Boolean> nameFilter) {
        void var3_3;
        Iterator iterator2;
        Intrinsics.checkNotNullParameter((Object)kindFilter, (String)"kindFilter");
        Intrinsics.checkNotNullParameter(nameFilter, (String)"nameFilter");
        if (!kindFilter.acceptsKinds(DescriptorKindFilter.Companion.getPACKAGES_MASK())) {
            return kotlin.collections.CollectionsKt.emptyList();
        }
        if (this.fqName.isRoot() && kindFilter.getExcludes().contains(DescriptorKindExclude.TopLevelPackages.INSTANCE)) {
            return kotlin.collections.CollectionsKt.emptyList();
        }
        Collection<FqName> subFqNames = this.moduleDescriptor.getSubPackagesOf(this.fqName, nameFilter);
        ArrayList result = new ArrayList(subFqNames.size());
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            Name shortName;
            FqName fqName = (FqName)iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)fqName.shortName(), (String)"shortName(...)");
            if (!((Boolean)nameFilter.invoke((Object)shortName)).booleanValue()) continue;
            CollectionsKt.addIfNotNull(result, this.getPackage(shortName));
        }
        return (Collection)var3_3;
    }

    @Override
    public Set<Name> getClassifierNames() {
        return SetsKt.emptySet();
    }

    public String toString() {
        return "subpackages of " + this.fqName + " from " + this.moduleDescriptor;
    }
}

