/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorVisitor;
import kotlin.reflect.jvm.internal.impl.descriptors.InvalidModuleExceptionKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleCapability;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentProvider;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageViewDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.CompositePackageFragmentProvider;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.DeclarationDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.ModuleDependencies;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.ModuleDependenciesImpl;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.ModuleDescriptorImpl$$Lambda$0;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.ModuleDescriptorImpl$$Lambda$1;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.PackageViewDescriptorFactory;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.platform.TargetPlatform;
import kotlin.reflect.jvm.internal.impl.storage.MemoizedFunctionToNotNull;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;

@SourceDebugExtension(value={"SMAP\nModuleDescriptorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleDescriptorImpl.kt\norg/jetbrains/kotlin/descriptors/impl/ModuleDescriptorImpl\n+ 2 coreLib.kt\norg/jetbrains/kotlin/utils/CoreLibKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,180:1\n19#2:181\n19#2:185\n19#2:186\n19#2:188\n774#3:182\n865#3,2:183\n1863#3,2:189\n1557#3:191\n1628#3,3:192\n1#4:187\n*S KotlinDebug\n*F\n+ 1 ModuleDescriptorImpl.kt\norg/jetbrains/kotlin/descriptors/impl/ModuleDescriptorImpl\n*L\n72#1:181\n75#1:185\n78#1:186\n91#1:188\n72#1:182\n72#1:183,2\n95#1:189,2\n101#1:191\n101#1:192,3\n*E\n"})
public final class ModuleDescriptorImpl
extends DeclarationDescriptorImpl
implements ModuleDescriptor {
    private final StorageManager storageManager;
    private final KotlinBuiltIns builtIns;
    private final TargetPlatform platform;
    private final Name stableName;
    private final Map<ModuleCapability<?>, Object> capabilities;
    private final PackageViewDescriptorFactory packageViewDescriptorFactory;
    private ModuleDependencies dependencies;
    private PackageFragmentProvider packageFragmentProviderForModuleContent;
    private boolean isValid;
    private final MemoizedFunctionToNotNull<FqName, PackageViewDescriptor> packages;
    private final Lazy packageFragmentProviderForWholeModuleWithDependencies$delegate;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public ModuleDescriptorImpl(Name moduleName, StorageManager storageManager, KotlinBuiltIns builtIns, TargetPlatform platform, Map<ModuleCapability<?>, ? extends Object> capabilities, Name stableName) {
        ModuleDescriptorImpl moduleDescriptorImpl;
        void var3_3;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        Intrinsics.checkNotNullParameter(capabilities, (String)"capabilities");
        super(Annotations.Companion.getEMPTY(), moduleName);
        this.storageManager = var2_2;
        this.builtIns = var3_3;
        this.platform = platform;
        this.stableName = stableName;
        if (!moduleName.isSpecial()) {
            throw new IllegalArgumentException("Module name must be special: " + moduleDescriptorImpl);
        }
        this.capabilities = capabilities;
        PackageViewDescriptorFactory packageViewDescriptorFactory = this.getCapability(PackageViewDescriptorFactory.Companion.getCAPABILITY());
        if (packageViewDescriptorFactory == null) {
            packageViewDescriptorFactory = PackageViewDescriptorFactory.Default.INSTANCE;
        }
        this.packageViewDescriptorFactory = packageViewDescriptorFactory;
        this.isValid = true;
        moduleDescriptorImpl = this;
        this.packages = this.storageManager.createMemoizedFunction(new ModuleDescriptorImpl$$Lambda$0(moduleDescriptorImpl));
        moduleDescriptorImpl = this;
        this.packageFragmentProviderForWholeModuleWithDependencies$delegate = LazyKt.lazy((Function0)new ModuleDescriptorImpl$$Lambda$1(moduleDescriptorImpl));
    }

    public /* synthetic */ ModuleDescriptorImpl(Name name, StorageManager storageManager, KotlinBuiltIns kotlinBuiltIns, TargetPlatform targetPlatform, Map map, Name name2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            targetPlatform = null;
        }
        if ((n & 0x10) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 0x20) != 0) {
            name2 = null;
        }
        this(name, storageManager, kotlinBuiltIns, targetPlatform, map, name2);
    }

    @Override
    public final KotlinBuiltIns getBuiltIns() {
        return this.builtIns;
    }

    public final boolean isValid() {
        return this.isValid;
    }

    public final void assertValid() {
        if (!this.isValid()) {
            InvalidModuleExceptionKt.moduleInvalidated(this);
        }
    }

    @Override
    public final List<ModuleDescriptor> getExpectedByModules() {
        Object object = this.dependencies;
        if (object == null) {
            object = "Dependencies of module " + this.getId() + " were not set";
            throw new AssertionError(object);
        }
        return object.getDirectExpectedByDependencies();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final PackageViewDescriptor getPackage(FqName fqName) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        this.assertValid();
        return (PackageViewDescriptor)this.packages.invoke(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Collection<FqName> getSubPackagesOf(FqName fqName, Function1<? super Name, Boolean> nameFilter) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        Intrinsics.checkNotNullParameter(nameFilter, (String)"nameFilter");
        this.assertValid();
        return this.getPackageFragmentProvider().getSubPackagesOf((FqName)var1_1, (Function1<? super Name, Boolean>)var2_2);
    }

    private final CompositePackageFragmentProvider getPackageFragmentProviderForWholeModuleWithDependencies() {
        Lazy lazy = this.packageFragmentProviderForWholeModuleWithDependencies$delegate;
        return (CompositePackageFragmentProvider)lazy.getValue();
    }

    private final boolean isInitialized() {
        return this.packageFragmentProviderForModuleContent != null;
    }

    /*
     * WARNING - void declaration
     */
    public final void setDependencies(ModuleDependencies dependencies) {
        void var1_1;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)dependencies, (String)"dependencies");
        boolean bl2 = bl = this.dependencies == null;
        if (_Assertions.ENABLED && !bl) {
            dependencies = "Dependencies of " + this.getId() + " were already set";
            throw new AssertionError(dependencies);
        }
        this.dependencies = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setDependencies(ModuleDescriptorImpl ... descriptors) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)descriptors, (String)"descriptors");
        this.setDependencies(ArraysKt.toList((Object[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final void setDependencies(List<ModuleDescriptorImpl> descriptors) {
        void var1_1;
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        this.setDependencies((List<ModuleDescriptorImpl>)var1_1, SetsKt.emptySet());
    }

    /*
     * WARNING - void declaration
     */
    public final void setDependencies(List<ModuleDescriptorImpl> descriptors, Set<ModuleDescriptorImpl> friends) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        Intrinsics.checkNotNullParameter(friends, (String)"friends");
        this.setDependencies(new ModuleDependenciesImpl((List<ModuleDescriptorImpl>)var1_1, (Set<ModuleDescriptorImpl>)var2_2, CollectionsKt.emptyList(), SetsKt.emptySet()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean shouldSeeInternalsOf(ModuleDescriptor targetModule) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)targetModule, (String)"targetModule");
        if (Intrinsics.areEqual((Object)this, (Object)targetModule)) {
            return true;
        }
        ModuleDependencies moduleDependencies = this.dependencies;
        Intrinsics.checkNotNull((Object)moduleDependencies);
        if (CollectionsKt.contains((Iterable)moduleDependencies.getModulesWhoseInternalsAreVisible(), (Object)targetModule)) {
            return true;
        }
        if (this.getExpectedByModules().contains(targetModule)) {
            return true;
        }
        return var1_1.getExpectedByModules().contains(this);
    }

    private final String getId() {
        String string = this.getName().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public final void initialize(PackageFragmentProvider providerForModuleContent) {
        void var1_1;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)providerForModuleContent, (String)"providerForModuleContent");
        boolean bl2 = bl = !this.isInitialized();
        if (_Assertions.ENABLED && !bl) {
            providerForModuleContent = "Attempt to initialize module " + this.getId() + " twice";
            throw new AssertionError(providerForModuleContent);
        }
        this.packageFragmentProviderForModuleContent = var1_1;
    }

    public final PackageFragmentProvider getPackageFragmentProvider() {
        this.assertValid();
        return this.getPackageFragmentProviderForWholeModuleWithDependencies();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> T getCapability(ModuleCapability<T> capability) {
        void var1_1;
        Intrinsics.checkNotNullParameter(capability, (String)"capability");
        Object object = this.capabilities.get(var1_1);
        if (object == null) {
            object = null;
        }
        return (T)object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String toString() {
        void var2_2;
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u2413 = stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        if (!this.isValid()) {
            $this$toString_u24lambda_u2413.append(" !isValid");
        }
        $this$toString_u24lambda_u2413.append(" packageFragmentProvider: ");
        Object object = this.packageFragmentProviderForModuleContent;
        var2_2.append(object != null && (object = object.getClass()) != null ? ((Class)object).getSimpleName() : null);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public final DeclarationDescriptor getContainingDeclaration() {
        return ModuleDescriptor.DefaultImpls.getContainingDeclaration(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor2, D data) {
        void var2_2;
        void var1_1;
        return ModuleDescriptor.DefaultImpls.accept(this, var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public ModuleDescriptorImpl(Name moduleName, StorageManager storageManager, KotlinBuiltIns builtIns, TargetPlatform platform) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        this((Name)var1_1, (StorageManager)var2_2, (KotlinBuiltIns)var3_3, platform, null, null, 48, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final PackageViewDescriptor packages$lambda$0(ModuleDescriptorImpl this$0, FqName fqName) {
        ModuleDescriptorImpl moduleDescriptorImpl;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        return this$0.packageViewDescriptorFactory.compute(this$0, (FqName)var1_1, moduleDescriptorImpl.storageManager);
    }

    private static final CompositePackageFragmentProvider packageFragmentProviderForWholeModuleWithDependencies_delegate$lambda$10(ModuleDescriptorImpl this$0) {
        String string;
        ModuleDescriptorImpl $this$mapTo$iv$iv;
        Object object;
        Object object2 = object = ((ModuleDescriptorImpl)this$0).dependencies;
        if (object2 == null) {
            this$0 = "Dependencies of module " + ((ModuleDescriptorImpl)this$0).getId() + " were not set before querying module content";
            throw new AssertionError(this$0);
        }
        object = object2;
        List<ModuleDescriptorImpl> dependenciesDescriptors = object2.getAllDependencies();
        ((ModuleDescriptorImpl)this$0).assertValid();
        boolean bl = dependenciesDescriptors.contains(this$0);
        if (_Assertions.ENABLED && !bl) {
            this$0 = "Module " + super.getId() + " is not contained in its own dependencies, this is probably a misconfiguration";
            throw new AssertionError(this$0);
        }
        Iterable iterable = dependenciesDescriptors;
        Object object3 = iterable.iterator();
        while (object3.hasNext()) {
            iterable = object3.next();
            ModuleDescriptorImpl dependency = (ModuleDescriptorImpl)((Object)iterable);
            boolean bl2 = dependency.isInitialized();
            if (!_Assertions.ENABLED || bl2) continue;
            object3 = "Dependency module " + dependency.getId() + " was not initialized by the time contents of dependent module " + super.getId() + " were queried";
            throw new AssertionError(object3);
        }
        Iterable $this$map$iv = (Iterable)object;
        object3 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        object = $this$mapTo$iv$iv.iterator();
        while (object.hasNext()) {
            Object item$iv$iv = object.next();
            $this$mapTo$iv$iv = (ModuleDescriptorImpl)item$iv$iv;
            Collection collection = destination$iv$iv;
            PackageFragmentProvider packageFragmentProvider = ((ModuleDescriptorImpl)object3).packageFragmentProviderForModuleContent;
            Intrinsics.checkNotNull((Object)packageFragmentProvider);
            collection.add(packageFragmentProvider);
        }
        string = "CompositeProvider@ModuleDescriptor for " + ((DeclarationDescriptorImpl)((Object)string)).getName();
        object = (List)iterable;
        return new CompositePackageFragmentProvider((List<? extends PackageFragmentProvider>)object, string);
    }

    static /* synthetic */ PackageViewDescriptor accessor$ModuleDescriptorImpl$lambda0(ModuleDescriptorImpl moduleDescriptorImpl, FqName fqName) {
        return ModuleDescriptorImpl.packages$lambda$0(moduleDescriptorImpl, fqName);
    }

    static /* synthetic */ CompositePackageFragmentProvider accessor$ModuleDescriptorImpl$lambda1(ModuleDescriptorImpl moduleDescriptorImpl) {
        return ModuleDescriptorImpl.packageFragmentProviderForWholeModuleWithDependencies_delegate$lambda$10(moduleDescriptorImpl);
    }
}

