/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins.jvm;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.builtins.jvm.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.load.kotlin.SignatureBuildingComponents;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;

@SourceDebugExtension(value={"SMAP\nJvmBuiltInsSignatures.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmBuiltInsSignatures.kt\norg/jetbrains/kotlin/builtins/jvm/JvmBuiltInsSignatures\n+ 2 SignatureBuildingComponents.kt\norg/jetbrains/kotlin/load/kotlin/SignatureBuildingComponentsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,212:1\n13#2:213\n13#2:219\n13#2:225\n13#2:226\n13#2:227\n13#2:228\n13#2:229\n13#2:230\n1454#3,5:214\n1454#3,5:220\n*S KotlinDebug\n*F\n+ 1 JvmBuiltInsSignatures.kt\norg/jetbrains/kotlin/builtins/jvm/JvmBuiltInsSignatures\n*L\n64#1:213\n185#1:219\n23#1:225\n71#1:226\n80#1:227\n136#1:228\n163#1:229\n180#1:230\n65#1:214,5\n189#1:220,5\n*E\n"})
public final class JvmBuiltInsSignatures {
    public static final JvmBuiltInsSignatures INSTANCE = new JvmBuiltInsSignatures();
    private static final Set<String> DROP_LIST_METHOD_SIGNATURES;
    private static final Set<String> HIDDEN_METHOD_SIGNATURES;
    private static final Set<String> DEPRECATED_LIST_METHODS;
    private static final Set<String> VISIBLE_METHOD_SIGNATURES;
    private static final Set<String> MUTABLE_METHOD_SIGNATURES;
    private static final Set<String> HIDDEN_CONSTRUCTOR_SIGNATURES;
    private static final Set<String> VISIBLE_CONSTRUCTOR_SIGNATURES;

    private JvmBuiltInsSignatures() {
    }

    public final Set<String> getDROP_LIST_METHOD_SIGNATURES() {
        return DROP_LIST_METHOD_SIGNATURES;
    }

    public final Set<String> getHIDDEN_METHOD_SIGNATURES() {
        return HIDDEN_METHOD_SIGNATURES;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> buildPrimitiveValueMethodsSet() {
        void var3_3;
        SignatureBuildingComponents $this$buildPrimitiveValueMethodsSet_u24lambda_u242 = SignatureBuildingComponents.INSTANCE;
        JvmPrimitiveType[] jvmPrimitiveTypeArray = new JvmPrimitiveType[2];
        Object object = jvmPrimitiveTypeArray;
        jvmPrimitiveTypeArray[0] = JvmPrimitiveType.BOOLEAN;
        object[1] = JvmPrimitiveType.CHAR;
        object = CollectionsKt.listOf((Object[])object);
        Collection destination$iv = new LinkedHashSet();
        object = object.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            JvmPrimitiveType it = (JvmPrimitiveType)((Object)e);
            String string = it.getWrapperFqName().shortName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            String[] stringArray = new String[1];
            String[] stringArray2 = stringArray;
            stringArray[0] = it.getJavaKeywordName() + "Value()" + it.getDesc();
            Iterable list$iv = $this$buildPrimitiveValueMethodsSet_u24lambda_u242.inJavaLang(string, stringArray2);
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        return (LinkedHashSet)var3_3;
    }

    public final Set<String> getDEPRECATED_LIST_METHODS() {
        return DEPRECATED_LIST_METHODS;
    }

    public final Set<String> getVISIBLE_METHOD_SIGNATURES() {
        return VISIBLE_METHOD_SIGNATURES;
    }

    public final Set<String> getMUTABLE_METHOD_SIGNATURES() {
        return MUTABLE_METHOD_SIGNATURES;
    }

    public final Set<String> getHIDDEN_CONSTRUCTOR_SIGNATURES() {
        return HIDDEN_CONSTRUCTOR_SIGNATURES;
    }

    public final Set<String> getVISIBLE_CONSTRUCTOR_SIGNATURES() {
        return VISIBLE_CONSTRUCTOR_SIGNATURES;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> buildPrimitiveStringConstructorsSet() {
        void var3_3;
        SignatureBuildingComponents $this$buildPrimitiveStringConstructorsSet_u24lambda_u249 = SignatureBuildingComponents.INSTANCE;
        JvmPrimitiveType[] jvmPrimitiveTypeArray = new JvmPrimitiveType[8];
        Object object = jvmPrimitiveTypeArray;
        jvmPrimitiveTypeArray[0] = JvmPrimitiveType.BOOLEAN;
        object[1] = JvmPrimitiveType.BYTE;
        object[2] = JvmPrimitiveType.DOUBLE;
        object[3] = JvmPrimitiveType.FLOAT;
        object[4] = JvmPrimitiveType.BYTE;
        object[5] = JvmPrimitiveType.INT;
        object[6] = JvmPrimitiveType.LONG;
        object[7] = JvmPrimitiveType.SHORT;
        object = CollectionsKt.listOf((Object[])object);
        Collection destination$iv = new LinkedHashSet();
        object = object.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            String[] it = (String[])e;
            String string = it.getWrapperFqName().shortName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            String[] stringArray = new String[1];
            it = stringArray;
            stringArray[0] = "Ljava/lang/String;";
            it = $this$buildPrimitiveStringConstructorsSet_u24lambda_u249.constructors(it);
            Iterable list$iv = $this$buildPrimitiveStringConstructorsSet_u24lambda_u249.inJavaLang(string, Arrays.copyOf(it, it.length));
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        return (LinkedHashSet)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isSerializableInJava(FqNameUnsafe fqName) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        if (this.isArrayOrPrimitiveArray(fqName)) {
            return true;
        }
        ClassId classId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(fqName);
        if (classId == null) {
            return false;
        }
        Object javaClassId = classId;
        try {
            javaClassId = Class.forName(((ClassId)javaClassId).asSingleFqName().asString());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return Serializable.class.isAssignableFrom((Class<?>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isArrayOrPrimitiveArray(FqNameUnsafe fqName) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        return Intrinsics.areEqual((Object)fqName, (Object)StandardNames.FqNames.array) || StandardNames.isPrimitiveArray((FqNameUnsafe)var1_1);
    }

    static {
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        stringArray[0] = "toArray()[Ljava/lang/Object;";
        stringArray2[1] = "toArray([Ljava/lang/Object;)[Ljava/lang/Object;";
        DROP_LIST_METHOD_SIGNATURES = SetsKt.plus(SignatureBuildingComponents.INSTANCE.inJavaUtil("Collection", stringArray2), (Object)"java/lang/annotation/Annotation.annotationType()Ljava/lang/Class;");
        SignatureBuildingComponents $this$HIDDEN_METHOD_SIGNATURES_u24lambda_u240 = SignatureBuildingComponents.INSTANCE;
        String[] stringArray3 = new String[2];
        String[] stringArray4 = stringArray3;
        stringArray3[0] = "sort(Ljava/util/Comparator;)V";
        stringArray4[1] = "reversed()Ljava/util/List;";
        Set set = SetsKt.plus(INSTANCE.buildPrimitiveValueMethodsSet(), (Iterable)$this$HIDDEN_METHOD_SIGNATURES_u24lambda_u240.inJavaUtil("List", stringArray4));
        String[] stringArray5 = new String[48];
        stringArray4 = stringArray5;
        stringArray5[0] = "codePointAt(I)I";
        stringArray4[1] = "codePointBefore(I)I";
        stringArray4[2] = "codePointCount(II)I";
        stringArray4[3] = "compareToIgnoreCase(Ljava/lang/String;)I";
        stringArray4[4] = "concat(Ljava/lang/String;)Ljava/lang/String;";
        stringArray4[5] = "contains(Ljava/lang/CharSequence;)Z";
        stringArray4[6] = "contentEquals(Ljava/lang/CharSequence;)Z";
        stringArray4[7] = "contentEquals(Ljava/lang/StringBuffer;)Z";
        stringArray4[8] = "endsWith(Ljava/lang/String;)Z";
        stringArray4[9] = "equalsIgnoreCase(Ljava/lang/String;)Z";
        stringArray4[10] = "getBytes()[B";
        stringArray4[11] = "getBytes(II[BI)V";
        stringArray4[12] = "getBytes(Ljava/lang/String;)[B";
        stringArray4[13] = "getBytes(Ljava/nio/charset/Charset;)[B";
        stringArray4[14] = "getChars(II[CI)V";
        stringArray4[15] = "indexOf(I)I";
        stringArray4[16] = "indexOf(II)I";
        stringArray4[17] = "indexOf(Ljava/lang/String;)I";
        stringArray4[18] = "indexOf(Ljava/lang/String;I)I";
        stringArray4[19] = "intern()Ljava/lang/String;";
        stringArray4[20] = "isEmpty()Z";
        stringArray4[21] = "lastIndexOf(I)I";
        stringArray4[22] = "lastIndexOf(II)I";
        stringArray4[23] = "lastIndexOf(Ljava/lang/String;)I";
        stringArray4[24] = "lastIndexOf(Ljava/lang/String;I)I";
        stringArray4[25] = "matches(Ljava/lang/String;)Z";
        stringArray4[26] = "offsetByCodePoints(II)I";
        stringArray4[27] = "regionMatches(ILjava/lang/String;II)Z";
        stringArray4[28] = "regionMatches(ZILjava/lang/String;II)Z";
        stringArray4[29] = "replaceAll(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;";
        stringArray4[30] = "replace(CC)Ljava/lang/String;";
        stringArray4[31] = "replaceFirst(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;";
        stringArray4[32] = "replace(Ljava/lang/CharSequence;Ljava/lang/CharSequence;)Ljava/lang/String;";
        stringArray4[33] = "split(Ljava/lang/String;I)[Ljava/lang/String;";
        stringArray4[34] = "split(Ljava/lang/String;)[Ljava/lang/String;";
        stringArray4[35] = "startsWith(Ljava/lang/String;I)Z";
        stringArray4[36] = "startsWith(Ljava/lang/String;)Z";
        stringArray4[37] = "substring(II)Ljava/lang/String;";
        stringArray4[38] = "substring(I)Ljava/lang/String;";
        stringArray4[39] = "toCharArray()[C";
        stringArray4[40] = "toLowerCase()Ljava/lang/String;";
        stringArray4[41] = "toLowerCase(Ljava/util/Locale;)Ljava/lang/String;";
        stringArray4[42] = "toUpperCase()Ljava/lang/String;";
        stringArray4[43] = "toUpperCase(Ljava/util/Locale;)Ljava/lang/String;";
        stringArray4[44] = "trim()Ljava/lang/String;";
        stringArray4[45] = "isBlank()Z";
        stringArray4[46] = "lines()Ljava/util/stream/Stream;";
        stringArray4[47] = "repeat(I)Ljava/lang/String;";
        Set set2 = SetsKt.plus((Set)set, (Iterable)$this$HIDDEN_METHOD_SIGNATURES_u24lambda_u240.inJavaLang("String", stringArray4));
        String[] stringArray6 = new String[2];
        stringArray4 = stringArray6;
        stringArray6[0] = "isInfinite()Z";
        stringArray4[1] = "isNaN()Z";
        Set set3 = SetsKt.plus((Set)set2, (Iterable)$this$HIDDEN_METHOD_SIGNATURES_u24lambda_u240.inJavaLang("Double", stringArray4));
        String[] stringArray7 = new String[2];
        stringArray4 = stringArray7;
        stringArray7[0] = "isInfinite()Z";
        stringArray4[1] = "isNaN()Z";
        Set set4 = SetsKt.plus((Set)set3, (Iterable)$this$HIDDEN_METHOD_SIGNATURES_u24lambda_u240.inJavaLang("Float", stringArray4));
        String[] stringArray8 = new String[2];
        stringArray4 = stringArray8;
        stringArray8[0] = "getDeclaringClass()Ljava/lang/Class;";
        stringArray4[1] = "finalize()V";
        Set set5 = SetsKt.plus((Set)set4, (Iterable)$this$HIDDEN_METHOD_SIGNATURES_u24lambda_u240.inJavaLang("Enum", stringArray4));
        String[] stringArray9 = new String[1];
        stringArray4 = stringArray9;
        stringArray9[0] = "isEmpty()Z";
        HIDDEN_METHOD_SIGNATURES = SetsKt.plus((Set)set5, (Iterable)$this$HIDDEN_METHOD_SIGNATURES_u24lambda_u240.inJavaLang("CharSequence", stringArray4));
        $this$HIDDEN_METHOD_SIGNATURES_u24lambda_u240 = SignatureBuildingComponents.INSTANCE;
        String[] stringArray10 = new String[2];
        stringArray4 = stringArray10;
        stringArray10[0] = "getFirst()Ljava/lang/Object;";
        stringArray4[1] = "getLast()Ljava/lang/Object;";
        DEPRECATED_LIST_METHODS = $this$HIDDEN_METHOD_SIGNATURES_u24lambda_u240.inJavaUtil("List", stringArray4);
        SignatureBuildingComponents $this$VISIBLE_METHOD_SIGNATURES_u24lambda_u244 = SignatureBuildingComponents.INSTANCE;
        String[] stringArray11 = new String[2];
        stringArray4 = stringArray11;
        stringArray11[0] = "codePoints()Ljava/util/stream/IntStream;";
        stringArray4[1] = "chars()Ljava/util/stream/IntStream;";
        Set<String> set6 = $this$VISIBLE_METHOD_SIGNATURES_u24lambda_u244.inJavaLang("CharSequence", stringArray4);
        String[] stringArray12 = new String[1];
        stringArray4 = stringArray12;
        stringArray12[0] = "forEachRemaining(Ljava/util/function/Consumer;)V";
        Set set7 = SetsKt.plus(set6, (Iterable)$this$VISIBLE_METHOD_SIGNATURES_u24lambda_u244.inJavaUtil("Iterator", stringArray4));
        String[] stringArray13 = new String[2];
        stringArray4 = stringArray13;
        stringArray13[0] = "forEach(Ljava/util/function/Consumer;)V";
        stringArray4[1] = "spliterator()Ljava/util/Spliterator;";
        Set set8 = SetsKt.plus((Set)set7, (Iterable)$this$VISIBLE_METHOD_SIGNATURES_u24lambda_u244.inJavaLang("Iterable", stringArray4));
        String[] stringArray14 = new String[10];
        stringArray4 = stringArray14;
        stringArray14[0] = "setStackTrace([Ljava/lang/StackTraceElement;)V";
        stringArray4[1] = "fillInStackTrace()Ljava/lang/Throwable;";
        stringArray4[2] = "getLocalizedMessage()Ljava/lang/String;";
        stringArray4[3] = "printStackTrace()V";
        stringArray4[4] = "printStackTrace(Ljava/io/PrintStream;)V";
        stringArray4[5] = "printStackTrace(Ljava/io/PrintWriter;)V";
        stringArray4[6] = "getStackTrace()[Ljava/lang/StackTraceElement;";
        stringArray4[7] = "initCause(Ljava/lang/Throwable;)Ljava/lang/Throwable;";
        stringArray4[8] = "getSuppressed()[Ljava/lang/Throwable;";
        stringArray4[9] = "addSuppressed(Ljava/lang/Throwable;)V";
        Set set9 = SetsKt.plus((Set)set8, (Iterable)$this$VISIBLE_METHOD_SIGNATURES_u24lambda_u244.inJavaLang("Throwable", stringArray4));
        String[] stringArray15 = new String[4];
        stringArray4 = stringArray15;
        stringArray15[0] = "spliterator()Ljava/util/Spliterator;";
        stringArray4[1] = "parallelStream()Ljava/util/stream/Stream;";
        stringArray4[2] = "stream()Ljava/util/stream/Stream;";
        stringArray4[3] = "removeIf(Ljava/util/function/Predicate;)Z";
        Set set10 = SetsKt.plus((Set)set9, (Iterable)$this$VISIBLE_METHOD_SIGNATURES_u24lambda_u244.inJavaUtil("Collection", stringArray4));
        String[] stringArray16 = new String[5];
        stringArray4 = stringArray16;
        stringArray16[0] = "replaceAll(Ljava/util/function/UnaryOperator;)V";
        stringArray4[1] = "addFirst(Ljava/lang/Object;)V";
        stringArray4[2] = "addLast(Ljava/lang/Object;)V";
        stringArray4[3] = "removeFirst()Ljava/lang/Object;";
        stringArray4[4] = "removeLast()Ljava/lang/Object;";
        Set set11 = SetsKt.plus((Set)set10, (Iterable)$this$VISIBLE_METHOD_SIGNATURES_u24lambda_u244.inJavaUtil("List", stringArray4));
        String[] stringArray17 = new String[10];
        stringArray4 = stringArray17;
        stringArray17[0] = "getOrDefault(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;";
        stringArray4[1] = "forEach(Ljava/util/function/BiConsumer;)V";
        stringArray4[2] = "replaceAll(Ljava/util/function/BiFunction;)V";
        stringArray4[3] = "merge(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;";
        stringArray4[4] = "computeIfPresent(Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;";
        stringArray4[5] = "putIfAbsent(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;";
        stringArray4[6] = "replace(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Z";
        stringArray4[7] = "replace(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;";
        stringArray4[8] = "computeIfAbsent(Ljava/lang/Object;Ljava/util/function/Function;)Ljava/lang/Object;";
        stringArray4[9] = "compute(Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;";
        VISIBLE_METHOD_SIGNATURES = SetsKt.plus((Set)set11, (Iterable)$this$VISIBLE_METHOD_SIGNATURES_u24lambda_u244.inJavaUtil("Map", stringArray4));
        SignatureBuildingComponents $this$MUTABLE_METHOD_SIGNATURES_u24lambda_u245 = SignatureBuildingComponents.INSTANCE;
        String[] stringArray18 = new String[1];
        stringArray4 = stringArray18;
        stringArray18[0] = "removeIf(Ljava/util/function/Predicate;)Z";
        Set<String> set12 = $this$MUTABLE_METHOD_SIGNATURES_u24lambda_u245.inJavaUtil("Collection", stringArray4);
        String[] stringArray19 = new String[6];
        stringArray4 = stringArray19;
        stringArray19[0] = "replaceAll(Ljava/util/function/UnaryOperator;)V";
        stringArray4[1] = "sort(Ljava/util/Comparator;)V";
        stringArray4[2] = "addFirst(Ljava/lang/Object;)V";
        stringArray4[3] = "addLast(Ljava/lang/Object;)V";
        stringArray4[4] = "removeFirst()Ljava/lang/Object;";
        stringArray4[5] = "removeLast()Ljava/lang/Object;";
        Set set13 = SetsKt.plus(set12, (Iterable)$this$MUTABLE_METHOD_SIGNATURES_u24lambda_u245.inJavaUtil("List", stringArray4));
        String[] stringArray20 = new String[9];
        stringArray4 = stringArray20;
        stringArray20[0] = "computeIfAbsent(Ljava/lang/Object;Ljava/util/function/Function;)Ljava/lang/Object;";
        stringArray4[1] = "computeIfPresent(Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;";
        stringArray4[2] = "compute(Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;";
        stringArray4[3] = "merge(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;";
        stringArray4[4] = "putIfAbsent(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;";
        stringArray4[5] = "remove(Ljava/lang/Object;Ljava/lang/Object;)Z";
        stringArray4[6] = "replaceAll(Ljava/util/function/BiFunction;)V";
        stringArray4[7] = "replace(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;";
        stringArray4[8] = "replace(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Z";
        MUTABLE_METHOD_SIGNATURES = SetsKt.plus((Set)set13, (Iterable)$this$MUTABLE_METHOD_SIGNATURES_u24lambda_u245.inJavaUtil("Map", stringArray4));
        SignatureBuildingComponents $this$HIDDEN_CONSTRUCTOR_SIGNATURES_u24lambda_u246 = SignatureBuildingComponents.INSTANCE;
        String[] stringArray21 = new String[1];
        stringArray4 = stringArray21;
        stringArray21[0] = "D";
        stringArray4 = $this$HIDDEN_CONSTRUCTOR_SIGNATURES_u24lambda_u246.constructors(stringArray4);
        Set set14 = SetsKt.plus(INSTANCE.buildPrimitiveStringConstructorsSet(), (Iterable)$this$HIDDEN_CONSTRUCTOR_SIGNATURES_u24lambda_u246.inJavaLang("Float", Arrays.copyOf(stringArray4, stringArray4.length)));
        String[] stringArray22 = new String[11];
        stringArray4 = stringArray22;
        stringArray22[0] = "[C";
        stringArray4[1] = "[CII";
        stringArray4[2] = "[III";
        stringArray4[3] = "[BIILjava/lang/String;";
        stringArray4[4] = "[BIILjava/nio/charset/Charset;";
        stringArray4[5] = "[BLjava/lang/String;";
        stringArray4[6] = "[BLjava/nio/charset/Charset;";
        stringArray4[7] = "[BII";
        stringArray4[8] = "[B";
        stringArray4[9] = "Ljava/lang/StringBuffer;";
        stringArray4[10] = "Ljava/lang/StringBuilder;";
        stringArray4 = $this$HIDDEN_CONSTRUCTOR_SIGNATURES_u24lambda_u246.constructors(stringArray4);
        HIDDEN_CONSTRUCTOR_SIGNATURES = SetsKt.plus((Set)set14, (Iterable)$this$HIDDEN_CONSTRUCTOR_SIGNATURES_u24lambda_u246.inJavaLang("String", Arrays.copyOf(stringArray4, stringArray4.length)));
        SignatureBuildingComponents $this$VISIBLE_CONSTRUCTOR_SIGNATURES_u24lambda_u247 = SignatureBuildingComponents.INSTANCE;
        String[] stringArray23 = new String[1];
        stringArray4 = stringArray23;
        stringArray23[0] = "Ljava/lang/String;Ljava/lang/Throwable;ZZ";
        stringArray4 = stringArray2.constructors(stringArray4);
        VISIBLE_CONSTRUCTOR_SIGNATURES = $this$VISIBLE_CONSTRUCTOR_SIGNATURES_u24lambda_u247.inJavaLang("Throwable", Arrays.copyOf(stringArray4, stringArray4.length));
    }
}

