/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins.jvm;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.builtins.CompanionObjectMapping;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionTypeKind;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.FqNamesUtilKt;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.reflect.jvm.internal.impl.name.StandardClassIds;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import kotlin.text.StringsKt;

@SourceDebugExtension(value={"SMAP\nJavaToKotlinClassMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaToKotlinClassMap.kt\norg/jetbrains/kotlin/builtins/jvm/JavaToKotlinClassMap\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,218:1\n49#1,2:220\n49#1,2:222\n49#1,2:224\n49#1,2:226\n49#1,2:228\n49#1,2:230\n49#1,2:232\n49#1,2:234\n1#2:219\n*S KotlinDebug\n*F\n+ 1 JavaToKotlinClassMap.kt\norg/jetbrains/kotlin/builtins/jvm/JavaToKotlinClassMap\n*L\n54#1:220,2\n55#1:222,2\n56#1:224,2\n57#1:226,2\n58#1:228,2\n59#1:230,2\n60#1:232,2\n61#1:234,2\n*E\n"})
public final class JavaToKotlinClassMap {
    public static final JavaToKotlinClassMap INSTANCE;
    private static final String NUMBERED_FUNCTION_PREFIX;
    private static final String NUMBERED_K_FUNCTION_PREFIX;
    private static final String NUMBERED_SUSPEND_FUNCTION_PREFIX;
    private static final String NUMBERED_K_SUSPEND_FUNCTION_PREFIX;
    private static final ClassId FUNCTION_N_CLASS_ID;
    private static final FqName FUNCTION_N_FQ_NAME;
    private static final ClassId K_FUNCTION_CLASS_ID;
    private static final ClassId K_CLASS_CLASS_ID;
    private static final ClassId CLASS_CLASS_ID;
    private static final HashMap<FqNameUnsafe, ClassId> javaToKotlin;
    private static final HashMap<FqNameUnsafe, ClassId> kotlinToJava;
    private static final HashMap<FqNameUnsafe, FqName> mutableToReadOnly;
    private static final HashMap<FqNameUnsafe, FqName> readOnlyToMutable;
    private static final HashMap<ClassId, ClassId> mutableToReadOnlyClassId;
    private static final HashMap<ClassId, ClassId> readOnlyToMutableClassId;
    private static final List<PlatformMutabilityMapping> mutabilityMappings;

    private JavaToKotlinClassMap() {
    }

    public final FqName getFUNCTION_N_FQ_NAME() {
        return FUNCTION_N_FQ_NAME;
    }

    public final List<PlatformMutabilityMapping> getMutabilityMappings() {
        return mutabilityMappings;
    }

    /*
     * WARNING - void declaration
     */
    public final ClassId mapJavaToKotlin(FqName fqName) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        return javaToKotlin.get(var1_1.toUnsafe());
    }

    /*
     * WARNING - void declaration
     */
    public final ClassId mapKotlinToJava(FqNameUnsafe kotlinFqName) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)kotlinFqName, (String)"kotlinFqName");
        if (this.isKotlinFunctionWithBigArity(kotlinFqName, NUMBERED_FUNCTION_PREFIX)) {
            return FUNCTION_N_CLASS_ID;
        }
        if (this.isKotlinFunctionWithBigArity(kotlinFqName, NUMBERED_SUSPEND_FUNCTION_PREFIX)) {
            return FUNCTION_N_CLASS_ID;
        }
        if (this.isKotlinFunctionWithBigArity(kotlinFqName, NUMBERED_K_FUNCTION_PREFIX)) {
            return K_FUNCTION_CLASS_ID;
        }
        if (this.isKotlinFunctionWithBigArity(kotlinFqName, NUMBERED_K_SUSPEND_FUNCTION_PREFIX)) {
            return K_FUNCTION_CLASS_ID;
        }
        return kotlinToJava.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isKotlinFunctionWithBigArity(FqNameUnsafe kotlinFqName, String prefix) {
        void var1_1;
        void var2_2;
        String string = kotlinFqName.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String fqNameAsString = string;
        if (!StringsKt.startsWith$default((String)string, (String)prefix, (boolean)false, (int)2, null)) {
            return false;
        }
        String string2 = fqNameAsString.substring(var2_2.length());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String arityString = string2;
        if (StringsKt.startsWith$default((CharSequence)string2, (char)'0', (boolean)false, (int)2, null)) {
            return false;
        }
        Integer arity = StringsKt.toIntOrNull((String)arityString);
        return arity != null && var1_1.intValue() >= 23;
    }

    /*
     * WARNING - void declaration
     */
    private final void addMapping(PlatformMutabilityMapping platformMutabilityMapping) {
        void var3_3;
        void var2_2;
        void var1_1;
        ClassId javaClassId = platformMutabilityMapping.component1();
        ClassId readOnlyClassId = platformMutabilityMapping.component2();
        ClassId mutableClassId = platformMutabilityMapping.component3();
        this.add(javaClassId, readOnlyClassId);
        this.addKotlinToJava(mutableClassId.asSingleFqName(), javaClassId);
        ((Map)mutableToReadOnlyClassId).put(mutableClassId, readOnlyClassId);
        ((Map)readOnlyToMutableClassId).put(readOnlyClassId, mutableClassId);
        FqName readOnlyFqName = readOnlyClassId.asSingleFqName();
        FqName mutableFqName = mutableClassId.asSingleFqName();
        ((Map)mutableToReadOnly).put(var1_1.asSingleFqName().toUnsafe(), readOnlyFqName);
        ((Map)readOnlyToMutable).put(var2_2.toUnsafe(), var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private final void add(ClassId javaClassId, ClassId kotlinClassId) {
        void var1_1;
        void var2_2;
        this.addJavaToKotlin(javaClassId, kotlinClassId);
        this.addKotlinToJava(var2_2.asSingleFqName(), (ClassId)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final void addTopLevel(Class<?> javaClass, FqNameUnsafe kotlinFqName) {
        void var1_1;
        void var2_2;
        FqName fqName = var2_2.toSafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"toSafe(...)");
        this.addTopLevel((Class<?>)var1_1, fqName);
    }

    /*
     * WARNING - void declaration
     */
    private final void addTopLevel(Class<?> javaClass, FqName kotlinFqName) {
        void var2_2;
        void var1_1;
        JavaToKotlinClassMap javaToKotlinClassMap = this;
        javaToKotlinClassMap.add(javaToKotlinClassMap.classId((Class<?>)var1_1), ClassId.Companion.topLevel((FqName)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    private final void addJavaToKotlin(ClassId javaClassId, ClassId kotlinClassId) {
        void var2_2;
        void var1_1;
        ((Map)javaToKotlin).put(var1_1.asSingleFqName().toUnsafe(), var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private final void addKotlinToJava(FqName kotlinFqNameUnsafe, ClassId javaClassId) {
        void var2_2;
        void var1_1;
        ((Map)kotlinToJava).put(var1_1.toUnsafe(), var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final FqName mutableToReadOnly(FqNameUnsafe fqNameUnsafe) {
        void var1_1;
        return (FqName)((Map)mutableToReadOnly).get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final FqName readOnlyToMutable(FqNameUnsafe fqNameUnsafe) {
        void var1_1;
        return (FqName)((Map)readOnlyToMutable).get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isMutable(FqNameUnsafe fqNameUnsafe) {
        void var1_1;
        return ((Map)mutableToReadOnly).containsKey(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isReadOnly(FqNameUnsafe fqNameUnsafe) {
        void var1_1;
        return ((Map)readOnlyToMutable).containsKey(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final ClassId classId(Class<?> clazz) {
        void var1_1;
        void var2_3;
        boolean bl;
        boolean bl2 = bl = !((Class)clazz).isPrimitive() && !((Class)clazz).isArray();
        if (_Assertions.ENABLED && !bl) {
            clazz = "Invalid class: " + clazz;
            throw new AssertionError(clazz);
        }
        Class<?> outer = ((Class)clazz).getDeclaringClass();
        if (outer == null) {
            return ClassId.Companion.topLevel(new FqName(((Class)clazz).getCanonicalName()));
        }
        ClassId classId = this.classId((Class<?>)var2_3);
        Name name = Name.identifier(var1_1.getSimpleName());
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
        return classId.createNestedClassId(name);
    }

    /*
     * WARNING - void declaration
     */
    static {
        int i;
        JavaToKotlinClassMap this_$iv;
        ClassId kotlinReadOnly$iv;
        INSTANCE = new JavaToKotlinClassMap();
        NUMBERED_FUNCTION_PREFIX = FunctionTypeKind.Function.INSTANCE.getPackageFqName() + '.' + FunctionTypeKind.Function.INSTANCE.getClassNamePrefix();
        NUMBERED_K_FUNCTION_PREFIX = FunctionTypeKind.KFunction.INSTANCE.getPackageFqName() + '.' + FunctionTypeKind.KFunction.INSTANCE.getClassNamePrefix();
        NUMBERED_SUSPEND_FUNCTION_PREFIX = FunctionTypeKind.SuspendFunction.INSTANCE.getPackageFqName() + '.' + FunctionTypeKind.SuspendFunction.INSTANCE.getClassNamePrefix();
        NUMBERED_K_SUSPEND_FUNCTION_PREFIX = FunctionTypeKind.KSuspendFunction.INSTANCE.getPackageFqName() + '.' + FunctionTypeKind.KSuspendFunction.INSTANCE.getClassNamePrefix();
        FUNCTION_N_CLASS_ID = ClassId.Companion.topLevel(new FqName("kotlin.jvm.functions.FunctionN"));
        FUNCTION_N_FQ_NAME = FUNCTION_N_CLASS_ID.asSingleFqName();
        K_FUNCTION_CLASS_ID = StandardClassIds.INSTANCE.getKFunction();
        K_CLASS_CLASS_ID = StandardClassIds.INSTANCE.getKClass();
        CLASS_CLASS_ID = INSTANCE.classId(Class.class);
        javaToKotlin = new HashMap();
        kotlinToJava = new HashMap();
        mutableToReadOnly = new HashMap();
        readOnlyToMutable = new HashMap();
        mutableToReadOnlyClassId = new HashMap();
        readOnlyToMutableClassId = new HashMap();
        Object[] objectArray = new PlatformMutabilityMapping[8];
        Object[] objectArray2 = objectArray;
        JavaToKotlinClassMap javaToKotlinClassMap = INSTANCE;
        ClassId classId = ClassId.Companion.topLevel(StandardNames.FqNames.iterable);
        FqName kotlinMutable$iv = StandardNames.FqNames.mutableIterable;
        ClassId mutableClassId$iv = new ClassId(kotlinReadOnly$iv.getPackageFqName(), FqNamesUtilKt.tail(kotlinMutable$iv, kotlinReadOnly$iv.getPackageFqName()), false);
        objectArray[0] = new PlatformMutabilityMapping(super.classId(Iterable.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = INSTANCE;
        kotlinReadOnly$iv = ClassId.Companion.topLevel(StandardNames.FqNames.iterator);
        kotlinMutable$iv = StandardNames.FqNames.mutableIterator;
        mutableClassId$iv = new ClassId(kotlinReadOnly$iv.getPackageFqName(), FqNamesUtilKt.tail(kotlinMutable$iv, kotlinReadOnly$iv.getPackageFqName()), false);
        objectArray2[1] = new PlatformMutabilityMapping(this_$iv.classId(Iterator.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = INSTANCE;
        kotlinReadOnly$iv = ClassId.Companion.topLevel(StandardNames.FqNames.collection);
        kotlinMutable$iv = StandardNames.FqNames.mutableCollection;
        mutableClassId$iv = new ClassId(kotlinReadOnly$iv.getPackageFqName(), FqNamesUtilKt.tail(kotlinMutable$iv, kotlinReadOnly$iv.getPackageFqName()), false);
        objectArray2[2] = new PlatformMutabilityMapping(this_$iv.classId(Collection.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = INSTANCE;
        kotlinReadOnly$iv = ClassId.Companion.topLevel(StandardNames.FqNames.list);
        kotlinMutable$iv = StandardNames.FqNames.mutableList;
        mutableClassId$iv = new ClassId(kotlinReadOnly$iv.getPackageFqName(), FqNamesUtilKt.tail(kotlinMutable$iv, kotlinReadOnly$iv.getPackageFqName()), false);
        objectArray2[3] = new PlatformMutabilityMapping(this_$iv.classId(List.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = INSTANCE;
        kotlinReadOnly$iv = ClassId.Companion.topLevel(StandardNames.FqNames.set);
        kotlinMutable$iv = StandardNames.FqNames.mutableSet;
        mutableClassId$iv = new ClassId(kotlinReadOnly$iv.getPackageFqName(), FqNamesUtilKt.tail(kotlinMutable$iv, kotlinReadOnly$iv.getPackageFqName()), false);
        objectArray2[4] = new PlatformMutabilityMapping(this_$iv.classId(Set.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = INSTANCE;
        kotlinReadOnly$iv = ClassId.Companion.topLevel(StandardNames.FqNames.listIterator);
        kotlinMutable$iv = StandardNames.FqNames.mutableListIterator;
        mutableClassId$iv = new ClassId(kotlinReadOnly$iv.getPackageFqName(), FqNamesUtilKt.tail(kotlinMutable$iv, kotlinReadOnly$iv.getPackageFqName()), false);
        objectArray2[5] = new PlatformMutabilityMapping(this_$iv.classId(ListIterator.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = INSTANCE;
        kotlinReadOnly$iv = ClassId.Companion.topLevel(StandardNames.FqNames.map);
        kotlinMutable$iv = StandardNames.FqNames.mutableMap;
        mutableClassId$iv = new ClassId(kotlinReadOnly$iv.getPackageFqName(), FqNamesUtilKt.tail(kotlinMutable$iv, kotlinReadOnly$iv.getPackageFqName()), false);
        objectArray2[6] = new PlatformMutabilityMapping(this_$iv.classId(Map.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = INSTANCE;
        ClassId classId2 = ClassId.Companion.topLevel(StandardNames.FqNames.map);
        Name name = StandardNames.FqNames.mapEntry.shortName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"shortName(...)");
        kotlinReadOnly$iv = classId2.createNestedClassId(name);
        kotlinMutable$iv = StandardNames.FqNames.mutableMapEntry;
        mutableClassId$iv = new ClassId(kotlinReadOnly$iv.getPackageFqName(), FqNamesUtilKt.tail(kotlinMutable$iv, kotlinReadOnly$iv.getPackageFqName()), false);
        objectArray2[7] = new PlatformMutabilityMapping(this_$iv.classId(Map.Entry.class), kotlinReadOnly$iv, mutableClassId$iv);
        mutabilityMappings = CollectionsKt.listOf((Object[])objectArray2);
        INSTANCE.addTopLevel(Object.class, StandardNames.FqNames.any);
        INSTANCE.addTopLevel(String.class, StandardNames.FqNames.string);
        INSTANCE.addTopLevel(CharSequence.class, StandardNames.FqNames.charSequence);
        INSTANCE.addTopLevel(Throwable.class, StandardNames.FqNames.throwable);
        INSTANCE.addTopLevel(Cloneable.class, StandardNames.FqNames.cloneable);
        INSTANCE.addTopLevel(Number.class, StandardNames.FqNames.number);
        INSTANCE.addTopLevel(Comparable.class, StandardNames.FqNames.comparable);
        INSTANCE.addTopLevel(Enum.class, StandardNames.FqNames._enum);
        INSTANCE.addTopLevel(Annotation.class, StandardNames.FqNames.annotation);
        for (PlatformMutabilityMapping platformCollection : mutabilityMappings) {
            INSTANCE.addMapping(platformCollection);
        }
        for (JvmPrimitiveType jvmType : JvmPrimitiveType.values()) {
            void var3_9;
            FqName fqName = jvmType.getWrapperFqName();
            Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"getWrapperFqName(...)");
            ClassId classId3 = ClassId.Companion.topLevel(fqName);
            PrimitiveType primitiveType = var3_9.getPrimitiveType();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)primitiveType), (String)"getPrimitiveType(...)");
            INSTANCE.add(classId3, ClassId.Companion.topLevel(StandardNames.getPrimitiveFqName(primitiveType)));
        }
        for (ClassId classId4 : CompanionObjectMapping.INSTANCE.allClassesWithIntrinsicCompanions()) {
            INSTANCE.add(ClassId.Companion.topLevel(new FqName("kotlin.jvm.internal." + classId4.getShortClassName().asString() + "CompanionObject")), classId4.createNestedClassId(SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT));
        }
        for (i = 0; i < 23; ++i) {
            INSTANCE.add(ClassId.Companion.topLevel(new FqName("kotlin.jvm.functions.Function" + i)), StandardNames.getFunctionClassId(i));
            INSTANCE.addKotlinToJava(new FqName(NUMBERED_K_FUNCTION_PREFIX + i), K_FUNCTION_CLASS_ID);
        }
        for (i = 0; i < 22; ++i) {
            void var2_8;
            void var1_5;
            FunctionTypeKind.KSuspendFunction kSuspendFunction = FunctionTypeKind.KSuspendFunction.INSTANCE;
            String kSuspendFun = kSuspendFunction.getPackageFqName() + '.' + var1_5.getClassNamePrefix();
            INSTANCE.addKotlinToJava(new FqName((String)var2_8 + i), K_FUNCTION_CLASS_ID);
        }
        FqName fqName = StandardNames.FqNames.nothing.toSafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"toSafe(...)");
        INSTANCE.addKotlinToJava(fqName, INSTANCE.classId(Void.class));
    }

    public static final class PlatformMutabilityMapping {
        private final ClassId javaClass;
        private final ClassId kotlinReadOnly;
        private final ClassId kotlinMutable;

        /*
         * WARNING - void declaration
         */
        public PlatformMutabilityMapping(ClassId javaClass, ClassId kotlinReadOnly, ClassId kotlinMutable) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)javaClass, (String)"javaClass");
            Intrinsics.checkNotNullParameter((Object)kotlinReadOnly, (String)"kotlinReadOnly");
            Intrinsics.checkNotNullParameter((Object)kotlinMutable, (String)"kotlinMutable");
            this.javaClass = var1_1;
            this.kotlinReadOnly = var2_2;
            this.kotlinMutable = var3_3;
        }

        public final ClassId getJavaClass() {
            return this.javaClass;
        }

        public final ClassId component1() {
            return this.javaClass;
        }

        public final ClassId component2() {
            return this.kotlinReadOnly;
        }

        public final ClassId component3() {
            return this.kotlinMutable;
        }

        public final String toString() {
            return "PlatformMutabilityMapping(javaClass=" + this.javaClass + ", kotlinReadOnly=" + this.kotlinReadOnly + ", kotlinMutable=" + this.kotlinMutable + ')';
        }

        public final int hashCode() {
            int n = this.javaClass.hashCode();
            n = n * 31 + this.kotlinReadOnly.hashCode();
            n = n * 31 + this.kotlinMutable.hashCode();
            return n;
        }

        public final boolean equals(Object other) {
            PlatformMutabilityMapping platformMutabilityMapping;
            if (this == other) {
                return true;
            }
            if (!(other instanceof PlatformMutabilityMapping)) {
                return false;
            }
            platformMutabilityMapping = platformMutabilityMapping;
            if (!Intrinsics.areEqual((Object)this.javaClass, (Object)platformMutabilityMapping.javaClass)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.kotlinReadOnly, (Object)platformMutabilityMapping.kotlinReadOnly)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.kotlinMutable, (Object)platformMutabilityMapping.kotlinMutable);
        }
    }
}

