/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins.functions;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;

public abstract class FunctionTypeKind {
    private final FqName packageFqName;
    private final String classNamePrefix;
    private final boolean isReflectType;
    private final ClassId annotationOnInvokeClassId;

    /*
     * WARNING - void declaration
     */
    public FunctionTypeKind(FqName packageFqName, String classNamePrefix, boolean isReflectType, ClassId annotationOnInvokeClassId) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)classNamePrefix, (String)"classNamePrefix");
        this.packageFqName = var1_1;
        this.classNamePrefix = var2_2;
        this.isReflectType = var3_3;
        this.annotationOnInvokeClassId = annotationOnInvokeClassId;
    }

    public final FqName getPackageFqName() {
        return this.packageFqName;
    }

    public final String getClassNamePrefix() {
        return this.classNamePrefix;
    }

    /*
     * WARNING - void declaration
     */
    public final Name numberedClassName(int arity) {
        void var1_1;
        Name name = Name.identifier(this.classNamePrefix + (int)var1_1);
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
        return name;
    }

    public String toString() {
        return this.packageFqName + '.' + this.classNamePrefix + 'N';
    }

    public static final class Function
    extends FunctionTypeKind {
        public static final Function INSTANCE = new Function();

        private Function() {
            super(StandardNames.BUILT_INS_PACKAGE_FQ_NAME, "Function", false, null);
        }
    }

    public static final class KFunction
    extends FunctionTypeKind {
        public static final KFunction INSTANCE = new KFunction();

        private KFunction() {
            super(StandardNames.KOTLIN_REFLECT_FQ_NAME, "KFunction", true, null);
        }
    }

    public static final class KSuspendFunction
    extends FunctionTypeKind {
        public static final KSuspendFunction INSTANCE = new KSuspendFunction();

        private KSuspendFunction() {
            super(StandardNames.KOTLIN_REFLECT_FQ_NAME, "KSuspendFunction", true, null);
        }
    }

    public static final class SuspendFunction
    extends FunctionTypeKind {
        public static final SuspendFunction INSTANCE = new SuspendFunction();

        private SuspendFunction() {
            super(StandardNames.COROUTINES_PACKAGE_FQ_NAME, "SuspendFunction", false, null);
        }
    }
}

