/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.builtins.UnsignedArrayType;
import kotlin.reflect.jvm.internal.impl.builtins.UnsignedType;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;

@SourceDebugExtension(value={"SMAP\nUnsignedType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnsignedType.kt\norg/jetbrains/kotlin/builtins/UnsignedTypes\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,122:1\n11165#2:123\n11500#2,3:124\n11165#2:127\n11500#2,3:128\n11500#2,3:131\n*S KotlinDebug\n*F\n+ 1 UnsignedType.kt\norg/jetbrains/kotlin/builtins/UnsignedTypes\n*L\n36#1:123\n36#1:124,3\n37#1:127\n37#1:128,3\n47#1:131,3\n*E\n"})
public final class UnsignedTypes {
    public static final UnsignedTypes INSTANCE;
    private static final Set<Name> unsignedTypeNames;
    private static final Set<Name> unsignedArrayTypeNames;
    private static final HashMap<ClassId, ClassId> arrayClassIdToUnsignedClassId;
    private static final HashMap<ClassId, ClassId> unsignedClassIdToArrayClassId;
    private static final HashMap<UnsignedArrayType, Name> unsignedArrayTypeToArrayCall;
    private static final Set<Name> arrayClassesShortNames;

    private UnsignedTypes() {
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isShortNameOfUnsignedArray(Name name) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return arrayClassesShortNames.contains(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final ClassId getUnsignedClassIdByArrayClassId(ClassId arrayClassId) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)arrayClassId, (String)"arrayClassId");
        return arrayClassIdToUnsignedClassId.get(var1_1);
    }

    @JvmStatic
    public static final boolean isUnsignedType(KotlinType type) {
        Annotated annotated;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (TypeUtils.noExpectedType(type)) {
            return false;
        }
        ClassifierDescriptor classifierDescriptor = type.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return false;
        }
        Annotated descriptor2 = classifierDescriptor;
        return INSTANCE.isUnsignedClass((DeclarationDescriptor)annotated);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isUnsignedClass(DeclarationDescriptor descriptor2) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        DeclarationDescriptor container = descriptor2.getContainingDeclaration();
        return container instanceof PackageFragmentDescriptor && Intrinsics.areEqual((Object)((PackageFragmentDescriptor)var2_2).getFqName(), (Object)StandardNames.BUILT_INS_PACKAGE_FQ_NAME) && unsignedTypeNames.contains(var1_1.getName());
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1_11;
        void $this$mapTo$iv;
        Object[] it;
        Collection collection;
        UnsignedArrayType[] $this$mapTo$iv$iv;
        INSTANCE = new UnsignedTypes();
        Enum[] $this$map$iv = UnsignedType.values();
        UnsignedType[] unsignedTypeArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        for (UnsignedArrayType item$iv$iv : $this$mapTo$iv$iv) {
            collection = destination$iv$iv;
            collection.add(it.getTypeName());
        }
        unsignedTypeNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        $this$map$iv = UnsignedArrayType.values();
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.length);
        for (UnsignedArrayType item$iv$iv : $this$mapTo$iv$iv) {
            collection = destination$iv$iv;
            collection.add(it.getTypeName());
        }
        unsignedArrayTypeNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        arrayClassIdToUnsignedClassId = new HashMap();
        unsignedClassIdToArrayClassId = new HashMap();
        Pair[] pairArray = new Pair[4];
        it = pairArray;
        pairArray[0] = TuplesKt.to((Object)((Object)UnsignedArrayType.UBYTEARRAY), (Object)Name.identifier("ubyteArrayOf"));
        it[1] = TuplesKt.to((Object)((Object)UnsignedArrayType.USHORTARRAY), (Object)Name.identifier("ushortArrayOf"));
        it[2] = TuplesKt.to((Object)((Object)UnsignedArrayType.UINTARRAY), (Object)Name.identifier("uintArrayOf"));
        it[3] = TuplesKt.to((Object)((Object)UnsignedArrayType.ULONGARRAY), (Object)Name.identifier("ulongArrayOf"));
        unsignedArrayTypeToArrayCall = MapsKt.hashMapOf((Pair[])it);
        it = UnsignedType.values();
        Collection destination$iv = new LinkedHashSet();
        int n = ((void)$this$mapTo$iv).length;
        for (int destination$iv$iv2 = 0; destination$iv$iv2 < n; ++destination$iv$iv2) {
            void it2;
            void item$iv;
            void var5_9 = item$iv = $this$mapTo$iv[destination$iv$iv2];
            collection = destination$iv;
            collection.add(it2.getArrayClassId().getShortClassName());
        }
        arrayClassesShortNames = (Set)var1_11;
        for (UnsignedType unsignedType : UnsignedType.values()) {
            void var3_5;
            ((Map)arrayClassIdToUnsignedClassId).put(unsignedType.getArrayClassId(), unsignedType.getClassId());
            ((Map)unsignedClassIdToArrayClassId).put(unsignedType.getClassId(), var3_5.getArrayClassId());
        }
    }
}

