/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.reflect.jvm.internal.impl.builtins.BuiltInsLoader;
import kotlin.reflect.jvm.internal.impl.builtins.BuiltInsPackageFragment;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.builtins.UnsignedTypes;
import kotlin.reflect.jvm.internal.impl.builtins.functions.BuiltInFictitiousFunctionClassFactory;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorUtilKt;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageViewDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyGetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.deserialization.AdditionalClassPartsProvider;
import kotlin.reflect.jvm.internal.impl.descriptors.deserialization.ClassDescriptorFactory;
import kotlin.reflect.jvm.internal.impl.descriptors.deserialization.PlatformDependentDeclarationFilter;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.ModuleDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.incremental.components.NoLookupLocation;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.storage.MemoizedFunctionToNotNull;
import kotlin.reflect.jvm.internal.impl.storage.NotNullLazyValue;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributesKt;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.Variance;

public abstract class KotlinBuiltIns {
    private ModuleDescriptorImpl builtInsModule;
    private NotNullLazyValue<ModuleDescriptorImpl> postponedBuiltInsModule;
    private final NotNullLazyValue<Primitives> primitives;
    private final NotNullLazyValue<Collection<PackageViewDescriptor>> builtInPackagesImportedByDefault;
    private final MemoizedFunctionToNotNull<Name, ClassDescriptor> builtInClassesByName;
    private final StorageManager storageManager;
    public static final Name BUILTINS_MODULE_NAME = Name.special("<built-ins module>");

    /*
     * WARNING - void declaration
     */
    protected KotlinBuiltIns(StorageManager storageManager) {
        void var1_1;
        if (storageManager == null) {
            KotlinBuiltIns.$$$reportNull$$$0(0);
        }
        this.storageManager = storageManager;
        this.builtInPackagesImportedByDefault = storageManager.createLazyValue(new Function0<Collection<PackageViewDescriptor>>(this){
            final /* synthetic */ KotlinBuiltIns this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            public Collection<PackageViewDescriptor> invoke() {
                return Arrays.asList(this.this$0.getBuiltInsModule().getPackage(StandardNames.BUILT_INS_PACKAGE_FQ_NAME), this.this$0.getBuiltInsModule().getPackage(StandardNames.COLLECTIONS_PACKAGE_FQ_NAME), this.this$0.getBuiltInsModule().getPackage(StandardNames.RANGES_PACKAGE_FQ_NAME), this.this$0.getBuiltInsModule().getPackage(StandardNames.ANNOTATION_PACKAGE_FQ_NAME));
            }
        });
        this.primitives = storageManager.createLazyValue(new Function0<Primitives>(this){
            final /* synthetic */ KotlinBuiltIns this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public Primitives invoke() {
                void var3_3;
                void var2_2;
                void var1_1;
                EnumMap<PrimitiveType, SimpleType> primitiveTypeToArrayKotlinType = new EnumMap<PrimitiveType, SimpleType>(PrimitiveType.class);
                HashMap<SimpleType, SimpleType> primitiveKotlinTypeToKotlinArrayType = new HashMap<SimpleType, SimpleType>();
                HashMap<SimpleType, SimpleType> kotlinArrayTypeToPrimitiveKotlinType = new HashMap<SimpleType, SimpleType>();
                for (PrimitiveType primitive : PrimitiveType.values()) {
                    SimpleType type = KotlinBuiltIns.access$000(this.this$0, primitive.getTypeName().asString());
                    SimpleType arrayType = KotlinBuiltIns.access$000(this.this$0, primitive.getArrayTypeName().asString());
                    primitiveTypeToArrayKotlinType.put(primitive, arrayType);
                    primitiveKotlinTypeToKotlinArrayType.put(type, arrayType);
                    kotlinArrayTypeToPrimitiveKotlinType.put(arrayType, type);
                }
                return new Primitives((Map)var1_1, (Map)var2_2, (Map)var3_3);
            }
        });
        this.builtInClassesByName = var1_1.createMemoizedFunction(new Function1<Name, ClassDescriptor>(this){
            final /* synthetic */ KotlinBuiltIns this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public ClassDescriptor invoke(Name name) {
                void var2_2;
                ClassifierDescriptor classifier = this.this$0.getBuiltInsPackageScope().getContributedClassifier(name, NoLookupLocation.FROM_BUILTINS);
                if (classifier == null) {
                    throw new AssertionError((Object)("Built-in class " + StandardNames.BUILT_INS_PACKAGE_FQ_NAME.child(name) + " is not found"));
                }
                if (!(classifier instanceof ClassDescriptor)) {
                    void var1_1;
                    throw new AssertionError((Object)("Must be a class descriptor " + var1_1 + ", but was " + classifier));
                }
                return (ClassDescriptor)var2_2;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    protected void createBuiltInsModule(boolean isFallback) {
        void var1_1;
        this.builtInsModule = new ModuleDescriptorImpl(BUILTINS_MODULE_NAME, this.storageManager, this, null);
        this.builtInsModule.initialize(BuiltInsLoader.Companion.getInstance().createPackageFragmentProvider(this.storageManager, this.builtInsModule, this.getClassDescriptorFactories(), this.getPlatformDependentDeclarationFilter(), this.getAdditionalClassPartsProvider(), (boolean)var1_1));
        this.builtInsModule.setDependencies(this.builtInsModule);
    }

    /*
     * WARNING - void declaration
     */
    public void setBuiltInsModule(ModuleDescriptorImpl module) {
        void var1_1;
        if (module == null) {
            KotlinBuiltIns.$$$reportNull$$$0(1);
        }
        this.storageManager.compute(new Function0<Void>(this, (ModuleDescriptorImpl)var1_1){
            final /* synthetic */ ModuleDescriptorImpl val$module;
            final /* synthetic */ KotlinBuiltIns this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$module = moduleDescriptorImpl;
            }

            public Void invoke() {
                if (this.this$0.builtInsModule != null) {
                    throw new AssertionError((Object)("Built-ins module is already set: " + this.this$0.builtInsModule + " (attempting to reset to " + this.val$module + ")"));
                }
                KotlinBuiltIns.access$202(this.this$0, this.val$module);
                return null;
            }
        });
    }

    protected AdditionalClassPartsProvider getAdditionalClassPartsProvider() {
        AdditionalClassPartsProvider.None none = AdditionalClassPartsProvider.None.INSTANCE;
        if (none == null) {
            KotlinBuiltIns.$$$reportNull$$$0(3);
        }
        return none;
    }

    protected PlatformDependentDeclarationFilter getPlatformDependentDeclarationFilter() {
        PlatformDependentDeclarationFilter.NoPlatformDependent noPlatformDependent = PlatformDependentDeclarationFilter.NoPlatformDependent.INSTANCE;
        if (noPlatformDependent == null) {
            KotlinBuiltIns.$$$reportNull$$$0(4);
        }
        return noPlatformDependent;
    }

    protected Iterable<ClassDescriptorFactory> getClassDescriptorFactories() {
        List<ClassDescriptorFactory> list = Collections.singletonList(new BuiltInFictitiousFunctionClassFactory(this.storageManager, this.getBuiltInsModule()));
        if (list == null) {
            KotlinBuiltIns.$$$reportNull$$$0(5);
        }
        return list;
    }

    protected StorageManager getStorageManager() {
        StorageManager storageManager = this.storageManager;
        if (storageManager == null) {
            KotlinBuiltIns.$$$reportNull$$$0(6);
        }
        return storageManager;
    }

    public ModuleDescriptorImpl getBuiltInsModule() {
        assert (this.builtInsModule != null || this.postponedBuiltInsModule != null) : "Uninitialized built-ins module";
        if (this.builtInsModule == null) {
            this.builtInsModule = (ModuleDescriptorImpl)this.postponedBuiltInsModule.invoke();
        }
        ModuleDescriptorImpl moduleDescriptorImpl = this.builtInsModule;
        if (moduleDescriptorImpl == null) {
            KotlinBuiltIns.$$$reportNull$$$0(7);
        }
        return moduleDescriptorImpl;
    }

    public static boolean isBuiltIn(DeclarationDescriptor descriptor2) {
        DeclarationDescriptor declarationDescriptor;
        if (descriptor2 == null) {
            KotlinBuiltIns.$$$reportNull$$$0(9);
        }
        return DescriptorUtils.getParentOfType(declarationDescriptor, BuiltInsPackageFragment.class, false) != null;
    }

    public static boolean isUnderKotlinPackage(DeclarationDescriptor descriptor2) {
        DeclarationDescriptor current;
        if (descriptor2 == null) {
            KotlinBuiltIns.$$$reportNull$$$0(10);
        }
        while (current != null) {
            if (current instanceof PackageFragmentDescriptor) {
                return ((PackageFragmentDescriptor)current).getFqName().startsWith(StandardNames.BUILT_INS_PACKAGE_NAME);
            }
            current = current.getContainingDeclaration();
        }
        return false;
    }

    public MemberScope getBuiltInsPackageScope() {
        MemberScope memberScope = this.getBuiltInsModule().getPackage(StandardNames.BUILT_INS_PACKAGE_FQ_NAME).getMemberScope();
        if (memberScope == null) {
            KotlinBuiltIns.$$$reportNull$$$0(11);
        }
        return memberScope;
    }

    /*
     * WARNING - void declaration
     */
    public ClassDescriptor getBuiltInClassByFqName(FqName fqName) {
        void var2_2;
        if (fqName == null) {
            KotlinBuiltIns.$$$reportNull$$$0(12);
        }
        ClassDescriptor descriptor2 = DescriptorUtilKt.resolveClassByFqName(this.getBuiltInsModule(), fqName, NoLookupLocation.FROM_BUILTINS);
        if (!$assertionsDisabled && descriptor2 == null) {
            void var1_1;
            throw new AssertionError((Object)("Can't find built-in class " + var1_1));
        }
        void v0 = var2_2;
        if (v0 == null) {
            KotlinBuiltIns.$$$reportNull$$$0(13);
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    private ClassDescriptor getBuiltInClassByName(String simpleName) {
        void var1_1;
        if (simpleName == null) {
            KotlinBuiltIns.$$$reportNull$$$0(14);
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)this.builtInClassesByName.invoke(Name.identifier((String)var1_1));
        if (classDescriptor == null) {
            KotlinBuiltIns.$$$reportNull$$$0(15);
        }
        return classDescriptor;
    }

    public ClassDescriptor getAny() {
        return this.getBuiltInClassByName("Any");
    }

    public ClassDescriptor getNothing() {
        return this.getBuiltInClassByName("Nothing");
    }

    /*
     * WARNING - void declaration
     */
    private ClassDescriptor getPrimitiveClassDescriptor(PrimitiveType type) {
        void var1_1;
        if (type == null) {
            KotlinBuiltIns.$$$reportNull$$$0(16);
        }
        return this.getBuiltInClassByName(var1_1.getTypeName().asString());
    }

    public ClassDescriptor getArray() {
        return this.getBuiltInClassByName("Array");
    }

    public ClassDescriptor getNumber() {
        return this.getBuiltInClassByName("Number");
    }

    public ClassDescriptor getUnit() {
        return this.getBuiltInClassByName("Unit");
    }

    /*
     * WARNING - void declaration
     */
    public ClassDescriptor getFunction(int parameterCount) {
        void var1_1;
        return this.getBuiltInClassByName(StandardNames.getFunctionName((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public ClassDescriptor getSuspendFunction(int parameterCount) {
        void var1_1;
        ClassDescriptor classDescriptor = this.getBuiltInClassByFqName(StandardNames.COROUTINES_PACKAGE_FQ_NAME.child(Name.identifier(StandardNames.getSuspendFunctionName((int)var1_1))));
        if (classDescriptor == null) {
            KotlinBuiltIns.$$$reportNull$$$0(18);
        }
        return classDescriptor;
    }

    public ClassDescriptor getString() {
        return this.getBuiltInClassByName("String");
    }

    public ClassDescriptor getComparable() {
        return this.getBuiltInClassByName("Comparable");
    }

    public ClassDescriptor getKClass() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByFqName(StandardNames.FqNames.kClass.toSafe());
        if (classDescriptor == null) {
            KotlinBuiltIns.$$$reportNull$$$0(21);
        }
        return classDescriptor;
    }

    public ClassDescriptor getCollection() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByFqName(StandardNames.FqNames.collection);
        if (classDescriptor == null) {
            KotlinBuiltIns.$$$reportNull$$$0(35);
        }
        return classDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    private SimpleType getBuiltInTypeByClassName(String classSimpleName) {
        void var1_1;
        if (classSimpleName == null) {
            KotlinBuiltIns.$$$reportNull$$$0(47);
        }
        SimpleType simpleType = this.getBuiltInClassByName((String)var1_1).getDefaultType();
        if (simpleType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(48);
        }
        return simpleType;
    }

    public SimpleType getNothingType() {
        SimpleType simpleType = this.getNothing().getDefaultType();
        if (simpleType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(49);
        }
        return simpleType;
    }

    public SimpleType getNullableNothingType() {
        SimpleType simpleType = this.getNothingType().makeNullableAsSpecified(true);
        if (simpleType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(50);
        }
        return simpleType;
    }

    public SimpleType getAnyType() {
        SimpleType simpleType = this.getAny().getDefaultType();
        if (simpleType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(51);
        }
        return simpleType;
    }

    public SimpleType getNullableAnyType() {
        SimpleType simpleType = this.getAnyType().makeNullableAsSpecified(true);
        if (simpleType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(52);
        }
        return simpleType;
    }

    public SimpleType getDefaultBound() {
        SimpleType simpleType = this.getNullableAnyType();
        if (simpleType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(53);
        }
        return simpleType;
    }

    /*
     * WARNING - void declaration
     */
    public SimpleType getPrimitiveKotlinType(PrimitiveType type) {
        void var1_1;
        if (type == null) {
            KotlinBuiltIns.$$$reportNull$$$0(54);
        }
        SimpleType simpleType = this.getPrimitiveClassDescriptor((PrimitiveType)var1_1).getDefaultType();
        if (simpleType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(55);
        }
        return simpleType;
    }

    public SimpleType getNumberType() {
        SimpleType simpleType = this.getNumber().getDefaultType();
        if (simpleType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(56);
        }
        return simpleType;
    }

    public SimpleType getByteType() {
        SimpleType simpleType = this.getPrimitiveKotlinType(PrimitiveType.BYTE);
        if (simpleType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(57);
        }
        return simpleType;
    }

    public SimpleType getShortType() {
        SimpleType simpleType = this.getPrimitiveKotlinType(PrimitiveType.SHORT);
        if (simpleType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(58);
        }
        return simpleType;
    }

    public SimpleType getIntType() {
        SimpleType simpleType = this.getPrimitiveKotlinType(PrimitiveType.INT);
        if (simpleType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(59);
        }
        return simpleType;
    }

    public SimpleType getLongType() {
        SimpleType simpleType = this.getPrimitiveKotlinType(PrimitiveType.LONG);
        if (simpleType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(60);
        }
        return simpleType;
    }

    public SimpleType getFloatType() {
        SimpleType simpleType = this.getPrimitiveKotlinType(PrimitiveType.FLOAT);
        if (simpleType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(61);
        }
        return simpleType;
    }

    public SimpleType getDoubleType() {
        SimpleType simpleType = this.getPrimitiveKotlinType(PrimitiveType.DOUBLE);
        if (simpleType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(62);
        }
        return simpleType;
    }

    public SimpleType getCharType() {
        SimpleType simpleType = this.getPrimitiveKotlinType(PrimitiveType.CHAR);
        if (simpleType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(63);
        }
        return simpleType;
    }

    public SimpleType getBooleanType() {
        SimpleType simpleType = this.getPrimitiveKotlinType(PrimitiveType.BOOLEAN);
        if (simpleType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(64);
        }
        return simpleType;
    }

    public SimpleType getUnitType() {
        SimpleType simpleType = this.getUnit().getDefaultType();
        if (simpleType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(65);
        }
        return simpleType;
    }

    public SimpleType getStringType() {
        SimpleType simpleType = this.getString().getDefaultType();
        if (simpleType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(66);
        }
        return simpleType;
    }

    /*
     * WARNING - void declaration
     */
    public KotlinType getArrayElementType(KotlinType arrayType) {
        void var1_1;
        void var3_3;
        KotlinType unsignedType;
        if (arrayType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(68);
        }
        if (KotlinBuiltIns.isArray(arrayType)) {
            if (arrayType.getArguments().size() != 1) {
                throw new IllegalStateException();
            }
            KotlinType kotlinType = arrayType.getArguments().get(0).getType();
            if (kotlinType == null) {
                KotlinBuiltIns.$$$reportNull$$$0(69);
            }
            return kotlinType;
        }
        KotlinType notNullArrayType = TypeUtils.makeNotNullable(arrayType);
        KotlinType primitiveType = ((Primitives)this.primitives.invoke()).kotlinArrayTypeToPrimitiveKotlinType.get(notNullArrayType);
        if (primitiveType != null) {
            KotlinType kotlinType = primitiveType;
            if (kotlinType == null) {
                KotlinBuiltIns.$$$reportNull$$$0(70);
            }
            return kotlinType;
        }
        ModuleDescriptor module = DescriptorUtils.getContainingModuleOrNull(notNullArrayType);
        if (module != null && (unsignedType = KotlinBuiltIns.getElementTypeForUnsignedArray(notNullArrayType, (ModuleDescriptor)var3_3)) != null) {
            void var2_2;
            void v2 = var2_2;
            if (v2 == null) {
                KotlinBuiltIns.$$$reportNull$$$0(71);
            }
            return v2;
        }
        throw new IllegalStateException("not array: " + var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static KotlinType getElementTypeForUnsignedArray(KotlinType notNullArrayType, ModuleDescriptor module) {
        ClassDescriptor classDescriptor;
        void var1_1;
        ClassDescriptor descriptor2;
        if (notNullArrayType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(72);
        }
        if (module == null) {
            KotlinBuiltIns.$$$reportNull$$$0(73);
        }
        if ((descriptor2 = notNullArrayType.getConstructor().getDeclarationDescriptor()) == null) {
            return null;
        }
        if (!UnsignedTypes.INSTANCE.isShortNameOfUnsignedArray(descriptor2.getName())) {
            return null;
        }
        ClassDescriptor arrayClassId = DescriptorUtilsKt.getClassId(descriptor2);
        if (arrayClassId == null) {
            return null;
        }
        ClassDescriptor elementClassId = UnsignedTypes.INSTANCE.getUnsignedClassIdByArrayClassId((ClassId)((Object)arrayClassId));
        if (elementClassId == null) {
            return null;
        }
        ClassDescriptor elementClassDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies((ModuleDescriptor)var1_1, (ClassId)((Object)elementClassId));
        if (elementClassDescriptor == null) {
            return null;
        }
        return classDescriptor.getDefaultType();
    }

    /*
     * WARNING - void declaration
     */
    public SimpleType getPrimitiveArrayKotlinType(PrimitiveType primitiveType) {
        void var1_1;
        if (primitiveType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(74);
        }
        SimpleType simpleType = ((Primitives)this.primitives.invoke()).primitiveTypeToArrayKotlinType.get(var1_1);
        if (simpleType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(75);
        }
        return simpleType;
    }

    public static PrimitiveType getPrimitiveType(DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            KotlinBuiltIns.$$$reportNull$$$0(77);
        }
        if (StandardNames.FqNames.primitiveTypeShortNames.contains(descriptor2.getName())) {
            DeclarationDescriptor declarationDescriptor;
            return StandardNames.FqNames.fqNameToPrimitiveType.get(DescriptorUtils.getFqName(declarationDescriptor));
        }
        return null;
    }

    public static PrimitiveType getPrimitiveArrayType(DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            KotlinBuiltIns.$$$reportNull$$$0(78);
        }
        if (StandardNames.FqNames.primitiveArrayTypeShortNames.contains(descriptor2.getName())) {
            DeclarationDescriptor declarationDescriptor;
            return StandardNames.FqNames.arrayClassFqNameToPrimitiveType.get(DescriptorUtils.getFqName(declarationDescriptor));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public SimpleType getArrayType(Variance projectionType, KotlinType argument, Annotations annotations) {
        void var1_1;
        void var3_3;
        void var2_2;
        if (projectionType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(79);
        }
        if (argument == null) {
            KotlinBuiltIns.$$$reportNull$$$0(80);
        }
        if (annotations == null) {
            KotlinBuiltIns.$$$reportNull$$$0(81);
        }
        List<TypeProjectionImpl> types = Collections.singletonList(new TypeProjectionImpl(projectionType, (KotlinType)var2_2));
        SimpleType simpleType = KotlinTypeFactory.simpleNotNullType(TypeAttributesKt.toDefaultAttributes((Annotations)var3_3), this.getArray(), (List<? extends TypeProjection>)var1_1);
        if (simpleType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(82);
        }
        return simpleType;
    }

    /*
     * WARNING - void declaration
     */
    public SimpleType getArrayType(Variance projectionType, KotlinType argument) {
        void var2_2;
        void var1_1;
        if (projectionType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(83);
        }
        if (argument == null) {
            KotlinBuiltIns.$$$reportNull$$$0(84);
        }
        SimpleType simpleType = this.getArrayType((Variance)var1_1, (KotlinType)var2_2, Annotations.Companion.getEMPTY());
        if (simpleType == null) {
            KotlinBuiltIns.$$$reportNull$$$0(85);
        }
        return simpleType;
    }

    public static boolean isArray(KotlinType type) {
        KotlinType kotlinType;
        if (type == null) {
            KotlinBuiltIns.$$$reportNull$$$0(89);
        }
        return KotlinBuiltIns.isConstructedFromGivenClass(kotlinType, StandardNames.FqNames.array);
    }

    public static boolean isArrayOrPrimitiveArray(ClassDescriptor descriptor2) {
        ClassDescriptor classDescriptor;
        if (descriptor2 == null) {
            KotlinBuiltIns.$$$reportNull$$$0(90);
        }
        return KotlinBuiltIns.classFqNameEquals(descriptor2, StandardNames.FqNames.array) || KotlinBuiltIns.getPrimitiveArrayType(classDescriptor) != null;
    }

    public static boolean isArrayOrPrimitiveArray(KotlinType type) {
        KotlinType kotlinType;
        if (type == null) {
            KotlinBuiltIns.$$$reportNull$$$0(91);
        }
        return KotlinBuiltIns.isArray(type) || KotlinBuiltIns.isPrimitiveArray(kotlinType);
    }

    public static boolean isPrimitiveArray(KotlinType type) {
        Annotated annotated;
        Annotated descriptor2;
        if (type == null) {
            KotlinBuiltIns.$$$reportNull$$$0(92);
        }
        return (descriptor2 = type.getConstructor().getDeclarationDescriptor()) != null && KotlinBuiltIns.getPrimitiveArrayType((DeclarationDescriptor)annotated) != null;
    }

    public static PrimitiveType getPrimitiveArrayElementType(KotlinType type) {
        Annotated annotated;
        Annotated descriptor2;
        if (type == null) {
            KotlinBuiltIns.$$$reportNull$$$0(93);
        }
        if ((descriptor2 = type.getConstructor().getDeclarationDescriptor()) == null) {
            return null;
        }
        return KotlinBuiltIns.getPrimitiveArrayType((DeclarationDescriptor)annotated);
    }

    public static boolean isPrimitiveType(KotlinType type) {
        KotlinType kotlinType;
        if (type == null) {
            KotlinBuiltIns.$$$reportNull$$$0(95);
        }
        return !type.isMarkedNullable() && KotlinBuiltIns.isPrimitiveTypeOrNullablePrimitiveType(kotlinType);
    }

    public static boolean isPrimitiveTypeOrNullablePrimitiveType(KotlinType type) {
        Annotated annotated;
        Annotated descriptor2;
        if (type == null) {
            KotlinBuiltIns.$$$reportNull$$$0(96);
        }
        return (descriptor2 = type.getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor && KotlinBuiltIns.isPrimitiveClass((ClassDescriptor)annotated);
    }

    public static boolean isPrimitiveClass(ClassDescriptor descriptor2) {
        ClassDescriptor classDescriptor;
        if (descriptor2 == null) {
            KotlinBuiltIns.$$$reportNull$$$0(97);
        }
        return KotlinBuiltIns.getPrimitiveType(classDescriptor) != null;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isConstructedFromGivenClass(KotlinType type, FqNameUnsafe fqName) {
        void var1_1;
        KotlinType kotlinType;
        if (type == null) {
            KotlinBuiltIns.$$$reportNull$$$0(98);
        }
        if (fqName == null) {
            KotlinBuiltIns.$$$reportNull$$$0(99);
        }
        return KotlinBuiltIns.isTypeConstructorForGivenClass(kotlinType.getConstructor(), (FqNameUnsafe)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isTypeConstructorForGivenClass(TypeConstructor typeConstructor2, FqNameUnsafe fqName) {
        void var1_1;
        Object object;
        Object descriptor2;
        if (typeConstructor2 == null) {
            KotlinBuiltIns.$$$reportNull$$$0(102);
        }
        if (fqName == null) {
            KotlinBuiltIns.$$$reportNull$$$0(103);
        }
        return (descriptor2 = typeConstructor2.getDeclarationDescriptor()) instanceof ClassDescriptor && KotlinBuiltIns.classFqNameEquals((ClassifierDescriptor)object, (FqNameUnsafe)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean classFqNameEquals(ClassifierDescriptor descriptor2, FqNameUnsafe fqName) {
        ClassifierDescriptor classifierDescriptor;
        void var1_1;
        if (descriptor2 == null) {
            KotlinBuiltIns.$$$reportNull$$$0(104);
        }
        if (fqName == null) {
            KotlinBuiltIns.$$$reportNull$$$0(105);
        }
        return descriptor2.getName().equals(fqName.shortName()) && var1_1.equals(DescriptorUtils.getFqName(classifierDescriptor));
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isNotNullConstructedFromGivenClass(KotlinType type, FqNameUnsafe fqName) {
        void var1_1;
        KotlinType kotlinType;
        if (type == null) {
            KotlinBuiltIns.$$$reportNull$$$0(106);
        }
        if (fqName == null) {
            KotlinBuiltIns.$$$reportNull$$$0(107);
        }
        return !type.isMarkedNullable() && KotlinBuiltIns.isConstructedFromGivenClass(kotlinType, (FqNameUnsafe)var1_1);
    }

    public static boolean isSpecialClassWithNoSupertypes(ClassDescriptor descriptor2) {
        ClassDescriptor classDescriptor;
        if (descriptor2 == null) {
            KotlinBuiltIns.$$$reportNull$$$0(108);
        }
        return KotlinBuiltIns.classFqNameEquals(descriptor2, StandardNames.FqNames.any) || KotlinBuiltIns.classFqNameEquals(classDescriptor, StandardNames.FqNames.nothing);
    }

    public static boolean isAny(ClassDescriptor descriptor2) {
        ClassDescriptor classDescriptor;
        if (descriptor2 == null) {
            KotlinBuiltIns.$$$reportNull$$$0(109);
        }
        return KotlinBuiltIns.classFqNameEquals(classDescriptor, StandardNames.FqNames.any);
    }

    public static boolean isBoolean(KotlinType type) {
        KotlinType kotlinType;
        if (type == null) {
            KotlinBuiltIns.$$$reportNull$$$0(111);
        }
        return KotlinBuiltIns.isConstructedFromGivenClassAndNotNullable(kotlinType, StandardNames.FqNames._boolean);
    }

    public static boolean isUByteArray(KotlinType type) {
        KotlinType kotlinType;
        if (type == null) {
            KotlinBuiltIns.$$$reportNull$$$0(129);
        }
        return KotlinBuiltIns.isConstructedFromGivenClassAndNotNullable(kotlinType, StandardNames.FqNames.uByteArrayFqName.toUnsafe());
    }

    public static boolean isUShortArray(KotlinType type) {
        KotlinType kotlinType;
        if (type == null) {
            KotlinBuiltIns.$$$reportNull$$$0(130);
        }
        return KotlinBuiltIns.isConstructedFromGivenClassAndNotNullable(kotlinType, StandardNames.FqNames.uShortArrayFqName.toUnsafe());
    }

    public static boolean isUIntArray(KotlinType type) {
        KotlinType kotlinType;
        if (type == null) {
            KotlinBuiltIns.$$$reportNull$$$0(131);
        }
        return KotlinBuiltIns.isConstructedFromGivenClassAndNotNullable(kotlinType, StandardNames.FqNames.uIntArrayFqName.toUnsafe());
    }

    public static boolean isULongArray(KotlinType type) {
        KotlinType kotlinType;
        if (type == null) {
            KotlinBuiltIns.$$$reportNull$$$0(132);
        }
        return KotlinBuiltIns.isConstructedFromGivenClassAndNotNullable(kotlinType, StandardNames.FqNames.uLongArrayFqName.toUnsafe());
    }

    public static boolean isUnsignedArrayType(KotlinType type) {
        KotlinType kotlinType;
        if (type == null) {
            KotlinBuiltIns.$$$reportNull$$$0(133);
        }
        return KotlinBuiltIns.isUByteArray(type) || KotlinBuiltIns.isUShortArray(type) || KotlinBuiltIns.isUIntArray(type) || KotlinBuiltIns.isULongArray(kotlinType);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isConstructedFromGivenClassAndNotNullable(KotlinType type, FqNameUnsafe fqName) {
        KotlinType kotlinType;
        void var1_1;
        if (type == null) {
            KotlinBuiltIns.$$$reportNull$$$0(135);
        }
        if (fqName == null) {
            KotlinBuiltIns.$$$reportNull$$$0(136);
        }
        return KotlinBuiltIns.isConstructedFromGivenClass(type, (FqNameUnsafe)var1_1) && !kotlinType.isMarkedNullable();
    }

    public static boolean isNothing(KotlinType type) {
        KotlinType kotlinType;
        if (type == null) {
            KotlinBuiltIns.$$$reportNull$$$0(137);
        }
        return KotlinBuiltIns.isNothingOrNullableNothing(type) && !TypeUtils.isNullableType(kotlinType);
    }

    public static boolean isNothingOrNullableNothing(KotlinType type) {
        KotlinType kotlinType;
        if (type == null) {
            KotlinBuiltIns.$$$reportNull$$$0(139);
        }
        return KotlinBuiltIns.isConstructedFromGivenClass(kotlinType, StandardNames.FqNames.nothing);
    }

    public static boolean isAnyOrNullableAny(KotlinType type) {
        KotlinType kotlinType;
        if (type == null) {
            KotlinBuiltIns.$$$reportNull$$$0(140);
        }
        return KotlinBuiltIns.isConstructedFromGivenClass(kotlinType, StandardNames.FqNames.any);
    }

    public static boolean isNullableAny(KotlinType type) {
        KotlinType kotlinType;
        if (type == null) {
            KotlinBuiltIns.$$$reportNull$$$0(141);
        }
        return KotlinBuiltIns.isAnyOrNullableAny(type) && kotlinType.isMarkedNullable();
    }

    public static boolean isDefaultBound(KotlinType type) {
        KotlinType kotlinType;
        if (type == null) {
            KotlinBuiltIns.$$$reportNull$$$0(142);
        }
        return KotlinBuiltIns.isNullableAny(kotlinType);
    }

    public static boolean isUnit(KotlinType type) {
        KotlinType kotlinType;
        if (type == null) {
            KotlinBuiltIns.$$$reportNull$$$0(143);
        }
        return KotlinBuiltIns.isNotNullConstructedFromGivenClass(kotlinType, StandardNames.FqNames.unit);
    }

    public static boolean isString(KotlinType type) {
        KotlinType kotlinType;
        return type != null && KotlinBuiltIns.isNotNullConstructedFromGivenClass(kotlinType, StandardNames.FqNames.string);
    }

    public static boolean isKClass(ClassDescriptor descriptor2) {
        ClassDescriptor classDescriptor;
        if (descriptor2 == null) {
            KotlinBuiltIns.$$$reportNull$$$0(159);
        }
        return KotlinBuiltIns.classFqNameEquals(classDescriptor, StandardNames.FqNames.kClass);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isDeprecated(DeclarationDescriptor declarationDescriptor) {
        if (declarationDescriptor == null) {
            KotlinBuiltIns.$$$reportNull$$$0(162);
        }
        if (declarationDescriptor.getOriginal().getAnnotations().hasAnnotation(StandardNames.FqNames.deprecated)) {
            return true;
        }
        if (declarationDescriptor instanceof PropertyDescriptor) {
            DeclarationDescriptor declarationDescriptor2;
            void var1_1;
            void var2_2;
            boolean isVar = ((PropertyDescriptor)declarationDescriptor).isVar();
            PropertyGetterDescriptor getter = ((PropertyDescriptor)declarationDescriptor).getGetter();
            DeclarationDescriptor setter = ((PropertyDescriptor)declarationDescriptor).getSetter();
            return getter != null && KotlinBuiltIns.isDeprecated((DeclarationDescriptor)var2_2) && (var1_1 == false || setter != null && KotlinBuiltIns.isDeprecated(declarationDescriptor2));
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ SimpleType access$000(KotlinBuiltIns x0, String x1) {
        void var1_1;
        return x0.getBuiltInTypeByClassName((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ ModuleDescriptorImpl access$202(KotlinBuiltIns x0, ModuleDescriptorImpl x1) {
        void var1_1;
        x0.builtInsModule = var1_1;
        return x0.builtInsModule;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 75: 
            case 82: 
            case 85: 
            case 87: 
            case 88: {
                string = "@NotNull method %s.%s must not return null";
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 75: 
            case 82: 
            case 85: 
            case 87: 
            case 88: {
                n2 = 2;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageManager";
                break;
            }
            case 1: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 75: 
            case 82: 
            case 85: 
            case 87: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlin/reflect/jvm/internal/impl/builtins/KotlinBuiltIns";
                break;
            }
            case 9: 
            case 10: 
            case 77: 
            case 78: 
            case 90: 
            case 97: 
            case 104: 
            case 108: 
            case 109: 
            case 144: 
            case 147: 
            case 148: 
            case 150: 
            case 158: 
            case 159: 
            case 160: 
            case 161: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 12: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 107: 
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "simpleName";
                break;
            }
            case 16: 
            case 17: 
            case 54: 
            case 89: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 98: 
            case 100: 
            case 106: 
            case 110: 
            case 111: 
            case 112: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 145: 
            case 146: 
            case 149: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 163: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classSimpleName";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayType";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notNullArrayType";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primitiveType";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlinType";
                break;
            }
            case 79: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectionType";
                break;
            }
            case 80: 
            case 84: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeConstructor";
                break;
            }
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDescriptor";
                break;
            }
            case 162: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationDescriptor";
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "kotlin/reflect/jvm/internal/impl/builtins/KotlinBuiltIns";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalClassPartsProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatformDependentDeclarationFilter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassDescriptorFactories";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorageManager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuiltInsModule";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuiltInPackagesImportedByDefault";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuiltInsPackageScope";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuiltInClassByFqName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuiltInClassByName";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuspendFunction";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getKFunction";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getKSuspendFunction";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getKClass";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getKType";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getKCallable";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getKProperty";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getKProperty0";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getKProperty1";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getKProperty2";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getKMutableProperty0";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getKMutableProperty1";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getKMutableProperty2";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getIterator";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getIterable";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutableIterable";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutableIterator";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getCollection";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutableCollection";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getList";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutableList";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getSet";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutableSet";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getMap";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutableMap";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getMapEntry";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutableMapEntry";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getListIterator";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutableListIterator";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuiltInTypeByClassName";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getNothingType";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullableNothingType";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnyType";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullableAnyType";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultBound";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimitiveKotlinType";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getNumberType";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getByteType";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortType";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntType";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getLongType";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getFloatType";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getDoubleType";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharType";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getBooleanType";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnitType";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringType";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getIterableType";
                break;
            }
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayElementType";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimitiveArrayKotlinType";
                break;
            }
            case 82: 
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayType";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnumType";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationType";
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setBuiltInsModule";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setPostponedBuiltinsModuleComputation";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 75: 
            case 82: 
            case 85: 
            case 87: 
            case 88: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isBuiltIn";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isUnderKotlinPackage";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getBuiltInClassByFqName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getBuiltInClassByName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPrimitiveClassDescriptor";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getPrimitiveArrayClassDescriptor";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getBuiltInTypeByClassName";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getPrimitiveKotlinType";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getArrayElementType";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getElementTypeForUnsignedArray";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getPrimitiveArrayKotlinType";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "getPrimitiveArrayKotlinTypeByPrimitiveKotlinType";
                break;
            }
            case 77: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "getPrimitiveType";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getPrimitiveArrayType";
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "getArrayType";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "getEnumType";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "isArray";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "isArrayOrPrimitiveArray";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "isPrimitiveArray";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "getPrimitiveArrayElementType";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "isPrimitiveType";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "isPrimitiveTypeOrNullablePrimitiveType";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "isPrimitiveClass";
                break;
            }
            case 98: 
            case 99: 
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "isConstructedFromGivenClass";
                break;
            }
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "isTypeConstructorForGivenClass";
                break;
            }
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "classFqNameEquals";
                break;
            }
            case 106: 
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "isNotNullConstructedFromGivenClass";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "isSpecialClassWithNoSupertypes";
                break;
            }
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "isAny";
                break;
            }
            case 111: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "isBoolean";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "isBooleanOrNullableBoolean";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "isNumber";
                break;
            }
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "isChar";
                break;
            }
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "isCharOrNullableChar";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "isInt";
                break;
            }
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "isByte";
                break;
            }
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "isLong";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "isLongOrNullableLong";
                break;
            }
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "isShort";
                break;
            }
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "isFloat";
                break;
            }
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "isFloatOrNullableFloat";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "isDouble";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "isUByte";
                break;
            }
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "isUShort";
                break;
            }
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "isUInt";
                break;
            }
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "isULong";
                break;
            }
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "isUByteArray";
                break;
            }
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "isUShortArray";
                break;
            }
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "isUIntArray";
                break;
            }
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "isULongArray";
                break;
            }
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "isUnsignedArrayType";
                break;
            }
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "isDoubleOrNullableDouble";
                break;
            }
            case 135: 
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "isConstructedFromGivenClassAndNotNullable";
                break;
            }
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "isNothing";
                break;
            }
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "isNullableNothing";
                break;
            }
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "isNothingOrNullableNothing";
                break;
            }
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "isAnyOrNullableAny";
                break;
            }
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "isNullableAny";
                break;
            }
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "isDefaultBound";
                break;
            }
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "isUnit";
                break;
            }
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "mayReturnNonUnitValue";
                break;
            }
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "isUnitOrNullableUnit";
                break;
            }
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "isBooleanOrSubtype";
                break;
            }
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "isMemberOfAny";
                break;
            }
            case 148: 
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "isEnum";
                break;
            }
            case 150: 
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "isComparable";
                break;
            }
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "isCollectionOrNullableCollection";
                break;
            }
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "isListOrNullableList";
                break;
            }
            case 154: {
                objectArray = objectArray;
                objectArray[2] = "isSetOrNullableSet";
                break;
            }
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "isMapOrNullableMap";
                break;
            }
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "isIterableOrNullableIterable";
                break;
            }
            case 157: {
                objectArray = objectArray;
                objectArray[2] = "isThrowableOrNullableThrowable";
                break;
            }
            case 158: {
                objectArray = objectArray;
                objectArray[2] = "isThrowable";
                break;
            }
            case 159: {
                objectArray = objectArray;
                objectArray[2] = "isKClass";
                break;
            }
            case 160: {
                objectArray = objectArray;
                objectArray[2] = "isNonPrimitiveArray";
                break;
            }
            case 161: {
                objectArray = objectArray;
                objectArray[2] = "isCloneable";
                break;
            }
            case 162: {
                objectArray = objectArray;
                objectArray[2] = "isDeprecated";
                break;
            }
            case 163: {
                objectArray = objectArray;
                objectArray[2] = "isNotNullOrNullableFunctionSupertype";
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 75: 
            case 82: 
            case 85: 
            case 87: 
            case 88: {
                runtimeException = new IllegalStateException(string2);
            }
        }
        throw runtimeException;
    }

    private static class Primitives {
        public final Map<PrimitiveType, SimpleType> primitiveTypeToArrayKotlinType;
        public final Map<KotlinType, SimpleType> primitiveKotlinTypeToKotlinArrayType;
        public final Map<SimpleType, SimpleType> kotlinArrayTypeToPrimitiveKotlinType;

        /*
         * WARNING - void declaration
         */
        private Primitives(Map<PrimitiveType, SimpleType> primitiveTypeToArrayKotlinType, Map<KotlinType, SimpleType> primitiveKotlinTypeToKotlinArrayType, Map<SimpleType, SimpleType> kotlinArrayTypeToPrimitiveKotlinType) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (primitiveTypeToArrayKotlinType == null) {
                Primitives.$$$reportNull$$$0(0);
            }
            if (primitiveKotlinTypeToKotlinArrayType == null) {
                Primitives.$$$reportNull$$$0(1);
            }
            if (kotlinArrayTypeToPrimitiveKotlinType == null) {
                Primitives.$$$reportNull$$$0(2);
            }
            this.primitiveTypeToArrayKotlinType = var1_1;
            this.primitiveKotlinTypeToKotlinArrayType = var2_2;
            this.kotlinArrayTypeToPrimitiveKotlinType = var3_3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "primitiveTypeToArrayKotlinType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "primitiveKotlinTypeToKotlinArrayType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "kotlinArrayTypeToPrimitiveKotlinType";
                }
            }
            objectArray[1] = "kotlin/reflect/jvm/internal/impl/builtins/KotlinBuiltIns$Primitives";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

