/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3.internal;

import androidx.compose.material3.internal.CalendarDate;
import androidx.compose.material3.internal.CalendarModel;
import androidx.compose.material3.internal.DateInputFormat;
import androidx.compose.material3.internal.LegacyCalendarModelImpl;
import androidx.compose.runtime.internal.StabilityInferred;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.format.TextStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000fJ\u0016\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u000fJ\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0018\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e0\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Landroidx/compose/material3/internal/PlatformDateFormat;", "", "locale", "Ljava/util/Locale;", "Landroidx/compose/material3/CalendarLocale;", "(Ljava/util/Locale;)V", "delegate", "Landroidx/compose/material3/internal/LegacyCalendarModelImpl;", "firstDayOfWeek", "", "getFirstDayOfWeek", "()I", "weekdayNames", "", "Lkotlin/Pair;", "", "getWeekdayNames", "()Ljava/util/List;", "formatWithPattern", "utcTimeMillis", "", "pattern", "formatWithSkeleton", "skeleton", "getDateInputFormat", "Landroidx/compose/material3/internal/DateInputFormat;", "is24HourFormat", "", "parse", "Landroidx/compose/material3/internal/CalendarDate;", "date", "material3"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPlatformDateFormat.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlatformDateFormat.desktop.kt\nandroidx/compose/material3/internal/PlatformDateFormat\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,114:1\n11065#2:115\n11400#2,3:116\n*S KotlinDebug\n*F\n+ 1 PlatformDateFormat.desktop.kt\nandroidx/compose/material3/internal/PlatformDateFormat\n*L\n91#1:115\n91#1:116,3\n*E\n"})
public final class PlatformDateFormat {
    private final Locale locale;
    private final LegacyCalendarModelImpl delegate;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public PlatformDateFormat(Locale locale) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        this.locale = var1_1;
        this.delegate = new LegacyCalendarModelImpl(this.locale);
    }

    public final int getFirstDayOfWeek() {
        return ((CalendarModel)this.delegate).getFirstDayOfWeek();
    }

    /*
     * WARNING - void declaration
     */
    public final String formatWithPattern(long utcTimeMillis, String pattern) {
        void var3_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        return ((CalendarModel)this.delegate).formatWithPattern((long)var1_1, (String)var3_2, this.locale);
    }

    /*
     * Unable to fully structure code
     */
    public final String formatWithSkeleton(long utcTimeMillis, String skeleton) {
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)skeleton, (String)"skeleton");
                var4_3 = skeleton;
                switch (var4_3.hashCode()) {
                    case -1097329781: {
                        if (var4_3.equals("yMMMMEEEEd")) break;
                        ** break;
                    }
                    case 114116409: {
                        if (!var4_3.equals("yMMMM")) {
                            ** break;
                        }
                        break block6;
                    }
                    case 114116432: {
                        if (!var4_3.equals("yMMMd")) ** break;
                        v0 = DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM).localizedBy(this.locale).format(Instant.ofEpochMilli(utcTimeMillis).atOffset(ZoneOffset.UTC));
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"format(...)");
                        return v0;
                    }
                }
                v1 = DateTimeFormatter.ofLocalizedDate(FormatStyle.FULL).localizedBy(this.locale).format(Instant.ofEpochMilli(utcTimeMillis).atOffset(ZoneOffset.UTC));
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"format(...)");
                return v1;
            }
            v2 = "LLLL yyyy";
            break block7;
lbl22:
            // 4 sources

            v2 = pattern;
        }
        pattern = v2;
        return this.formatWithPattern((long)var1_1, (String)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    public final CalendarDate parse(String date, String pattern) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        return ((CalendarModel)this.delegate).parse((String)var1_1, (String)var2_2);
    }

    public final DateInputFormat getDateInputFormat() {
        return ((CalendarModel)this.delegate).getDateInputFormat(this.locale);
    }

    /*
     * WARNING - void declaration
     */
    public final List<Pair<String, String>> getWeekdayNames() {
        void var1_1;
        void $this$mapTo$iv$iv;
        DayOfWeek[] $this$map$iv;
        DayOfWeek[] dayOfWeekArray = $this$map$iv = DayOfWeek.values();
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Collection collection = destination$iv$iv;
            collection.add(TuplesKt.to((Object)it.getDisplayName(TextStyle.FULL, this.locale), (Object)it.getDisplayName(TextStyle.NARROW, this.locale)));
        }
        return (List)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean is24HourFormat() {
        void var1_1;
        DateFormat dateFormat = DateFormat.getTimeInstance(1, this.locale);
        if (!(dateFormat instanceof SimpleDateFormat)) {
            return false;
        }
        String string = ((SimpleDateFormat)var1_1).toPattern();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toPattern(...)");
        return StringsKt.contains$default((CharSequence)string, (char)'H', (boolean)false, (int)2, null);
    }
}

