/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3.internal;

import androidx.compose.material3.internal.CalendarDate;
import androidx.compose.material3.internal.CalendarModel;
import androidx.compose.material3.internal.CalendarModelKt;
import androidx.compose.material3.internal.CalendarMonth;
import androidx.compose.material3.internal.DateInputFormat;
import androidx.compose.runtime.internal.StabilityInferred;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 32\u00020\u0001:\u00013B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J$\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00132\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004H\u0016J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001bH\u0016J\u0014\u0010\u001f\u001a\u00020 2\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004H\u0016J\u0010\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\rH\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010\"\u001a\u00020\rH\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010#\u001a\u00020$2\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u0007H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u001bH\u0016J\u0018\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020$2\u0006\u0010+\u001a\u00020\u0007H\u0016J\u001a\u0010,\u001a\u0004\u0018\u00010\r2\u0006\u0010\"\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0013H\u0016J\u0018\u0010-\u001a\u00020$2\u0006\u0010*\u001a\u00020$2\u0006\u0010.\u001a\u00020\u0007H\u0016J\b\u0010/\u001a\u00020\u0013H\u0016J\u001a\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u00120\u0011H\u0002J\u0014\u00100\u001a\u00020&*\u00020\r2\u0006\u00101\u001a\u000202H\u0002J\f\u00100\u001a\u00020&*\u00020$H\u0002R\u001b\u0010\u0006\u001a\u00020\u00078VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR-\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u00120\u00118VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u000b\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00064"}, d2={"Landroidx/compose/material3/internal/LegacyCalendarModelImpl;", "Landroidx/compose/material3/internal/CalendarModel;", "locale", "Ljava/util/Locale;", "Landroidx/compose/material3/CalendarLocale;", "(Ljava/util/Locale;)V", "firstDayOfWeek", "", "getFirstDayOfWeek", "()I", "firstDayOfWeek$delegate", "Lkotlin/Lazy;", "today", "Landroidx/compose/material3/internal/CalendarDate;", "getToday", "()Landroidx/compose/material3/internal/CalendarDate;", "weekdayNames", "", "Lkotlin/Pair;", "", "getWeekdayNames", "()Ljava/util/List;", "weekdayNames$delegate", "dayInISO8601", "day", "formatWithPattern", "utcTimeMillis", "", "pattern", "getCanonicalDate", "timeInMillis", "getDateInputFormat", "Landroidx/compose/material3/internal/DateInputFormat;", "getDayOfWeek", "date", "getMonth", "Landroidx/compose/material3/internal/CalendarMonth;", "firstDayCalendar", "Ljava/util/Calendar;", "year", "month", "minusMonths", "from", "subtractedMonthsCount", "parse", "plusMonths", "addedMonthsCount", "toString", "toCalendar", "timeZone", "Ljava/util/TimeZone;", "Companion", "material3"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nLegacyCalendarModelImpl.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LegacyCalendarModelImpl.jvm.kt\nandroidx/compose/material3/internal/LegacyCalendarModelImpl\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,245:1\n69#2,6:246\n*S KotlinDebug\n*F\n+ 1 LegacyCalendarModelImpl.jvm.kt\nandroidx/compose/material3/internal/LegacyCalendarModelImpl\n*L\n65#1:246,6\n*E\n"})
public final class LegacyCalendarModelImpl
extends CalendarModel {
    public static final Companion Companion = new Companion(null);
    private final Lazy firstDayOfWeek$delegate;
    private final Lazy weekdayNames$delegate;
    public static final int $stable = 8;
    private static final TimeZone utcTimeZone;

    /*
     * WARNING - void declaration
     */
    public LegacyCalendarModelImpl(Locale locale) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        super(locale);
        this.firstDayOfWeek$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Integer>(this, (Locale)var1_1){
            final /* synthetic */ LegacyCalendarModelImpl this$0;
            final /* synthetic */ Locale $locale;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.$locale = var2_2;
                super(0);
            }

            public final Integer invoke() {
                return LegacyCalendarModelImpl.access$dayInISO8601(this.this$0, Calendar.getInstance(this.$locale).getFirstDayOfWeek());
            }
        }));
        this.weekdayNames$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends Pair<? extends String, ? extends String>>>(this){
            final /* synthetic */ LegacyCalendarModelImpl this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                super(0);
            }

            public final List<Pair<String, String>> invoke() {
                return LegacyCalendarModelImpl.access$weekdayNames(this.this$0);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final CalendarDate getToday() {
        void var2_2;
        void var1_1;
        Calendar systemCalendar = Calendar.getInstance();
        systemCalendar.set(11, 0);
        systemCalendar.set(12, 0);
        systemCalendar.set(13, 0);
        systemCalendar.set(14, 0);
        int utcOffset = systemCalendar.get(15) + systemCalendar.get(16);
        return new CalendarDate(systemCalendar.get(1), systemCalendar.get(2) + 1, systemCalendar.get(5), var1_1.getTimeInMillis() + (long)var2_2);
    }

    @Override
    public final int getFirstDayOfWeek() {
        Lazy lazy = this.firstDayOfWeek$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    @Override
    public final List<Pair<String, String>> getWeekdayNames() {
        Lazy lazy = this.weekdayNames$delegate;
        return (List)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<String, String>> weekdayNames() {
        void var3_3;
        void var2_2;
        List list;
        List $this$weekdayNames_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        Object[] weekdays = new DateFormatSymbols(this.getLocale()).getWeekdays();
        String[] shortWeekdays = new DateFormatSymbols(this.getLocale()).getShortWeekdays();
        Intrinsics.checkNotNull((Object)weekdays);
        List $this$fastForEachIndexed$iv = ArraysKt.drop((Object[])weekdays, (int)2);
        int index$iv = 0;
        int n = $this$fastForEachIndexed$iv.size();
        while (index$iv < n) {
            void day;
            Object item$iv = $this$fastForEachIndexed$iv.get(index$iv);
            item$iv = (String)item$iv;
            int index = index$iv++;
            $this$weekdayNames_u24lambda_u241.add(new Pair((Object)day, (Object)shortWeekdays[index + 2]));
        }
        var2_2.add(new Pair((Object)var3_3[1], (Object)shortWeekdays[1]));
        return CollectionsKt.build((List)list);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final DateInputFormat getDateInputFormat(Locale locale) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        DateFormat dateFormat = DateFormat.getDateInstance(3, (Locale)var1_1);
        Intrinsics.checkNotNull((Object)dateFormat, (String)"null cannot be cast to non-null type java.text.SimpleDateFormat");
        String string = ((SimpleDateFormat)dateFormat).toPattern();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toPattern(...)");
        return CalendarModelKt.datePatternAsInputFormat(string);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final CalendarDate getCanonicalDate(long timeInMillis) {
        void var3_2;
        void var1_1;
        Calendar calendar = Calendar.getInstance(utcTimeZone);
        calendar.setTimeInMillis((long)var1_1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return new CalendarDate(calendar.get(1), calendar.get(2) + 1, calendar.get(5), var3_2.getTimeInMillis());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final CalendarMonth getMonth(long timeInMillis) {
        void var3_2;
        void var1_1;
        Calendar firstDayCalendar = Calendar.getInstance(utcTimeZone);
        firstDayCalendar.setTimeInMillis((long)var1_1);
        firstDayCalendar.set(5, 1);
        firstDayCalendar.set(11, 0);
        firstDayCalendar.set(12, 0);
        firstDayCalendar.set(13, 0);
        firstDayCalendar.set(14, 0);
        Intrinsics.checkNotNull((Object)firstDayCalendar);
        return this.getMonth((Calendar)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final CalendarMonth getMonth(CalendarDate date) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return ((CalendarModel)this).getMonth(date.getYear(), var1_1.getMonth());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final CalendarMonth getMonth(int year, int month) {
        void var3_3;
        void var2_2;
        void var1_1;
        Calendar firstDayCalendar = Calendar.getInstance(utcTimeZone);
        firstDayCalendar.clear();
        firstDayCalendar.set(1, (int)var1_1);
        firstDayCalendar.set(2, (int)(var2_2 - true));
        firstDayCalendar.set(5, 1);
        Intrinsics.checkNotNull((Object)firstDayCalendar);
        return this.getMonth((Calendar)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getDayOfWeek(CalendarDate date) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        LegacyCalendarModelImpl legacyCalendarModelImpl = this;
        TimeZone timeZone = TimeZone.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)timeZone, (String)"getDefault(...)");
        return legacyCalendarModelImpl.dayInISO8601(legacyCalendarModelImpl.toCalendar((CalendarDate)var1_1, timeZone).get(7));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final CalendarMonth plusMonths(CalendarMonth from, int addedMonthsCount) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        if (addedMonthsCount <= 0) {
            return from;
        }
        Calendar laterMonth = this.toCalendar(from);
        laterMonth.add(2, (int)var2_2);
        return this.getMonth((Calendar)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final CalendarMonth minusMonths(CalendarMonth from, int subtractedMonthsCount) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        if (subtractedMonthsCount <= 0) {
            return from;
        }
        Calendar earlierMonth = this.toCalendar(from);
        earlierMonth.add(2, (int)(-var2_2));
        return this.getMonth((Calendar)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String formatWithPattern(long utcTimeMillis, String pattern, Locale locale) {
        void var3_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return Companion.formatWithPattern((long)var1_1, (String)var3_2, locale, this.getFormatterCache$material3());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final CalendarDate parse(String date, String pattern) {
        CalendarDate calendarDate;
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        dateFormat.setTimeZone(utcTimeZone);
        dateFormat.setLenient(false);
        try {
            void var2_2;
            Date date2 = dateFormat.parse(date);
            if (date2 == null) {
                return null;
            }
            Date parsedDate = date2;
            Calendar calendar = Calendar.getInstance(utcTimeZone);
            calendar.setTime((Date)((Object)calendarDate));
            calendarDate = new CalendarDate(calendar.get(1), calendar.get(2) + 1, calendar.get(5), var2_2.getTimeInMillis());
        }
        catch (ParseException parseException) {
            calendarDate = null;
        }
        return calendarDate;
    }

    public final String toString() {
        return "LegacyCalendarModel";
    }

    /*
     * WARNING - void declaration
     */
    private final int dayInISO8601(int day) {
        void var1_1;
        int shiftedDay = (day + 6) % 7;
        if (shiftedDay == 0) {
            return 7;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private final CalendarMonth getMonth(Calendar firstDayCalendar) {
        void var1_1;
        void var2_2;
        void daysFromStartOfWeekToFirstOfMonth;
        int difference = this.dayInISO8601(firstDayCalendar.get(7)) - ((CalendarModel)this).getFirstDayOfWeek();
        daysFromStartOfWeekToFirstOfMonth = difference < 0 ? difference + 7 : daysFromStartOfWeekToFirstOfMonth;
        return new CalendarMonth(firstDayCalendar.get(1), firstDayCalendar.get(2) + 1, firstDayCalendar.getActualMaximum(5), (int)var2_2, var1_1.getTimeInMillis());
    }

    /*
     * WARNING - void declaration
     */
    private final Calendar toCalendar(CalendarMonth $this$toCalendar) {
        void var2_2;
        void var1_1;
        Calendar calendar = Calendar.getInstance(utcTimeZone);
        calendar.setTimeInMillis(var1_1.getStartUtcTimeMillis());
        Intrinsics.checkNotNull((Object)calendar);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private final Calendar toCalendar(CalendarDate $this$toCalendar, TimeZone timeZone) {
        void var2_2;
        void var1_1;
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.clear();
        calendar.set(1, $this$toCalendar.getYear());
        calendar.set(2, $this$toCalendar.getMonth() - 1);
        calendar.set(5, var1_1.getDayOfMonth());
        Intrinsics.checkNotNull((Object)calendar);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ int access$dayInISO8601(LegacyCalendarModelImpl $this, int day) {
        void var1_1;
        return $this.dayInISO8601((int)var1_1);
    }

    public static final /* synthetic */ List access$weekdayNames(LegacyCalendarModelImpl $this) {
        return $this.weekdayNames();
    }

    static {
        TimeZone timeZone = TimeZone.getTimeZone("UTC");
        Intrinsics.checkNotNullExpressionValue((Object)timeZone, (String)"getTimeZone(...)");
        utcTimeZone = timeZone;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\n\u0010\f\u001a\u00060\rj\u0002`\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0010J0\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\b2\n\u0010\f\u001a\u00060\rj\u0002`\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0010H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Landroidx/compose/material3/internal/LegacyCalendarModelImpl$Companion;", "", "()V", "utcTimeZone", "Ljava/util/TimeZone;", "getUtcTimeZone$material3", "()Ljava/util/TimeZone;", "formatWithPattern", "", "utcTimeMillis", "", "pattern", "locale", "Ljava/util/Locale;", "Landroidx/compose/material3/CalendarLocale;", "cache", "", "getCachedSimpleDateFormat", "Ljava/text/SimpleDateFormat;", "material3"})
    @SourceDebugExtension(value={"SMAP\nLegacyCalendarModelImpl.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LegacyCalendarModelImpl.jvm.kt\nandroidx/compose/material3/internal/LegacyCalendarModelImpl$Companion\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,245:1\n372#2,7:246\n*S KotlinDebug\n*F\n+ 1 LegacyCalendarModelImpl.jvm.kt\nandroidx/compose/material3/internal/LegacyCalendarModelImpl$Companion\n*L\n196#1:246,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final String formatWithPattern(long utcTimeMillis, String pattern, Locale locale, Map<String, Object> cache) {
            void var3_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            Intrinsics.checkNotNullParameter(cache, (String)"cache");
            SimpleDateFormat dateFormat = this.getCachedSimpleDateFormat(pattern, locale, cache);
            Calendar calendar = Calendar.getInstance(this.getUtcTimeZone$material3());
            calendar.setTimeInMillis((long)var1_1);
            String string = var3_2.format(calendar.getTimeInMillis());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            return string;
        }

        public final TimeZone getUtcTimeZone$material3() {
            return utcTimeZone;
        }

        /*
         * WARNING - void declaration
         */
        private final SimpleDateFormat getCachedSimpleDateFormat(String pattern, Locale locale, Map<String, Object> cache) {
            Object v;
            void $this$getOrPut$iv;
            String key$iv = pattern + locale.toLanguageTag();
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                void var1_1;
                void answer$iv;
                void var3_3;
                void var2_2;
                SimpleDateFormat dateFormat = new SimpleDateFormat(pattern, (Locale)var2_2);
                dateFormat.setTimeZone(Companion.getUtcTimeZone$material3());
                var3_3.put(key$iv, answer$iv);
                v = var1_1;
            } else {
                v = value$iv;
            }
            return (SimpleDateFormat)v;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

