/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3.internal;

import androidx.compose.material3.internal.CalendarDate;
import androidx.compose.material3.internal.CalendarModel;
import androidx.compose.material3.internal.CalendarMonth;
import androidx.compose.material3.internal.DateInputFormat;
import androidx.compose.material3.internal.KotlinxDatetimeCalendarModelKt;
import androidx.compose.material3.internal.PlatformDateFormat;
import androidx.compose.runtime.internal.StabilityInferred;
import java.time.DayOfWeek;
import java.time.ZoneId;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.Clock;
import kotlinx.datetime.DatePeriod;
import kotlinx.datetime.DayOfWeekKt;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateJvmKt;
import kotlinx.datetime.LocalDateKt;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.LocalTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J$\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00172\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004H\u0016J\u0010\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u001cH\u0016J\u0014\u0010 \u001a\u00020!2\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004H\u0016J\u0010\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u0011H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010#\u001a\u00020\u0011H\u0016J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u0007H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020\u001cH\u0016J\u0018\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020\u0007H\u0016J\u001a\u0010+\u001a\u0004\u0018\u00010\u00112\u0006\u0010#\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0017H\u0016J\u0018\u0010,\u001a\u00020%2\u0006\u0010)\u001a\u00020%2\u0006\u0010-\u001a\u00020\u0007H\u0016J\f\u0010.\u001a\u00020\u0007*\u00020/H\u0002J\u0014\u00100\u001a\u00020%*\u0002012\u0006\u00102\u001a\u00020\rH\u0002R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R&\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u00160\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00063"}, d2={"Landroidx/compose/material3/internal/KotlinxDatetimeCalendarModel;", "Landroidx/compose/material3/internal/CalendarModel;", "locale", "Ljava/util/Locale;", "Landroidx/compose/material3/CalendarLocale;", "(Ljava/util/Locale;)V", "firstDayOfWeek", "", "getFirstDayOfWeek", "()I", "platformDateFormat", "Landroidx/compose/material3/internal/PlatformDateFormat;", "systemTZ", "Lkotlinx/datetime/TimeZone;", "getSystemTZ", "()Lkotlinx/datetime/TimeZone;", "today", "Landroidx/compose/material3/internal/CalendarDate;", "getToday", "()Landroidx/compose/material3/internal/CalendarDate;", "weekdayNames", "", "Lkotlin/Pair;", "", "getWeekdayNames", "()Ljava/util/List;", "formatWithPattern", "utcTimeMillis", "", "pattern", "getCanonicalDate", "timeInMillis", "getDateInputFormat", "Landroidx/compose/material3/internal/DateInputFormat;", "getDayOfWeek", "date", "getMonth", "Landroidx/compose/material3/internal/CalendarMonth;", "year", "month", "minusMonths", "from", "subtractedMonthsCount", "parse", "plusMonths", "addedMonthsCount", "daysFromStartOfWeekToFirstOfMonth", "Lkotlinx/datetime/LocalDate;", "toCalendarMonth", "Lkotlinx/datetime/Instant;", "timeZone", "material3"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nKotlinxDatetimeCalendarModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinxDatetimeCalendarModel.kt\nandroidx/compose/material3/internal/KotlinxDatetimeCalendarModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,193:1\n1#2:194\n*E\n"})
public final class KotlinxDatetimeCalendarModel
extends CalendarModel {
    private final PlatformDateFormat platformDateFormat;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public KotlinxDatetimeCalendarModel(Locale locale) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        super(locale);
        this.platformDateFormat = new PlatformDateFormat((Locale)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final CalendarDate getToday() {
        void var1_1;
        LocalDateTime localDate = TimeZoneKt.toLocalDateTime((Instant)Clock.System.INSTANCE.now(), (TimeZone)this.getSystemTZ());
        return new CalendarDate(localDate.getYear(), localDate.getMonthNumber(), localDate.getDayOfMonth(), TimeZoneKt.toInstant((LocalDateTime)LocalDateKt.atTime((LocalDate)var1_1.getDate(), (LocalTime)KotlinxDatetimeCalendarModelKt.getMidnight()), (TimeZone)((TimeZone)TimeZone.access$getUTC$cp())).toEpochMilliseconds());
    }

    @Override
    public final int getFirstDayOfWeek() {
        return this.platformDateFormat.getFirstDayOfWeek();
    }

    @Override
    public final List<Pair<String, String>> getWeekdayNames() {
        return this.platformDateFormat.getWeekdayNames();
    }

    private final TimeZone getSystemTZ() {
        TimeZone.Companion companion = TimeZone.Companion;
        ZoneId zoneId = ZoneId.systemDefault();
        Intrinsics.checkNotNullExpressionValue((Object)zoneId, (String)"systemDefault(...)");
        return TimeZone.Companion.ofZone$kotlinx_datetime((ZoneId)zoneId);
    }

    @Override
    public final DateInputFormat getDateInputFormat(Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return this.platformDateFormat.getDateInputFormat();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final CalendarDate getCanonicalDate(long timeInMillis) {
        void var1_1;
        return KotlinxDatetimeCalendarModelKt.toCalendarDate(TimeZoneKt.atStartOfDayIn((LocalDate)TimeZoneKt.toLocalDateTime((Instant)Instant.Companion.fromEpochMilliseconds((long)var1_1), (TimeZone)((TimeZone)TimeZone.access$getUTC$cp())).getDate(), (TimeZone)((TimeZone)TimeZone.access$getUTC$cp())), (TimeZone)TimeZone.access$getUTC$cp());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final CalendarMonth getMonth(long timeInMillis) {
        void var1_1;
        return this.toCalendarMonth(Instant.Companion.fromEpochMilliseconds((long)var1_1), (TimeZone)TimeZone.access$getUTC$cp());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final CalendarMonth getMonth(CalendarDate date) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return ((CalendarModel)this).getMonth(var1_1.getUtcTimeMillis());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final CalendarMonth getMonth(int year, int month) {
        void var1_2;
        void var2_3;
        Instant instant = TimeZoneKt.toInstant((LocalDateTime)LocalDateKt.atTime((LocalDate)new LocalDate(year, (int)var2_3, 1), (LocalTime)KotlinxDatetimeCalendarModelKt.getMidnight()), (TimeZone)((TimeZone)TimeZone.access$getUTC$cp()));
        return ((CalendarModel)this).getMonth(var1_2.toEpochMilliseconds());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getDayOfWeek(CalendarDate date) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return DayOfWeekKt.getIsoDayNumber((DayOfWeek)new LocalDate(date.getYear(), date.getMonth(), var1_1.getDayOfMonth()).getDayOfWeek());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final CalendarMonth plusMonths(CalendarMonth from, int addedMonthsCount) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        return this.toCalendarMonth(TimeZoneKt.toInstant((LocalDateTime)LocalDateKt.atTime((LocalDate)LocalDateJvmKt.plus((LocalDate)TimeZoneKt.toLocalDateTime((Instant)Instant.Companion.fromEpochMilliseconds((long)var1_1.getStartUtcTimeMillis()), (TimeZone)((TimeZone)TimeZone.access$getUTC$cp())).getDate(), (DatePeriod)new DatePeriod(0, (int)var2_2, 0, 5)), (LocalTime)KotlinxDatetimeCalendarModelKt.getMidnight()), (TimeZone)((TimeZone)TimeZone.access$getUTC$cp())), (TimeZone)TimeZone.access$getUTC$cp());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final CalendarMonth minusMonths(CalendarMonth from, int subtractedMonthsCount) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        return ((CalendarModel)this).plusMonths((CalendarMonth)var1_1, (int)(-var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String formatWithPattern(long utcTimeMillis, String pattern, Locale locale) {
        void var3_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return this.platformDateFormat.formatWithPattern((long)var1_1, (String)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final CalendarDate parse(String date, String pattern) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        return this.platformDateFormat.parse((String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private final CalendarMonth toCalendarMonth(Instant $this$toCalendarMonth, TimeZone timeZone) {
        void var2_2;
        void var1_1;
        LocalDateTime dateTime = TimeZoneKt.toLocalDateTime((Instant)$this$toCalendarMonth, (TimeZone)timeZone);
        LocalDate monthStart = new LocalDate(dateTime.getYear(), dateTime.getMonth(), 1);
        return new CalendarMonth(dateTime.getYear(), dateTime.getMonthNumber(), KotlinxDatetimeCalendarModelKt.access$numberOfDays(dateTime.getMonth(), KotlinxDatetimeCalendarModelKt.access$isLeapYear(var1_1.getYear())), this.daysFromStartOfWeekToFirstOfMonth(monthStart), TimeZoneKt.toInstant((LocalDateTime)LocalDateKt.atTime((LocalDate)var2_2, (LocalTime)KotlinxDatetimeCalendarModelKt.getMidnight()), (TimeZone)((TimeZone)TimeZone.access$getUTC$cp())).toEpochMilliseconds());
    }

    /*
     * WARNING - void declaration
     */
    private final int daysFromStartOfWeekToFirstOfMonth(LocalDate $this$daysFromStartOfWeekToFirstOfMonth) {
        void var1_2;
        int it = DayOfWeekKt.getIsoDayNumber((DayOfWeek)$this$daysFromStartOfWeekToFirstOfMonth.getDayOfWeek()) - ((CalendarModel)this).getFirstDayOfWeek();
        if (it >= 0) {
            return it;
        }
        return (int)(var1_2 + 7);
    }
}

