/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3.carousel;

import androidx.collection.FloatList;
import androidx.collection.FloatListKt;
import androidx.collection.MutableFloatList;
import androidx.compose.material3.carousel.Keyline;
import androidx.compose.material3.carousel.KeylineList;
import androidx.compose.material3.carousel.KeylineListKt;
import androidx.compose.material3.carousel.KeylineListScope;
import androidx.compose.material3.carousel.ShiftPointRange;
import androidx.compose.ui.util.MathHelpersKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010!\n\u0000\u001a8\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a.\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\f2\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0002\u001a\u001e\u0010\u000f\u001a\u00020\u00042\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\f2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002\u001a \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0004H\u0002\u001a.\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\f2\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004H\u0002\u001a\u001e\u0010\u0019\u001a\u00020\u00042\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00010\f2\u0006\u0010\u0018\u001a\u00020\u0004H\u0002\u001a&\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00042\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u001a0\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004H\u0002\u001a0\u0010&\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a(\u0010)\u001a\b\u0012\u0004\u0012\u00020\b0**\b\u0012\u0004\u0012\u00020\b0*2\u0006\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020\nH\u0002\u00a8\u0006+"}, d2={"createShiftedKeylineListForContentPadding", "Landroidx/compose/material3/carousel/KeylineList;", "from", "carouselMainAxisSize", "", "itemSpacing", "contentPadding", "pivot", "Landroidx/compose/material3/carousel/Keyline;", "pivotIndex", "", "getEndKeylineSteps", "", "defaultKeylines", "afterContentPadding", "getEndShiftDistance", "endKeylineSteps", "getShiftPointRange", "Landroidx/compose/material3/carousel/ShiftPointRange;", "stepsCount", "shiftPoint", "Landroidx/collection/FloatList;", "interpolation", "getStartKeylineSteps", "beforeContentPadding", "getStartShiftDistance", "startKeylineSteps", "getStepInterpolationPoints", "totalShiftDistance", "steps", "isShiftingLeft", "", "lerp", "outputMin", "outputMax", "inputMin", "inputMax", "value", "moveKeylineAndCreateShiftedKeylineList", "srcIndex", "dstIndex", "move", "", "material3"})
@SourceDebugExtension(value={"SMAP\nStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Strategy.kt\nandroidx/compose/material3/carousel/StrategyKt\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,626:1\n235#2,3:627\n33#2,4:630\n238#2,2:634\n38#2:636\n240#2:637\n277#2,3:638\n69#2,4:641\n280#2,2:645\n74#2:647\n282#2:648\n1549#3:649\n1620#3,3:650\n1855#3,2:653\n*S KotlinDebug\n*F\n+ 1 Strategy.kt\nandroidx/compose/material3/carousel/StrategyKt\n*L\n483#1:627,3\n483#1:630,4\n483#1:634,2\n483#1:636\n483#1:637\n501#1:638,3\n501#1:641,4\n501#1:645,2\n501#1:647\n501#1:648\n562#1:649\n562#1:650,3\n590#1:653,2\n*E\n"})
public final class StrategyKt {
    /*
     * WARNING - void declaration
     */
    private static final float getStartShiftDistance(List<KeylineList> startKeylineSteps, float beforeContentPadding) {
        void var1_1;
        List<KeylineList> list;
        if (startKeylineSteps.isEmpty()) {
            return 0.0f;
        }
        return Math.max(((Keyline)CollectionsKt.first((List)((List)CollectionsKt.last(startKeylineSteps)))).getUnadjustedOffset() - ((Keyline)CollectionsKt.first((List)((List)CollectionsKt.first(list)))).getUnadjustedOffset(), (float)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static final float getEndShiftDistance(List<KeylineList> endKeylineSteps, float afterContentPadding) {
        void var1_1;
        List<KeylineList> list;
        if (endKeylineSteps.isEmpty()) {
            return 0.0f;
        }
        return Math.max(((Keyline)CollectionsKt.last((List)((List)CollectionsKt.first(endKeylineSteps)))).getUnadjustedOffset() - ((Keyline)CollectionsKt.last((List)((List)CollectionsKt.last(list)))).getUnadjustedOffset(), (float)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<KeylineList> getStartKeylineSteps(KeylineList defaultKeylines, float carouselMainAxisSize, float itemSpacing, float beforeContentPadding) {
        if (defaultKeylines.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        List steps = new ArrayList();
        steps.add(defaultKeylines);
        if (defaultKeylines.isFirstFocalItemAtStartOfContainer()) {
            if (!(beforeContentPadding == 0.0f)) {
                steps.add(StrategyKt.createShiftedKeylineListForContentPadding(defaultKeylines, carouselMainAxisSize, itemSpacing, beforeContentPadding, defaultKeylines.getFirstFocal(), defaultKeylines.getFirstFocalIndex()));
            }
            return steps;
        }
        int startIndex = defaultKeylines.getFirstNonAnchorIndex();
        int n = defaultKeylines.getFirstFocalIndex();
        int numberOfSteps = n - startIndex;
        if (numberOfSteps <= 0 && defaultKeylines.getFirstFocal().getCutoff() > 0.0f) {
            steps.add(StrategyKt.moveKeylineAndCreateShiftedKeylineList(defaultKeylines, 0, 0, carouselMainAxisSize, itemSpacing));
            return steps;
        }
        for (int i = 0; i < numberOfSteps; ++i) {
            KeylineList prevStep = (KeylineList)CollectionsKt.last((List)steps);
            int originalItemIndex = startIndex + i;
            int dstIndex = CollectionsKt.getLastIndex((List)defaultKeylines);
            if (originalItemIndex > 0) {
                float originalNeighborBeforeSize = defaultKeylines.get(originalItemIndex - 1).getSize();
                dstIndex = prevStep.firstIndexAfterFocalRangeWithSize(originalNeighborBeforeSize) - 1;
            }
            steps.add(StrategyKt.moveKeylineAndCreateShiftedKeylineList(prevStep, defaultKeylines.getFirstNonAnchorIndex(), dstIndex, carouselMainAxisSize, itemSpacing));
        }
        if (!(beforeContentPadding == 0.0f)) {
            void var3_3;
            void var2_2;
            void var1_1;
            List list = steps;
            list.set(CollectionsKt.getLastIndex((List)list), StrategyKt.createShiftedKeylineListForContentPadding((KeylineList)CollectionsKt.last((List)steps), (float)var1_1, (float)var2_2, (float)var3_3, ((KeylineList)CollectionsKt.last((List)steps)).getFirstFocal(), ((KeylineList)CollectionsKt.last((List)steps)).getFirstFocalIndex()));
        }
        return steps;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<KeylineList> getEndKeylineSteps(KeylineList defaultKeylines, float carouselMainAxisSize, float itemSpacing, float afterContentPadding) {
        if (defaultKeylines.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        List steps = new ArrayList();
        steps.add(defaultKeylines);
        if (defaultKeylines.isLastFocalItemAtEndOfContainer(carouselMainAxisSize)) {
            if (!(afterContentPadding == 0.0f)) {
                steps.add(StrategyKt.createShiftedKeylineListForContentPadding(defaultKeylines, carouselMainAxisSize, itemSpacing, -afterContentPadding, defaultKeylines.getLastFocal(), defaultKeylines.getLastFocalIndex()));
            }
            return steps;
        }
        int startIndex = defaultKeylines.getLastFocalIndex();
        int endIndex = defaultKeylines.getLastNonAnchorIndex();
        int numberOfSteps = endIndex - startIndex;
        if (numberOfSteps <= 0 && defaultKeylines.getLastFocal().getCutoff() > 0.0f) {
            steps.add(StrategyKt.moveKeylineAndCreateShiftedKeylineList(defaultKeylines, 0, 0, carouselMainAxisSize, itemSpacing));
            return steps;
        }
        for (int i = 0; i < numberOfSteps; ++i) {
            KeylineList prevStep = (KeylineList)CollectionsKt.last((List)steps);
            int originalItemIndex = endIndex - i;
            int dstIndex = 0;
            if (originalItemIndex < CollectionsKt.getLastIndex((List)defaultKeylines)) {
                float originalNeighborAfterSize = defaultKeylines.get(originalItemIndex + 1).getSize();
                dstIndex = prevStep.lastIndexBeforeFocalRangeWithSize(originalNeighborAfterSize) + 1;
            }
            KeylineList keylines = StrategyKt.moveKeylineAndCreateShiftedKeylineList(prevStep, defaultKeylines.getLastNonAnchorIndex(), dstIndex, carouselMainAxisSize, itemSpacing);
            steps.add(keylines);
        }
        if (!(afterContentPadding == 0.0f)) {
            void var3_3;
            void var2_2;
            void var1_1;
            List list = steps;
            list.set(CollectionsKt.getLastIndex((List)list), StrategyKt.createShiftedKeylineListForContentPadding((KeylineList)CollectionsKt.last((List)steps), (float)var1_1, (float)var2_2, (float)(-var3_3), ((KeylineList)CollectionsKt.last((List)steps)).getLastFocal(), ((KeylineList)CollectionsKt.last((List)steps)).getLastFocalIndex()));
        }
        return steps;
    }

    /*
     * WARNING - void declaration
     */
    private static final KeylineList createShiftedKeylineListForContentPadding(KeylineList from, float carouselMainAxisSize2, float itemSpacing, float contentPadding2, Keyline pivot, int pivotIndex) {
        void var1_2;
        Keyline keyline;
        List $this$fastFilter$iv = from;
        ArrayList target$iv = new ArrayList($this$fastFilter$iv.size());
        List $this$fastForEach$iv$iv = $this$fastFilter$iv;
        int n = $this$fastForEach$iv$iv.size();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            Object e;
            Object it$iv = e = $this$fastForEach$iv$iv.get(index$iv$iv);
            keyline = (Keyline)e;
            if (!(!keyline.isAnchor())) continue;
            ((Collection)target$iv).add(it$iv);
        }
        int numberOfNonAnchorKeylines = ((Collection)target$iv).size();
        float sizeReduction = contentPadding2 / (float)numberOfNonAnchorKeylines;
        KeylineList carouselMainAxisSize2 = KeylineListKt.keylineListOf(carouselMainAxisSize2, itemSpacing, pivotIndex, pivot.getOffset() - sizeReduction / 2.0f + contentPadding2, (Function1<? super KeylineListScope, Unit>)((Function1)new Function1<KeylineListScope, Unit>(from, sizeReduction){
            final /* synthetic */ KeylineList $from;
            final /* synthetic */ float $sizeReduction;
            {
                void var2_2;
                void var1_1;
                this.$from = var1_1;
                this.$sizeReduction = var2_2;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(KeylineListScope $this$keylineListOf) {
                void $this$fastForEach$iv;
                Intrinsics.checkNotNullParameter((Object)$this$keylineListOf, (String)"$this$keylineListOf");
                List list = this.$from;
                float f = this.$sizeReduction;
                int n = $this$fastForEach$iv.size();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    E e = $this$fastForEach$iv.get(index$iv);
                    Keyline k = (Keyline)e;
                    $this$keylineListOf.add(k.getSize() - Math.abs(f), k.isAnchor());
                }
            }
        }));
        List $this$fastMapIndexed$iv = carouselMainAxisSize2;
        ArrayList target$iv2 = new ArrayList($this$fastMapIndexed$iv.size());
        List $this$fastForEachIndexed$iv$iv = $this$fastMapIndexed$iv;
        int index$iv$iv = 0;
        int n2 = $this$fastForEachIndexed$iv$iv.size();
        while (index$iv$iv < n2) {
            void var3_8;
            void var2_6;
            void e$iv;
            Object item$iv$iv = $this$fastForEachIndexed$iv$iv.get(index$iv$iv);
            keyline = item$iv$iv;
            int index$iv22 = index$iv$iv++;
            Keyline index$iv22 = (Keyline)e$iv;
            int contentPadding2 = index$iv22;
            Collection collection = target$iv2;
            collection.add(Keyline.copy$default((Keyline)var2_6, 0.0f, 0.0f, from.get((int)var3_8).getUnadjustedOffset(), false, false, false, 0.0f, 123, null));
        }
        List<Keyline> list = (List)var1_2;
        return new KeylineList(list);
    }

    /*
     * WARNING - void declaration
     */
    private static final KeylineList moveKeylineAndCreateShiftedKeylineList(KeylineList from, int srcIndex, int dstIndex, float carouselMainAxisSize, float itemSpacing) {
        void var2_2;
        void var1_1;
        KeylineList keylineList;
        void var3_3;
        int pivotDir = srcIndex > dstIndex ? 1 : -1;
        float pivotDelta = (from.get(srcIndex).getSize() - from.get(srcIndex).getCutoff() + itemSpacing) * (float)pivotDir;
        int newPivotIndex = from.getPivotIndex() + pivotDir;
        float newPivotOffset = from.getPivot().getOffset() + pivotDelta;
        return KeylineListKt.keylineListOf((float)var3_3, itemSpacing, newPivotIndex, newPivotOffset, (Function1<? super KeylineListScope, Unit>)((Function1)new Function1<KeylineListScope, Unit>(keylineList, (int)var1_1, (int)var2_2){
            final /* synthetic */ KeylineList $from;
            final /* synthetic */ int $srcIndex;
            final /* synthetic */ int $dstIndex;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.$from = var1_1;
                this.$srcIndex = var2_2;
                this.$dstIndex = var3_3;
                super(1);
            }

            public final void invoke(KeylineListScope $this$keylineListOf) {
                Intrinsics.checkNotNullParameter((Object)$this$keylineListOf, (String)"$this$keylineListOf");
                List $this$fastForEach$iv = StrategyKt.access$move(CollectionsKt.toMutableList((Collection)this.$from), this.$srcIndex, this.$dstIndex);
                int n = $this$fastForEach$iv.size();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    E e = $this$fastForEach$iv.get(index$iv);
                    Keyline k = (Keyline)e;
                    $this$keylineListOf.add(k.getSize(), k.isAnchor());
                }
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private static final FloatList getStepInterpolationPoints(float totalShiftDistance, List<KeylineList> steps, boolean isShiftingLeft) {
        void var3_3;
        void $this$mapTo$iv$iv;
        MutableFloatList points = FloatListKt.mutableFloatListOf((float)0.0f);
        if (totalShiftDistance == 0.0f || steps.isEmpty()) {
            return (FloatList)points;
        }
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)1, (int)steps.size());
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        object = $this$mapTo$iv$iv.iterator();
        while (object.hasNext()) {
            void i;
            int item$iv$iv = ((IntIterator)object).nextInt();
            Collection collection = destination$iv$iv;
            KeylineList prevKeylines22 = steps.get((int)(i - true));
            KeylineList currKeylines = steps.get((int)i);
            float prevKeylines22 = isShiftingLeft ? ((Keyline)CollectionsKt.first((List)currKeylines)).getUnadjustedOffset() - ((Keyline)CollectionsKt.first((List)prevKeylines22)).getUnadjustedOffset() : ((Keyline)CollectionsKt.last((List)prevKeylines22)).getUnadjustedOffset() - ((Keyline)CollectionsKt.last((List)currKeylines)).getUnadjustedOffset();
            float stepPercentage = prevKeylines22 / totalShiftDistance;
            float point = i == CollectionsKt.getLastIndex(steps) ? 1.0f : points.get((int)(i - true)) + stepPercentage;
            collection.add(points.add(point));
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        return (FloatList)var3_3;
    }

    private static final ShiftPointRange getShiftPointRange(int stepsCount, FloatList shiftPoint, float interpolation) {
        int n;
        float lowerBounds = shiftPoint.get(0);
        Object object = (Iterable)RangesKt.until((int)1, (int)n);
        object = object.iterator();
        while (object.hasNext()) {
            int n2 = ((IntIterator)object).nextInt();
            int i = n2;
            float upperBounds = shiftPoint.get(i);
            if (interpolation <= upperBounds) {
                return new ShiftPointRange(i - 1, i, StrategyKt.lerp(0.0f, 1.0f, lowerBounds, upperBounds, interpolation));
            }
            lowerBounds = upperBounds;
        }
        return new ShiftPointRange(0, 0, 0.0f);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Keyline> move(List<Keyline> $this$move, int srcIndex, int dstIndex) {
        List<Keyline> list;
        void var3_3;
        void var2_2;
        void var1_1;
        Keyline keyline = $this$move.get(srcIndex);
        $this$move.remove((int)var1_1);
        $this$move.add((int)var2_2, (Keyline)var3_3);
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private static final float lerp(float outputMin, float outputMax, float inputMin, float inputMax, float value) {
        void var2_2;
        void var3_3;
        void var1_1;
        float f;
        if (value <= inputMin) {
            return outputMin;
        }
        if (value >= inputMax) {
            return outputMax;
        }
        return MathHelpersKt.lerp((float)f, (float)var1_1, (float)((value - inputMin) / (var3_3 - var2_2)));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ float access$getStartShiftDistance(List startKeylineSteps, float beforeContentPadding) {
        void var1_1;
        return StrategyKt.getStartShiftDistance(startKeylineSteps, (float)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ float access$getEndShiftDistance(List endKeylineSteps, float afterContentPadding) {
        void var1_1;
        return StrategyKt.getEndShiftDistance(endKeylineSteps, (float)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ FloatList access$getStepInterpolationPoints(float totalShiftDistance, List steps, boolean isShiftingLeft) {
        void var2_2;
        void var1_1;
        return StrategyKt.getStepInterpolationPoints(totalShiftDistance, (List<KeylineList>)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ List access$getStartKeylineSteps(KeylineList defaultKeylines, float carouselMainAxisSize, float itemSpacing, float beforeContentPadding) {
        void var3_3;
        void var2_2;
        void var1_1;
        return StrategyKt.getStartKeylineSteps(defaultKeylines, (float)var1_1, (float)var2_2, (float)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ List access$getEndKeylineSteps(KeylineList defaultKeylines, float carouselMainAxisSize, float itemSpacing, float afterContentPadding) {
        void var3_3;
        void var2_2;
        void var1_1;
        return StrategyKt.getEndKeylineSteps(defaultKeylines, (float)var1_1, (float)var2_2, (float)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ float access$lerp(float outputMin, float outputMax, float inputMin, float inputMax, float value) {
        void var3_3;
        void var2_2;
        void var1_1;
        return StrategyKt.lerp(outputMin, (float)var1_1, (float)var2_2, (float)var3_3, value);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ShiftPointRange access$getShiftPointRange(int stepsCount, FloatList shiftPoint, float interpolation) {
        void var2_2;
        void var1_1;
        return StrategyKt.getShiftPointRange(stepsCount, (FloatList)var1_1, (float)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ List access$move(List $receiver, int srcIndex, int dstIndex) {
        void var2_2;
        void var1_1;
        return StrategyKt.move($receiver, (int)var1_1, (int)var2_2);
    }
}

