/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3.carousel;

import androidx.compose.material3.carousel.Arrangement;
import androidx.compose.material3.carousel.CarouselAlignment;
import androidx.compose.material3.carousel.CarouselDefaults;
import androidx.compose.material3.carousel.KeylineList;
import androidx.compose.material3.carousel.KeylineListKt;
import androidx.compose.material3.carousel.KeylineListScope;
import androidx.compose.ui.unit.Density;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001H\u0002\u001a0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001aD\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00012\b\b\u0002\u0010\u0014\u001a\u00020\u0001H\u0000\u001a(\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001H\u0000\u00a8\u0006\u0017"}, d2={"calculateMediumChildSize", "", "minimumMediumSize", "largeItemSize", "remainingSpace", "createLeftAlignedKeylineList", "Landroidx/compose/material3/carousel/KeylineList;", "carouselMainAxisSize", "itemSpacing", "leftAnchorSize", "rightAnchorSize", "arrangement", "Landroidx/compose/material3/carousel/Arrangement;", "multiBrowseKeylineList", "density", "Landroidx/compose/ui/unit/Density;", "preferredItemSize", "itemCount", "", "minSmallItemSize", "maxSmallItemSize", "uncontainedKeylineList", "itemSize", "material3"})
@SourceDebugExtension(value={"SMAP\nKeylines.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Keylines.kt\nandroidx/compose/material3/carousel/KeylinesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,248:1\n1#2:249\n*E\n"})
public final class KeylinesKt {
    /*
     * WARNING - void declaration
     */
    public static final KeylineList multiBrowseKeylineList(Density density, float carouselMainAxisSize, float preferredItemSize, float itemSpacing, int itemCount, float minSmallItemSize, float maxSmallItemSize) {
        void var3_5;
        void var1_2;
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        if (carouselMainAxisSize == 0.0f || preferredItemSize == 0.0f) {
            return KeylineListKt.emptyKeylineList();
        }
        int[] nArray = new int[1];
        int[] nArray2 = nArray;
        nArray[0] = 1;
        int[] smallCounts = nArray2;
        int[] nArray3 = new int[2];
        int[] nArray4 = nArray3;
        nArray3[0] = 1;
        nArray4[1] = 0;
        int[] mediumCounts = nArray4;
        float targetLargeSize = Math.min(preferredItemSize, carouselMainAxisSize);
        float targetSmallSize = RangesKt.coerceIn((float)(targetLargeSize / 3.0f), (float)minSmallItemSize, (float)maxSmallItemSize);
        float targetMediumSize = (targetLargeSize + targetSmallSize) / 2.0f;
        if (carouselMainAxisSize < minSmallItemSize * 2.0f) {
            int[] nArray5 = new int[1];
            int[] nArray6 = nArray5;
            nArray5[0] = 0;
            smallCounts = nArray6;
        }
        float minAvailableLargeSpace = carouselMainAxisSize - targetMediumSize * (float)ArraysKt.maxOrThrow((int[])mediumCounts) - maxSmallItemSize * (float)ArraysKt.maxOrThrow((int[])smallCounts);
        int minLargeCount = Math.max(1, (int)Math.floor(minAvailableLargeSpace / targetLargeSize));
        int maxLargeCount = (int)Math.ceil(carouselMainAxisSize / targetLargeSize);
        int n = 0;
        int n2 = maxLargeCount - minLargeCount + 1;
        int[] nArray7 = new int[n2];
        while (n < n2) {
            int n3 = n++;
            nArray7[n3] = maxLargeCount - n3;
        }
        int[] largeCounts = nArray7;
        Density density2 = density;
        float anchorSize = density2.toPx-0680j_4(CarouselDefaults.INSTANCE.getAnchorSize-D9Ej5fM$material3());
        Arrangement arrangement = Arrangement.Companion.findLowestCostArrangement(carouselMainAxisSize, itemSpacing, targetSmallSize, minSmallItemSize, maxSmallItemSize, smallCounts, targetMediumSize, mediumCounts, targetLargeSize, largeCounts);
        if (arrangement != null && arrangement.itemCount() > itemCount) {
            void var2_3;
            void var0_1;
            int smallCount = arrangement.getSmallCount();
            int mediumCount = arrangement.getMediumCount();
            for (int keylineSurplus = arrangement.itemCount() - itemCount; keylineSurplus > 0; --keylineSurplus) {
                if (smallCount > 0) {
                    --smallCount;
                    continue;
                }
                if (mediumCount <= 1) continue;
                --mediumCount;
            }
            int[] nArray8 = new int[1];
            int[] nArray9 = nArray8;
            nArray8[0] = smallCount;
            int[] nArray10 = nArray9;
            int[] nArray11 = new int[1];
            nArray9 = nArray11;
            nArray11[0] = var0_1;
            arrangement = Arrangement.Companion.findLowestCostArrangement(carouselMainAxisSize, itemSpacing, (float)var2_3, minSmallItemSize, maxSmallItemSize, nArray10, targetMediumSize, nArray9, targetLargeSize, largeCounts);
        }
        if (arrangement == null) {
            return KeylineListKt.emptyKeylineList();
        }
        float f = anchorSize;
        return KeylinesKt.createLeftAlignedKeylineList((float)var1_2, (float)var3_5, f, f, arrangement);
    }

    public static /* synthetic */ KeylineList multiBrowseKeylineList$default(Density density, float f, float f2, float f3, int n, float f4, float f5, int n2, Object object) {
        if ((n2 & 0x20) != 0) {
            object = density;
            f4 = object.toPx-0680j_4(CarouselDefaults.INSTANCE.getMinSmallItemSize-D9Ej5fM$material3());
        }
        if ((n2 & 0x40) != 0) {
            object = density;
            f5 = object.toPx-0680j_4(CarouselDefaults.INSTANCE.getMaxSmallItemSize-D9Ej5fM$material3());
        }
        return KeylinesKt.multiBrowseKeylineList(density, f, f2, f3, n, f4, f5);
    }

    /*
     * WARNING - void declaration
     */
    public static final KeylineList createLeftAlignedKeylineList(float carouselMainAxisSize, float itemSpacing, float leftAnchorSize, float rightAnchorSize, Arrangement arrangement) {
        void var3_3;
        void var2_2;
        void var1_1;
        float f;
        Intrinsics.checkNotNullParameter((Object)arrangement, (String)"arrangement");
        return KeylineListKt.keylineListOf-WNYm7Xg(f, (float)var1_1, CarouselAlignment.Companion.getStart-NUL3oTo(), (Function1<? super KeylineListScope, Unit>)((Function1)new Function1<KeylineListScope, Unit>((float)var2_2, arrangement, (float)var3_3){
            final /* synthetic */ float $leftAnchorSize;
            final /* synthetic */ Arrangement $arrangement;
            final /* synthetic */ float $rightAnchorSize;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.$leftAnchorSize = var1_1;
                this.$arrangement = var2_2;
                this.$rightAnchorSize = var3_3;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(KeylineListScope $this$keylineListOf) {
                void var1_1;
                int n;
                Intrinsics.checkNotNullParameter((Object)$this$keylineListOf, (String)"$this$keylineListOf");
                $this$keylineListOf.add(this.$leftAnchorSize, true);
                int n2 = this.$arrangement.getLargeCount();
                Arrangement arrangement = this.$arrangement;
                for (n = 0; n < n2; ++n) {
                    KeylineListScope.add$default($this$keylineListOf, arrangement.getLargeSize(), false, 2, null);
                }
                n2 = this.$arrangement.getMediumCount();
                arrangement = this.$arrangement;
                for (n = 0; n < n2; ++n) {
                    KeylineListScope.add$default($this$keylineListOf, arrangement.getMediumSize(), false, 2, null);
                }
                n2 = this.$arrangement.getSmallCount();
                arrangement = this.$arrangement;
                for (n = 0; n < n2; ++n) {
                    KeylineListScope.add$default($this$keylineListOf, arrangement.getSmallSize(), false, 2, null);
                }
                var1_1.add(this.$rightAnchorSize, true);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    public static final KeylineList uncontainedKeylineList(Density density, float carouselMainAxisSize, float itemSize, float itemSpacing) {
        void var0_1;
        void var2_3;
        void var3_4;
        void var1_2;
        float f;
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        if (carouselMainAxisSize == 0.0f || itemSize == 0.0f) {
            return KeylineListKt.emptyKeylineList();
        }
        float largeItemSize = Math.min(itemSize + itemSpacing, carouselMainAxisSize);
        int largeCount = Math.max(1, (int)Math.floor(carouselMainAxisSize / largeItemSize));
        float remainingSpace = carouselMainAxisSize - (float)largeCount * largeItemSize;
        int mediumCount = f > 0.0f ? 1 : 0;
        Density density2 = density;
        float defaultAnchorSize = density2.toPx-0680j_4(CarouselDefaults.INSTANCE.getAnchorSize-D9Ej5fM$material3());
        float mediumItemSize = KeylinesKt.calculateMediumChildSize(defaultAnchorSize, largeItemSize, remainingSpace);
        Arrangement arrangement = new Arrangement(0, 0.0f, 0, mediumItemSize, mediumCount, largeItemSize, largeCount);
        itemSize = Math.min(defaultAnchorSize, itemSize);
        float leftAnchorSize = Math.max(itemSize, mediumItemSize * 0.5f);
        return KeylinesKt.createLeftAlignedKeylineList((float)var1_2, (float)var3_4, (float)var2_3, (float)var0_1, arrangement);
    }

    /*
     * WARNING - void declaration
     */
    private static final float calculateMediumChildSize(float minimumMediumSize, float largeItemSize, float remainingSpace) {
        float f;
        float largeItemThreshold;
        float mediumItemSize = minimumMediumSize;
        float f2 = remainingSpace * 1.5f;
        if ((mediumItemSize = Math.max(f2, mediumItemSize)) > (largeItemThreshold = largeItemSize * 0.85f)) {
            void var1_1;
            void var2_2;
            float sizeWithFifthCutOff = var2_2 * 1.2f;
            f = Math.max((float)var1_1, f);
        }
        return f;
    }
}

