/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.safety;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jsoup.helper.Validate;
import org.jsoup.internal.Normalizer;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Element;

public class Safelist {
    private final Set<TagName> tagNames = new HashSet<TagName>();
    private final Map<TagName, Set<AttributeKey>> attributes = new HashMap<TagName, Set<AttributeKey>>();
    private final Map<TagName, Map<AttributeKey, AttributeValue>> enforcedAttributes = new HashMap<TagName, Map<AttributeKey, AttributeValue>>();
    private final Map<TagName, Map<AttributeKey, Set<Protocol>>> protocols = new HashMap<TagName, Map<AttributeKey, Set<Protocol>>>();
    private boolean preserveRelativeLinks = false;

    public static Safelist none() {
        return new Safelist();
    }

    public static Safelist simpleText() {
        return new Safelist().addTags("b", "em", "i", "strong", "u");
    }

    public static Safelist basic() {
        return new Safelist().addTags("a", "b", "blockquote", "br", "cite", "code", "dd", "dl", "dt", "em", "i", "li", "ol", "p", "pre", "q", "small", "span", "strike", "strong", "sub", "sup", "u", "ul").addAttributes("a", "href").addAttributes("blockquote", "cite").addAttributes("q", "cite").addProtocols("a", "href", "ftp", "http", "https", "mailto").addProtocols("blockquote", "cite", "http", "https").addProtocols("cite", "cite", "http", "https").addEnforcedAttribute("a", "rel", "nofollow");
    }

    public static Safelist basicWithImages() {
        return Safelist.basic().addTags("img").addAttributes("img", "align", "alt", "height", "src", "title", "width").addProtocols("img", "src", "http", "https");
    }

    public static Safelist relaxed() {
        return new Safelist().addTags("a", "b", "blockquote", "br", "caption", "cite", "code", "col", "colgroup", "dd", "div", "dl", "dt", "em", "h1", "h2", "h3", "h4", "h5", "h6", "i", "img", "li", "ol", "p", "pre", "q", "small", "span", "strike", "strong", "sub", "sup", "table", "tbody", "td", "tfoot", "th", "thead", "tr", "u", "ul").addAttributes("a", "href", "title").addAttributes("blockquote", "cite").addAttributes("col", "span", "width").addAttributes("colgroup", "span", "width").addAttributes("img", "align", "alt", "height", "src", "title", "width").addAttributes("ol", "start", "type").addAttributes("q", "cite").addAttributes("table", "summary", "width").addAttributes("td", "abbr", "axis", "colspan", "rowspan", "width").addAttributes("th", "abbr", "axis", "colspan", "rowspan", "scope", "width").addAttributes("ul", "type").addProtocols("a", "href", "ftp", "http", "https", "mailto").addProtocols("blockquote", "cite", "http", "https").addProtocols("cite", "cite", "http", "https").addProtocols("img", "src", "http", "https").addProtocols("q", "cite", "http", "https");
    }

    public Safelist() {
    }

    /*
     * WARNING - void declaration
     */
    public Safelist(Safelist copy) {
        this();
        void var1_1;
        this.tagNames.addAll(copy.tagNames);
        for (Map.Entry<TagName, Set<AttributeKey>> entry : copy.attributes.entrySet()) {
            this.attributes.put(entry.getKey(), new HashSet(entry.getValue()));
        }
        for (Map.Entry<TagName, Object> entry : copy.enforcedAttributes.entrySet()) {
            this.enforcedAttributes.put(entry.getKey(), new HashMap((Map)entry.getValue()));
        }
        for (Map.Entry<TagName, Object> entry : copy.protocols.entrySet()) {
            HashMap attributeProtocolsCopy = new HashMap();
            for (Map.Entry attributeProtocols : ((Map)entry.getValue()).entrySet()) {
                attributeProtocolsCopy.put((AttributeKey)attributeProtocols.getKey(), new HashSet((Collection)attributeProtocols.getValue()));
            }
            this.protocols.put(entry.getKey(), attributeProtocolsCopy);
        }
        this.preserveRelativeLinks = var1_1.preserveRelativeLinks;
    }

    /*
     * WARNING - void declaration
     */
    public Safelist addTags(String ... tags) {
        void var1_1;
        Validate.notNull(tags);
        for (void tagName : var1_1) {
            Validate.notEmpty((String)tagName);
            this.tagNames.add(TagName.valueOf((String)tagName));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Safelist removeTags(String ... tags) {
        void var1_1;
        Validate.notNull(tags);
        for (void tag : var1_1) {
            Validate.notEmpty((String)tag);
            TagName tagName = TagName.valueOf((String)tag);
            if (!this.tagNames.remove(tagName)) continue;
            this.attributes.remove(tagName);
            this.enforcedAttributes.remove(tagName);
            this.protocols.remove(tagName);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Safelist addAttributes(String tag, String ... attributes) {
        Set<AttributeKey> set;
        Validate.notEmpty(tag);
        Validate.notNull(attributes);
        Validate.isTrue(attributes.length > 0, "No attribute names supplied.");
        TagName tagName = TagName.valueOf(tag);
        this.tagNames.add(tagName);
        HashSet<AttributeKey> attributeSet = new HashSet<AttributeKey>();
        for (void var6_6 : set) {
            Validate.notEmpty((String)var6_6);
            attributeSet.add(AttributeKey.valueOf((String)var6_6));
        }
        if (this.attributes.containsKey(tagName)) {
            set = this.attributes.get(tagName);
            set.addAll(attributeSet);
        } else {
            void var3_3;
            void var1_1;
            this.attributes.put((TagName)var1_1, (Set<AttributeKey>)var3_3);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Safelist removeAttributes(String tag, String ... attributes) {
        void var1_1;
        Validate.notEmpty(tag);
        Validate.notNull(attributes);
        Validate.isTrue(attributes.length > 0, "No attribute names supplied.");
        TagName tagName = TagName.valueOf(tag);
        HashSet<AttributeKey> attributeSet = new HashSet<AttributeKey>();
        for (String key : attributes) {
            Validate.notEmpty(key);
            attributeSet.add(AttributeKey.valueOf(key));
        }
        if (this.tagNames.contains(tagName) && this.attributes.containsKey(tagName)) {
            Iterator<TagName> iterator;
            Set<AttributeKey> currentSet = this.attributes.get(tagName);
            currentSet.removeAll(attributeSet);
            if (iterator.isEmpty()) {
                void var3_3;
                this.attributes.remove(var3_3);
            }
        }
        if (var1_1.equals(":all")) {
            for (TagName name : this.attributes.keySet()) {
                Set<AttributeKey> currentSet = this.attributes.get(name);
                currentSet.removeAll(attributeSet);
                if (!currentSet.isEmpty()) continue;
                this.attributes.remove(name);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Safelist addEnforcedAttribute(String tag, String attribute, String value) {
        Validate.notEmpty(tag);
        Validate.notEmpty(attribute);
        Validate.notEmpty(value);
        TagName tagName = TagName.valueOf(tag);
        this.tagNames.add(tagName);
        AttributeKey attrKey = AttributeKey.valueOf(attribute);
        AttributeValue attrVal = AttributeValue.valueOf(value);
        if (this.enforcedAttributes.containsKey(tagName)) {
            this.enforcedAttributes.get(tagName).put(attrKey, attrVal);
        } else {
            void var1_1;
            void var3_3;
            void var2_2;
            HashMap<void, void> attrMap = new HashMap<void, void>();
            attrMap.put(var2_2, var3_3);
            this.enforcedAttributes.put((TagName)var1_1, attrMap);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Safelist removeEnforcedAttribute(String tag, String attribute) {
        Validate.notEmpty(tag);
        Validate.notEmpty(attribute);
        TagName tagName = TagName.valueOf(tag);
        if (this.tagNames.contains(tagName) && this.enforcedAttributes.containsKey(tagName)) {
            void var3_3;
            void var2_2;
            AttributeKey attrKey = AttributeKey.valueOf(attribute);
            Map<AttributeKey, AttributeValue> attrMap = this.enforcedAttributes.get(tagName);
            attrMap.remove(var2_2);
            if (var3_3.isEmpty()) {
                void var1_1;
                this.enforcedAttributes.remove(var1_1);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Safelist preserveRelativeLinks(boolean preserve) {
        void var1_1;
        this.preserveRelativeLinks = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Safelist addProtocols(String tag, String attribute, String ... protocols) {
        void var3_3;
        Set<Protocol> protSet;
        Map<Object, Object> attrMap;
        Validate.notEmpty(tag);
        Validate.notEmpty(attribute);
        Validate.notNull(protocols);
        TagName tagName = TagName.valueOf(tag);
        AttributeKey attrKey = AttributeKey.valueOf(attribute);
        if (this.protocols.containsKey(tagName)) {
            attrMap = this.protocols.get(tagName);
        } else {
            attrMap = new HashMap();
            this.protocols.put(tagName, attrMap);
        }
        if (attrMap.containsKey(attrKey)) {
            protSet = (Set)attrMap.get(attrKey);
        } else {
            void var2_2;
            protSet = new HashSet();
            attrMap.put(var2_2, protSet);
        }
        for (void protocol : var3_3) {
            Validate.notEmpty((String)protocol);
            Protocol prot = Protocol.valueOf((String)protocol);
            protSet.add(prot);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Safelist removeProtocols(String tag, String attribute, String ... removeProtocols) {
        void var3_3;
        Validate.notEmpty(tag);
        Validate.notEmpty(attribute);
        Validate.notNull(removeProtocols);
        TagName tagName = TagName.valueOf(tag);
        AttributeKey attr = AttributeKey.valueOf(attribute);
        Validate.isTrue(this.protocols.containsKey(tagName), "Cannot remove a protocol that is not set.");
        Map<AttributeKey, Set<Protocol>> tagProtocols = this.protocols.get(tagName);
        Validate.isTrue(tagProtocols.containsKey(attr), "Cannot remove a protocol that is not set.");
        Set<Protocol> attrProtocols = tagProtocols.get(attr);
        for (void protocol : var3_3) {
            Validate.notEmpty((String)protocol);
            attrProtocols.remove(Protocol.valueOf((String)protocol));
        }
        if (attrProtocols.isEmpty()) {
            void var2_2;
            tagProtocols.remove(var2_2);
            if (tagProtocols.isEmpty()) {
                void var1_1;
                this.protocols.remove(var1_1);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isSafeTag(String tag) {
        void var1_1;
        return this.tagNames.contains(TagName.valueOf((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isSafeAttribute(String tagName, Element el, Attribute attr) {
        void var3_3;
        void var2_2;
        void var1_1;
        String attrKey;
        Attributes expect;
        Map<AttributeKey, Object> attrProts;
        TagName tag = TagName.valueOf(tagName);
        AttributeKey key = AttributeKey.valueOf(attr.getKey());
        Set<AttributeKey> okSet = this.attributes.get(tag);
        if (okSet != null && okSet.contains(key)) {
            if (this.protocols.containsKey(tag)) {
                attrProts = this.protocols.get(tag);
                return !attrProts.containsKey(key) || this.testValidProtocol(el, attr, (Set)attrProts.get(key));
            }
            return true;
        }
        if ((attrProts = this.enforcedAttributes.get(attrProts)) != null && (expect = this.getEnforcedAttributes(tagName)).hasKeyIgnoreCase(attrKey = attr.getKey())) {
            return expect.getIgnoreCase(attrKey).equals(attr.getValue());
        }
        return !var1_1.equals(":all") && this.isSafeAttribute(":all", (Element)var2_2, (Attribute)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private boolean testValidProtocol(Element el, Attribute attr, Set<Protocol> protocols) {
        Iterator<Protocol> iterator;
        String value = el.absUrl(attr.getKey());
        if (value.length() == 0) {
            value = attr.getValue();
        }
        if (!this.preserveRelativeLinks) {
            ((Attribute)((Object)iterator)).setValue(value);
        }
        iterator = protocols.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            protocols = iterator.next();
            String prot = ((TypedValue)protocols).toString();
            if (prot.equals("#")) {
                if (!this.isValidAnchor(value)) continue;
                return true;
            }
            prot = prot + ":";
            if (!Normalizer.lowerCase(value).startsWith((String)var3_3)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isValidAnchor(String value) {
        void var1_1;
        return value.startsWith("#") && !var1_1.matches(".*\\s.*");
    }

    /*
     * WARNING - void declaration
     */
    Attributes getEnforcedAttributes(String tagName) {
        void var2_2;
        Attributes attrs = new Attributes();
        TagName tag = TagName.valueOf(tagName);
        if (this.enforcedAttributes.containsKey(tag)) {
            Map<AttributeKey, AttributeValue> map;
            map = this.enforcedAttributes.get(map);
            for (Map.Entry entry : map.entrySet()) {
                attrs.put(((AttributeKey)entry.getKey()).toString(), ((AttributeValue)entry.getValue()).toString());
            }
        }
        return var2_2;
    }

    static class TagName
    extends TypedValue {
        /*
         * WARNING - void declaration
         */
        TagName(String value) {
            super((String)var1_1);
            void var1_1;
        }

        static TagName valueOf(String value) {
            String string;
            return new TagName(string);
        }
    }

    static class AttributeKey
    extends TypedValue {
        /*
         * WARNING - void declaration
         */
        AttributeKey(String value) {
            super((String)var1_1);
            void var1_1;
        }

        static AttributeKey valueOf(String value) {
            String string;
            return new AttributeKey(string);
        }
    }

    static class AttributeValue
    extends TypedValue {
        /*
         * WARNING - void declaration
         */
        AttributeValue(String value) {
            super((String)var1_1);
            void var1_1;
        }

        static AttributeValue valueOf(String value) {
            String string;
            return new AttributeValue(string);
        }
    }

    static class Protocol
    extends TypedValue {
        /*
         * WARNING - void declaration
         */
        Protocol(String value) {
            super((String)var1_1);
            void var1_1;
        }

        static Protocol valueOf(String value) {
            String string;
            return new Protocol(string);
        }
    }

    static abstract class TypedValue {
        private final String value;

        /*
         * WARNING - void declaration
         */
        TypedValue(String value) {
            void var1_1;
            Validate.notNull(value);
            this.value = var1_1;
        }

        public int hashCode() {
            int n = 31 + (this.value == null ? 0 : this.value.hashCode());
            return n;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object obj) {
            void var1_1;
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TypedValue other = (TypedValue)obj;
            if (this.value == null) {
                return other.value == null;
            }
            return this.value.equals(var1_1.value);
        }

        public String toString() {
            return this.value;
        }
    }
}

