/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.safety;

import java.util.Collection;
import java.util.List;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.parser.ParseErrorList;
import org.jsoup.parser.Parser;
import org.jsoup.parser.Tag;
import org.jsoup.safety.Safelist;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;

public class Cleaner {
    private final Safelist safelist;

    /*
     * WARNING - void declaration
     */
    public Cleaner(Safelist safelist) {
        void var1_1;
        Validate.notNull(safelist);
        this.safelist = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Document clean(Document dirtyDocument) {
        void var2_2;
        void var1_1;
        Validate.notNull(dirtyDocument);
        Document clean = Document.createShell(((Node)dirtyDocument).baseUri());
        this.copySafeNodes(dirtyDocument.body(), clean.body());
        clean.outputSettings(var1_1.outputSettings().clone());
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isValid(Document dirtyDocument) {
        void var1_1;
        void var2_2;
        Validate.notNull(dirtyDocument);
        Document clean = Document.createShell(((Node)dirtyDocument).baseUri());
        int n = this.copySafeNodes(dirtyDocument.body(), var2_2.body());
        return n == 0 && var1_1.head().childNodes().isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public boolean isValidBodyHtml(String bodyHtml) {
        void var2_3;
        void var3_4;
        void var1_1;
        Document clean = Document.createShell("");
        Document dirty = Document.createShell("");
        ParseErrorList errorList = ParseErrorList.tracking(1);
        List<Node> nodes = Parser.parseFragment(bodyHtml, dirty.body(), "", errorList);
        dirty.body().insertChildren(0, (Collection<? extends Node>)var1_1);
        int n = this.copySafeNodes(var3_4.body(), var2_3.body());
        return n == 0 && errorList.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private int copySafeNodes(Element source, Element dest) {
        void var2_2;
        void var1_1;
        CleaningVisitor cleaningVisitor = new CleaningVisitor(source, dest);
        NodeTraversor.traverse((NodeVisitor)cleaningVisitor, (Node)var1_1);
        return ((CleaningVisitor)var2_2).numDiscarded;
    }

    /*
     * WARNING - void declaration
     */
    private ElementMeta createSafeElement(Element sourceEl) {
        void var3_3;
        void var2_2;
        String sourceTag = sourceEl.tagName();
        Attributes destAttrs = new Attributes();
        Element dest = new Element(Tag.valueOf(sourceTag), ((Node)sourceEl).baseUri(), destAttrs);
        int numDiscarded = 0;
        Object object = ((Node)sourceEl).attributes();
        object = ((Attributes)object).iterator();
        while (object.hasNext()) {
            Attribute sourceAttr = (Attribute)object.next();
            if (this.safelist.isSafeAttribute(sourceTag, sourceEl, sourceAttr)) {
                destAttrs.put(sourceAttr);
                continue;
            }
            ++numDiscarded;
        }
        Attributes enforcedAttrs = this.safelist.getEnforcedAttributes((String)var2_2);
        var3_3.addAll(enforcedAttrs);
        if (sourceEl.sourceRange().isTracked()) {
            sourceEl.sourceRange().track(dest, true);
        }
        if (sourceEl.endSourceRange().isTracked()) {
            void var1_1;
            var1_1.endSourceRange().track(dest, false);
        }
        return new ElementMeta(dest, numDiscarded);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ ElementMeta access$100(Cleaner x0, Element x1) {
        void var1_1;
        return x0.createSafeElement((Element)var1_1);
    }

    private static class ElementMeta {
        Element el;
        int numAttribsDiscarded;

        /*
         * WARNING - void declaration
         */
        ElementMeta(Element el, int numAttribsDiscarded) {
            void var2_2;
            void var1_1;
            this.el = var1_1;
            this.numAttribsDiscarded = var2_2;
        }
    }

    private final class CleaningVisitor
    implements NodeVisitor {
        private int numDiscarded = 0;
        private final Element root;
        private Element destination;

        /*
         * WARNING - void declaration
         */
        private CleaningVisitor(Element root, Element destination) {
            void var3_3;
            void var2_2;
            this.root = var2_2;
            this.destination = var3_3;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @Override
        public final void head(Node source, int depth) {
            TextNode destText;
            ElementMeta meta;
            if (source instanceof Element) {
                Element sourceEl = (Element)source;
                if (Cleaner.this.safelist.isSafeTag(sourceEl.normalName())) {
                    meta = Cleaner.access$100(Cleaner.this, sourceEl);
                    Element destChild = meta.el;
                    this.destination.appendChild(destChild);
                    this.numDiscarded += meta.numAttribsDiscarded;
                    this.destination = destChild;
                    return;
                }
                if (meta == this.root) return;
                ++this.numDiscarded;
                return;
            }
            if (meta instanceof TextNode) {
                TextNode sourceText = (TextNode)((Object)meta);
                destText = new TextNode(sourceText.getWholeText());
                this.destination.appendChild(destText);
                return;
            }
            if (destText instanceof DataNode && Cleaner.this.safelist.isSafeTag(destText.parent().nodeName())) {
                void var1_1;
                void var2_5;
                DataNode sourceData = (DataNode)((Object)destText);
                DataNode destData = new DataNode(var2_5.getWholeData());
                this.destination.appendChild((Node)var1_1);
                return;
            }
            ++this.numDiscarded;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void tail(Node source, int depth) {
            void var1_1;
            if (source instanceof Element && Cleaner.this.safelist.isSafeTag(var1_1.nodeName())) {
                this.destination = this.destination.parent();
            }
        }
    }
}

