/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.CDataNode;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.DocumentType;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Entities;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.nodes.XmlDeclaration;
import org.jsoup.parser.ParseSettings;
import org.jsoup.parser.Parser;
import org.jsoup.parser.Tag;
import org.jsoup.parser.Token;
import org.jsoup.parser.TreeBuilder;

public class XmlTreeBuilder
extends TreeBuilder {
    private static final int maxQueueDepth = 256;

    @Override
    ParseSettings defaultSettings() {
        return ParseSettings.preserveCase;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void initialiseParse(Reader input, String baseUri, Parser parser) {
        void var3_3;
        void var2_2;
        void var1_1;
        super.initialiseParse((Reader)var1_1, (String)var2_2, (Parser)var3_3);
        this.stack.add(this.doc);
        this.doc.outputSettings().syntax(Document.OutputSettings.Syntax.xml).escapeMode(Entities.EscapeMode.xhtml).prettyPrint(false);
    }

    /*
     * WARNING - void declaration
     */
    Document parse(Reader input, String baseUri) {
        void var2_2;
        void var1_1;
        return this.parse((Reader)var1_1, (String)var2_2, new Parser(this));
    }

    /*
     * WARNING - void declaration
     */
    Document parse(String input, String baseUri) {
        void var2_2;
        void var1_1;
        return this.parse(new StringReader((String)var1_1), (String)var2_2, new Parser(this));
    }

    @Override
    XmlTreeBuilder newInstance() {
        return new XmlTreeBuilder();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean process(Token token) {
        switch (token.type) {
            case StartTag: {
                this.insert(token.asStartTag());
                break;
            }
            case EndTag: {
                this.popStackToClose(token.asEndTag());
                break;
            }
            case Comment: {
                this.insert(token.asComment());
                break;
            }
            case Character: {
                this.insert(token.asCharacter());
                break;
            }
            case Doctype: {
                this.insert(token.asDoctype());
                break;
            }
            case EOF: {
                break;
            }
            default: {
                void var1_1;
                Validate.fail("Unexpected token type: " + (Object)((Object)var1_1.type));
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected void insertNode(Node node) {
        void var1_1;
        this.currentElement().appendChild(node);
        this.onNodeInserted((Node)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    protected void insertNode(Node node, Token token) {
        void var2_2;
        void var1_1;
        this.currentElement().appendChild(node);
        this.onNodeInserted((Node)var1_1, (Token)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    Element insert(Token.StartTag startTag) {
        void var3_3;
        void var1_1;
        Tag tag = this.tagFor(startTag.name(), this.settings);
        if (startTag.hasAttributes()) {
            startTag.attributes.deduplicate(this.settings);
        }
        Element el = new Element(tag, null, this.settings.normalizeAttributes(startTag.attributes));
        this.insertNode(el, startTag);
        if (var1_1.isSelfClosing()) {
            if (!tag.isKnownTag()) {
                void var2_2;
                var2_2.setSelfClosing();
            }
        } else {
            this.stack.add(el);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    void insert(Token.Comment commentToken) {
        void var1_1;
        void var3_3;
        XmlDeclaration decl;
        Comment comment;
        Comment insert = comment = new Comment(commentToken.getData());
        if (commentToken.bogus && comment.isXmlDeclaration() && (decl = comment.asXmlDeclaration()) != null) {
            void var2_2;
            insert = var2_2;
        }
        this.insertNode((Node)var3_3, (Token)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    void insert(Token.Character token) {
        void var1_1;
        void var2_2;
        String data = token.getData();
        this.insertNode(token.isCData() ? new CDataNode(data) : new TextNode((String)var2_2), (Token)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    void insert(Token.Doctype d) {
        void var1_1;
        void var2_2;
        DocumentType doctypeNode = new DocumentType(this.settings.normalizeTag(d.getName()), d.getPublicIdentifier(), d.getSystemIdentifier());
        doctypeNode.setPubSysKey(d.getPubSysKey());
        this.insertNode((Node)var2_2, (Token)var1_1);
    }

    protected void popStackToClose(Token.EndTag endTag) {
        Element next;
        int pos;
        String elName = this.settings.normalizeTag(endTag.tagName);
        Element firstFound = null;
        int bottom = this.stack.size() - 1;
        int upper = bottom >= 256 ? bottom - 256 : 0;
        for (pos = this.stack.size() - 1; pos >= upper; --pos) {
            next = this.stack.get(pos);
            if (!((Node)next).nodeName().equals(elName)) continue;
            firstFound = next;
            break;
        }
        if (firstFound == null) {
            return;
        }
        for (pos = this.stack.size() - 1; pos >= 0; --pos) {
            next = this.stack.get(pos);
            this.stack.remove(pos);
            if (next != firstFound) continue;
            this.onNodeClosed(next, endTag);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    List<Node> parseFragment(String inputFragment, String baseUri, Parser parser) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.initialiseParse(new StringReader((String)var1_1), (String)var2_2, (Parser)var3_3);
        this.runParser();
        return this.doc.childNodes();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    List<Node> parseFragment(String inputFragment, Element context, String baseUri, Parser parser) {
        void var3_3;
        void var1_1;
        return this.parseFragment((String)var1_1, (String)var3_3, parser);
    }
}

