/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.Range;
import org.jsoup.parser.CharacterReader;
import org.jsoup.parser.ParseError;
import org.jsoup.parser.ParseErrorList;
import org.jsoup.parser.ParseSettings;
import org.jsoup.parser.Parser;
import org.jsoup.parser.Tag;
import org.jsoup.parser.Token;
import org.jsoup.parser.Tokeniser;

abstract class TreeBuilder {
    protected Parser parser;
    CharacterReader reader;
    Tokeniser tokeniser;
    protected Document doc;
    protected ArrayList<Element> stack;
    protected String baseUri;
    protected Token currentToken;
    protected ParseSettings settings;
    protected Map<String, Tag> seenTags;
    private Token.StartTag start = new Token.StartTag();
    private Token.EndTag end = new Token.EndTag();
    private boolean trackSourceRange;

    TreeBuilder() {
    }

    abstract ParseSettings defaultSettings();

    /*
     * WARNING - void declaration
     */
    protected void initialiseParse(Reader input, String baseUri, Parser parser) {
        void var2_2;
        void var3_3;
        void var1_1;
        Validate.notNullParam(input, "input");
        Validate.notNullParam(baseUri, "baseUri");
        Validate.notNull(parser);
        this.doc = new Document(baseUri);
        this.doc.parser(parser);
        this.parser = parser;
        this.settings = parser.settings();
        this.reader = new CharacterReader((Reader)var1_1);
        this.trackSourceRange = parser.isTrackPosition();
        this.reader.trackNewlines(parser.isTrackErrors() || this.trackSourceRange);
        this.currentToken = null;
        this.tokeniser = new Tokeniser(this.reader, var3_3.getErrors());
        this.stack = new ArrayList(32);
        this.seenTags = new HashMap<String, Tag>();
        this.baseUri = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    Document parse(Reader input, String baseUri, Parser parser) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.initialiseParse((Reader)var1_1, (String)var2_2, (Parser)var3_3);
        this.runParser();
        this.reader.close();
        this.reader = null;
        this.tokeniser = null;
        this.stack = null;
        this.seenTags = null;
        return this.doc;
    }

    abstract TreeBuilder newInstance();

    abstract List<Node> parseFragment(String var1, Element var2, String var3, Parser var4);

    /*
     * WARNING - void declaration
     */
    protected void runParser() {
        void var3_3;
        Tokeniser tokeniser = this.tokeniser;
        Token.TokenType eof = Token.TokenType.EOF;
        do {
            Token token = tokeniser.read();
            this.process(token);
            token.reset();
        } while (var3_3.type != eof);
    }

    protected abstract boolean process(Token var1);

    /*
     * WARNING - void declaration
     */
    protected boolean processStartTag(String name) {
        void var1_1;
        void var2_2;
        Token.StartTag start = this.start;
        if (this.currentToken == start) {
            return this.process(new Token.StartTag().name(name));
        }
        return this.process(var2_2.reset().name((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public boolean processStartTag(String name, Attributes attrs) {
        void var3_3;
        void var2_2;
        void var1_1;
        Token.StartTag start = this.start;
        if (this.currentToken == start) {
            return this.process(new Token.StartTag().nameAttr(name, attrs));
        }
        start.reset();
        start.nameAttr((String)var1_1, (Attributes)var2_2);
        return this.process((Token)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean processEndTag(String name) {
        void var1_1;
        if (this.currentToken == this.end) {
            return this.process(new Token.EndTag().name(name));
        }
        TreeBuilder treeBuilder = this;
        return treeBuilder.process(treeBuilder.end.reset().name((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    protected Element currentElement() {
        int size = this.stack.size();
        if (size > 0) {
            void var1_1;
            return this.stack.get((int)(var1_1 - true));
        }
        return this.doc;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean currentElementIs(String normalName) {
        void var1_1;
        void var2_2;
        if (this.stack.size() == 0) {
            return false;
        }
        Element current = this.currentElement();
        return current != null && var2_2.normalName().equals(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void error(String msg) {
        void var1_1;
        this.error((String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    protected void error(String msg, Object ... args) {
        ParseErrorList errors = this.parser.getErrors();
        if (errors.canAddError()) {
            void var2_2;
            void var1_1;
            void var3_3;
            var3_3.add(new ParseError(this.reader, (String)var1_1, (Object[])var2_2));
        }
    }

    protected boolean isContentForTagData(String normalName) {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected Tag tagFor(String tagName, ParseSettings settings) {
        void var3_3;
        Tag tag = this.seenTags.get(tagName);
        if (tag == null) {
            void var1_1;
            void var2_2;
            tag = Tag.valueOf(tagName, (ParseSettings)var2_2);
            this.seenTags.put((String)var1_1, tag);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    protected void onNodeInserted(Node node, Token token) {
        void var2_2;
        void var1_1;
        this.trackNodePosition((Node)var1_1, (Token)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    protected void onNodeClosed(Node node, Token token) {
        void var2_2;
        void var1_1;
        this.trackNodePosition((Node)var1_1, (Token)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    private void trackNodePosition(Node node, Token token, boolean start) {
        if (this.trackSourceRange && token != null) {
            void var3_5;
            void var1_1;
            Range range;
            int startPos = token.startPos();
            if (startPos == -1) {
                return;
            }
            Range.Position startRange = new Range.Position(startPos, this.reader.lineNumber(startPos), this.reader.columnNumber(startPos));
            int endPos = token.endPos();
            Range.Position endRange = new Range.Position(endPos, this.reader.lineNumber(endPos), this.reader.columnNumber(endPos));
            range = new Range(startRange, (Range.Position)((Object)range));
            range.track((Node)var1_1, (boolean)var3_5);
        }
    }
}

