/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import org.jsoup.helper.Validate;
import org.jsoup.nodes.Attributes;
import org.jsoup.parser.ParseSettings;

abstract class Token {
    TokenType type;
    static final int Unset = -1;
    private int startPos;
    private int endPos = -1;

    private Token() {
    }

    String tokenType() {
        return this.getClass().getSimpleName();
    }

    Token reset() {
        this.startPos = -1;
        this.endPos = -1;
        return this;
    }

    int startPos() {
        return this.startPos;
    }

    /*
     * WARNING - void declaration
     */
    void startPos(int pos) {
        void var1_1;
        this.startPos = var1_1;
    }

    int endPos() {
        return this.endPos;
    }

    /*
     * WARNING - void declaration
     */
    void endPos(int pos) {
        void var1_1;
        this.endPos = var1_1;
    }

    static void reset(StringBuilder sb) {
        if (sb != null) {
            StringBuilder stringBuilder;
            sb.delete(0, stringBuilder.length());
        }
    }

    final boolean isDoctype() {
        return this.type == TokenType.Doctype;
    }

    final Doctype asDoctype() {
        return (Doctype)this;
    }

    final boolean isStartTag() {
        return this.type == TokenType.StartTag;
    }

    final StartTag asStartTag() {
        return (StartTag)this;
    }

    final boolean isEndTag() {
        return this.type == TokenType.EndTag;
    }

    final EndTag asEndTag() {
        return (EndTag)this;
    }

    final boolean isComment() {
        return this.type == TokenType.Comment;
    }

    final Comment asComment() {
        return (Comment)this;
    }

    final boolean isCharacter() {
        return this.type == TokenType.Character;
    }

    final boolean isCData() {
        return this instanceof CData;
    }

    final Character asCharacter() {
        return (Character)this;
    }

    final boolean isEOF() {
        return this.type == TokenType.EOF;
    }

    public static enum TokenType {
        Doctype,
        StartTag,
        EndTag,
        Comment,
        Character,
        EOF;

    }

    static final class Doctype
    extends Token {
        final StringBuilder name = new StringBuilder();
        String pubSysKey = null;
        final StringBuilder publicIdentifier = new StringBuilder();
        final StringBuilder systemIdentifier = new StringBuilder();
        boolean forceQuirks = false;

        Doctype() {
            this.type = TokenType.Doctype;
        }

        @Override
        final Token reset() {
            super.reset();
            Doctype.reset(this.name);
            this.pubSysKey = null;
            Doctype.reset(this.publicIdentifier);
            Doctype.reset(this.systemIdentifier);
            this.forceQuirks = false;
            return this;
        }

        final String getName() {
            return this.name.toString();
        }

        final String getPubSysKey() {
            return this.pubSysKey;
        }

        final String getPublicIdentifier() {
            return this.publicIdentifier.toString();
        }

        public final String getSystemIdentifier() {
            return this.systemIdentifier.toString();
        }

        public final boolean isForceQuirks() {
            return this.forceQuirks;
        }

        public final String toString() {
            return "<!doctype " + this.getName() + ">";
        }
    }

    static final class StartTag
    extends Tag {
        StartTag() {
            this.type = TokenType.StartTag;
        }

        @Override
        final Tag reset() {
            super.reset();
            this.attributes = null;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        final StartTag nameAttr(String name, Attributes attributes) {
            void var2_2;
            void var1_1;
            this.tagName = var1_1;
            this.attributes = var2_2;
            this.normalName = ParseSettings.normalName(this.tagName);
            return this;
        }

        @Override
        public final String toString() {
            if (this.hasAttributes() && this.attributes.size() > 0) {
                return "<" + this.toStringName() + " " + this.attributes.toString() + ">";
            }
            return "<" + this.toStringName() + ">";
        }
    }

    static final class EndTag
    extends Tag {
        EndTag() {
            this.type = TokenType.EndTag;
        }

        @Override
        public final String toString() {
            return "</" + this.toStringName() + ">";
        }
    }

    static final class Comment
    extends Token {
        private final StringBuilder data = new StringBuilder();
        private String dataS;
        boolean bogus = false;

        @Override
        final Token reset() {
            super.reset();
            Comment.reset(this.data);
            this.dataS = null;
            this.bogus = false;
            return this;
        }

        Comment() {
            this.type = TokenType.Comment;
        }

        final String getData() {
            if (this.dataS != null) {
                return this.dataS;
            }
            return this.data.toString();
        }

        /*
         * WARNING - void declaration
         */
        final Comment append(String append) {
            this.ensureData();
            if (this.data.length() == 0) {
                this.dataS = append;
            } else {
                void var1_1;
                this.data.append((String)var1_1);
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        final Comment append(char append) {
            void var1_1;
            this.ensureData();
            this.data.append((char)var1_1);
            return this;
        }

        private void ensureData() {
            if (this.dataS != null) {
                this.data.append(this.dataS);
                this.dataS = null;
            }
        }

        public final String toString() {
            return "<!--" + this.getData() + "-->";
        }
    }

    static final class CData
    extends Character {
        /*
         * WARNING - void declaration
         */
        CData(String data) {
            void var1_1;
            this.data((String)var1_1);
        }

        @Override
        public final String toString() {
            return "<![CDATA[" + this.getData() + "]]>";
        }
    }

    static class Character
    extends Token {
        private String data;

        Character() {
            this.type = TokenType.Character;
        }

        @Override
        Token reset() {
            super.reset();
            this.data = null;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        Character data(String data) {
            void var1_1;
            this.data = var1_1;
            return this;
        }

        String getData() {
            return this.data;
        }

        public String toString() {
            return this.getData();
        }
    }

    static final class EOF
    extends Token {
        EOF() {
            this.type = TokenType.EOF;
        }

        @Override
        final Token reset() {
            super.reset();
            return this;
        }

        public final String toString() {
            return "";
        }
    }

    static abstract class Tag
    extends Token {
        protected String tagName;
        protected String normalName;
        private final StringBuilder attrName = new StringBuilder();
        private String attrNameS;
        private boolean hasAttrName = false;
        private final StringBuilder attrValue = new StringBuilder();
        private String attrValueS;
        private boolean hasAttrValue = false;
        private boolean hasEmptyAttrValue = false;
        boolean selfClosing = false;
        Attributes attributes;
        private static final int MaxAttributes = 512;

        Tag() {
        }

        @Override
        Tag reset() {
            super.reset();
            this.tagName = null;
            this.normalName = null;
            Tag.reset(this.attrName);
            this.attrNameS = null;
            this.hasAttrName = false;
            Tag.reset(this.attrValue);
            this.attrValueS = null;
            this.hasEmptyAttrValue = false;
            this.hasAttrValue = false;
            this.selfClosing = false;
            this.attributes = null;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        final void newAttribute() {
            String string;
            String name;
            if (this.attributes == null) {
                this.attributes = new Attributes();
            }
            if (this.hasAttrName && this.attributes.size() < 512 && (name = (string = this.attrName.length() > 0 ? this.attrName.toString() : this.attrNameS).trim()).length() > 0) {
                void var2_2;
                String value = this.hasAttrValue ? (this.attrValue.length() > 0 ? this.attrValue.toString() : this.attrValueS) : (this.hasEmptyAttrValue ? "" : null);
                this.attributes.add(string, (String)var2_2);
            }
            Tag.reset(this.attrName);
            this.attrNameS = null;
            this.hasAttrName = false;
            Tag.reset(this.attrValue);
            this.attrValueS = null;
            this.hasAttrValue = false;
            this.hasEmptyAttrValue = false;
        }

        final boolean hasAttributes() {
            return this.attributes != null;
        }

        /*
         * WARNING - void declaration
         */
        final boolean hasAttribute(String key) {
            void var1_1;
            return this.attributes != null && this.attributes.hasKey((String)var1_1);
        }

        final void finaliseTag() {
            if (this.hasAttrName) {
                this.newAttribute();
            }
        }

        final String name() {
            Validate.isFalse(this.tagName == null || this.tagName.length() == 0);
            return this.tagName;
        }

        final String normalName() {
            return this.normalName;
        }

        final String toStringName() {
            if (this.tagName != null) {
                return this.tagName;
            }
            return "[unset]";
        }

        /*
         * WARNING - void declaration
         */
        final Tag name(String name) {
            void var1_1;
            this.tagName = var1_1;
            this.normalName = ParseSettings.normalName(this.tagName);
            return this;
        }

        final boolean isSelfClosing() {
            return this.selfClosing;
        }

        /*
         * WARNING - void declaration
         */
        final void appendTagName(String append) {
            void var1_1;
            append = append.replace('\u0000', '\ufffd');
            this.tagName = this.tagName == null ? append : this.tagName.concat((String)var1_1);
            this.normalName = ParseSettings.normalName(this.tagName);
        }

        /*
         * WARNING - void declaration
         */
        final void appendTagName(char append) {
            void var1_1;
            this.appendTagName(String.valueOf((char)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        final void appendAttributeName(String append) {
            void var1_1;
            append = append.replace('\u0000', '\ufffd');
            this.ensureAttrName();
            if (this.attrName.length() == 0) {
                this.attrNameS = append;
                return;
            }
            this.attrName.append((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        final void appendAttributeName(char append) {
            void var1_1;
            this.ensureAttrName();
            this.attrName.append((char)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        final void appendAttributeValue(String append) {
            void var1_1;
            this.ensureAttrValue();
            if (this.attrValue.length() == 0) {
                this.attrValueS = append;
                return;
            }
            this.attrValue.append((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        final void appendAttributeValue(char append) {
            void var1_1;
            this.ensureAttrValue();
            this.attrValue.append((char)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        final void appendAttributeValue(char[] append) {
            void var1_1;
            this.ensureAttrValue();
            this.attrValue.append((char[])var1_1);
        }

        /*
         * WARNING - void declaration
         */
        final void appendAttributeValue(int[] appendCodepoints) {
            void var1_1;
            this.ensureAttrValue();
            for (void codepoint : var1_1) {
                this.attrValue.appendCodePoint((int)codepoint);
            }
        }

        final void setEmptyAttributeValue() {
            this.hasEmptyAttrValue = true;
        }

        private void ensureAttrName() {
            this.hasAttrName = true;
            if (this.attrNameS != null) {
                this.attrName.append(this.attrNameS);
                this.attrNameS = null;
            }
        }

        private void ensureAttrValue() {
            this.hasAttrValue = true;
            if (this.attrValueS != null) {
                this.attrValue.append(this.attrValueS);
                this.attrValueS = null;
            }
        }

        public abstract String toString();
    }
}

