/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.parser.CharacterReader;
import org.jsoup.parser.HtmlTreeBuilder;
import org.jsoup.parser.ParseErrorList;
import org.jsoup.parser.ParseSettings;
import org.jsoup.parser.Tokeniser;
import org.jsoup.parser.TreeBuilder;
import org.jsoup.parser.XmlTreeBuilder;

public class Parser {
    private TreeBuilder treeBuilder;
    private ParseErrorList errors;
    private ParseSettings settings;
    private boolean trackPosition = false;

    /*
     * WARNING - void declaration
     */
    public Parser(TreeBuilder treeBuilder) {
        void var1_1;
        this.treeBuilder = treeBuilder;
        this.settings = var1_1.defaultSettings();
        this.errors = ParseErrorList.noTracking();
    }

    public Parser newInstance() {
        return new Parser(this);
    }

    /*
     * WARNING - void declaration
     */
    private Parser(Parser copy) {
        void var1_1;
        this.treeBuilder = copy.treeBuilder.newInstance();
        this.errors = new ParseErrorList(copy.errors);
        this.settings = new ParseSettings(copy.settings);
        this.trackPosition = var1_1.trackPosition;
    }

    /*
     * WARNING - void declaration
     */
    public Document parseInput(String html, String baseUri) {
        void var2_2;
        void var1_1;
        return this.treeBuilder.parse(new StringReader((String)var1_1), (String)var2_2, this);
    }

    /*
     * WARNING - void declaration
     */
    public Document parseInput(Reader inputHtml, String baseUri) {
        void var2_2;
        void var1_1;
        return this.treeBuilder.parse((Reader)var1_1, (String)var2_2, this);
    }

    /*
     * WARNING - void declaration
     */
    public List<Node> parseFragmentInput(String fragment, Element context, String baseUri) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.treeBuilder.parseFragment((String)var1_1, (Element)var2_2, (String)var3_3, this);
    }

    public TreeBuilder getTreeBuilder() {
        return this.treeBuilder;
    }

    public Parser setTreeBuilder(TreeBuilder treeBuilder) {
        this.treeBuilder = treeBuilder;
        var1_1.parser = this;
        return this;
    }

    public boolean isTrackErrors() {
        return this.errors.getMaxSize() > 0;
    }

    /*
     * WARNING - void declaration
     */
    public Parser setTrackErrors(int maxErrors) {
        void var1_1;
        this.errors = maxErrors > 0 ? ParseErrorList.tracking((int)var1_1) : ParseErrorList.noTracking();
        return this;
    }

    public ParseErrorList getErrors() {
        return this.errors;
    }

    public boolean isTrackPosition() {
        return this.trackPosition;
    }

    /*
     * WARNING - void declaration
     */
    public Parser setTrackPosition(boolean trackPosition) {
        void var1_1;
        this.trackPosition = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Parser settings(ParseSettings settings) {
        void var1_1;
        this.settings = var1_1;
        return this;
    }

    public ParseSettings settings() {
        return this.settings;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isContentForTagData(String normalName) {
        void var1_1;
        return this.getTreeBuilder().isContentForTagData((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Document parse(String html, String baseUri) {
        void var2_2;
        void var1_1;
        String string;
        HtmlTreeBuilder treeBuilder = new HtmlTreeBuilder();
        return treeBuilder.parse(new StringReader(string), (String)var1_1, new Parser((TreeBuilder)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static List<Node> parseFragment(String fragmentHtml, Element context, String baseUri) {
        void var3_3;
        void var2_2;
        void var1_1;
        String string;
        HtmlTreeBuilder treeBuilder = new HtmlTreeBuilder();
        return treeBuilder.parseFragment(string, (Element)var1_1, (String)var2_2, new Parser((TreeBuilder)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public static List<Node> parseFragment(String fragmentHtml, Element context, String baseUri, ParseErrorList errorList) {
        void var2_2;
        void var1_1;
        String string;
        void var3_3;
        HtmlTreeBuilder treeBuilder = new HtmlTreeBuilder();
        Parser parser = new Parser(treeBuilder);
        new Parser(treeBuilder).errors = var3_3;
        return treeBuilder.parseFragment(string, (Element)var1_1, (String)var2_2, parser);
    }

    /*
     * WARNING - void declaration
     */
    public static List<Node> parseXmlFragment(String fragmentXml, String baseUri) {
        void var2_2;
        void var1_1;
        String string;
        XmlTreeBuilder treeBuilder = new XmlTreeBuilder();
        return treeBuilder.parseFragment(string, (String)var1_1, new Parser((TreeBuilder)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static Document parseBodyFragment(String bodyHtml, String baseUri) {
        void var2_5;
        Node[] nodeArray;
        Document doc = Document.createShell(baseUri);
        Element body = doc.body();
        bodyHtml = Parser.parseFragment((String)bodyHtml, body, baseUri);
        Node[] nodes = bodyHtml.toArray(new Node[0]);
        for (int i = nodes.length - 1; i > 0; --i) {
            nodes[i].remove();
        }
        Node[] nodeArray2 = nodeArray;
        int n = nodeArray.length;
        for (int i = 0; i < n; ++i) {
            Node node = nodeArray2[i];
            body.appendChild(node);
        }
        return var2_5;
    }

    /*
     * WARNING - void declaration
     */
    public static String unescapeEntities(String string, boolean inAttribute) {
        void var1_1;
        Tokeniser tokeniser;
        tokeniser = new Tokeniser(new CharacterReader((String)((Object)tokeniser)), ParseErrorList.noTracking());
        return tokeniser.unescapeEntities((boolean)var1_1);
    }

    public static Parser htmlParser() {
        return new Parser(new HtmlTreeBuilder());
    }

    public static Parser xmlParser() {
        return new Parser(new XmlTreeBuilder());
    }
}

