/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.jsoup.helper.Validate;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.CDataNode;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.FormElement;
import org.jsoup.nodes.LeafNode;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.parser.HtmlTreeBuilderState;
import org.jsoup.parser.ParseError;
import org.jsoup.parser.ParseSettings;
import org.jsoup.parser.Parser;
import org.jsoup.parser.Tag;
import org.jsoup.parser.Token;
import org.jsoup.parser.TokeniserState;
import org.jsoup.parser.TreeBuilder;

public class HtmlTreeBuilder
extends TreeBuilder {
    static final String[] TagsSearchInScope = new String[]{"applet", "caption", "html", "marquee", "object", "table", "td", "th"};
    static final String[] TagSearchList = new String[]{"ol", "ul"};
    static final String[] TagSearchButton = new String[]{"button"};
    static final String[] TagSearchTableScope = new String[]{"html", "table"};
    static final String[] TagSearchSelectScope = new String[]{"optgroup", "option"};
    static final String[] TagSearchEndTags = new String[]{"dd", "dt", "li", "optgroup", "option", "p", "rb", "rp", "rt", "rtc"};
    static final String[] TagThoroughSearchEndTags = new String[]{"caption", "colgroup", "dd", "dt", "li", "optgroup", "option", "p", "rb", "rp", "rt", "rtc", "tbody", "td", "tfoot", "th", "thead", "tr"};
    static final String[] TagSearchSpecial = new String[]{"address", "applet", "area", "article", "aside", "base", "basefont", "bgsound", "blockquote", "body", "br", "button", "caption", "center", "col", "colgroup", "command", "dd", "details", "dir", "div", "dl", "dt", "embed", "fieldset", "figcaption", "figure", "footer", "form", "frame", "frameset", "h1", "h2", "h3", "h4", "h5", "h6", "head", "header", "hgroup", "hr", "html", "iframe", "img", "input", "isindex", "li", "link", "listing", "marquee", "menu", "meta", "nav", "noembed", "noframes", "noscript", "object", "ol", "p", "param", "plaintext", "pre", "script", "section", "select", "style", "summary", "table", "tbody", "td", "textarea", "tfoot", "th", "thead", "title", "tr", "ul", "wbr", "xmp"};
    public static final int MaxScopeSearchDepth = 100;
    private HtmlTreeBuilderState state;
    private HtmlTreeBuilderState originalState;
    private boolean baseUriSetFromDoc;
    private Element headElement;
    private FormElement formElement;
    private Element contextElement;
    private ArrayList<Element> formattingElements;
    private ArrayList<HtmlTreeBuilderState> tmplInsertMode;
    private List<String> pendingTableCharacters;
    private Token.EndTag emptyEnd;
    private boolean framesetOk;
    private boolean fosterInserts;
    private boolean fragmentParsing;
    private static final int maxQueueDepth = 256;
    private String[] specificScopeTarget = new String[]{null};
    private static final int maxUsedFormattingElements = 12;

    @Override
    ParseSettings defaultSettings() {
        return ParseSettings.htmlDefault;
    }

    @Override
    HtmlTreeBuilder newInstance() {
        return new HtmlTreeBuilder();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void initialiseParse(Reader input, String baseUri, Parser parser) {
        void var3_3;
        void var2_2;
        void var1_1;
        super.initialiseParse((Reader)var1_1, (String)var2_2, (Parser)var3_3);
        this.state = HtmlTreeBuilderState.Initial;
        this.originalState = null;
        this.baseUriSetFromDoc = false;
        this.headElement = null;
        this.formElement = null;
        this.contextElement = null;
        this.formattingElements = new ArrayList();
        this.tmplInsertMode = new ArrayList();
        this.pendingTableCharacters = new ArrayList<String>();
        this.emptyEnd = new Token.EndTag();
        this.framesetOk = true;
        this.fosterInserts = false;
        this.fragmentParsing = false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    List<Node> parseFragment(String inputFragment, Element context, String baseUri, Parser parser) {
        void var2_3;
        this.state = HtmlTreeBuilderState.Initial;
        this.initialiseParse(new StringReader(inputFragment), baseUri, parser);
        this.contextElement = context;
        this.fragmentParsing = true;
        Node root = null;
        if (context != null) {
            void var3_4;
            String contextTag;
            if (context.ownerDocument() != null) {
                this.doc.quirksMode(context.ownerDocument().quirksMode());
            }
            switch (contextTag = context.normalName()) {
                case "title": 
                case "textarea": {
                    this.tokeniser.transition(TokeniserState.Rcdata);
                    break;
                }
                case "iframe": 
                case "noembed": 
                case "noframes": 
                case "style": 
                case "xml": {
                    this.tokeniser.transition(TokeniserState.Rawtext);
                    break;
                }
                case "script": {
                    this.tokeniser.transition(TokeniserState.ScriptData);
                    break;
                }
                case "noscript": {
                    this.tokeniser.transition(TokeniserState.Data);
                    break;
                }
                case "plaintext": {
                    this.tokeniser.transition(TokeniserState.PLAINTEXT);
                    break;
                }
                case "template": {
                    this.tokeniser.transition(TokeniserState.Data);
                    this.pushTemplateMode(HtmlTreeBuilderState.InTemplate);
                    break;
                }
                default: {
                    this.tokeniser.transition(TokeniserState.Data);
                }
            }
            root = new Element(this.tagFor(contextTag, this.settings), (String)var3_4);
            this.doc.appendChild(root);
            this.stack.add((Element)root);
            this.resetInsertionMode();
            for (Element formSearch = context; formSearch != null; formSearch = formSearch.parent()) {
                if (!(formSearch instanceof FormElement)) continue;
                this.formElement = (FormElement)formSearch;
                break;
            }
        }
        this.runParser();
        if (var2_3 != null) {
            void var1_1;
            List<Node> nodes = root.siblingNodes();
            if (!nodes.isEmpty()) {
                ((Element)root).insertChildren(-1, nodes);
            }
            return var1_1.childNodes();
        }
        return this.doc.childNodes();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean process(Token token) {
        void var1_1;
        this.currentToken = token;
        return this.state.process((Token)var1_1, this);
    }

    /*
     * WARNING - void declaration
     */
    boolean process(Token token, HtmlTreeBuilderState state) {
        void var1_1;
        void var2_2;
        this.currentToken = token;
        return var2_2.process((Token)var1_1, this);
    }

    /*
     * WARNING - void declaration
     */
    void transition(HtmlTreeBuilderState state) {
        void var1_1;
        this.state = var1_1;
    }

    HtmlTreeBuilderState state() {
        return this.state;
    }

    void markInsertionMode() {
        this.originalState = this.state;
    }

    HtmlTreeBuilderState originalState() {
        return this.originalState;
    }

    /*
     * WARNING - void declaration
     */
    void framesetOk(boolean framesetOk) {
        void var1_1;
        this.framesetOk = var1_1;
    }

    boolean framesetOk() {
        return this.framesetOk;
    }

    Document getDocument() {
        return this.doc;
    }

    String getBaseUri() {
        return this.baseUri;
    }

    /*
     * WARNING - void declaration
     */
    void maybeSetBaseUri(Element base) {
        if (this.baseUriSetFromDoc) {
            return;
        }
        String href = base.absUrl("href");
        if (href.length() != 0) {
            void var1_1;
            this.baseUri = href;
            this.baseUriSetFromDoc = true;
            this.doc.setBaseUri((String)var1_1);
        }
    }

    boolean isFragmentParsing() {
        return this.fragmentParsing;
    }

    /*
     * WARNING - void declaration
     */
    void error(HtmlTreeBuilderState state) {
        if (this.parser.getErrors().canAddError()) {
            void var1_1;
            this.parser.getErrors().add(new ParseError(this.reader, "Unexpected %s token [%s] when in state [%s]", this.currentToken.tokenType(), this.currentToken, var1_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    Element insert(Token.StartTag startTag) {
        void var2_4;
        void var1_1;
        int n;
        if (startTag.hasAttributes() && !startTag.attributes.isEmpty() && (n = startTag.attributes.deduplicate(this.settings)) > 0) {
            this.error("Dropped duplicate attribute(s) in tag [%s]", startTag.normalName);
        }
        if (startTag.isSelfClosing()) {
            Element el = this.insertEmpty(startTag);
            this.stack.add(el);
            this.tokeniser.transition(TokeniserState.Data);
            this.tokeniser.emit(this.emptyEnd.reset().name(el.tagName()));
            return el;
        }
        Element el = new Element(this.tagFor(startTag.name(), this.settings), null, this.settings.normalizeAttributes(startTag.attributes));
        this.insert(el, (Token)var1_1);
        return var2_4;
    }

    /*
     * WARNING - void declaration
     */
    Element insertStartTag(String startTagName) {
        void var1_1;
        Element el = new Element(this.tagFor(startTagName, this.settings), null);
        this.insert(el);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    void insert(Element el) {
        void var1_1;
        this.insertNode(el, null);
        this.stack.add((Element)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void insert(Element el, Token token) {
        void var1_1;
        void var2_2;
        this.insertNode(el, (Token)var2_2);
        this.stack.add((Element)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    Element insertEmpty(Token.StartTag startTag) {
        void var3_3;
        void var1_1;
        Tag tag = this.tagFor(startTag.name(), this.settings);
        Element el = new Element(tag, null, this.settings.normalizeAttributes(startTag.attributes));
        this.insertNode(el, startTag);
        if (var1_1.isSelfClosing()) {
            if (tag.isKnownTag()) {
                if (!tag.isEmpty()) {
                    this.tokeniser.error("Tag [%s] cannot be self closing; not a void tag", tag.normalName());
                }
            } else {
                void var2_2;
                var2_2.setSelfClosing();
            }
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    FormElement insertForm(Token.StartTag startTag, boolean onStack, boolean checkTemplateStack) {
        void var2_2;
        void var1_1;
        void var3_3;
        Tag tag = this.tagFor(startTag.name(), this.settings);
        FormElement el = new FormElement(tag, null, this.settings.normalizeAttributes(startTag.attributes));
        if (var3_3 == false || !this.onStack("template")) {
            this.setFormElement(el);
        }
        this.insertNode(el, (Token)var1_1);
        if (var2_2 != false) {
            this.stack.add(el);
        }
        return el;
    }

    /*
     * WARNING - void declaration
     */
    void insert(Token.Comment commentToken) {
        void var1_1;
        void var2_2;
        Comment comment = new Comment(commentToken.getData());
        this.insertNode((Node)var2_2, (Token)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    void insert(Token.Character characterToken) {
        void var1_1;
        void var2_3;
        void var3_2;
        LeafNode node;
        Element el = this.currentElement();
        String tagName = el.normalName();
        String data = characterToken.getData();
        node = characterToken.isCData() ? new CDataNode(data) : (this.isContentForTagData((String)((Object)node)) ? new DataNode(data) : new TextNode(data));
        var3_2.appendChild(node);
        this.onNodeInserted((Node)var2_3, (Token)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void insertNode(Node node, Token token) {
        void var2_2;
        void var1_1;
        if (this.stack.isEmpty()) {
            this.doc.appendChild(node);
        } else if (this.isFosterInserts() && StringUtil.inSorted(this.currentElement().normalName(), HtmlTreeBuilderState.Constants.InTableFoster)) {
            this.insertInFosterParent(node);
        } else {
            this.currentElement().appendChild(node);
        }
        if (node instanceof Element && ((Element)node).tag().isFormListed() && this.formElement != null) {
            this.formElement.addElement((Element)node);
        }
        this.onNodeInserted((Node)var1_1, (Token)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    Element pop() {
        void var1_1;
        int size = this.stack.size();
        return this.stack.remove((int)(var1_1 - true));
    }

    /*
     * WARNING - void declaration
     */
    void push(Element element) {
        void var1_1;
        this.stack.add((Element)var1_1);
    }

    ArrayList<Element> getStack() {
        return this.stack;
    }

    /*
     * WARNING - void declaration
     */
    boolean onStack(Element el) {
        void var1_1;
        return HtmlTreeBuilder.onStack(this.stack, (Element)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    boolean onStack(String elName) {
        void var1_1;
        return this.getFromStack((String)var1_1) != null;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean onStack(ArrayList<Element> queue, Element element) {
        void pos;
        int upper;
        int bottom = queue.size() - 1;
        int n = upper = bottom >= 256 ? bottom - 256 : 0;
        while (pos >= upper) {
            Element element2 = queue.get((int)pos);
            if (element2 == element) {
                return true;
            }
            --pos;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    Element getFromStack(String elName) {
        void pos;
        int upper;
        int bottom = this.stack.size() - 1;
        int n = upper = bottom >= 256 ? bottom - 256 : 0;
        while (pos >= upper) {
            Element next = this.stack.get((int)pos);
            if (next.normalName().equals(elName)) {
                return next;
            }
            --pos;
        }
        return null;
    }

    boolean removeFromStack(Element el) {
        for (int pos = this.stack.size() - 1; pos >= 0; --pos) {
            Element element = this.stack.get(pos);
            if (element != el) continue;
            this.stack.remove(pos);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    Element popStackToClose(String elName) {
        for (int pos = this.stack.size() - 1; pos >= 0; --pos) {
            void var3_3;
            Element el = this.stack.get(pos);
            this.stack.remove(pos);
            if (!el.normalName().equals(elName)) continue;
            if (this.currentToken instanceof Token.EndTag) {
                this.onNodeClosed(el, this.currentToken);
            }
            return var3_3;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    void popStackToClose(String ... elNames) {
        for (int pos = this.stack.size() - 1; pos >= 0; --pos) {
            void var3_3;
            Element next = this.stack.get(pos);
            this.stack.remove(pos);
            if (StringUtil.inSorted(var3_3.normalName(), elNames)) break;
        }
    }

    void popStackToBefore(String elName) {
        Element element;
        for (int pos = this.stack.size() - 1; pos >= 0 && !(element = this.stack.get(pos)).normalName().equals(elName); --pos) {
            this.stack.remove(pos);
        }
    }

    void clearStackToTableContext() {
        this.clearStackToContext("table", "template");
    }

    void clearStackToTableBodyContext() {
        this.clearStackToContext("tbody", "tfoot", "thead", "template");
    }

    void clearStackToTableRowContext() {
        this.clearStackToContext("tr", "template");
    }

    /*
     * WARNING - void declaration
     */
    private void clearStackToContext(String ... nodeNames) {
        void var3_3;
        Element next;
        for (int pos = this.stack.size() - 1; pos >= 0 && !StringUtil.in((next = this.stack.get(pos)).normalName(), nodeNames) && !var3_3.normalName().equals("html"); --pos) {
            this.stack.remove(pos);
        }
    }

    Element aboveOnStack(Element el) {
        assert (this.onStack(el));
        for (int pos = this.stack.size() - 1; pos >= 0; --pos) {
            Element element = this.stack.get(pos);
            if (element != el) continue;
            return this.stack.get(pos - 1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    void insertOnStackAfter(Element after, Element in) {
        void var2_3;
        void var1_2;
        int i = this.stack.lastIndexOf(after);
        Validate.isTrue(i != -1);
        this.stack.add((int)(var1_2 + true), (Element)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    void replaceOnStack(Element out, Element in) {
        void var2_2;
        void var1_1;
        HtmlTreeBuilder htmlTreeBuilder = this;
        htmlTreeBuilder.replaceInQueue(htmlTreeBuilder.stack, (Element)var1_1, (Element)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void replaceInQueue(ArrayList<Element> queue, Element out, Element in) {
        void var3_4;
        void var2_3;
        void var1_1;
        int i = queue.lastIndexOf(out);
        Validate.isTrue(i != -1);
        var1_1.set((int)var2_3, var3_4);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    boolean resetInsertionMode() {
        void pos;
        boolean last = false;
        int bottom = this.stack.size() - 1;
        int upper = bottom >= 256 ? bottom - 256 : 0;
        HtmlTreeBuilderState origState = this.state;
        if (this.stack.size() == 0) {
            this.transition(HtmlTreeBuilderState.InBody);
        }
        while (pos >= upper) {
            void var1_1;
            Element node = this.stack.get((int)pos);
            if (pos == upper) {
                last = true;
                if (this.fragmentParsing) {
                    node = this.contextElement;
                }
            }
            String string = node != null ? node.normalName() : "";
            switch (string) {
                case "select": {
                    this.transition(HtmlTreeBuilderState.InSelect);
                    return this.state != origState;
                }
                case "td": 
                case "th": {
                    if (last) break;
                    this.transition(HtmlTreeBuilderState.InCell);
                    return this.state != origState;
                }
                case "tr": {
                    this.transition(HtmlTreeBuilderState.InRow);
                    return this.state != origState;
                }
                case "tbody": 
                case "thead": 
                case "tfoot": {
                    this.transition(HtmlTreeBuilderState.InTableBody);
                    return this.state != origState;
                }
                case "caption": {
                    this.transition(HtmlTreeBuilderState.InCaption);
                    return this.state != origState;
                }
                case "colgroup": {
                    this.transition(HtmlTreeBuilderState.InColumnGroup);
                    return this.state != origState;
                }
                case "table": {
                    this.transition(HtmlTreeBuilderState.InTable);
                    return this.state != origState;
                }
                case "template": {
                    void var1_2;
                    HtmlTreeBuilderState tmplState = this.currentTemplateMode();
                    Validate.notNull((Object)tmplState, "Bug: no template insertion mode on stack!");
                    this.transition((HtmlTreeBuilderState)var1_2);
                    return this.state != origState;
                }
                case "head": {
                    if (var1_1 != false) break;
                    this.transition(HtmlTreeBuilderState.InHead);
                    return this.state != origState;
                }
                case "body": {
                    this.transition(HtmlTreeBuilderState.InBody);
                    return this.state != origState;
                }
                case "frameset": {
                    this.transition(HtmlTreeBuilderState.InFrameset);
                    return this.state != origState;
                }
                case "html": {
                    HtmlTreeBuilder htmlTreeBuilder = this;
                    htmlTreeBuilder.transition(htmlTreeBuilder.headElement == null ? HtmlTreeBuilderState.BeforeHead : HtmlTreeBuilderState.AfterHead);
                    return this.state != origState;
                }
            }
            if (var1_1 != false) {
                this.transition(HtmlTreeBuilderState.InBody);
                return this.state != origState;
            }
            --pos;
        }
        return this.state != origState;
    }

    void resetBody() {
        if (!this.onStack("body")) {
            this.stack.add(this.doc.body());
        }
        this.transition(HtmlTreeBuilderState.InBody);
    }

    /*
     * WARNING - void declaration
     */
    private boolean inSpecificScope(String targetName, String[] baseTypes, String[] extraTypes) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.specificScopeTarget[0] = var1_1;
        HtmlTreeBuilder htmlTreeBuilder = this;
        return htmlTreeBuilder.inSpecificScope(htmlTreeBuilder.specificScopeTarget, (String[])var2_2, (String[])var3_3);
    }

    private boolean inSpecificScope(String[] targetNames, String[] baseTypes, String[] extraTypes) {
        int bottom = this.stack.size() - 1;
        int top = bottom > 100 ? bottom - 100 : 0;
        for (int pos = bottom; pos >= top; --pos) {
            String elName = this.stack.get(pos).normalName();
            if (StringUtil.inSorted(elName, targetNames)) {
                return true;
            }
            if (StringUtil.inSorted(elName, baseTypes)) {
                return false;
            }
            if (extraTypes == null || !StringUtil.inSorted(elName, extraTypes)) continue;
            return false;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    boolean inScope(String[] targetNames) {
        void var1_1;
        return this.inSpecificScope((String[])var1_1, TagsSearchInScope, null);
    }

    /*
     * WARNING - void declaration
     */
    boolean inScope(String targetName) {
        void var1_1;
        return this.inScope((String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    boolean inScope(String targetName, String[] extras) {
        void var2_2;
        void var1_1;
        return this.inSpecificScope((String)var1_1, TagsSearchInScope, (String[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    boolean inListItemScope(String targetName) {
        void var1_1;
        return this.inScope((String)var1_1, TagSearchList);
    }

    /*
     * WARNING - void declaration
     */
    boolean inButtonScope(String targetName) {
        void var1_1;
        return this.inScope((String)var1_1, TagSearchButton);
    }

    /*
     * WARNING - void declaration
     */
    boolean inTableScope(String targetName) {
        void var1_1;
        return this.inSpecificScope((String)var1_1, TagSearchTableScope, null);
    }

    boolean inSelectScope(String targetName) {
        for (int pos = this.stack.size() - 1; pos >= 0; --pos) {
            Element element = this.stack.get(pos);
            String elName = element.normalName();
            if (elName.equals(targetName)) {
                return true;
            }
            if (StringUtil.inSorted((String)((Object)element), TagSearchSelectScope)) continue;
            return false;
        }
        Validate.fail("Should not be reachable");
        return false;
    }

    /*
     * WARNING - void declaration
     */
    void setHeadElement(Element headElement) {
        void var1_1;
        this.headElement = var1_1;
    }

    Element getHeadElement() {
        return this.headElement;
    }

    boolean isFosterInserts() {
        return this.fosterInserts;
    }

    /*
     * WARNING - void declaration
     */
    void setFosterInserts(boolean fosterInserts) {
        void var1_1;
        this.fosterInserts = var1_1;
    }

    FormElement getFormElement() {
        return this.formElement;
    }

    /*
     * WARNING - void declaration
     */
    void setFormElement(FormElement formElement) {
        void var1_1;
        this.formElement = var1_1;
    }

    void newPendingTableCharacters() {
        this.pendingTableCharacters = new ArrayList<String>();
    }

    List<String> getPendingTableCharacters() {
        return this.pendingTableCharacters;
    }

    void generateImpliedEndTags(String excludeTag) {
        while (StringUtil.inSorted(this.currentElement().normalName(), TagSearchEndTags) && (excludeTag == null || !this.currentElementIs(excludeTag))) {
            this.pop();
        }
    }

    void generateImpliedEndTags() {
        this.generateImpliedEndTags(false);
    }

    void generateImpliedEndTags(boolean thorough) {
        String[] search;
        String[] stringArray = search = thorough ? TagThoroughSearchEndTags : TagSearchEndTags;
        while (StringUtil.inSorted(this.currentElement().normalName(), search)) {
            this.pop();
        }
    }

    /*
     * WARNING - void declaration
     */
    void closeElement(String name) {
        void var1_1;
        this.generateImpliedEndTags(name);
        if (!name.equals(this.currentElement().normalName())) {
            HtmlTreeBuilder htmlTreeBuilder = this;
            htmlTreeBuilder.error(htmlTreeBuilder.state());
        }
        this.popStackToClose((String)var1_1);
    }

    boolean isSpecial(Element el) {
        String string = el.normalName();
        return StringUtil.inSorted(string, TagSearchSpecial);
    }

    Element lastFormattingElement() {
        if (this.formattingElements.size() > 0) {
            return this.formattingElements.get(this.formattingElements.size() - 1);
        }
        return null;
    }

    int positionOfElement(Element el) {
        for (int i = 0; i < this.formattingElements.size(); ++i) {
            if (el != this.formattingElements.get(i)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    Element removeLastFormattingElement() {
        int size = this.formattingElements.size();
        if (size > 0) {
            void var1_1;
            return this.formattingElements.remove((int)(var1_1 - true));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    void pushActiveFormattingElements(Element in) {
        void var1_1;
        this.checkActiveFormattingElements(in);
        this.formattingElements.add((Element)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    void pushWithBookmark(Element in, int bookmark) {
        this.checkActiveFormattingElements(in);
        try {
            void var2_2;
            this.formattingElements.add((int)var2_2, in);
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            void var1_1;
            this.formattingElements.add((Element)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void checkActiveFormattingElements(Element in) {
        Element el;
        void pos;
        int numSeen = 0;
        int size = this.formattingElements.size() - 1;
        int ceil = size - 12;
        if (ceil < 0) {
            ceil = 0;
        }
        while (pos >= ceil && (el = this.formattingElements.get((int)pos)) != null) {
            if (this.isSameFormattingElement(in, el)) {
                ++numSeen;
            }
            if (numSeen == 3) {
                this.formattingElements.remove((int)pos);
                return;
            }
            --pos;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isSameFormattingElement(Element a, Element b) {
        void var2_2;
        void var1_1;
        return a.normalName().equals(b.normalName()) && var1_1.attributes().equals(var2_2.attributes());
    }

    /*
     * WARNING - void declaration
     */
    void reconstructFormattingElements() {
        Element entry;
        if (this.stack.size() > 256) {
            return;
        }
        Element last = this.lastFormattingElement();
        if (last == null || this.onStack(last)) {
            return;
        }
        int size = this.formattingElements.size();
        int ceil = size - 12;
        if (ceil < 0) {
            ceil = 0;
        }
        int pos = size - 1;
        boolean skip = false;
        do {
            if (pos != ceil) continue;
            skip = true;
            break;
        } while ((entry = this.formattingElements.get(--pos)) != null && !this.onStack(entry));
        do {
            void var3_4;
            if (!skip) {
                entry = this.formattingElements.get(++pos);
            }
            Validate.notNull(entry);
            skip = false;
            Element newEl = new Element(this.tagFor(entry.normalName(), this.settings), null, ((Node)entry).attributes().clone());
            this.insert(newEl);
            this.formattingElements.set(pos, (Element)var3_4);
        } while (pos != size - 1);
    }

    void clearFormattingElementsToLastMarker() {
        Element element;
        while (!this.formattingElements.isEmpty() && (element = this.removeLastFormattingElement()) != null) {
        }
    }

    void removeFromActiveFormattingElements(Element el) {
        for (int pos = this.formattingElements.size() - 1; pos >= 0; --pos) {
            Element element = this.formattingElements.get(pos);
            if (element != el) continue;
            this.formattingElements.remove(pos);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    boolean isInActiveFormattingElements(Element el) {
        void var1_1;
        return HtmlTreeBuilder.onStack(this.formattingElements, (Element)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    Element getActiveFormattingElement(String nodeName) {
        Element next;
        for (int pos = this.formattingElements.size() - 1; pos >= 0 && (next = this.formattingElements.get(pos)) != null; --pos) {
            void var3_3;
            if (!next.normalName().equals(nodeName)) continue;
            return var3_3;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    void replaceActiveFormattingElement(Element out, Element in) {
        void var2_2;
        void var1_1;
        HtmlTreeBuilder htmlTreeBuilder = this;
        htmlTreeBuilder.replaceInQueue(htmlTreeBuilder.formattingElements, (Element)var1_1, (Element)var2_2);
    }

    void insertMarkerToFormattingElements() {
        this.formattingElements.add(null);
    }

    /*
     * WARNING - void declaration
     */
    void insertInFosterParent(Node in) {
        void var1_1;
        void var2_4;
        Element fosterParent;
        Element lastTable = this.getFromStack("table");
        boolean isLastTableParent = false;
        if (lastTable != null) {
            if (lastTable.parent() != null) {
                lastTable.parent();
                fosterParent = null;
                isLastTableParent = true;
            } else {
                fosterParent = this.aboveOnStack(lastTable);
            }
        } else {
            fosterParent = this.stack.get(0);
        }
        if (isLastTableParent) {
            void var3_2;
            Validate.notNull(lastTable);
            var3_2.before(in);
            return;
        }
        var2_4.appendChild((Node)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    void pushTemplateMode(HtmlTreeBuilderState state) {
        void var1_1;
        this.tmplInsertMode.add((HtmlTreeBuilderState)var1_1);
    }

    HtmlTreeBuilderState popTemplateMode() {
        if (this.tmplInsertMode.size() > 0) {
            return this.tmplInsertMode.remove(this.tmplInsertMode.size() - 1);
        }
        return null;
    }

    int templateModeSize() {
        return this.tmplInsertMode.size();
    }

    HtmlTreeBuilderState currentTemplateMode() {
        if (this.tmplInsertMode.size() > 0) {
            return this.tmplInsertMode.get(this.tmplInsertMode.size() - 1);
        }
        return null;
    }

    public String toString() {
        return "TreeBuilder{currentToken=" + this.currentToken + ", state=" + (Object)((Object)this.state) + ", currentElement=" + this.currentElement() + '}';
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean isContentForTagData(String normalName) {
        void var1_1;
        return normalName.equals("script") || var1_1.equals("style");
    }
}

