/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.io.IOException;
import org.jsoup.helper.Validate;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Entities;
import org.jsoup.nodes.LeafNode;
import org.jsoup.nodes.Node;

public class TextNode
extends LeafNode {
    /*
     * WARNING - void declaration
     */
    public TextNode(String text) {
        void var1_1;
        this.value = var1_1;
    }

    @Override
    public String nodeName() {
        return "#text";
    }

    public String text() {
        return StringUtil.normaliseWhitespace(this.getWholeText());
    }

    /*
     * WARNING - void declaration
     */
    public TextNode text(String text) {
        void var1_1;
        this.coreValue((String)var1_1);
        return this;
    }

    public String getWholeText() {
        return this.coreValue();
    }

    public boolean isBlank() {
        return StringUtil.isBlank(this.coreValue());
    }

    /*
     * WARNING - void declaration
     */
    public TextNode splitText(int offset) {
        void var1_2;
        void var3_4;
        void var2_3;
        String text = this.coreValue();
        Validate.isTrue(offset >= 0, "Split offset must be not be negative");
        Validate.isTrue(offset < text.length(), "Split offset must not be greater than current text length");
        String head = text.substring(0, offset);
        String tail = var2_3.substring(offset);
        this.text((String)var3_4);
        TextNode tailNode = new TextNode(tail);
        if (this.parentNode != null) {
            this.parentNode.addChildren(this.siblingIndex() + 1, tailNode);
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void outerHtmlHead(Appendable accum, int depth, Document.OutputSettings out) throws IOException {
        void var3_3;
        void var1_1;
        boolean prettyPrint = out.prettyPrint();
        Element parent = this.parentNode instanceof Element ? (Element)this.parentNode : null;
        boolean normaliseWhite = prettyPrint && !Element.preserveWhitespace(this.parentNode);
        boolean trimLeading = false;
        boolean trimTrailing = false;
        if (normaliseWhite) {
            trimLeading = this.siblingIndex == 0 && parent != null && parent.tag().isBlock() || this.parentNode instanceof Document;
            trimTrailing = this.nextSibling() == null && parent != null && parent.tag().isBlock();
            Node next = this.nextSibling();
            boolean bl = next instanceof Element && ((Element)next).shouldIndent(out) || next instanceof TextNode && ((TextNode)next).isBlank();
            if (bl && this.isBlank()) {
                return;
            }
            if (this.siblingIndex == 0 && parent != null && parent.tag().formatAsBlock() && !this.isBlank() || out.outline() && this.siblingNodes().size() > 0 && !this.isBlank()) {
                void var2_2;
                this.indent(accum, (int)var2_2, out);
            }
        }
        Entities.escape((Appendable)var1_1, this.coreValue(), (Document.OutputSettings)var3_3, false, normaliseWhite, trimLeading, trimTrailing);
    }

    @Override
    void outerHtmlTail(Appendable accum, int depth, Document.OutputSettings out) {
    }

    @Override
    public String toString() {
        return this.outerHtml();
    }

    @Override
    public TextNode clone() {
        return (TextNode)super.clone();
    }

    public static TextNode createFromEncoded(String encodedText) {
        String string;
        String text = Entities.unescape(encodedText);
        return new TextNode(string);
    }

    static String normaliseWhitespace(String text) {
        String string = StringUtil.normaliseWhitespace(text);
        return string;
    }

    static String stripLeadingWhitespace(String text) {
        return text.replaceFirst("^\\s+", "");
    }

    static boolean lastCharIsWhitespace(StringBuilder sb) {
        if (sb.length() != 0) {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder;
            if (stringBuilder2.charAt(stringBuilder2.length() - 1) == ' ') {
                return true;
            }
        }
        return false;
    }
}

