/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.util.List;
import org.jsoup.helper.Validate;
import org.jsoup.helper.W3CDom;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.parser.HtmlTreeBuilder;
import org.jsoup.parser.Parser;
import org.w3c.dom.NodeList;

final class NodeUtils {
    NodeUtils() {
    }

    static Document.OutputSettings outputSettings(Node node) {
        Node owner = node.ownerDocument();
        if (owner != null) {
            Node node2;
            return ((Document)node2).outputSettings();
        }
        return new Document("").outputSettings();
    }

    static Parser parser(Node node) {
        Node doc = node.ownerDocument();
        if (doc != null && ((Document)doc).parser() != null) {
            Node node2;
            return ((Document)node2).parser();
        }
        return new Parser(new HtmlTreeBuilder());
    }

    /*
     * WARNING - void declaration
     */
    static <T extends Node> List<T> selectXpath(String xpath, Element el, Class<T> nodeType) {
        void var2_2;
        NodeList nodeList;
        void var3_3;
        void var1_1;
        Validate.notEmpty(xpath);
        Validate.notNull(el);
        Validate.notNull(nodeType);
        W3CDom w3c = new W3CDom().namespaceAware(false);
        org.w3c.dom.Document wDoc = w3c.fromJsoup(el);
        org.w3c.dom.Node contextNode = w3c.contextNode(wDoc);
        NodeList nodeList2 = w3c.selectXpath(xpath, (org.w3c.dom.Node)var1_1);
        return var3_3.sourceNodes(nodeList, var2_2);
    }
}

