/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jsoup.SerializationException;
import org.jsoup.helper.Consumer;
import org.jsoup.helper.Validate;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.NodeUtils;
import org.jsoup.nodes.Range;
import org.jsoup.select.Elements;
import org.jsoup.select.NodeFilter;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;

public abstract class Node
implements Cloneable {
    static final List<Node> EmptyNodes = Collections.emptyList();
    static final String EmptyString = "";
    Node parentNode;
    int siblingIndex;

    protected Node() {
    }

    public abstract String nodeName();

    protected abstract boolean hasAttributes();

    public boolean hasParent() {
        return this.parentNode != null;
    }

    /*
     * WARNING - void declaration
     */
    public String attr(String attributeKey) {
        Validate.notNull(attributeKey);
        if (!this.hasAttributes()) {
            return EmptyString;
        }
        String val = this.attributes().getIgnoreCase(attributeKey);
        if (val.length() > 0) {
            void var2_2;
            return var2_2;
        }
        if (attributeKey.startsWith("abs:")) {
            void var1_1;
            return this.absUrl(var1_1.substring(4));
        }
        return EmptyString;
    }

    public abstract Attributes attributes();

    public int attributesSize() {
        if (this.hasAttributes()) {
            return this.attributes().size();
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public Node attr(String attributeKey, String attributeValue) {
        void var2_2;
        void var1_1;
        attributeKey = NodeUtils.parser(this).settings().normalizeAttribute(attributeKey);
        this.attributes().putIgnoreCase((String)var1_1, (String)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasAttr(String attributeKey) {
        void var1_1;
        Validate.notNull(attributeKey);
        if (!this.hasAttributes()) {
            return false;
        }
        if (attributeKey.startsWith("abs:")) {
            void var2_2;
            String key = attributeKey.substring(4);
            if (this.attributes().hasKeyIgnoreCase(key) && !this.absUrl((String)var2_2).isEmpty()) {
                return true;
            }
        }
        return this.attributes().hasKeyIgnoreCase((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Node removeAttr(String attributeKey) {
        Validate.notNull(attributeKey);
        if (this.hasAttributes()) {
            void var1_1;
            this.attributes().removeIgnoreCase((String)var1_1);
        }
        return this;
    }

    public Node clearAttributes() {
        if (this.hasAttributes()) {
            Iterator<Attribute> it = this.attributes().iterator();
            while (it.hasNext()) {
                it.next();
                it.remove();
            }
        }
        return this;
    }

    public abstract String baseUri();

    protected abstract void doSetBaseUri(String var1);

    /*
     * WARNING - void declaration
     */
    public void setBaseUri(String baseUri) {
        void var1_1;
        Validate.notNull(baseUri);
        this.doSetBaseUri((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String absUrl(String attributeKey) {
        void var1_1;
        Validate.notEmpty(attributeKey);
        if (!this.hasAttributes() || !this.attributes().hasKeyIgnoreCase(attributeKey)) {
            return EmptyString;
        }
        return StringUtil.resolve(this.baseUri(), this.attributes().getIgnoreCase((String)var1_1));
    }

    protected abstract List<Node> ensureChildNodes();

    /*
     * WARNING - void declaration
     */
    public Node childNode(int index) {
        void var1_1;
        return this.ensureChildNodes().get((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public List<Node> childNodes() {
        void var2_2;
        void var1_1;
        if (this.childNodeSize() == 0) {
            return EmptyNodes;
        }
        List<Node> children = this.ensureChildNodes();
        ArrayList rewrap = new ArrayList(children.size());
        rewrap.addAll(var1_1);
        return Collections.unmodifiableList(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public List<Node> childNodesCopy() {
        void var2_2;
        Iterator iterator;
        List<Node> nodes = this.ensureChildNodes();
        ArrayList<Node> children = new ArrayList<Node>(nodes.size());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            Node node = (Node)iterator.next();
            children.add(var3_3.clone());
        }
        return var2_2;
    }

    public abstract int childNodeSize();

    protected Node[] childNodesAsArray() {
        return this.ensureChildNodes().toArray(new Node[0]);
    }

    public abstract Node empty();

    public Node parent() {
        return this.parentNode;
    }

    public final Node parentNode() {
        return this.parentNode;
    }

    /*
     * WARNING - void declaration
     */
    public Node root() {
        void var1_1;
        Node node = this;
        while (node.parentNode != null) {
            node = node.parentNode;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Document ownerDocument() {
        Node root = this.root();
        if (root instanceof Document) {
            void var1_1;
            return (Document)var1_1;
        }
        return null;
    }

    public void remove() {
        Validate.notNull(this.parentNode);
        this.parentNode.removeChild(this);
    }

    /*
     * WARNING - void declaration
     */
    public Node before(String html) {
        void var1_1;
        Node node = this;
        node.addSiblingHtml(node.siblingIndex, (String)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Node before(Node node) {
        void var1_1;
        Validate.notNull(node);
        Validate.notNull(this.parentNode);
        this.parentNode.addChildren(this.siblingIndex, new Node[]{var1_1});
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Node after(String html) {
        void var1_1;
        Node node = this;
        node.addSiblingHtml(node.siblingIndex + 1, (String)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Node after(Node node) {
        void var1_1;
        Validate.notNull(node);
        Validate.notNull(this.parentNode);
        this.parentNode.addChildren(this.siblingIndex + 1, new Node[]{var1_1});
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private void addSiblingHtml(int index, String html) {
        void var2_2;
        void var1_1;
        void var3_3;
        Validate.notNull(html);
        Validate.notNull(this.parentNode);
        Element context = this.parent() instanceof Element ? (Element)this.parent() : null;
        List<Node> nodes = NodeUtils.parser(this).parseFragmentInput(html, (Element)var3_3, this.baseUri());
        this.parentNode.addChildren((int)var1_1, var2_2.toArray(new Node[0]));
    }

    public Node wrap(String html) {
        Validate.notEmpty(html);
        Element context = this.parentNode != null && this.parentNode instanceof Element ? (Element)this.parentNode : (this instanceof Element ? (Element)this : null);
        List<Node> wrapChildren = NodeUtils.parser(this).parseFragmentInput(html, context, this.baseUri());
        Node wrapNode = wrapChildren.get(0);
        if (!(wrapNode instanceof Element)) {
            return this;
        }
        Element wrap = (Element)wrapNode;
        Element deepest = this.getDeepChild(wrap);
        if (this.parentNode != null) {
            this.parentNode.replaceChild(this, wrap);
        }
        deepest.addChildren(this);
        if (wrapChildren.size() > 0) {
            for (int i = 0; i < wrapChildren.size(); ++i) {
                Node remainder = wrapChildren.get(i);
                if (wrap == remainder) continue;
                if (remainder.parentNode != null) {
                    remainder.parentNode.removeChild(remainder);
                }
                wrap.after(remainder);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Node unwrap() {
        void var1_1;
        Validate.notNull(this.parentNode);
        Node firstChild = this.firstChild();
        this.parentNode.addChildren(this.siblingIndex, this.childNodesAsArray());
        this.remove();
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Element getDeepChild(Element el) {
        void var1_1;
        Elements children;
        while ((children = el.children()).size() > 0) {
            void var2_2;
            el = (Element)var2_2.get(0);
        }
        return var1_1;
    }

    void nodelistChanged() {
    }

    /*
     * WARNING - void declaration
     */
    public void replaceWith(Node in) {
        void var1_1;
        Validate.notNull(in);
        Validate.notNull(this.parentNode);
        this.parentNode.replaceChild(this, (Node)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void setParentNode(Node parentNode) {
        void var1_1;
        Validate.notNull(parentNode);
        if (this.parentNode != null) {
            this.parentNode.removeChild(this);
        }
        this.parentNode = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected void replaceChild(Node out, Node in) {
        void var3_3;
        void var2_2;
        Validate.isTrue(out.parentNode == this);
        Validate.notNull(in);
        if (in.parentNode != null) {
            in.parentNode.removeChild(in);
        }
        int index = out.siblingIndex;
        this.ensureChildNodes().set(index, in);
        in.parentNode = this;
        var2_2.setSiblingIndex((int)var3_3);
        var1_1.parentNode = null;
    }

    /*
     * WARNING - void declaration
     */
    protected void removeChild(Node out) {
        void var2_2;
        Validate.isTrue(out.parentNode == this);
        int index = out.siblingIndex;
        this.ensureChildNodes().remove(index);
        this.reindexChildren((int)var2_2);
        var1_1.parentNode = null;
    }

    /*
     * WARNING - void declaration
     */
    protected void addChildren(Node ... children) {
        void var1_1;
        List<Node> nodes = this.ensureChildNodes();
        for (void child : var1_1) {
            this.reparentChild((Node)child);
            nodes.add((Node)child);
            child.setSiblingIndex(nodes.size() - 1);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void addChildren(int index, Node ... children) {
        void var1_1;
        void var2_2;
        void var3_3;
        Validate.notNull(children);
        if (children.length == 0) {
            return;
        }
        List<Node> nodes = this.ensureChildNodes();
        Node firstParent = children[0].parent();
        if (firstParent != null && firstParent.childNodeSize() == children.length) {
            boolean sameList = true;
            List<Node> firstParentNodes = firstParent.ensureChildNodes();
            int i = children.length;
            while (i-- > 0) {
                if (children[i] == firstParentNodes.get(i)) continue;
                sameList = false;
                break;
            }
            if (sameList) {
                boolean wasEmpty = this.childNodeSize() == 0;
                firstParent.empty();
                nodes.addAll(index, Arrays.asList(children));
                i = children.length;
                while (i-- > 0) {
                    children[i].parentNode = this;
                }
                if (!wasEmpty || children[0].siblingIndex != 0) {
                    this.reindexChildren(index);
                }
                return;
            }
        }
        Validate.noNullElements(children);
        Node[] nodeArray = children;
        int n = children.length;
        for (int i = 0; i < n; ++i) {
            Node child = nodeArray[i];
            this.reparentChild(child);
        }
        var3_3.addAll(index, Arrays.asList(var2_2));
        this.reindexChildren((int)var1_1);
    }

    protected void reparentChild(Node child) {
        child.setParentNode(this);
    }

    /*
     * WARNING - void declaration
     */
    private void reindexChildren(int start) {
        void i;
        int size = this.childNodeSize();
        if (size == 0) {
            return;
        }
        List<Node> childNodes = this.ensureChildNodes();
        while (i < size) {
            childNodes.get((int)i).setSiblingIndex((int)i);
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public List<Node> siblingNodes() {
        void var2_2;
        Iterator iterator;
        if (this.parentNode == null) {
            return Collections.emptyList();
        }
        List<Node> nodes = this.parentNode.ensureChildNodes();
        ArrayList<void> siblings = new ArrayList<void>(nodes.size() - 1);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            Node node = (Node)iterator.next();
            if (node == this) continue;
            siblings.add(var3_3);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Node nextSibling() {
        if (this.parentNode == null) {
            return null;
        }
        List<Node> siblings = this.parentNode.ensureChildNodes();
        int index = this.siblingIndex + 1;
        if (siblings.size() > index) {
            void var2_2;
            void var1_1;
            return (Node)var1_1.get((int)var2_2);
        }
        return null;
    }

    public Node previousSibling() {
        if (this.parentNode == null) {
            return null;
        }
        if (this.siblingIndex > 0) {
            return this.parentNode.ensureChildNodes().get(this.siblingIndex - 1);
        }
        return null;
    }

    public int siblingIndex() {
        return this.siblingIndex;
    }

    /*
     * WARNING - void declaration
     */
    protected void setSiblingIndex(int siblingIndex) {
        void var1_1;
        this.siblingIndex = var1_1;
    }

    public Node firstChild() {
        if (this.childNodeSize() == 0) {
            return null;
        }
        return this.ensureChildNodes().get(0);
    }

    /*
     * WARNING - void declaration
     */
    public Node lastChild() {
        void var1_1;
        int size = this.childNodeSize();
        if (size == 0) {
            return null;
        }
        List<Node> list = this.ensureChildNodes();
        return list.get((int)(var1_1 - true));
    }

    /*
     * WARNING - void declaration
     */
    public Node traverse(NodeVisitor nodeVisitor) {
        void var1_1;
        Validate.notNull(nodeVisitor);
        NodeTraversor.traverse((NodeVisitor)var1_1, this);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Node forEachNode(Consumer<? super Node> action) {
        void var1_1;
        Validate.notNull(action);
        NodeTraversor.traverse((arg_0, arg_1) -> Node.lambda$forEachNode$0((Consumer)var1_1, arg_0, arg_1), this);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Node filter(NodeFilter nodeFilter) {
        void var1_1;
        Validate.notNull(nodeFilter);
        NodeTraversor.filter((NodeFilter)var1_1, this);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public String outerHtml() {
        void var1_1;
        StringBuilder accum = StringUtil.borrowBuilder();
        this.outerHtml(accum);
        return StringUtil.releaseBuilder((StringBuilder)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void outerHtml(Appendable accum) {
        void var1_1;
        NodeTraversor.traverse((NodeVisitor)new OuterHtmlVisitor((Appendable)var1_1, NodeUtils.outputSettings(this)), this);
    }

    abstract void outerHtmlHead(Appendable var1, int var2, Document.OutputSettings var3) throws IOException;

    abstract void outerHtmlTail(Appendable var1, int var2, Document.OutputSettings var3) throws IOException;

    /*
     * WARNING - void declaration
     */
    public <T extends Appendable> T html(T appendable) {
        void var1_1;
        this.outerHtml(appendable);
        return var1_1;
    }

    public Range sourceRange() {
        return Range.of(this, true);
    }

    public String toString() {
        return this.outerHtml();
    }

    /*
     * WARNING - void declaration
     */
    protected void indent(Appendable accum, int depth, Document.OutputSettings out) throws IOException {
        void var3_3;
        void var2_2;
        accum.append('\n').append(StringUtil.padding((int)(var2_2 * out.indentAmount()), var3_3.maxPaddingWidth()));
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        return this == var1_1;
    }

    public int hashCode() {
        return super.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasSameValue(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.outerHtml().equals(((Node)var1_1).outerHtml());
    }

    /*
     * WARNING - void declaration
     */
    public Node clone() {
        void var1_1;
        Node thisClone = this.doClone(null);
        LinkedList<Node> nodesToProcess = new LinkedList<Node>();
        nodesToProcess.add(thisClone);
        while (!nodesToProcess.isEmpty()) {
            Node currParent = (Node)nodesToProcess.remove();
            int size = currParent.childNodeSize();
            for (int i = 0; i < size; ++i) {
                List<Node> childNodes = currParent.ensureChildNodes();
                Node childClone = childNodes.get(i).doClone(currParent);
                childNodes.set(i, childClone);
                nodesToProcess.add(childClone);
            }
        }
        return var1_1;
    }

    public Node shallowClone() {
        return this.doClone(null);
    }

    /*
     * WARNING - void declaration
     */
    protected Node doClone(Node parent) {
        void var2_3;
        Document doc;
        Node clone;
        try {
            clone = (Node)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.parentNode = e;
        int n = clone.siblingIndex = e == null ? 0 : this.siblingIndex;
        if (e == null && !(this instanceof Document) && (doc = this.ownerDocument()) != null) {
            void var1_1;
            Document docClone = doc.shallowClone();
            clone.parentNode = docClone;
            var1_1.ensureChildNodes().add(clone);
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$forEachNode$0(Consumer action, Node node, int depth) {
        void var1_1;
        action.accept(var1_1);
    }

    private static class OuterHtmlVisitor
    implements NodeVisitor {
        private final Appendable accum;
        private final Document.OutputSettings out;

        /*
         * WARNING - void declaration
         */
        OuterHtmlVisitor(Appendable accum, Document.OutputSettings out) {
            void var2_2;
            void var1_1;
            this.accum = var1_1;
            this.out = out;
            var2_2.prepareEncoder();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void head(Node node, int depth) {
            try {
                void var2_3;
                node.outerHtmlHead(this.accum, (int)var2_3, this.out);
                return;
            }
            catch (IOException exception) {
                void var1_2;
                throw new SerializationException((Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void tail(Node node, int depth) {
            if (!node.nodeName().equals("#text")) {
                try {
                    void var2_3;
                    node.outerHtmlTail(this.accum, (int)var2_3, this.out);
                    return;
                }
                catch (IOException exception) {
                    void var1_2;
                    throw new SerializationException((Throwable)var1_2);
                }
            }
        }
    }
}

