/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.util.ArrayList;
import java.util.List;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.helper.HttpConnection;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.parser.Tag;
import org.jsoup.select.Elements;

public class FormElement
extends Element {
    private final Elements elements = new Elements();

    /*
     * WARNING - void declaration
     */
    public FormElement(Tag tag, String baseUri, Attributes attributes) {
        super((Tag)var1_1, (String)var2_2, (Attributes)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    public Elements elements() {
        return this.elements;
    }

    /*
     * WARNING - void declaration
     */
    public FormElement addElement(Element element) {
        void var1_1;
        this.elements.add(var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void removeChild(Node out) {
        void var1_1;
        super.removeChild(out);
        this.elements.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Connection submit() {
        void var2_2;
        void var1_1;
        Connection connection;
        String action = this.hasAttr("action") ? this.absUrl("action") : ((Node)this).baseUri();
        Validate.notEmpty(action, "Could not determine a form action URL for submit. Ensure you set a base URI when parsing.");
        Connection.Method method = this.attr("method").equalsIgnoreCase("POST") ? Connection.Method.POST : Connection.Method.GET;
        Document owner = this.ownerDocument();
        connection = owner != null ? ((Document)((Object)connection)).connection().newRequest() : Jsoup.newSession();
        return connection.url((String)var1_1).data(this.formData()).method((Connection.Method)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public List<Connection.KeyVal> formData() {
        void var1_1;
        ArrayList<HttpConnection.KeyVal> data = new ArrayList<HttpConnection.KeyVal>();
        for (Element el : this.elements) {
            void var3_3;
            Element option;
            String type;
            String name;
            if (!el.tag().isFormSubmittable() || el.hasAttr("disabled") || (name = el.attr("name")).length() == 0 || (type = el.attr("type")).equalsIgnoreCase("button")) continue;
            if ("select".equals(el.normalName())) {
                boolean bl;
                Object options = el.select("option[selected]");
                boolean set = false;
                options = ((ArrayList)options).iterator();
                while (options.hasNext()) {
                    Element option2 = (Element)options.next();
                    data.add(HttpConnection.KeyVal.create(name, option2.val()));
                    bl = true;
                }
                if (bl || (option = el.selectFirst("option")) == null) continue;
                data.add(HttpConnection.KeyVal.create(name, option.val()));
                continue;
            }
            if ("checkbox".equalsIgnoreCase((String)((Object)option)) || "radio".equalsIgnoreCase((String)((Object)option))) {
                if (!el.hasAttr("checked")) continue;
                String val = el.val().length() > 0 ? el.val() : "on";
                data.add(HttpConnection.KeyVal.create(name, val));
                continue;
            }
            data.add(HttpConnection.KeyVal.create(name, var3_3.val()));
        }
        return var1_1;
    }

    @Override
    public FormElement clone() {
        return (FormElement)super.clone();
    }
}

