/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.io.IOException;
import java.nio.charset.CharsetEncoder;
import java.util.Arrays;
import java.util.HashMap;
import org.jsoup.SerializationException;
import org.jsoup.helper.Validate;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.EntitiesData;
import org.jsoup.parser.CharacterReader;
import org.jsoup.parser.Parser;

public class Entities {
    private static final int empty = -1;
    private static final String emptyName = "";
    static final int codepointRadix = 36;
    private static final char[] codeDelims = new char[]{',', ';'};
    private static final HashMap<String, String> multipoints = new HashMap();
    private static final Document.OutputSettings DefaultOutput = new Document.OutputSettings();

    private Entities() {
    }

    public static boolean isNamedEntity(String name) {
        String string;
        return EscapeMode.extended.codepointForName(string) != -1;
    }

    public static boolean isBaseNamedEntity(String name) {
        String string;
        return EscapeMode.base.codepointForName(string) != -1;
    }

    /*
     * WARNING - void declaration
     */
    public static String getByName(String name) {
        String val = multipoints.get(name);
        if (val != null) {
            void var1_2;
            return var1_2;
        }
        int codepoint = EscapeMode.extended.codepointForName(name);
        if (codepoint != -1) {
            void var0_1;
            return new String(new int[]{var0_1}, 0, 1);
        }
        return emptyName;
    }

    /*
     * WARNING - void declaration
     */
    public static int codepointsForName(String name, int[] codepoints) {
        String val = multipoints.get(name);
        if (val != null) {
            void var2_3;
            codepoints[0] = val.codePointAt(0);
            codepoints[1] = var2_3.codePointAt(1);
            return 2;
        }
        int codepoint = EscapeMode.extended.codepointForName(name);
        if (codepoint != -1) {
            void var0_1;
            var1_2[0] = var0_1;
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public static String escape(String string, Document.OutputSettings out) {
        void var2_3;
        if (string == null) {
            return emptyName;
        }
        StringBuilder accum = StringUtil.borrowBuilder();
        try {
            void var1_2;
            Entities.escape(accum, string, (Document.OutputSettings)var1_2, false, false, false, false);
        }
        catch (IOException e) {
            void var0_1;
            throw new SerializationException((Throwable)var0_1);
        }
        return StringUtil.releaseBuilder((StringBuilder)var2_3);
    }

    public static String escape(String string) {
        return Entities.escape(string, DefaultOutput);
    }

    static void escape(Appendable accum, String string, Document.OutputSettings out, boolean inAttribute, boolean normaliseWhite, boolean stripLeadingWhite, boolean trimTrailing) throws IOException {
        int codePoint;
        boolean lastWasWhite = false;
        boolean reachedNonWhite = false;
        EscapeMode escapeMode = out.escapeMode();
        CharsetEncoder encoder = out.encoder();
        CoreCharset coreCharset = out.coreCharset;
        int length = string.length();
        boolean skipped = false;
        for (int offset = 0; offset < length; offset += Character.charCount(codePoint)) {
            codePoint = string.codePointAt(offset);
            if (normaliseWhite) {
                if (StringUtil.isWhitespace(codePoint)) {
                    if (stripLeadingWhite && !reachedNonWhite || lastWasWhite) continue;
                    if (trimTrailing) {
                        skipped = true;
                        continue;
                    }
                    accum.append(' ');
                    lastWasWhite = true;
                    continue;
                }
                lastWasWhite = false;
                reachedNonWhite = true;
                if (skipped) {
                    accum.append(' ');
                    skipped = false;
                }
            }
            if (codePoint < 65536) {
                char c = (char)codePoint;
                switch (c) {
                    case '&': {
                        accum.append("&amp;");
                        break;
                    }
                    case '\u00a0': {
                        if (escapeMode != EscapeMode.xhtml) {
                            accum.append("&nbsp;");
                            break;
                        }
                        accum.append("&#xa0;");
                        break;
                    }
                    case '<': {
                        if (!inAttribute || escapeMode == EscapeMode.xhtml || out.syntax() == Document.OutputSettings.Syntax.xml) {
                            accum.append("&lt;");
                            break;
                        }
                        accum.append(c);
                        break;
                    }
                    case '>': {
                        if (!inAttribute) {
                            accum.append("&gt;");
                            break;
                        }
                        accum.append(c);
                        break;
                    }
                    case '\"': {
                        if (inAttribute) {
                            accum.append("&quot;");
                            break;
                        }
                        accum.append(c);
                        break;
                    }
                    case '\t': 
                    case '\n': 
                    case '\r': {
                        accum.append(c);
                        break;
                    }
                    default: {
                        if (c < ' ' || !Entities.canEncode(coreCharset, c, encoder)) {
                            Entities.appendEncoded(accum, escapeMode, codePoint);
                            break;
                        }
                        accum.append(c);
                        break;
                    }
                }
                continue;
            }
            String c = new String(Character.toChars(codePoint));
            if (encoder.canEncode(c)) {
                accum.append(c);
                continue;
            }
            Entities.appendEncoded(accum, escapeMode, codePoint);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void appendEncoded(Appendable accum, EscapeMode escapeMode, int codePoint) throws IOException {
        void var2_2;
        Appendable appendable;
        String name = escapeMode.nameForCodepoint(codePoint);
        if (!emptyName.equals(name)) {
            void var1_1;
            accum.append('&').append((CharSequence)var1_1).append(';');
            return;
        }
        appendable.append("&#x").append(Integer.toHexString((int)var2_2)).append(';');
    }

    public static String unescape(String string) {
        return Entities.unescape(string, false);
    }

    /*
     * WARNING - void declaration
     */
    static String unescape(String string, boolean strict) {
        void var1_1;
        return Parser.unescapeEntities(string, (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean canEncode(CoreCharset charset, char c, CharsetEncoder fallback) {
        void var1_1;
        void var2_2;
        CoreCharset coreCharset;
        switch (coreCharset) {
            case ascii: {
                return c < '\u0080';
            }
            case utf: {
                return true;
            }
        }
        return var2_2.canEncode((char)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static void load(EscapeMode e, String pointsData, int size) {
        EscapeMode.access$102(e, new String[size]);
        EscapeMode.access$202(e, new int[size]);
        EscapeMode.access$302(e, new int[size]);
        EscapeMode.access$402(e, new String[size]);
        int i = 0;
        CharacterReader reader = new CharacterReader(pointsData);
        try {
            void var2_3;
            void var3_4;
            while (!reader.isEmpty()) {
                int cp2;
                String name = reader.consumeTo('=');
                reader.advance();
                int cp1 = Integer.parseInt(reader.consumeToAny(codeDelims), 36);
                char codeDelim = reader.current();
                reader.advance();
                if (codeDelim == ',') {
                    cp2 = Integer.parseInt(reader.consumeTo(';'), 36);
                    reader.advance();
                } else {
                    cp2 = -1;
                }
                String string = reader.consumeTo('&');
                int index = Integer.parseInt(string, 36);
                reader.advance();
                ((EscapeMode)e).nameKeys[i] = name;
                ((EscapeMode)e).codeVals[i] = cp1;
                ((EscapeMode)e).codeKeys[index] = cp1;
                ((EscapeMode)e).nameVals[index] = name;
                if (cp2 != -1) {
                    multipoints.put(name, new String(new int[]{cp1, cp2}, 0, 2));
                }
                ++i;
            }
            Validate.isTrue(var3_4 == var2_3, "Unexpected count of entities loaded");
            reader.close();
            return;
        }
        catch (Throwable throwable) {
            void var1_2;
            var1_2.close();
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(EscapeMode x0, String x1, int x2) {
        void var2_2;
        void var1_1;
        Entities.load(x0, (String)var1_1, (int)var2_2);
    }

    public static enum EscapeMode {
        xhtml(EntitiesData.xmlPoints, 4),
        base(EntitiesData.basePoints, 106),
        extended(EntitiesData.fullPoints, 2125);

        private String[] nameKeys;
        private int[] codeVals;
        private int[] codeKeys;
        private String[] nameVals;

        /*
         * WARNING - void declaration
         */
        private EscapeMode(String file, int size) {
            void var3_3;
            Entities.access$000(this, (String)var3_3, size);
        }

        /*
         * WARNING - void declaration
         */
        final int codepointForName(String name) {
            int index = Arrays.binarySearch(this.nameKeys, name);
            if (index >= 0) {
                void var1_2;
                return this.codeVals[var1_2];
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        final String nameForCodepoint(int codepoint) {
            int index = Arrays.binarySearch(this.codeKeys, codepoint);
            if (index >= 0) {
                void var2_2;
                void var1_1;
                if (index < this.nameVals.length - 1 && this.codeKeys[index + 1] == var1_1) {
                    return this.nameVals[index + 1];
                }
                return this.nameVals[var2_2];
            }
            return Entities.emptyName;
        }

        private int size() {
            return this.nameKeys.length;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ String[] access$102(EscapeMode x0, String[] x1) {
            void var1_1;
            x0.nameKeys = var1_1;
            return x0.nameKeys;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ int[] access$202(EscapeMode x0, int[] x1) {
            void var1_1;
            x0.codeVals = var1_1;
            return x0.codeVals;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ int[] access$302(EscapeMode x0, int[] x1) {
            void var1_1;
            x0.codeKeys = var1_1;
            return x0.codeKeys;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ String[] access$402(EscapeMode x0, String[] x1) {
            void var1_1;
            x0.nameVals = var1_1;
            return x0.nameVals;
        }
    }

    static enum CoreCharset {
        ascii,
        utf,
        fallback;


        static CoreCharset byName(String name) {
            String string;
            if (name.equals("US-ASCII")) {
                return ascii;
            }
            if (string.startsWith("UTF-")) {
                return utf;
            }
            return fallback;
        }
    }
}

