/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jsoup.helper.ChangeNotifyingArrayList;
import org.jsoup.helper.Consumer;
import org.jsoup.helper.Validate;
import org.jsoup.internal.NonnullByDefault;
import org.jsoup.internal.Normalizer;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.CDataNode;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.NodeUtils;
import org.jsoup.nodes.Range;
import org.jsoup.nodes.TextNode;
import org.jsoup.parser.Tag;
import org.jsoup.select.Collector;
import org.jsoup.select.Elements;
import org.jsoup.select.Evaluator;
import org.jsoup.select.NodeFilter;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;
import org.jsoup.select.QueryParser;
import org.jsoup.select.Selector;

@NonnullByDefault
public class Element
extends Node {
    private static final List<Element> EmptyChildren = Collections.emptyList();
    private static final Pattern ClassSplit = Pattern.compile("\\s+");
    private static final String BaseUriKey = Attributes.internalKey("baseUri");
    private Tag tag;
    private WeakReference<List<Element>> shadowChildrenRef;
    List<Node> childNodes;
    Attributes attributes;

    /*
     * WARNING - void declaration
     */
    public Element(String tag) {
        this(Tag.valueOf((String)var1_1), "", null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Element(Tag tag, String baseUri, Attributes attributes) {
        void var1_1;
        void var3_3;
        Validate.notNull(tag);
        this.childNodes = EmptyNodes;
        this.attributes = var3_3;
        this.tag = var1_1;
        if (baseUri != null) {
            void var2_2;
            this.setBaseUri((String)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Element(Tag tag, String baseUri) {
        this((Tag)var1_1, (String)var2_2, null);
        void var2_2;
        void var1_1;
    }

    protected boolean hasChildNodes() {
        return this.childNodes != EmptyNodes;
    }

    @Override
    protected List<Node> ensureChildNodes() {
        if (this.childNodes == EmptyNodes) {
            this.childNodes = new NodeList(this, 4);
        }
        return this.childNodes;
    }

    @Override
    protected boolean hasAttributes() {
        return this.attributes != null;
    }

    @Override
    public Attributes attributes() {
        if (this.attributes == null) {
            this.attributes = new Attributes();
        }
        return this.attributes;
    }

    @Override
    public String baseUri() {
        return Element.searchUpForAttribute(this, BaseUriKey);
    }

    private static String searchUpForAttribute(Element start, String key) {
        for (Element el = start; el != null; el = el.parent()) {
            if (el.attributes == null || !el.attributes.hasKey(key)) continue;
            return el.attributes.get(key);
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doSetBaseUri(String baseUri) {
        void var1_1;
        ((Node)this).attributes().put(BaseUriKey, (String)var1_1);
    }

    @Override
    public int childNodeSize() {
        return this.childNodes.size();
    }

    @Override
    public String nodeName() {
        return this.tag.getName();
    }

    public String tagName() {
        return this.tag.getName();
    }

    public String normalName() {
        return this.tag.normalName();
    }

    /*
     * WARNING - void declaration
     */
    public Element tagName(String tagName) {
        void var1_1;
        Validate.notEmptyParam(tagName, "tagName");
        this.tag = Tag.valueOf((String)var1_1, NodeUtils.parser(this).settings());
        return this;
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean isBlock() {
        return this.tag.isBlock();
    }

    public String id() {
        if (this.attributes != null) {
            return this.attributes.getIgnoreCase("id");
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    public Element id(String id) {
        void var1_1;
        Validate.notNull(id);
        this.attr("id", (String)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Element attr(String attributeKey, String attributeValue) {
        void var2_2;
        void var1_1;
        super.attr((String)var1_1, (String)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Element attr(String attributeKey, boolean attributeValue) {
        void var2_2;
        void var1_1;
        ((Node)this).attributes().put((String)var1_1, (boolean)var2_2);
        return this;
    }

    public Map<String, String> dataset() {
        return ((Node)this).attributes().dataset();
    }

    @Override
    public final Element parent() {
        return (Element)this.parentNode;
    }

    /*
     * WARNING - void declaration
     */
    public Elements parents() {
        void var1_1;
        Elements parents = new Elements();
        Element.accumulateParents(this, parents);
        return var1_1;
    }

    private static void accumulateParents(Element el, Elements parents) {
        Element parent;
        while ((parent = el.parent()) != null && !parent.tagName().equals("#root")) {
            parents.add(parent);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Element child(int index) {
        void var1_1;
        return this.childElementsList().get((int)var1_1);
    }

    public int childrenSize() {
        return this.childElementsList().size();
    }

    public Elements children() {
        return new Elements(this.childElementsList());
    }

    /*
     * WARNING - void declaration
     */
    List<Element> childElementsList() {
        void var1_1;
        ArrayList<Element> children;
        if (((Node)this).childNodeSize() == 0) {
            return EmptyChildren;
        }
        if (this.shadowChildrenRef == null || (children = (ArrayList<Element>)this.shadowChildrenRef.get()) == null) {
            int size = this.childNodes.size();
            children = new ArrayList<Element>(size);
            for (int i = 0; i < size; ++i) {
                Node node = this.childNodes.get(i);
                if (!(node instanceof Element)) continue;
                children.add((Element)node);
            }
            this.shadowChildrenRef = new WeakReference(children);
        }
        return var1_1;
    }

    @Override
    void nodelistChanged() {
        super.nodelistChanged();
        this.shadowChildrenRef = null;
    }

    /*
     * WARNING - void declaration
     */
    public List<TextNode> textNodes() {
        void var1_1;
        ArrayList<TextNode> textNodes = new ArrayList<TextNode>();
        for (Node node : this.childNodes) {
            void var3_3;
            if (!(node instanceof TextNode)) continue;
            textNodes.add((TextNode)var3_3);
        }
        return Collections.unmodifiableList(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public List<DataNode> dataNodes() {
        void var1_1;
        ArrayList<DataNode> dataNodes = new ArrayList<DataNode>();
        for (Node node : this.childNodes) {
            void var3_3;
            if (!(node instanceof DataNode)) continue;
            dataNodes.add((DataNode)var3_3);
        }
        return Collections.unmodifiableList(var1_1);
    }

    public Elements select(String cssQuery) {
        return Selector.select(cssQuery, this);
    }

    public Elements select(Evaluator evaluator) {
        return Selector.select(evaluator, this);
    }

    public Element selectFirst(String cssQuery) {
        return Selector.selectFirst(cssQuery, this);
    }

    public Element selectFirst(Evaluator evaluator) {
        return Collector.findFirst(evaluator, this);
    }

    /*
     * WARNING - void declaration
     */
    public Element expectFirst(String cssQuery) {
        void var1_1;
        return (Element)Validate.ensureNotNull(Selector.selectFirst(cssQuery, this), this.parent() != null ? "No elements matched the query '%s' on element '%s'." : "No elements matched the query '%s' in the document.", var1_1, this.tagName());
    }

    /*
     * WARNING - void declaration
     */
    public boolean is(String cssQuery) {
        void var1_1;
        return this.is(QueryParser.parse((String)var1_1));
    }

    public boolean is(Evaluator evaluator) {
        return evaluator.matches(this.root(), this);
    }

    /*
     * WARNING - void declaration
     */
    public Element closest(String cssQuery) {
        void var1_1;
        return this.closest(QueryParser.parse((String)var1_1));
    }

    public Element closest(Evaluator evaluator) {
        Validate.notNull(evaluator);
        Element el = this;
        Element root = this.root();
        do {
            if (!evaluator.matches(root, el)) continue;
            return el;
        } while ((el = el.parent()) != null);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Elements selectXpath(String xpath) {
        void var1_1;
        return new Elements(NodeUtils.selectXpath((String)var1_1, this, Element.class));
    }

    /*
     * WARNING - void declaration
     */
    public <T extends Node> List<T> selectXpath(String xpath, Class<T> nodeType) {
        void var2_2;
        return NodeUtils.selectXpath(xpath, this, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public Element appendChild(Node child) {
        void var1_1;
        Validate.notNull(child);
        this.reparentChild(child);
        this.ensureChildNodes();
        this.childNodes.add(child);
        var1_1.setSiblingIndex(this.childNodes.size() - 1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Element appendChildren(Collection<? extends Node> children) {
        void var1_1;
        this.insertChildren(-1, (Collection<? extends Node>)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Element appendTo(Element parent) {
        void var1_1;
        Validate.notNull(parent);
        var1_1.appendChild(this);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Element prependChild(Node child) {
        void var1_1;
        Validate.notNull(child);
        this.addChildren(0, new Node[]{var1_1});
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Element prependChildren(Collection<? extends Node> children) {
        void var1_1;
        this.insertChildren(0, (Collection<? extends Node>)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Element insertChildren(int index, Collection<? extends Node> children) {
        void var2_2;
        void var1_1;
        void var3_3;
        Validate.notNull(children, "Children collection to be inserted must not be null.");
        int currentSize = ((Node)this).childNodeSize();
        if (index < 0) {
            index += currentSize + 1;
        }
        Validate.isTrue(index >= 0 && index <= var3_3, "Insert position out of bounds.");
        children = new ArrayList<Node>(children);
        Node[] nodeArray = ((ArrayList)children).toArray(new Node[0]);
        this.addChildren((int)var1_1, (Node[])var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Element insertChildren(int index, Node ... children) {
        void var2_2;
        void var1_1;
        void var3_3;
        Validate.notNull(children, "Children collection to be inserted must not be null.");
        int currentSize = ((Node)this).childNodeSize();
        if (index < 0) {
            index += currentSize + 1;
        }
        Validate.isTrue(index >= 0 && index <= var3_3, "Insert position out of bounds.");
        this.addChildren((int)var1_1, (Node[])var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Element appendElement(String tagName) {
        void var1_1;
        Element child = new Element(Tag.valueOf(tagName, NodeUtils.parser(this).settings()), ((Node)this).baseUri());
        this.appendChild(child);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Element prependElement(String tagName) {
        void var1_1;
        Element child = new Element(Tag.valueOf(tagName, NodeUtils.parser(this).settings()), ((Node)this).baseUri());
        this.prependChild(child);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Element appendText(String text) {
        void var1_1;
        Validate.notNull(text);
        TextNode node = new TextNode(text);
        this.appendChild((Node)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Element prependText(String text) {
        void var1_1;
        Validate.notNull(text);
        TextNode node = new TextNode(text);
        this.prependChild((Node)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Element append(String html) {
        void var1_1;
        Validate.notNull(html);
        Element element = this;
        List<Node> nodes = NodeUtils.parser(this).parseFragmentInput(html, element, ((Node)element).baseUri());
        this.addChildren(var1_1.toArray(new Node[0]));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Element prepend(String html) {
        void var1_1;
        Validate.notNull(html);
        Element element = this;
        List<Node> nodes = NodeUtils.parser(this).parseFragmentInput(html, element, ((Node)element).baseUri());
        this.addChildren(0, var1_1.toArray(new Node[0]));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Element before(String html) {
        void var1_1;
        return (Element)super.before((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Element before(Node node) {
        void var1_1;
        return (Element)super.before((Node)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Element after(String html) {
        void var1_1;
        return (Element)super.after((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Element after(Node node) {
        void var1_1;
        return (Element)super.after((Node)var1_1);
    }

    @Override
    public Element empty() {
        this.childNodes.clear();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Element wrap(String html) {
        void var1_1;
        return (Element)super.wrap((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String cssSelector() {
        void var2_2;
        void var1_1;
        if (this.id().length() > 0) {
            String idSel = "#" + this.id();
            Document doc = this.ownerDocument();
            if (doc != null) {
                Elements els = doc.select(idSel);
                if (els.size() == 1 && els.get(0) == this) {
                    return idSel;
                }
            } else {
                return idSel;
            }
        }
        String tagName = this.tagName().replace(':', '|');
        StringBuilder selector = new StringBuilder((String)var1_1);
        String classes = StringUtil.join(this.classNames(), ".");
        if (classes.length() > 0) {
            void var3_3;
            selector.append('.').append((String)var3_3);
        }
        if (this.parent() == null || this.parent() instanceof Document) {
            return selector.toString();
        }
        selector.insert(0, " > ");
        if (this.parent().select(selector.toString()).size() > 1) {
            selector.append(String.format(":nth-child(%d)", this.elementSiblingIndex() + 1));
        }
        return this.parent().cssSelector() + var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public Elements siblingElements() {
        void var2_2;
        Iterator iterator;
        if (this.parentNode == null) {
            return new Elements(0);
        }
        List<Element> elements = this.parent().childElementsList();
        Elements siblings = new Elements(elements.size() - 1);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            Element el = (Element)iterator.next();
            if (el == this) continue;
            siblings.add(var3_3);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Element nextElementSibling() {
        if (this.parentNode == null) {
            return null;
        }
        List<Element> siblings = this.parent().childElementsList();
        int index = Element.indexInList(this, siblings);
        if (siblings.size() > index + 1) {
            void var2_2;
            void var1_1;
            return (Element)var1_1.get((int)(var2_2 + true));
        }
        return null;
    }

    public Elements nextElementSiblings() {
        return this.nextElementSiblings(true);
    }

    /*
     * WARNING - void declaration
     */
    public Element previousElementSibling() {
        if (this.parentNode == null) {
            return null;
        }
        List<Element> siblings = this.parent().childElementsList();
        int index = Element.indexInList(this, siblings);
        if (index > 0) {
            void var2_2;
            void var1_1;
            return (Element)var1_1.get((int)(var2_2 - true));
        }
        return null;
    }

    public Elements previousElementSiblings() {
        return this.nextElementSiblings(false);
    }

    /*
     * WARNING - void declaration
     */
    private Elements nextElementSiblings(boolean next) {
        void var2_2;
        void var1_1;
        Elements els = new Elements();
        if (this.parentNode == null) {
            return els;
        }
        els.add(this);
        if (var1_1 != false) {
            return els.nextAll();
        }
        return var2_2.prevAll();
    }

    /*
     * WARNING - void declaration
     */
    public Element firstElementSibling() {
        if (this.parent() != null) {
            List<Element> siblings = this.parent().childElementsList();
            if (siblings.size() > 1) {
                void var1_1;
                return (Element)var1_1.get(0);
            }
            return this;
        }
        return this;
    }

    public int elementSiblingIndex() {
        if (this.parent() == null) {
            return 0;
        }
        Element element = this;
        return Element.indexInList(element, element.parent().childElementsList());
    }

    /*
     * WARNING - void declaration
     */
    public Element lastElementSibling() {
        if (this.parent() != null) {
            List<Element> siblings = this.parent().childElementsList();
            if (siblings.size() > 1) {
                void var1_1;
                void v0 = var1_1;
                return (Element)v0.get(v0.size() - 1);
            }
            return this;
        }
        return this;
    }

    private static <E extends Element> int indexInList(Element search, List<E> elements) {
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            if (elements.get(i) != search) continue;
            return i;
        }
        return 0;
    }

    public Element firstElementChild() {
        int size = ((Node)this).childNodeSize();
        if (size == 0) {
            return null;
        }
        List<Node> children = this.ensureChildNodes();
        for (int i = 0; i < size; ++i) {
            Node node = children.get(i);
            if (!(node instanceof Element)) continue;
            return (Element)node;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Element lastElementChild() {
        int size = ((Node)this).childNodeSize();
        if (size == 0) {
            return null;
        }
        List<Node> children = this.ensureChildNodes();
        for (int i = size - 1; i >= 0; --i) {
            void var3_3;
            Node node = children.get(i);
            if (!(node instanceof Element)) continue;
            return (Element)var3_3;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Elements getElementsByTag(String tagName) {
        void var1_1;
        Validate.notEmpty(tagName);
        tagName = Normalizer.normalize(tagName);
        return Collector.collect(new Evaluator.Tag((String)var1_1), this);
    }

    /*
     * WARNING - void declaration
     */
    public Element getElementById(String id) {
        Validate.notEmpty(id);
        Elements elements = Collector.collect(new Evaluator.Id(id), this);
        if (elements.size() > 0) {
            void var1_1;
            return (Element)var1_1.get(0);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Elements getElementsByClass(String className) {
        void var1_1;
        Validate.notEmpty(className);
        return Collector.collect(new Evaluator.Class((String)var1_1), this);
    }

    /*
     * WARNING - void declaration
     */
    public Elements getElementsByAttribute(String key) {
        void var1_1;
        Validate.notEmpty(key);
        key = key.trim();
        return Collector.collect(new Evaluator.Attribute((String)var1_1), this);
    }

    /*
     * WARNING - void declaration
     */
    public Elements getElementsByAttributeStarting(String keyPrefix) {
        void var1_1;
        Validate.notEmpty(keyPrefix);
        keyPrefix = keyPrefix.trim();
        return Collector.collect(new Evaluator.AttributeStarting((String)var1_1), this);
    }

    /*
     * WARNING - void declaration
     */
    public Elements getElementsByAttributeValue(String key, String value) {
        void var2_2;
        void var1_1;
        return Collector.collect(new Evaluator.AttributeWithValue((String)var1_1, (String)var2_2), this);
    }

    /*
     * WARNING - void declaration
     */
    public Elements getElementsByAttributeValueNot(String key, String value) {
        void var2_2;
        void var1_1;
        return Collector.collect(new Evaluator.AttributeWithValueNot((String)var1_1, (String)var2_2), this);
    }

    /*
     * WARNING - void declaration
     */
    public Elements getElementsByAttributeValueStarting(String key, String valuePrefix) {
        void var2_2;
        void var1_1;
        return Collector.collect(new Evaluator.AttributeWithValueStarting((String)var1_1, (String)var2_2), this);
    }

    /*
     * WARNING - void declaration
     */
    public Elements getElementsByAttributeValueEnding(String key, String valueSuffix) {
        void var2_2;
        void var1_1;
        return Collector.collect(new Evaluator.AttributeWithValueEnding((String)var1_1, (String)var2_2), this);
    }

    /*
     * WARNING - void declaration
     */
    public Elements getElementsByAttributeValueContaining(String key, String match) {
        void var2_2;
        void var1_1;
        return Collector.collect(new Evaluator.AttributeWithValueContaining((String)var1_1, (String)var2_2), this);
    }

    /*
     * WARNING - void declaration
     */
    public Elements getElementsByAttributeValueMatching(String key, Pattern pattern) {
        void var2_2;
        void var1_1;
        return Collector.collect(new Evaluator.AttributeWithValueMatching((String)var1_1, (Pattern)var2_2), this);
    }

    /*
     * WARNING - void declaration
     */
    public Elements getElementsByAttributeValueMatching(String key, String regex) {
        void var3_4;
        void var1_1;
        try {
            Pattern pattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            void var1_2;
            void var2_3;
            throw new IllegalArgumentException("Pattern syntax error: " + (String)var2_3, (Throwable)var1_2);
        }
        return this.getElementsByAttributeValueMatching((String)var1_1, (Pattern)var3_4);
    }

    /*
     * WARNING - void declaration
     */
    public Elements getElementsByIndexLessThan(int index) {
        void var1_1;
        return Collector.collect(new Evaluator.IndexLessThan((int)var1_1), this);
    }

    /*
     * WARNING - void declaration
     */
    public Elements getElementsByIndexGreaterThan(int index) {
        void var1_1;
        return Collector.collect(new Evaluator.IndexGreaterThan((int)var1_1), this);
    }

    /*
     * WARNING - void declaration
     */
    public Elements getElementsByIndexEquals(int index) {
        void var1_1;
        return Collector.collect(new Evaluator.IndexEquals((int)var1_1), this);
    }

    /*
     * WARNING - void declaration
     */
    public Elements getElementsContainingText(String searchText) {
        void var1_1;
        return Collector.collect(new Evaluator.ContainsText((String)var1_1), this);
    }

    /*
     * WARNING - void declaration
     */
    public Elements getElementsContainingOwnText(String searchText) {
        void var1_1;
        return Collector.collect(new Evaluator.ContainsOwnText((String)var1_1), this);
    }

    /*
     * WARNING - void declaration
     */
    public Elements getElementsMatchingText(Pattern pattern) {
        void var1_1;
        return Collector.collect(new Evaluator.Matches((Pattern)var1_1), this);
    }

    /*
     * WARNING - void declaration
     */
    public Elements getElementsMatchingText(String regex) {
        void var2_2;
        try {
            Pattern pattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            void var1_1;
            throw new IllegalArgumentException("Pattern syntax error: " + (String)var1_1, e);
        }
        return this.getElementsMatchingText((Pattern)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public Elements getElementsMatchingOwnText(Pattern pattern) {
        void var1_1;
        return Collector.collect(new Evaluator.MatchesOwn((Pattern)var1_1), this);
    }

    /*
     * WARNING - void declaration
     */
    public Elements getElementsMatchingOwnText(String regex) {
        void var2_2;
        try {
            Pattern pattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            void var1_1;
            throw new IllegalArgumentException("Pattern syntax error: " + (String)var1_1, e);
        }
        return this.getElementsMatchingOwnText((Pattern)var2_2);
    }

    public Elements getAllElements() {
        return Collector.collect(new Evaluator.AllElements(), this);
    }

    /*
     * WARNING - void declaration
     */
    public String text() {
        void var1_1;
        StringBuilder accum = StringUtil.borrowBuilder();
        NodeTraversor.traverse(new NodeVisitor(){
            final /* synthetic */ StringBuilder val$accum;
            final /* synthetic */ Element this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$accum = stringBuilder;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void head(Node node, int depth) {
                TextNode textNode;
                if (node instanceof TextNode) {
                    textNode = (TextNode)node;
                    Element.access$000(this.val$accum, textNode);
                    return;
                }
                if (textNode instanceof Element) {
                    void var1_1;
                    Element element = (Element)((Object)textNode);
                    if (this.val$accum.length() > 0 && (element.isBlock() || ((Element)var1_1).tag.normalName().equals("br")) && !TextNode.lastCharIsWhitespace(this.val$accum)) {
                        this.val$accum.append(' ');
                    }
                }
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void tail(Node node, int depth) {
                void var1_1;
                Element element;
                if (node instanceof Element && (element = (Element)node).isBlock() && var1_1.nextSibling() instanceof TextNode && !TextNode.lastCharIsWhitespace(this.val$accum)) {
                    this.val$accum.append(' ');
                }
            }
        }, this);
        return StringUtil.releaseBuilder((StringBuilder)var1_1).trim();
    }

    /*
     * WARNING - void declaration
     */
    public String wholeText() {
        void var1_1;
        StringBuilder accum = StringUtil.borrowBuilder();
        NodeTraversor.traverse((node, depth) -> {
            StringBuilder stringBuilder;
            Element.appendWholeText(node, stringBuilder);
        }, this);
        return StringUtil.releaseBuilder((StringBuilder)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static void appendWholeText(Node node, StringBuilder accum) {
        if (node instanceof TextNode) {
            accum.append(((TextNode)node).getWholeText());
            return;
        }
        if (node instanceof Element) {
            void var1_1;
            Node node2;
            Element.appendNewlineIfBr((Element)node2, (StringBuilder)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public String wholeOwnText() {
        void var1_1;
        StringBuilder accum = StringUtil.borrowBuilder();
        int size = ((Node)this).childNodeSize();
        for (int i = 0; i < size; ++i) {
            Node node = this.childNodes.get(i);
            Element.appendWholeText(node, accum);
        }
        return StringUtil.releaseBuilder((StringBuilder)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String ownText() {
        void var1_1;
        StringBuilder sb = StringUtil.borrowBuilder();
        this.ownText(sb);
        return StringUtil.releaseBuilder((StringBuilder)var1_1).trim();
    }

    /*
     * WARNING - void declaration
     */
    private void ownText(StringBuilder accum) {
        for (int i = 0; i < ((Node)this).childNodeSize(); ++i) {
            void var3_3;
            Node child = this.childNodes.get(i);
            if (child instanceof TextNode) {
                TextNode textNode = (TextNode)child;
                Element.appendNormalisedText(accum, (TextNode)var3_3);
                continue;
            }
            if (!(var3_3 instanceof Element)) continue;
            Element.appendWhitespaceIfBr((Element)var3_3, accum);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void appendNormalisedText(StringBuilder accum, TextNode textNode) {
        StringBuilder stringBuilder;
        void var2_2;
        void var1_1;
        String text = textNode.getWholeText();
        if (Element.preserveWhitespace(textNode.parentNode) || var1_1 instanceof CDataNode) {
            accum.append(text);
            return;
        }
        StringUtil.appendNormalisedWhitespace(accum, (String)var2_2, TextNode.lastCharIsWhitespace(stringBuilder));
    }

    /*
     * WARNING - void declaration
     */
    private static void appendWhitespaceIfBr(Element element, StringBuilder accum) {
        if (element.tag.normalName().equals("br") && !TextNode.lastCharIsWhitespace(accum)) {
            void var1_1;
            var1_1.append(" ");
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void appendNewlineIfBr(Element element, StringBuilder accum) {
        if (element.tag.normalName().equals("br")) {
            void var1_1;
            var1_1.append("\n");
        }
    }

    static boolean preserveWhitespace(Node node) {
        if (node instanceof Element) {
            Node el = (Element)node;
            int i = 0;
            do {
                if (((Element)el).tag.preserveWhitespace()) {
                    return true;
                }
                el = ((Element)el).parent();
            } while (++i < 6 && el != null);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public Element text(String text) {
        void var2_2;
        Validate.notNull(text);
        this.empty();
        Document owner = this.ownerDocument();
        if (owner != null && var2_2.parser().isContentForTagData(this.normalName())) {
            this.appendChild(new DataNode(text));
        } else {
            void var1_1;
            this.appendChild(new TextNode((String)var1_1));
        }
        return this;
    }

    public boolean hasText() {
        for (Node child : this.childNodes) {
            Element element;
            if (!(child instanceof TextNode ? !((TextNode)(child = (TextNode)child)).isBlank() : child instanceof Element && (element = (Element)element).hasText())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public String data() {
        void var1_1;
        StringBuilder sb = StringUtil.borrowBuilder();
        for (Node childNode : this.childNodes) {
            void var3_3;
            String elementData;
            Node comment;
            DataNode data;
            if (childNode instanceof DataNode) {
                data = (DataNode)childNode;
                sb.append(data.getWholeData());
                continue;
            }
            if (data instanceof Comment) {
                comment = (Comment)((Object)data);
                sb.append(comment.getData());
                continue;
            }
            if (comment instanceof Element) {
                comment = (Element)comment;
                elementData = ((Element)comment).data();
                sb.append(elementData);
                continue;
            }
            if (!(elementData instanceof CDataNode)) continue;
            CDataNode cDataNode = (CDataNode)((Object)elementData);
            sb.append(var3_3.getWholeText());
        }
        return StringUtil.releaseBuilder((StringBuilder)var1_1);
    }

    public String className() {
        return this.attr("class").trim();
    }

    /*
     * WARNING - void declaration
     */
    public Set<String> classNames() {
        void var1_1;
        String[] names = ClassSplit.split(this.className());
        LinkedHashSet<String> classNames = new LinkedHashSet<String>(Arrays.asList(names));
        classNames.remove("");
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Element classNames(Set<String> classNames) {
        Validate.notNull(classNames);
        if (classNames.isEmpty()) {
            ((Node)this).attributes().remove("class");
        } else {
            void var1_1;
            ((Node)this).attributes().put("class", StringUtil.join(var1_1, " "));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasClass(String className) {
        void var3_3;
        if (this.attributes == null) {
            return false;
        }
        String classAttr = this.attributes.getIgnoreCase("class");
        int len = classAttr.length();
        int wantLen = className.length();
        if (len == 0 || len < wantLen) {
            return false;
        }
        if (len == wantLen) {
            return className.equalsIgnoreCase(classAttr);
        }
        boolean inClass = false;
        int start = 0;
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(classAttr.charAt(i))) {
                if (!inClass) continue;
                if (i - start == wantLen && classAttr.regionMatches(true, start, className, 0, wantLen)) {
                    return true;
                }
                inClass = false;
                continue;
            }
            if (inClass) continue;
            inClass = true;
            start = i;
        }
        if (inClass && var3_3 - start == wantLen) {
            void var1_1;
            void var2_2;
            return var2_2.regionMatches(true, start, (String)var1_1, 0, wantLen);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public Element addClass(String className) {
        void var2_2;
        void var1_1;
        Validate.notNull(className);
        Set<String> classes = this.classNames();
        classes.add((String)var1_1);
        this.classNames((Set<String>)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Element removeClass(String className) {
        void var2_2;
        void var1_1;
        Validate.notNull(className);
        Set<String> classes = this.classNames();
        classes.remove(var1_1);
        this.classNames((Set<String>)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Element toggleClass(String className) {
        void var2_2;
        Validate.notNull(className);
        Set<String> classes = this.classNames();
        if (classes.contains(className)) {
            classes.remove(className);
        } else {
            void var1_1;
            classes.add((String)var1_1);
        }
        this.classNames((Set<String>)var2_2);
        return this;
    }

    public String val() {
        if (this.normalName().equals("textarea")) {
            return this.text();
        }
        return this.attr("value");
    }

    /*
     * WARNING - void declaration
     */
    public Element val(String value) {
        if (this.normalName().equals("textarea")) {
            this.text(value);
        } else {
            void var1_1;
            this.attr("value", (String)var1_1);
        }
        return this;
    }

    public Range endSourceRange() {
        return Range.of(this, false);
    }

    /*
     * WARNING - void declaration
     */
    boolean shouldIndent(Document.OutputSettings out) {
        void var1_1;
        return out.prettyPrint() && this.isFormatAsBlock(out) && !this.isInlineable((Document.OutputSettings)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void outerHtmlHead(Appendable accum, int depth, Document.OutputSettings out) throws IOException {
        void var1_1;
        if (this.shouldIndent(out) && (!(accum instanceof StringBuilder) || ((StringBuilder)accum).length() > 0)) {
            void var2_2;
            this.indent(accum, (int)var2_2, out);
        }
        accum.append('<').append(this.tagName());
        if (this.attributes != null) {
            this.attributes.html(accum, out);
        }
        if (this.childNodes.isEmpty() && this.tag.isSelfClosing()) {
            void var3_3;
            if (var3_3.syntax() == Document.OutputSettings.Syntax.html && this.tag.isEmpty()) {
                accum.append('>');
                return;
            }
            accum.append(" />");
            return;
        }
        var1_1.append('>');
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void outerHtmlTail(Appendable accum, int depth, Document.OutputSettings out) throws IOException {
        if (!this.childNodes.isEmpty() || !this.tag.isSelfClosing()) {
            void var1_1;
            if (out.prettyPrint() && !this.childNodes.isEmpty() && (this.tag.formatAsBlock() || out.outline() && (this.childNodes.size() > 1 || this.childNodes.size() == 1 && this.childNodes.get(0) instanceof Element))) {
                void var3_3;
                void var2_2;
                this.indent(accum, (int)var2_2, (Document.OutputSettings)var3_3);
            }
            var1_1.append("</").append(this.tagName()).append('>');
        }
    }

    /*
     * WARNING - void declaration
     */
    public String html() {
        void var1_1;
        StringBuilder accum = StringUtil.borrowBuilder();
        ((Node)this).html(accum);
        String html = StringUtil.releaseBuilder(accum);
        if (NodeUtils.outputSettings(this).prettyPrint()) {
            return html.trim();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T extends Appendable> T html(T appendable) {
        void var1_1;
        int size = this.childNodes.size();
        for (int i = 0; i < size; ++i) {
            this.childNodes.get(i).outerHtml(appendable);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Element html(String html) {
        void var1_1;
        this.empty();
        this.append((String)var1_1);
        return this;
    }

    @Override
    public Element clone() {
        return (Element)super.clone();
    }

    @Override
    public Element shallowClone() {
        return new Element(this.tag, ((Node)this).baseUri(), this.attributes == null ? null : this.attributes.clone());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Element doClone(Node parent) {
        void var1_1;
        Element clone = (Element)super.doClone(parent);
        ((Element)super.doClone(parent)).attributes = this.attributes != null ? this.attributes.clone() : null;
        clone.childNodes = new NodeList(clone, this.childNodes.size());
        clone.childNodes.addAll(this.childNodes);
        return var1_1;
    }

    @Override
    public Element clearAttributes() {
        if (this.attributes != null) {
            super.clearAttributes();
            this.attributes = null;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Element removeAttr(String attributeKey) {
        void var1_1;
        return (Element)super.removeAttr((String)var1_1);
    }

    @Override
    public Element root() {
        return (Element)super.root();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Element traverse(NodeVisitor nodeVisitor) {
        void var1_1;
        return (Element)super.traverse((NodeVisitor)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Element forEachNode(Consumer<? super Node> action) {
        void var1_1;
        return (Element)super.forEachNode((Consumer<? super Node>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Element forEach(Consumer<? super Element> action) {
        void var1_1;
        Validate.notNull(action);
        NodeTraversor.traverse((arg_0, arg_1) -> Element.lambda$forEach$1((Consumer)var1_1, arg_0, arg_1), this);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Element filter(NodeFilter nodeFilter) {
        void var1_1;
        return (Element)super.filter((NodeFilter)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private boolean isFormatAsBlock(Document.OutputSettings out) {
        void var1_1;
        return this.tag.formatAsBlock() || this.parent() != null && this.parent().tag().formatAsBlock() || var1_1.outline();
    }

    /*
     * WARNING - void declaration
     */
    private boolean isInlineable(Document.OutputSettings out) {
        void var1_1;
        return this.tag().isInline() && (this.parent() == null || this.parent().isBlock()) && this.previousSibling() != null && !var1_1.outline();
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$forEach$1(Consumer action, Node node, int depth) {
        if (node instanceof Element) {
            void var1_1;
            Consumer consumer;
            consumer.accept((Element)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(StringBuilder x0, TextNode x1) {
        void var1_1;
        Element.appendNormalisedText(x0, (TextNode)var1_1);
    }

    private static final class NodeList
    extends ChangeNotifyingArrayList<Node> {
        private final Element owner;

        /*
         * WARNING - void declaration
         */
        NodeList(Element owner, int initialCapacity) {
            super((int)var2_2);
            void var1_1;
            void var2_2;
            this.owner = var1_1;
        }

        @Override
        public final void onContentsChanged() {
            this.owner.nodelistChanged();
        }
    }
}

