/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.io.IOException;
import org.jsoup.helper.Validate;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.LeafNode;
import org.jsoup.nodes.Node;

public class DocumentType
extends LeafNode {
    public static final String PUBLIC_KEY = "PUBLIC";
    public static final String SYSTEM_KEY = "SYSTEM";
    private static final String NAME = "name";
    private static final String PUB_SYS_KEY = "pubSysKey";
    private static final String PUBLIC_ID = "publicId";
    private static final String SYSTEM_ID = "systemId";

    /*
     * WARNING - void declaration
     */
    public DocumentType(String name, String publicId, String systemId) {
        void var3_3;
        void var2_2;
        void var1_1;
        Validate.notNull(name);
        Validate.notNull(publicId);
        Validate.notNull(systemId);
        ((Node)this).attr(NAME, (String)var1_1);
        ((Node)this).attr(PUBLIC_ID, (String)var2_2);
        ((Node)this).attr(SYSTEM_ID, (String)var3_3);
        this.updatePubSyskey();
    }

    /*
     * WARNING - void declaration
     */
    public void setPubSysKey(String value) {
        if (value != null) {
            void var1_1;
            ((Node)this).attr(PUB_SYS_KEY, (String)var1_1);
        }
    }

    private void updatePubSyskey() {
        if (this.has(PUBLIC_ID)) {
            ((Node)this).attr(PUB_SYS_KEY, PUBLIC_KEY);
            return;
        }
        if (this.has(SYSTEM_ID)) {
            ((Node)this).attr(PUB_SYS_KEY, SYSTEM_KEY);
        }
    }

    public String name() {
        return ((Node)this).attr(NAME);
    }

    public String publicId() {
        return ((Node)this).attr(PUBLIC_ID);
    }

    public String systemId() {
        return ((Node)this).attr(SYSTEM_ID);
    }

    @Override
    public String nodeName() {
        return "#doctype";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void outerHtmlHead(Appendable accum, int depth, Document.OutputSettings out) throws IOException {
        void var1_1;
        void var3_3;
        if (this.siblingIndex > 0 && out.prettyPrint()) {
            accum.append('\n');
        }
        if (var3_3.syntax() == Document.OutputSettings.Syntax.html && !this.has(PUBLIC_ID) && !this.has(SYSTEM_ID)) {
            accum.append("<!doctype");
        } else {
            accum.append("<!DOCTYPE");
        }
        if (this.has(NAME)) {
            accum.append(" ").append(((Node)this).attr(NAME));
        }
        if (this.has(PUB_SYS_KEY)) {
            accum.append(" ").append(((Node)this).attr(PUB_SYS_KEY));
        }
        if (this.has(PUBLIC_ID)) {
            accum.append(" \"").append(((Node)this).attr(PUBLIC_ID)).append('\"');
        }
        if (this.has(SYSTEM_ID)) {
            accum.append(" \"").append(((Node)this).attr(SYSTEM_ID)).append('\"');
        }
        var1_1.append('>');
    }

    @Override
    void outerHtmlTail(Appendable accum, int depth, Document.OutputSettings out) {
    }

    /*
     * WARNING - void declaration
     */
    private boolean has(String attribute) {
        void var1_1;
        return !StringUtil.isBlank(((Node)this).attr((String)var1_1));
    }
}

