/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.helper.DataUtil;
import org.jsoup.helper.Validate;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.DocumentType;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Entities;
import org.jsoup.nodes.LeafNode;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.nodes.XmlDeclaration;
import org.jsoup.parser.ParseSettings;
import org.jsoup.parser.Parser;
import org.jsoup.parser.Tag;
import org.jsoup.select.Elements;
import org.jsoup.select.Evaluator;

public class Document
extends Element {
    private Connection connection;
    private OutputSettings outputSettings = new OutputSettings();
    private Parser parser;
    private QuirksMode quirksMode = QuirksMode.noQuirks;
    private final String location;
    private boolean updateMetaCharset = false;
    private static final Evaluator titleEval = new Evaluator.Tag("title");

    /*
     * WARNING - void declaration
     */
    public Document(String baseUri) {
        super(Tag.valueOf("#root", ParseSettings.htmlDefault), baseUri);
        void var1_1;
        this.location = var1_1;
        this.parser = Parser.htmlParser();
    }

    /*
     * WARNING - void declaration
     */
    public static Document createShell(String baseUri) {
        Document document;
        void var1_1;
        Validate.notNull(baseUri);
        Document doc = new Document(baseUri);
        new Document(baseUri).parser = doc.parser();
        Element html = doc.appendElement("html");
        html.appendElement("head");
        var1_1.appendElement("body");
        return document;
    }

    public String location() {
        return this.location;
    }

    public Connection connection() {
        if (this.connection == null) {
            return Jsoup.newSession();
        }
        return this.connection;
    }

    /*
     * WARNING - void declaration
     */
    public DocumentType documentType() {
        for (Node node : this.childNodes) {
            void var2_2;
            if (node instanceof DocumentType) {
                return (DocumentType)node;
            }
            if (var2_2 instanceof LeafNode) continue;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private Element htmlEl() {
        for (Element el : this.childElementsList()) {
            void var2_2;
            if (!el.normalName().equals("html")) continue;
            return var2_2;
        }
        return this.appendElement("html");
    }

    /*
     * WARNING - void declaration
     */
    public Element head() {
        void var1_1;
        Element html = this.htmlEl();
        for (Element el : html.childElementsList()) {
            void var3_3;
            if (!el.normalName().equals("head")) continue;
            return var3_3;
        }
        return var1_1.prependElement("head");
    }

    /*
     * WARNING - void declaration
     */
    public Element body() {
        void var1_1;
        Element html = this.htmlEl();
        for (Element el : html.childElementsList()) {
            void var3_3;
            if (!"body".equals(el.normalName()) && !"frameset".equals(el.normalName())) continue;
            return var3_3;
        }
        return var1_1.appendElement("body");
    }

    /*
     * WARNING - void declaration
     */
    public String title() {
        Element titleEl = this.head().selectFirst(titleEval);
        if (titleEl != null) {
            void var1_1;
            return StringUtil.normaliseWhitespace(var1_1.text()).trim();
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    public void title(String title) {
        void var1_1;
        void var2_2;
        Validate.notNull(title);
        Element titleEl = this.head().selectFirst(titleEval);
        if (titleEl == null) {
            titleEl = this.head().appendElement("title");
        }
        var2_2.text((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Element createElement(String tagName) {
        void var1_1;
        return new Element(Tag.valueOf((String)var1_1, ParseSettings.preserveCase), ((Node)this).baseUri());
    }

    /*
     * WARNING - void declaration
     */
    public Document normalise() {
        void var1_1;
        void var2_2;
        Element htmlEl = this.htmlEl();
        Element head = this.head();
        this.body();
        this.normaliseTextNodes((Element)var2_2);
        this.normaliseTextNodes(htmlEl);
        Document document = this;
        document.normaliseTextNodes(document);
        this.normaliseStructure("head", htmlEl);
        this.normaliseStructure("body", (Element)var1_1);
        this.ensureMetaCharsetElement();
        return this;
    }

    private void normaliseTextNodes(Element element) {
        ArrayList<TextNode> toMove = new ArrayList<TextNode>();
        for (Node node : element.childNodes) {
            TextNode tn;
            if (!(node instanceof TextNode) || (tn = (TextNode)node).isBlank()) continue;
            toMove.add(tn);
        }
        for (int i = toMove.size() - 1; i >= 0; --i) {
            Node node;
            node = (Node)toMove.get(i);
            element.removeChild(node);
            this.body().prependChild(new TextNode(" "));
            this.body().prependChild(node);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void normaliseStructure(String tag, Element htmlEl) {
        Elements elements = this.getElementsByTag(tag);
        Element master = elements.first();
        if (elements.size() > 1) {
            ArrayList<Node> toMove = new ArrayList<Node>();
            for (int i = 1; i < elements.size(); ++i) {
                Node dupe = (Node)elements.get(i);
                toMove.addAll(dupe.ensureChildNodes());
                dupe.remove();
            }
            for (Node dupe : toMove) {
                master.appendChild(dupe);
            }
        }
        if (master.parent() != null && !master.parent().equals(htmlEl)) {
            void var3_3;
            void var2_2;
            var2_2.appendChild((Node)var3_3);
        }
    }

    @Override
    public String outerHtml() {
        return super.html();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Element text(String text) {
        void var1_1;
        this.body().text((String)var1_1);
        return this;
    }

    @Override
    public String nodeName() {
        return "#document";
    }

    /*
     * WARNING - void declaration
     */
    public void charset(Charset charset) {
        void var1_1;
        this.updateMetaCharsetElement(true);
        this.outputSettings.charset((Charset)var1_1);
        this.ensureMetaCharsetElement();
    }

    public Charset charset() {
        return this.outputSettings.charset();
    }

    /*
     * WARNING - void declaration
     */
    public void updateMetaCharsetElement(boolean update) {
        void var1_1;
        this.updateMetaCharset = var1_1;
    }

    public boolean updateMetaCharsetElement() {
        return this.updateMetaCharset;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Document clone() {
        void var1_1;
        Document clone = (Document)super.clone();
        ((Document)super.clone()).outputSettings = this.outputSettings.clone();
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Document shallowClone() {
        void var1_1;
        Document clone = new Document(((Node)this).baseUri());
        if (this.attributes != null) {
            clone.attributes = this.attributes.clone();
        }
        clone.outputSettings = this.outputSettings.clone();
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void ensureMetaCharsetElement() {
        block3: {
            void var1_1;
            XmlDeclaration decl;
            block4: {
                block6: {
                    block5: {
                        Element metaCharset;
                        if (!this.updateMetaCharset) break block3;
                        OutputSettings.Syntax syntax = this.outputSettings().syntax();
                        if (syntax == OutputSettings.Syntax.html) {
                            metaCharset = this.selectFirst("meta[charset]");
                            if (metaCharset != null) {
                                metaCharset.attr("charset", this.charset().displayName());
                            } else {
                                this.head().appendElement("meta").attr("charset", this.charset().displayName());
                            }
                            this.select("meta[name=charset]").remove();
                            return;
                        }
                        if (metaCharset != OutputSettings.Syntax.xml) break block3;
                        Node node = this.ensureChildNodes().get(0);
                        if (!(node instanceof XmlDeclaration)) break block4;
                        decl = (XmlDeclaration)node;
                        if (!decl.name().equals("xml")) break block5;
                        ((Node)decl).attr("encoding", this.charset().displayName());
                        if (!((Node)decl).hasAttr("version")) break block6;
                        ((Node)decl).attr("version", "1.0");
                        break block3;
                    }
                    decl = new XmlDeclaration("xml", false);
                    ((Node)decl).attr("version", "1.0");
                    ((Node)decl).attr("encoding", this.charset().displayName());
                    this.prependChild(decl);
                }
                return;
            }
            decl = new XmlDeclaration("xml", false);
            ((Node)decl).attr("version", "1.0");
            ((Node)decl).attr("encoding", this.charset().displayName());
            this.prependChild((Node)var1_1);
        }
    }

    public OutputSettings outputSettings() {
        return this.outputSettings;
    }

    /*
     * WARNING - void declaration
     */
    public Document outputSettings(OutputSettings outputSettings) {
        void var1_1;
        Validate.notNull(outputSettings);
        this.outputSettings = var1_1;
        return this;
    }

    public QuirksMode quirksMode() {
        return this.quirksMode;
    }

    /*
     * WARNING - void declaration
     */
    public Document quirksMode(QuirksMode quirksMode) {
        void var1_1;
        this.quirksMode = var1_1;
        return this;
    }

    public Parser parser() {
        return this.parser;
    }

    /*
     * WARNING - void declaration
     */
    public Document parser(Parser parser) {
        void var1_1;
        this.parser = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Document connection(Connection connection) {
        void var1_1;
        Validate.notNull(connection);
        this.connection = var1_1;
        return this;
    }

    public static class OutputSettings
    implements Cloneable {
        private Entities.EscapeMode escapeMode = Entities.EscapeMode.base;
        private Charset charset = DataUtil.UTF_8;
        private final ThreadLocal<CharsetEncoder> encoderThreadLocal = new ThreadLocal();
        Entities.CoreCharset coreCharset;
        private boolean prettyPrint = true;
        private boolean outline = false;
        private int indentAmount = 1;
        private int maxPaddingWidth = 30;
        private Syntax syntax = Syntax.html;

        public Entities.EscapeMode escapeMode() {
            return this.escapeMode;
        }

        /*
         * WARNING - void declaration
         */
        public OutputSettings escapeMode(Entities.EscapeMode escapeMode) {
            void var1_1;
            this.escapeMode = var1_1;
            return this;
        }

        public Charset charset() {
            return this.charset;
        }

        /*
         * WARNING - void declaration
         */
        public OutputSettings charset(Charset charset) {
            void var1_1;
            this.charset = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public OutputSettings charset(String charset) {
            void var1_1;
            this.charset(Charset.forName((String)var1_1));
            return this;
        }

        /*
         * WARNING - void declaration
         */
        CharsetEncoder prepareEncoder() {
            void var1_1;
            CharsetEncoder encoder = this.charset.newEncoder();
            this.encoderThreadLocal.set(encoder);
            this.coreCharset = Entities.CoreCharset.byName(encoder.charset().name());
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        CharsetEncoder encoder() {
            CharsetEncoder encoder = this.encoderThreadLocal.get();
            if (encoder != null) {
                void var1_1;
                return var1_1;
            }
            return this.prepareEncoder();
        }

        public Syntax syntax() {
            return this.syntax;
        }

        /*
         * WARNING - void declaration
         */
        public OutputSettings syntax(Syntax syntax) {
            void var1_1;
            this.syntax = var1_1;
            return this;
        }

        public boolean prettyPrint() {
            return this.prettyPrint;
        }

        /*
         * WARNING - void declaration
         */
        public OutputSettings prettyPrint(boolean pretty) {
            void var1_1;
            this.prettyPrint = var1_1;
            return this;
        }

        public boolean outline() {
            return this.outline;
        }

        /*
         * WARNING - void declaration
         */
        public OutputSettings outline(boolean outlineMode) {
            void var1_1;
            this.outline = var1_1;
            return this;
        }

        public int indentAmount() {
            return this.indentAmount;
        }

        /*
         * WARNING - void declaration
         */
        public OutputSettings indentAmount(int indentAmount) {
            void var1_1;
            Validate.isTrue(indentAmount >= 0);
            this.indentAmount = var1_1;
            return this;
        }

        public int maxPaddingWidth() {
            return this.maxPaddingWidth;
        }

        /*
         * WARNING - void declaration
         */
        public OutputSettings maxPaddingWidth(int maxPaddingWidth) {
            void var1_1;
            Validate.isTrue(maxPaddingWidth >= -1);
            this.maxPaddingWidth = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public OutputSettings clone() {
            void var1_1;
            OutputSettings clone;
            try {
                clone = (OutputSettings)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
            clone.charset(this.charset.name());
            clone.escapeMode = Entities.EscapeMode.valueOf(this.escapeMode.name());
            return var1_1;
        }

        public static enum Syntax {
            html,
            xml;

        }
    }

    public static enum QuirksMode {
        noQuirks,
        quirks,
        limitedQuirks;

    }
}

