/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jsoup.SerializationException;
import org.jsoup.helper.Validate;
import org.jsoup.internal.Normalizer;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Document;
import org.jsoup.parser.ParseSettings;

public class Attributes
implements Cloneable,
Iterable<Attribute> {
    protected static final String dataPrefix = "data-";
    static final char InternalPrefix = '/';
    private static final int InitialCapacity = 3;
    private static final int GrowthFactor = 2;
    static final int NotFound = -1;
    private static final String EmptyString = "";
    private int size = 0;
    String[] keys = new String[3];
    Object[] vals = new Object[3];

    /*
     * WARNING - void declaration
     */
    private void checkCapacity(int minNewSize) {
        void var2_2;
        int newCap;
        Validate.isTrue(minNewSize >= this.size);
        int curCap = this.keys.length;
        if (curCap >= minNewSize) {
            return;
        }
        int n = newCap = curCap >= 3 ? this.size << 1 : 3;
        if (minNewSize > newCap) {
            void var1_1;
            newCap = var1_1;
        }
        this.keys = Arrays.copyOf(this.keys, newCap);
        this.vals = Arrays.copyOf(this.vals, (int)var2_2);
    }

    int indexOfKey(String key) {
        Validate.notNull(key);
        for (int i = 0; i < this.size; ++i) {
            if (!key.equals(this.keys[i])) continue;
            return i;
        }
        return -1;
    }

    private int indexOfKeyIgnoreCase(String key) {
        Validate.notNull(key);
        for (int i = 0; i < this.size; ++i) {
            if (!key.equalsIgnoreCase(this.keys[i])) continue;
            return i;
        }
        return -1;
    }

    static String checkNotNull(Object val) {
        Object object;
        if (val == null) {
            return EmptyString;
        }
        return (String)object;
    }

    /*
     * WARNING - void declaration
     */
    public String get(String key) {
        void var1_2;
        int i = this.indexOfKey(key);
        if (i == -1) {
            return EmptyString;
        }
        return Attributes.checkNotNull(this.vals[var1_2]);
    }

    /*
     * WARNING - void declaration
     */
    public String getIgnoreCase(String key) {
        void var1_2;
        int i = this.indexOfKeyIgnoreCase(key);
        if (i == -1) {
            return EmptyString;
        }
        return Attributes.checkNotNull(this.vals[var1_2]);
    }

    /*
     * WARNING - void declaration
     */
    Object getUserData(String key) {
        void var1_2;
        int i;
        Validate.notNull(key);
        if (!this.isInternalKey(key)) {
            key = Attributes.internalKey(key);
        }
        if ((i = this.indexOfKeyIgnoreCase(key)) == -1) {
            return null;
        }
        return this.vals[var1_2];
    }

    /*
     * WARNING - void declaration
     */
    public Attributes add(String key, String value) {
        void var2_2;
        void var1_1;
        this.addObject((String)var1_1, var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private void addObject(String key, Object value) {
        void var2_2;
        void var1_1;
        Attributes attributes = this;
        attributes.checkCapacity(attributes.size + 1);
        this.keys[this.size] = var1_1;
        this.vals[this.size] = var2_2;
        ++this.size;
    }

    /*
     * WARNING - void declaration
     */
    public Attributes put(String key, String value) {
        Validate.notNull(key);
        int i = this.indexOfKey(key);
        if (i != -1) {
            this.vals[var3_3] = value;
        } else {
            void var2_2;
            void var1_1;
            this.add((String)var1_1, (String)var2_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    Attributes putUserData(String key, Object value) {
        Validate.notNull(key);
        if (!this.isInternalKey(key)) {
            key = Attributes.internalKey(key);
        }
        Validate.notNull(value);
        int i = this.indexOfKey(key);
        if (i != -1) {
            this.vals[var3_3] = value;
        } else {
            void var2_2;
            void var1_1;
            this.addObject((String)var1_1, var2_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    void putIgnoreCase(String key, String value) {
        int i = this.indexOfKeyIgnoreCase(key);
        if (i != -1) {
            this.vals[i] = value;
            if (!this.keys[i].equals(key)) {
                this.keys[var3_3] = key;
                return;
            }
        } else {
            void var2_2;
            void var1_1;
            this.add((String)var1_1, (String)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Attributes put(String key, boolean value) {
        if (value) {
            this.putIgnoreCase(key, null);
        } else {
            void var1_1;
            this.remove((String)var1_1);
        }
        return this;
    }

    public Attributes put(Attribute attribute) {
        Validate.notNull(attribute);
        this.put(attribute.getKey(), attribute.getValue());
        var1_1.parent = this;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private void remove(int index) {
        Validate.isFalse(index >= this.size);
        int shifted = this.size - index - 1;
        if (shifted > 0) {
            void var2_2;
            void var1_1;
            System.arraycopy(this.keys, index + 1, this.keys, index, shifted);
            System.arraycopy(this.vals, index + 1, this.vals, (int)var1_1, (int)var2_2);
        }
        --this.size;
        this.keys[this.size] = null;
        this.vals[this.size] = null;
    }

    /*
     * WARNING - void declaration
     */
    public void remove(String key) {
        int i = this.indexOfKey(key);
        if (i != -1) {
            void var1_2;
            this.remove((int)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeIgnoreCase(String key) {
        int i = this.indexOfKeyIgnoreCase(key);
        if (i != -1) {
            void var1_2;
            this.remove((int)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasKey(String key) {
        void var1_1;
        return this.indexOfKey((String)var1_1) != -1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasKeyIgnoreCase(String key) {
        void var1_1;
        return this.indexOfKeyIgnoreCase((String)var1_1) != -1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasDeclaredValueForKey(String key) {
        void var1_2;
        int i = this.indexOfKey(key);
        return i != -1 && this.vals[var1_2] != null;
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasDeclaredValueForKeyIgnoreCase(String key) {
        void var1_2;
        int i = this.indexOfKeyIgnoreCase(key);
        return i != -1 && this.vals[var1_2] != null;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    /*
     * WARNING - void declaration
     */
    public void addAll(Attributes incoming) {
        Iterator<Attribute> iterator;
        if (incoming.size() == 0) {
            return;
        }
        Attributes attributes = this;
        attributes.checkCapacity(attributes.size + incoming.size);
        boolean needsPut = this.size != 0;
        iterator = ((Attributes)((Object)iterator)).iterator();
        while (iterator.hasNext()) {
            void var3_3;
            Attribute attr = iterator.next();
            if (needsPut) {
                this.put(attr);
                continue;
            }
            this.add(attr.getKey(), var3_3.getValue());
        }
    }

    @Override
    public Iterator<Attribute> iterator() {
        return new Iterator<Attribute>(this){
            int i = 0;
            final /* synthetic */ Attributes this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public boolean hasNext() {
                while (this.i < this.this$0.size && Attributes.access$100(this.this$0, this.this$0.keys[this.i])) {
                    ++this.i;
                }
                return this.i < this.this$0.size;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Attribute next() {
                void var1_1;
                Attribute attr = new Attribute(this.this$0.keys[this.i], (String)this.this$0.vals[this.i], this.this$0);
                ++this.i;
                return var1_1;
            }

            @Override
            public void remove() {
                Attributes.access$200(this.this$0, --this.i);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public List<Attribute> asList() {
        void var1_1;
        ArrayList<void> list = new ArrayList<void>(this.size);
        for (int i = 0; i < this.size; ++i) {
            void var3_3;
            Attributes attributes = this;
            if (attributes.isInternalKey(attributes.keys[i])) continue;
            Attribute attr = new Attribute(this.keys[i], (String)this.vals[i], this);
            list.add(var3_3);
        }
        return Collections.unmodifiableList(var1_1);
    }

    public Map<String, String> dataset() {
        return new Dataset(this);
    }

    /*
     * WARNING - void declaration
     */
    public String html() {
        void var1_1;
        StringBuilder sb = StringUtil.borrowBuilder();
        try {
            this.html(sb, new Document(EmptyString).outputSettings());
        }
        catch (IOException e) {
            void var1_2;
            throw new SerializationException((Throwable)var1_2);
        }
        return StringUtil.releaseBuilder((StringBuilder)var1_1);
    }

    final void html(Appendable accum, Document.OutputSettings out) throws IOException {
        int sz = this.size;
        for (int i = 0; i < sz; ++i) {
            String key;
            Attributes attributes = this;
            if (attributes.isInternalKey(attributes.keys[i]) || (key = Attribute.getValidKey(this.keys[i], out.syntax())) == null) continue;
            Attribute.htmlNoValidate(key, (String)this.vals[i], accum.append(' '), out);
        }
    }

    public String toString() {
        return this.html();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attributes that = (Attributes)o;
        if (this.size != that.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            void var3_3;
            String key = this.keys[i];
            int thatI = that.indexOfKey(key);
            if (thatI == -1) {
                return false;
            }
            Object val = this.vals[i];
            Object thatVal = that.vals[thatI];
            if (!(val == null ? thatVal != null : !val.equals(var3_3))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int result = this.size;
        result = result * 31 + Arrays.hashCode(this.keys);
        var1_1 = var1_1 * 31 + Arrays.hashCode(this.vals);
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Attributes clone() {
        void var1_1;
        try {
            Attributes clone = (Attributes)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.size = this.size;
        clone.keys = Arrays.copyOf(this.keys, this.size);
        clone.vals = Arrays.copyOf(this.vals, this.size);
        return var1_1;
    }

    public void normalize() {
        for (int i = 0; i < this.size; ++i) {
            this.keys[i] = Normalizer.lowerCase(this.keys[i]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public int deduplicate(ParseSettings settings) {
        void var2_3;
        if (this.isEmpty()) {
            return 0;
        }
        boolean preserve = settings.preserveAttributeCase();
        int dupes = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            for (int j = i + 1; j < this.keys.length && this.keys[j] != null; ++j) {
                if ((!preserve || !this.keys[i].equals(this.keys[j])) && (preserve || !this.keys[i].equalsIgnoreCase(this.keys[j]))) continue;
                ++dupes;
                this.remove(j);
                --j;
            }
        }
        return (int)var2_3;
    }

    private static String dataKey(String key) {
        String string;
        return dataPrefix + string;
    }

    static String internalKey(String key) {
        String string;
        return "/" + string;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isInternalKey(String key) {
        void var1_1;
        return key != null && key.length() > 1 && var1_1.charAt(0) == '/';
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$100(Attributes x0, String x1) {
        void var1_1;
        return x0.isInternalKey((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$200(Attributes x0, int x1) {
        void var1_1;
        x0.remove((int)var1_1);
    }

    private static class Dataset
    extends AbstractMap<String, String> {
        private final Attributes attributes;

        /*
         * WARNING - void declaration
         */
        private Dataset(Attributes attributes) {
            void var1_1;
            this.attributes = var1_1;
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return new EntrySet();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String put(String key, String value) {
            void var3_3;
            void var2_2;
            void var1_1;
            String dataKey = Attributes.dataKey(key);
            String oldValue = this.attributes.hasKey(dataKey) ? this.attributes.get(dataKey) : null;
            this.attributes.put((String)var1_1, (String)var2_2);
            return var3_3;
        }

        private class EntrySet
        extends AbstractSet<Map.Entry<String, String>> {
            private EntrySet() {
            }

            @Override
            public Iterator<Map.Entry<String, String>> iterator() {
                return new DatasetIterator();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public int size() {
                void var1_1;
                int count = 0;
                DatasetIterator iter = new DatasetIterator();
                while (iter.hasNext()) {
                    ++count;
                }
                return (int)var1_1;
            }
        }

        private class DatasetIterator
        implements Iterator<Map.Entry<String, String>> {
            private Iterator<Attribute> attrIter;
            private Attribute attr;

            private DatasetIterator() {
                this.attrIter = Dataset.this.attributes.iterator();
            }

            @Override
            public boolean hasNext() {
                while (this.attrIter.hasNext()) {
                    this.attr = this.attrIter.next();
                    if (!this.attr.isDataAttribute()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Map.Entry<String, String> next() {
                return new Attribute(this.attr.getKey().substring(5), this.attr.getValue());
            }

            @Override
            public void remove() {
                Dataset.this.attributes.remove(this.attr.getKey());
            }
        }
    }
}

