/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.internal;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import org.jsoup.helper.Validate;

public final class ConstrainableInputStream
extends BufferedInputStream {
    private static final int DefaultSize = 32768;
    private final boolean capped;
    private final int maxSize;
    private long startTime;
    private long timeout = 0L;
    private int remaining;
    private boolean interrupted;

    /*
     * WARNING - void declaration
     */
    private ConstrainableInputStream(InputStream in, int bufferSize, int maxSize) {
        super((InputStream)var1_1, (int)var2_2);
        void var3_3;
        void var2_2;
        void var1_1;
        Validate.isTrue(maxSize >= 0);
        this.maxSize = maxSize;
        this.remaining = maxSize;
        this.capped = var3_3 != false;
        this.startTime = System.nanoTime();
    }

    /*
     * WARNING - void declaration
     */
    public static ConstrainableInputStream wrap(InputStream in, int bufferSize, int maxSize) {
        void var2_2;
        void var1_1;
        InputStream inputStream;
        if (in instanceof ConstrainableInputStream) {
            return (ConstrainableInputStream)in;
        }
        return new ConstrainableInputStream(inputStream, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int read(byte[] b, int off, int len) throws IOException {
        if (this.interrupted || this.capped && this.remaining <= 0) {
            return -1;
        }
        if (Thread.interrupted()) {
            this.interrupted = true;
            return -1;
        }
        if (this.expired()) {
            throw new SocketTimeoutException("Read timeout");
        }
        if (this.capped && len > this.remaining) {
            len = this.remaining;
        }
        try {
            void var1_2;
            void var3_4;
            void var2_3;
            int read = super.read(b, (int)var2_3, (int)var3_4);
            this.remaining -= read;
            return (int)var1_2;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final ByteBuffer readToByteBuffer(int max) throws IOException {
        int read;
        Validate.isTrue(max >= 0, "maxSize must be 0 (unlimited) or larger");
        boolean localCapped = max > 0;
        int bufferSize = localCapped && max < 32768 ? max : 32768;
        byte[] readBuffer = new byte[bufferSize];
        ByteArrayOutputStream outStream = new ByteArrayOutputStream(bufferSize);
        int remaining = max;
        while ((read = this.read(readBuffer, 0, localCapped ? Math.min(remaining, bufferSize) : bufferSize)) != -1) {
            void var1_1;
            if (localCapped) {
                if (read >= remaining) {
                    outStream.write(readBuffer, 0, remaining);
                    break;
                }
                remaining -= read;
            }
            outStream.write(readBuffer, 0, (int)var1_1);
        }
        return ByteBuffer.wrap(outStream.toByteArray());
    }

    @Override
    public final void reset() throws IOException {
        super.reset();
        this.remaining = this.maxSize - this.markpos;
    }

    /*
     * WARNING - void declaration
     */
    public final ConstrainableInputStream timeout(long startTimeNanos, long timeoutMillis) {
        void var3_2;
        void var1_1;
        this.startTime = var1_1;
        this.timeout = var3_2 * 1000000L;
        return this;
    }

    private boolean expired() {
        if (this.timeout == 0L) {
            return false;
        }
        long l = System.nanoTime();
        long l2 = l - this.startTime;
        return l2 > this.timeout;
    }
}

