/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.helper;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.jsoup.helper.Validate;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;
import org.jsoup.select.Selector;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class W3CDom {
    public static final String SourceProperty = "jsoupSource";
    private static final String ContextProperty = "jsoupContextSource";
    private static final String ContextNodeProperty = "jsoupContextNode";
    public static final String XPathFactoryProperty = "javax.xml.xpath.XPathFactory:jsoup";
    protected DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private boolean namespaceAware = true;

    public W3CDom() {
        this.factory.setNamespaceAware(true);
    }

    public boolean namespaceAware() {
        return this.namespaceAware;
    }

    /*
     * WARNING - void declaration
     */
    public W3CDom namespaceAware(boolean namespaceAware) {
        void var1_1;
        this.namespaceAware = namespaceAware;
        this.factory.setNamespaceAware((boolean)var1_1);
        return this;
    }

    public static org.w3c.dom.Document convert(Document in) {
        Document document;
        return new W3CDom().fromJsoup(document);
    }

    /*
     * WARNING - void declaration
     */
    public static String asString(org.w3c.dom.Document doc, Map<String, String> properties) {
        try {
            void var3_4;
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            if (properties != null) {
                void var1_1;
                transformer.setOutputProperties(W3CDom.propertiesFromMap((Map<String, String>)var1_1));
            }
            if (doc.getDoctype() != null) {
                org.w3c.dom.Node node;
                org.w3c.dom.Node doctype = doc.getDoctype();
                if (!StringUtil.isBlank(doctype.getPublicId())) {
                    transformer.setOutputProperty("doctype-public", doctype.getPublicId());
                }
                if (!StringUtil.isBlank(doctype.getSystemId())) {
                    transformer.setOutputProperty("doctype-system", doctype.getSystemId());
                } else if (doctype.getName().equalsIgnoreCase("html") && StringUtil.isBlank(doctype.getPublicId()) && StringUtil.isBlank(node.getSystemId())) {
                    transformer.setOutputProperty("doctype-system", "about:legacy-compat");
                }
            }
            transformer.transform(domSource, result);
            return var3_4.toString();
        }
        catch (TransformerException e) {
            void var2_3;
            throw new IllegalStateException((Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    static Properties propertiesFromMap(Map<String, String> map) {
        void var1_1;
        Map<String, String> map2;
        Properties props = new Properties();
        props.putAll(map2);
        return var1_1;
    }

    public static HashMap<String, String> OutputHtml() {
        return W3CDom.methodMap("html");
    }

    public static HashMap<String, String> OutputXml() {
        return W3CDom.methodMap("xml");
    }

    /*
     * WARNING - void declaration
     */
    private static HashMap<String, String> methodMap(String method) {
        void var1_1;
        String string;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("method", string);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public org.w3c.dom.Document fromJsoup(Document in) {
        void var1_1;
        return this.fromJsoup((org.jsoup.nodes.Element)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public org.w3c.dom.Document fromJsoup(org.jsoup.nodes.Element in) {
        Validate.notNull(in);
        try {
            void var2_2;
            void var1_1;
            DocumentBuilder builder = this.factory.newDocumentBuilder();
            DOMImplementation impl = builder.getDOMImplementation();
            org.w3c.dom.Document out = builder.newDocument();
            Document inDoc = in.ownerDocument();
            org.jsoup.nodes.DocumentType doctype = inDoc != null ? inDoc.documentType() : null;
            if (doctype != null) {
                DocumentType documentType = impl.createDocumentType(doctype.name(), doctype.publicId(), doctype.systemId());
                out.appendChild(documentType);
            }
            out.setXmlStandalone(true);
            org.jsoup.nodes.Element context = in instanceof Document ? in.child(0) : in;
            out.setUserData(ContextProperty, context, null);
            this.convert((org.jsoup.nodes.Element)(inDoc != null ? inDoc : var1_1), out);
            return var2_2;
        }
        catch (ParserConfigurationException e) {
            void var3_4;
            throw new IllegalStateException((Throwable)var3_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void convert(Document in, org.w3c.dom.Document out) {
        void var2_2;
        void var1_1;
        this.convert((org.jsoup.nodes.Element)var1_1, (org.w3c.dom.Document)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void convert(org.jsoup.nodes.Element in, org.w3c.dom.Document out) {
        void var1_1;
        void var3_3;
        void rootEl;
        W3CBuilder builder = new W3CBuilder(out);
        W3CBuilder.access$002(builder, this.namespaceAware);
        Document inDoc = in.ownerDocument();
        if (inDoc != null) {
            if (!StringUtil.isBlank(inDoc.location())) {
                void var2_2;
                var2_2.setDocumentURI(inDoc.location());
            }
            W3CBuilder.access$102(builder, inDoc.outputSettings().syntax());
        }
        rootEl = in instanceof Document ? in.child(0) : rootEl;
        NodeTraversor.traverse((NodeVisitor)var3_3, (Node)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public NodeList selectXpath(String xpath, org.w3c.dom.Document doc) {
        void var2_2;
        void var1_1;
        return this.selectXpath((String)var1_1, (org.w3c.dom.Node)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public NodeList selectXpath(String xpath, org.w3c.dom.Node contextNode) {
        void var2_2;
        Validate.notEmptyParam(xpath, "xpath");
        Validate.notNullParam(contextNode, "contextNode");
        try {
            Object object = System.getProperty(XPathFactoryProperty);
            object = object != null ? XPathFactory.newInstance("jsoup") : XPathFactory.newInstance();
            object = ((XPathFactory)object).newXPath().compile(xpath);
            NodeList nodeList = (NodeList)object.evaluate(contextNode, XPathConstants.NODESET);
            Validate.notNull(nodeList);
        }
        catch (XPathExpressionException | XPathFactoryConfigurationException e) {
            void var3_4;
            void var1_1;
            throw new Selector.SelectorParseException("Could not evaluate XPath query [%s]: %s", var1_1, var3_4.getMessage());
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public <T extends Node> List<T> sourceNodes(NodeList nodeList, Class<T> nodeType) {
        void var3_3;
        Validate.notNull(nodeList);
        Validate.notNull(nodeType);
        ArrayList<Node> nodes = new ArrayList<Node>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            org.w3c.dom.Node node = nodeList.item(i);
            Object source = node.getUserData(SourceProperty);
            if (!nodeType.isInstance(source)) continue;
            nodes.add((Node)nodeType.cast(source));
        }
        return var3_3;
    }

    public org.w3c.dom.Node contextNode(org.w3c.dom.Document wDoc) {
        return (org.w3c.dom.Node)wDoc.getUserData(ContextNodeProperty);
    }

    public String asString(org.w3c.dom.Document doc) {
        return W3CDom.asString(doc, null);
    }

    protected static class W3CBuilder
    implements NodeVisitor {
        private static final String xmlnsKey = "xmlns";
        private static final String xmlnsPrefix = "xmlns:";
        private final org.w3c.dom.Document doc;
        private boolean namespaceAware = true;
        private final Stack<HashMap<String, String>> namespacesStack = new Stack();
        private org.w3c.dom.Node dest;
        private Document.OutputSettings.Syntax syntax = Document.OutputSettings.Syntax.xml;
        private final org.jsoup.nodes.Element contextElement;

        /*
         * WARNING - void declaration
         */
        public W3CBuilder(org.w3c.dom.Document doc) {
            void var1_1;
            this.doc = doc;
            this.namespacesStack.push(new HashMap());
            this.dest = doc;
            this.contextElement = (org.jsoup.nodes.Element)var1_1.getUserData(W3CDom.ContextProperty);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void head(Node source, int depth) {
            org.jsoup.nodes.Element sourceEl;
            this.namespacesStack.push(new HashMap(this.namespacesStack.peek()));
            if (source instanceof org.jsoup.nodes.Element) {
                sourceEl = (org.jsoup.nodes.Element)source;
                String prefix = this.updateNamespaces(sourceEl);
                String namespace = this.namespaceAware ? this.namespacesStack.peek().get(prefix) : null;
                String tagName = sourceEl.tagName();
                try {
                    Element el = namespace == null && tagName.contains(":") ? this.doc.createElementNS("", tagName) : this.doc.createElementNS(namespace, tagName);
                    this.copyAttributes(sourceEl, el);
                    this.append(el, sourceEl);
                    if (sourceEl == this.contextElement) {
                        this.doc.setUserData(W3CDom.ContextNodeProperty, el, null);
                    }
                    this.dest = el;
                }
                catch (DOMException dOMException) {
                    void var3_7;
                    W3CBuilder w3CBuilder = this;
                    w3CBuilder.append(w3CBuilder.doc.createTextNode("<" + (String)var3_7 + ">"), sourceEl);
                    return;
                }
            } else {
                org.jsoup.nodes.Comment sourceComment;
                TextNode sourceText;
                if (sourceEl instanceof TextNode) {
                    sourceText = (TextNode)((Object)sourceEl);
                    Text text = this.doc.createTextNode(sourceText.getWholeText());
                    this.append(text, sourceText);
                    return;
                }
                if (sourceText instanceof org.jsoup.nodes.Comment) {
                    sourceComment = (org.jsoup.nodes.Comment)((Object)sourceText);
                    Comment comment = this.doc.createComment(sourceComment.getData());
                    this.append(comment, sourceComment);
                    return;
                }
                if (sourceComment instanceof DataNode) {
                    void var1_1;
                    void var2_6;
                    DataNode sourceData = (DataNode)((Object)sourceComment);
                    Text node = this.doc.createTextNode(sourceData.getWholeData());
                    this.append((org.w3c.dom.Node)var2_6, (Node)var1_1);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private void append(org.w3c.dom.Node append, Node source) {
            void var1_1;
            void var2_2;
            append.setUserData(W3CDom.SourceProperty, var2_2, null);
            this.dest.appendChild((org.w3c.dom.Node)var1_1);
        }

        @Override
        public void tail(Node source, int depth) {
            if (source instanceof org.jsoup.nodes.Element && this.dest.getParentNode() instanceof Element) {
                this.dest = this.dest.getParentNode();
            }
            this.namespacesStack.pop();
        }

        /*
         * WARNING - void declaration
         */
        private void copyAttributes(Node source, Element el) {
            for (Attribute attribute : source.attributes()) {
                void var3_3;
                String key = Attribute.getValidKey(attribute.getKey(), this.syntax);
                if (key == null) continue;
                el.setAttribute(key, var3_3.getValue());
            }
        }

        /*
         * WARNING - void declaration
         */
        private String updateNamespaces(org.jsoup.nodes.Element el) {
            Object object = ((Node)el).attributes();
            object = ((Attributes)object).iterator();
            while (object.hasNext()) {
                void var3_4;
                String prefix;
                Attribute attr = (Attribute)object.next();
                String key = attr.getKey();
                if (key.equals(xmlnsKey)) {
                    prefix = "";
                } else {
                    if (!prefix.startsWith(xmlnsPrefix)) continue;
                    prefix = prefix.substring(6);
                }
                this.namespacesStack.peek().put(prefix, var3_4.getValue());
            }
            int pos = el.tagName().indexOf(58);
            if (pos > 0) {
                void var2_3;
                void var1_1;
                return var1_1.tagName().substring(0, (int)var2_3);
            }
            return "";
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ boolean access$002(W3CBuilder x0, boolean x1) {
            void var1_1;
            x0.namespaceAware = var1_1;
            return x0.namespaceAware;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ Document.OutputSettings.Syntax access$102(W3CBuilder x0, Document.OutputSettings.Syntax x1) {
            void var1_1;
            x0.syntax = var1_1;
            return x0.syntax;
        }
    }
}

