/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.helper;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.CookieManager;
import java.net.CookieStore;
import java.net.HttpURLConnection;
import java.net.IDN;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.jsoup.Connection;
import org.jsoup.HttpStatusException;
import org.jsoup.UncheckedIOException;
import org.jsoup.UnsupportedMimeTypeException;
import org.jsoup.helper.CookieUtil;
import org.jsoup.helper.DataUtil;
import org.jsoup.helper.Validate;
import org.jsoup.internal.ConstrainableInputStream;
import org.jsoup.internal.Normalizer;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Document;
import org.jsoup.parser.Parser;
import org.jsoup.parser.TokenQueue;

public class HttpConnection
implements Connection {
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String DEFAULT_UA = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.130 Safari/537.36";
    private static final String USER_AGENT = "User-Agent";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String FORM_URL_ENCODED = "application/x-www-form-urlencoded";
    private static final int HTTP_TEMP_REDIR = 307;
    private static final String DefaultUploadType = "application/octet-stream";
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    private Request req;
    private Connection.Response res;

    /*
     * WARNING - void declaration
     */
    public static Connection connect(String url) {
        void var1_1;
        String string;
        HttpConnection con = new HttpConnection();
        con.url(string);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static Connection connect(URL url) {
        void var1_1;
        URL uRL;
        HttpConnection con = new HttpConnection();
        con.url(uRL);
        return var1_1;
    }

    public HttpConnection() {
        this.req = new Request();
    }

    /*
     * WARNING - void declaration
     */
    HttpConnection(Request copy) {
        void var1_1;
        this.req = new Request((Request)var1_1);
    }

    private static String encodeUrl(String url) {
        try {
            URL uRL = new URL(url);
            return HttpConnection.encodeUrl(uRL).toExternalForm();
        }
        catch (Exception exception) {
            String string;
            return string;
        }
    }

    static URL encodeUrl(URL u) {
        u = HttpConnection.punyUrl(u);
        try {
            String string = u.toExternalForm();
            String urlS = string.replace(" ", "%20");
            URI uri = new URI(urlS);
            return new URL(((URI)((Object)string)).toASCIIString());
        }
        catch (MalformedURLException | URISyntaxException exception) {
            URL uRL;
            return uRL;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static URL punyUrl(URL url) {
        URL uRL;
        if (!StringUtil.isAscii(url.getHost())) {
            try {
                String puny = IDN.toASCII(url.getHost());
                url = new URL(url.getProtocol(), puny, url.getPort(), url.getFile());
            }
            catch (MalformedURLException e) {
                void var1_2;
                throw new IllegalArgumentException((Throwable)var1_2);
            }
        }
        return uRL;
    }

    private static String encodeMimeName(String val) {
        return val.replace("\"", "%22");
    }

    @Override
    public Connection newRequest() {
        return new HttpConnection(this.req);
    }

    /*
     * WARNING - void declaration
     */
    private HttpConnection(Request req, Response res) {
        void var2_2;
        void var1_1;
        this.req = var1_1;
        this.res = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Connection url(URL url) {
        void var1_1;
        this.req.url((URL)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Connection url(String url) {
        Validate.notEmptyParam(url, "url");
        try {
            this.req.url(new URL(HttpConnection.encodeUrl(url)));
        }
        catch (MalformedURLException e) {
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException(String.format("The supplied URL, '%s', is malformed. Make sure it is an absolute URL, and starts with 'http://' or 'https://'. See https://jsoup.org/cookbook/extracting-data/working-with-urls", var1_1), (Throwable)var2_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Connection proxy(Proxy proxy) {
        void var1_1;
        this.req.proxy((Proxy)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Connection proxy(String host, int port) {
        void var2_2;
        void var1_1;
        this.req.proxy((String)var1_1, (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Connection userAgent(String userAgent) {
        void var1_1;
        Validate.notNullParam(userAgent, "userAgent");
        this.req.header(USER_AGENT, (String)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Connection timeout(int millis) {
        void var1_1;
        this.req.timeout((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Connection maxBodySize(int bytes) {
        void var1_1;
        this.req.maxBodySize((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Connection followRedirects(boolean followRedirects) {
        void var1_1;
        this.req.followRedirects((boolean)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Connection referrer(String referrer) {
        void var1_1;
        Validate.notNullParam(referrer, "referrer");
        this.req.header("Referer", (String)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Connection method(Connection.Method method) {
        void var1_1;
        this.req.method((Connection.Method)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Connection ignoreHttpErrors(boolean ignoreHttpErrors) {
        void var1_1;
        this.req.ignoreHttpErrors((boolean)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Connection ignoreContentType(boolean ignoreContentType) {
        void var1_1;
        this.req.ignoreContentType((boolean)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Connection data(String key, String value) {
        void var2_2;
        void var1_1;
        this.req.data(KeyVal.create((String)var1_1, (String)var2_2));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Connection sslSocketFactory(SSLSocketFactory sslSocketFactory) {
        void var1_1;
        this.req.sslSocketFactory((SSLSocketFactory)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Connection data(String key, String filename, InputStream inputStream) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.req.data(KeyVal.create((String)var1_1, (String)var2_2, (InputStream)var3_3));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Connection data(String key, String filename, InputStream inputStream, String contentType) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.req.data(KeyVal.create((String)var1_1, (String)var2_2, (InputStream)var3_3).contentType(contentType));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Connection data(Map<String, String> data) {
        Iterator iterator;
        Validate.notNullParam(data, "data");
        for (Map.Entry entry : iterator.entrySet()) {
            void var2_2;
            this.req.data(KeyVal.create((String)entry.getKey(), (String)var2_2.getValue()));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Connection data(String ... keyvals) {
        Validate.notNullParam(keyvals, "keyvals");
        Validate.isTrue(keyvals.length % 2 == 0, "Must supply an even number of key value pairs");
        for (int i = 0; i < keyvals.length; i += 2) {
            void var3_3;
            String key = keyvals[i];
            String value = keyvals[i + 1];
            Validate.notEmpty(key, "Data key must not be empty");
            Validate.notNull(value, "Data value must not be null");
            this.req.data(KeyVal.create((String)var3_3, value));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Connection data(Collection<Connection.KeyVal> data) {
        Iterator iterator;
        Validate.notNullParam(data, "data");
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            Connection.KeyVal entry = (Connection.KeyVal)iterator.next();
            this.req.data((Connection.KeyVal)var2_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Connection.KeyVal data(String key) {
        Validate.notEmptyParam(key, "key");
        for (Connection.KeyVal keyVal : this.request().data()) {
            void var3_3;
            if (!keyVal.key().equals(key)) continue;
            return var3_3;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Connection requestBody(String body) {
        void var1_1;
        this.req.requestBody((String)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Connection header(String name, String value) {
        void var2_2;
        void var1_1;
        this.req.header((String)var1_1, (String)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Connection headers(Map<String, String> headers) {
        Iterator iterator;
        Validate.notNullParam(headers, "headers");
        for (Map.Entry entry : iterator.entrySet()) {
            void var2_2;
            this.req.header((String)entry.getKey(), (String)var2_2.getValue());
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Connection cookie(String name, String value) {
        void var2_2;
        void var1_1;
        this.req.cookie((String)var1_1, (String)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Connection cookies(Map<String, String> cookies) {
        Iterator iterator;
        Validate.notNullParam(cookies, "cookies");
        for (Map.Entry entry : iterator.entrySet()) {
            void var2_2;
            this.req.cookie((String)entry.getKey(), (String)var2_2.getValue());
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Connection cookieStore(CookieStore cookieStore) {
        void var1_1;
        Request.access$002(this.req, new CookieManager((CookieStore)var1_1, null));
        return this;
    }

    @Override
    public CookieStore cookieStore() {
        return this.req.cookieManager.getCookieStore();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Connection parser(Parser parser) {
        void var1_1;
        this.req.parser((Parser)var1_1);
        return this;
    }

    @Override
    public Document get() throws IOException {
        this.req.method(Connection.Method.GET);
        this.execute();
        Validate.notNull(this.res);
        return this.res.parse();
    }

    @Override
    public Document post() throws IOException {
        this.req.method(Connection.Method.POST);
        this.execute();
        Validate.notNull(this.res);
        return this.res.parse();
    }

    @Override
    public Connection.Response execute() throws IOException {
        this.res = Response.execute(this.req);
        return this.res;
    }

    @Override
    public Connection.Request request() {
        return this.req;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Connection request(Connection.Request request) {
        void var1_1;
        this.req = (Request)var1_1;
        return this;
    }

    @Override
    public Connection.Response response() {
        if (this.res == null) {
            throw new IllegalArgumentException("You must execute the request before getting a response.");
        }
        return this.res;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Connection response(Connection.Response response) {
        void var1_1;
        this.res = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Connection postDataCharset(String charset) {
        void var1_1;
        this.req.postDataCharset((String)var1_1);
        return this;
    }

    private static boolean needsMultipart(Connection.Request req) {
        for (Connection.KeyVal keyVal : req.data()) {
            if (!keyVal.hasInputStream()) continue;
            return true;
        }
        return false;
    }

    public static class Request
    extends Base<Connection.Request>
    implements Connection.Request {
        private Proxy proxy;
        private int timeoutMilliseconds;
        private int maxBodySizeBytes;
        private boolean followRedirects;
        private final Collection<Connection.KeyVal> data;
        private String body = null;
        private boolean ignoreHttpErrors = false;
        private boolean ignoreContentType = false;
        private Parser parser;
        private boolean parserDefined = false;
        private String postDataCharset = DataUtil.defaultCharsetName;
        private SSLSocketFactory sslSocketFactory;
        private CookieManager cookieManager;
        private volatile boolean executing = false;

        Request() {
            this.timeoutMilliseconds = 30000;
            this.maxBodySizeBytes = 0x200000;
            this.followRedirects = true;
            this.data = new ArrayList<Connection.KeyVal>();
            this.method = Connection.Method.GET;
            this.addHeader("Accept-Encoding", "gzip");
            this.addHeader(HttpConnection.USER_AGENT, HttpConnection.DEFAULT_UA);
            this.parser = Parser.htmlParser();
            this.cookieManager = new CookieManager();
        }

        /*
         * WARNING - void declaration
         */
        Request(Request copy) {
            super(copy);
            void var1_1;
            this.proxy = copy.proxy;
            this.postDataCharset = copy.postDataCharset;
            this.timeoutMilliseconds = copy.timeoutMilliseconds;
            this.maxBodySizeBytes = copy.maxBodySizeBytes;
            this.followRedirects = copy.followRedirects;
            this.data = new ArrayList<Connection.KeyVal>();
            this.data.addAll(copy.data());
            this.body = copy.body;
            this.ignoreHttpErrors = copy.ignoreHttpErrors;
            this.ignoreContentType = copy.ignoreContentType;
            this.parser = copy.parser.newInstance();
            this.parserDefined = copy.parserDefined;
            this.sslSocketFactory = copy.sslSocketFactory;
            this.cookieManager = var1_1.cookieManager;
            this.executing = false;
        }

        @Override
        public Proxy proxy() {
            return this.proxy;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Request proxy(Proxy proxy) {
            void var1_1;
            this.proxy = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Request proxy(String host, int port) {
            void var2_2;
            void var1_1;
            this.proxy = new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved((String)var1_1, (int)var2_2));
            return this;
        }

        @Override
        public int timeout() {
            return this.timeoutMilliseconds;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Request timeout(int millis) {
            void var1_1;
            Validate.isTrue(millis >= 0, "Timeout milliseconds must be 0 (infinite) or greater");
            this.timeoutMilliseconds = var1_1;
            return this;
        }

        @Override
        public int maxBodySize() {
            return this.maxBodySizeBytes;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Connection.Request maxBodySize(int bytes) {
            void var1_1;
            Validate.isTrue(bytes >= 0, "maxSize must be 0 (unlimited) or larger");
            this.maxBodySizeBytes = var1_1;
            return this;
        }

        @Override
        public boolean followRedirects() {
            return this.followRedirects;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Connection.Request followRedirects(boolean followRedirects) {
            void var1_1;
            this.followRedirects = var1_1;
            return this;
        }

        @Override
        public boolean ignoreHttpErrors() {
            return this.ignoreHttpErrors;
        }

        @Override
        public SSLSocketFactory sslSocketFactory() {
            return this.sslSocketFactory;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void sslSocketFactory(SSLSocketFactory sslSocketFactory) {
            void var1_1;
            this.sslSocketFactory = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Connection.Request ignoreHttpErrors(boolean ignoreHttpErrors) {
            void var1_1;
            this.ignoreHttpErrors = var1_1;
            return this;
        }

        @Override
        public boolean ignoreContentType() {
            return this.ignoreContentType;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Connection.Request ignoreContentType(boolean ignoreContentType) {
            void var1_1;
            this.ignoreContentType = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Request data(Connection.KeyVal keyval) {
            void var1_1;
            Validate.notNullParam(keyval, "keyval");
            this.data.add((Connection.KeyVal)var1_1);
            return this;
        }

        @Override
        public Collection<Connection.KeyVal> data() {
            return this.data;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Connection.Request requestBody(String body) {
            void var1_1;
            this.body = var1_1;
            return this;
        }

        @Override
        public String requestBody() {
            return this.body;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Request parser(Parser parser) {
            void var1_1;
            this.parser = var1_1;
            this.parserDefined = true;
            return this;
        }

        @Override
        public Parser parser() {
            return this.parser;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Connection.Request postDataCharset(String charset) {
            void var1_1;
            Validate.notNullParam(charset, "charset");
            if (!Charset.isSupported(charset)) {
                throw new IllegalCharsetNameException(charset);
            }
            this.postDataCharset = var1_1;
            return this;
        }

        @Override
        public String postDataCharset() {
            return this.postDataCharset;
        }

        CookieManager cookieManager() {
            return this.cookieManager;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ CookieManager access$002(Request x0, CookieManager x1) {
            void var1_1;
            x0.cookieManager = var1_1;
            return x0.cookieManager;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ boolean access$602(Request x0, boolean x1) {
            void var1_1;
            x0.executing = var1_1;
            return x0.executing;
        }

        static {
            System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        }
    }

    public static class Response
    extends Base<Connection.Response>
    implements Connection.Response {
        private static final int MAX_REDIRECTS = 20;
        private static final String LOCATION = "Location";
        private final int statusCode;
        private final String statusMessage;
        private ByteBuffer byteData;
        private InputStream bodyStream;
        private HttpURLConnection conn;
        private String charset;
        private final String contentType;
        private boolean executed = false;
        private boolean inputStreamRead = false;
        private int numRedirects = 0;
        private final Request req;
        private static final Pattern xmlContentTypeRxp = Pattern.compile("(application|text)/\\w*\\+?xml.*");

        Response() {
            this.statusCode = 400;
            this.statusMessage = "Request not made";
            this.req = new Request();
            this.contentType = null;
        }

        static Response execute(Request req) throws IOException {
            return Response.execute(req, null);
        }

        /*
         * WARNING - void declaration
         */
        static Response execute(Request req, Response previousResponse) throws IOException {
            void var3_11;
            block31: {
                int status;
                Response res;
                HttpURLConnection conn;
                long startTime;
                block30: {
                    void e;
                    boolean hasRequestBody;
                    Request request = req;
                    synchronized (request) {
                        Validate.isFalse(req.executing, "Multiple threads were detected trying to execute the same request concurrently. Make sure to use Connection#newRequest() and do not share an executing request between threads.");
                        Request.access$602(req, true);
                    }
                    Validate.notNullParam(req, "req");
                    URL url = req.url();
                    Validate.notNull(url, "URL must be specified to connect");
                    String protocol = url.getProtocol();
                    if (!protocol.equals("http") && !protocol.equals("https")) {
                        throw new MalformedURLException("Only http & https protocols supported");
                    }
                    boolean methodHasBody = req.method().hasBody();
                    boolean bl = hasRequestBody = req.requestBody() != null;
                    if (!methodHasBody) {
                        Validate.isFalse(hasRequestBody, "Cannot set a request body for HTTP method " + (Object)((Object)req.method()));
                    }
                    String mimeBoundary = null;
                    if (req.data().size() > 0 && (!methodHasBody || hasRequestBody)) {
                        Response.serialiseRequestUrl(req);
                    } else if (methodHasBody) {
                        mimeBoundary = Response.setOutputContentType(req);
                    }
                    startTime = System.nanoTime();
                    conn = Response.createConnection(req);
                    res = null;
                    conn.connect();
                    if (conn.getDoOutput()) {
                        try (OutputStream out = conn.getOutputStream();){
                            Response.writePost(req, out, mimeBoundary);
                        }
                    }
                    status = conn.getResponseCode();
                    res = new Response(conn, req, (Response)e);
                    if (!res.hasHeader(LOCATION) || !req.followRedirects()) break block30;
                    if (status != 307) {
                        req.method(Connection.Method.GET);
                        req.data().clear();
                        req.requestBody(null);
                        req.removeHeader(HttpConnection.CONTENT_TYPE);
                    }
                    String location = res.header(LOCATION);
                    Validate.notNull(location);
                    if (location.startsWith("http:/") && location.charAt(6) != '/') {
                        location = location.substring(6);
                    }
                    Object redir = StringUtil.resolve(req.url(), location);
                    req.url(HttpConnection.encodeUrl((URL)redir));
                    Request.access$602(req, false);
                    redir = Response.execute(req, res);
                    Request.access$602(req, false);
                    return redir;
                }
                try {
                    void var1_1;
                    if (!(status >= 200 && status < 400 || req.ignoreHttpErrors())) {
                        throw new HttpStatusException("HTTP error fetching URL", status, req.url().toString());
                    }
                    String contentType = res.contentType();
                    if (!(contentType == null || req.ignoreContentType() || contentType.startsWith("text/") || xmlContentTypeRxp.matcher(contentType).matches())) {
                        throw new UnsupportedMimeTypeException("Unhandled content type. Must be text/*, application/xml, or application/*+xml", contentType, req.url().toString());
                    }
                    if (contentType != null && xmlContentTypeRxp.matcher((CharSequence)var1_1).matches() && !req.parserDefined) {
                        req.parser(Parser.xmlParser());
                    }
                    res.charset = DataUtil.getCharsetFromContentType(res.contentType);
                    if (conn.getContentLength() != 0 && req.method() != Connection.Method.HEAD) {
                        void var2_7;
                        res.bodyStream = conn.getErrorStream() != null ? conn.getErrorStream() : var2_7.getInputStream();
                        Validate.notNull(res.bodyStream);
                        if (res.hasHeaderWithValue(HttpConnection.CONTENT_ENCODING, "gzip")) {
                            res.bodyStream = new GZIPInputStream(res.bodyStream);
                        } else if (res.hasHeaderWithValue(HttpConnection.CONTENT_ENCODING, "deflate")) {
                            res.bodyStream = new InflaterInputStream(res.bodyStream, new Inflater(true));
                        }
                        res.bodyStream = ConstrainableInputStream.wrap(res.bodyStream, 32768, req.maxBodySize()).timeout(startTime, req.timeout());
                        break block31;
                    }
                    res.byteData = DataUtil.emptyByteBuffer();
                }
                catch (IOException e) {
                    try {
                        if (res != null) {
                            super.safeClose();
                        }
                        throw e;
                    }
                    catch (Throwable throwable) {
                        Request request;
                        Request.access$602(request, false);
                        throw throwable;
                    }
                }
            }
            Request.access$602(req, false);
            res.executed = true;
            return var3_11;
        }

        @Override
        public int statusCode() {
            return this.statusCode;
        }

        @Override
        public String statusMessage() {
            return this.statusMessage;
        }

        @Override
        public String charset() {
            return this.charset;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Response charset(String charset) {
            void var1_1;
            this.charset = var1_1;
            return this;
        }

        @Override
        public String contentType() {
            return this.contentType;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Document parse() throws IOException {
            void var1_1;
            Validate.isTrue(this.executed, "Request must be executed (with .execute(), .get(), or .post() before parsing response");
            if (this.byteData != null) {
                this.bodyStream = new ByteArrayInputStream(this.byteData.array());
                this.inputStreamRead = false;
            }
            Validate.isFalse(this.inputStreamRead, "Input stream already read and parsed, cannot re-read.");
            Document doc = DataUtil.parseInputStream(this.bodyStream, this.charset, this.url.toExternalForm(), this.req.parser());
            doc.connection(new HttpConnection(this.req, this));
            this.charset = doc.outputSettings().charset().name();
            this.inputStreamRead = true;
            this.safeClose();
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private void prepareByteData() {
            Validate.isTrue(this.executed, "Request must be executed (with .execute(), .get(), or .post() before getting response body");
            if (this.bodyStream != null && this.byteData == null) {
                Validate.isFalse(this.inputStreamRead, "Request has already been read (with .parse())");
                try {
                    this.byteData = DataUtil.readToByteBuffer(this.bodyStream, this.req.maxBodySize());
                    return;
                }
                catch (IOException e) {
                    void var1_1;
                    throw new UncheckedIOException((IOException)var1_1);
                }
                finally {
                    this.inputStreamRead = true;
                    this.safeClose();
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String body() {
            void var1_1;
            this.prepareByteData();
            Validate.notNull(this.byteData);
            String body = (this.charset == null ? DataUtil.UTF_8 : Charset.forName(this.charset)).decode(this.byteData).toString();
            ((Buffer)this.byteData).rewind();
            return var1_1;
        }

        @Override
        public byte[] bodyAsBytes() {
            this.prepareByteData();
            Validate.notNull(this.byteData);
            return this.byteData.array();
        }

        @Override
        public Connection.Response bufferUp() {
            this.prepareByteData();
            return this;
        }

        @Override
        public BufferedInputStream bodyStream() {
            Validate.isTrue(this.executed, "Request must be executed (with .execute(), .get(), or .post() before getting response body");
            Validate.isFalse(this.inputStreamRead, "Request has already been read");
            this.inputStreamRead = true;
            return ConstrainableInputStream.wrap(this.bodyStream, 32768, this.req.maxBodySize());
        }

        /*
         * WARNING - void declaration
         */
        private static HttpURLConnection createConnection(Request req) throws IOException {
            void var1_1;
            Object object;
            Proxy proxy = req.proxy();
            HttpURLConnection conn = (HttpURLConnection)(proxy == null ? req.url().openConnection() : req.url().openConnection(proxy));
            conn.setRequestMethod(req.method().name());
            conn.setInstanceFollowRedirects(false);
            conn.setConnectTimeout(req.timeout());
            conn.setReadTimeout(req.timeout() / 2);
            if (req.sslSocketFactory() != null && conn instanceof HttpsURLConnection) {
                ((HttpsURLConnection)conn).setSSLSocketFactory(req.sslSocketFactory());
            }
            if (req.method().hasBody()) {
                conn.setDoOutput(true);
            }
            CookieUtil.applyCookiesToRequest(req, conn);
            for (Map.Entry entry : ((Request)object).multiHeaders().entrySet()) {
                for (String value : (List)entry.getValue()) {
                    conn.addRequestProperty((String)entry.getKey(), value);
                }
            }
            return var1_1;
        }

        private void safeClose() {
            if (this.bodyStream != null) {
                try {
                    this.bodyStream.close();
                }
                catch (IOException iOException) {
                }
                finally {
                    this.bodyStream = null;
                }
            }
            if (this.conn != null) {
                this.conn.disconnect();
                this.conn = null;
            }
        }

        /*
         * WARNING - void declaration
         */
        private Response(HttpURLConnection conn, Request request, Response previousResponse) throws IOException {
            Iterator iterator;
            this.conn = conn;
            this.req = request;
            this.method = Connection.Method.valueOf(conn.getRequestMethod());
            this.url = conn.getURL();
            this.statusCode = conn.getResponseCode();
            this.statusMessage = conn.getResponseMessage();
            this.contentType = conn.getContentType();
            LinkedHashMap<String, List<String>> resHeaders = Response.createHeaderMap(conn);
            this.processResponseHeaders(resHeaders);
            CookieUtil.storeCookies(this.req, this.url, (Map<String, List<String>>)((Object)iterator));
            if (previousResponse != null) {
                for (Map.Entry prevCookie : previousResponse.cookies().entrySet()) {
                    void var2_2;
                    if (this.hasCookie((String)prevCookie.getKey())) continue;
                    this.cookie((String)prevCookie.getKey(), (String)var2_2.getValue());
                }
                previousResponse.safeClose();
                this.numRedirects = previousResponse.numRedirects + 1;
                if (this.numRedirects >= 20) {
                    void var3_3;
                    throw new IOException(String.format("Too many redirects occurred trying to load URL %s", var3_3.url()));
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private static LinkedHashMap<String, List<String>> createHeaderMap(HttpURLConnection conn) {
            void var1_1;
            LinkedHashMap headers = new LinkedHashMap();
            int i = 0;
            while (true) {
                void var3_3;
                String key = conn.getHeaderFieldKey(i);
                String val = conn.getHeaderField(i);
                if (key == null && val == null) break;
                ++i;
                if (key == null || val == null) continue;
                if (headers.containsKey(key)) {
                    ((List)headers.get(key)).add(val);
                    continue;
                }
                ArrayList<String> vals = new ArrayList<String>();
                vals.add(val);
                headers.put(var3_3, vals);
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        void processResponseHeaders(Map<String, List<String>> resHeaders) {
            for (Map.Entry<String, List<String>> entry : resHeaders.entrySet()) {
                void var2_2;
                String name = entry.getKey();
                if (name == null) continue;
                List<String> values = entry.getValue();
                if (name.equalsIgnoreCase("Set-Cookie")) {
                    for (String value : values) {
                        if (value == null) continue;
                        TokenQueue cd = new TokenQueue(value);
                        String cookieName = cd.chompTo("=").trim();
                        String cookieVal = cd.consumeTo(";").trim();
                        if (cookieName.length() <= 0 || this.cookies.containsKey(cookieName)) continue;
                        this.cookie(cookieName, cookieVal);
                    }
                }
                for (String value : var2_2) {
                    this.addHeader(name, value);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private static String setOutputContentType(Connection.Request req) {
            void var2_2;
            String contentType = req.header(HttpConnection.CONTENT_TYPE);
            String bound = null;
            if (contentType != null) {
                void var1_1;
                if (contentType.contains(HttpConnection.MULTIPART_FORM_DATA) && !var1_1.contains("boundary")) {
                    bound = DataUtil.mimeBoundary();
                    req.header(HttpConnection.CONTENT_TYPE, "multipart/form-data; boundary=" + bound);
                }
            } else if (HttpConnection.needsMultipart(req)) {
                bound = DataUtil.mimeBoundary();
                req.header(HttpConnection.CONTENT_TYPE, "multipart/form-data; boundary=" + bound);
            } else {
                Connection.Request request;
                req.header(HttpConnection.CONTENT_TYPE, "application/x-www-form-urlencoded; charset=" + request.postDataCharset());
            }
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        private static void writePost(Connection.Request req, OutputStream outputStream, String boundary) throws IOException {
            Iterator iterator;
            Collection<Connection.KeyVal> data = req.data();
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter(outputStream, Charset.forName(req.postDataCharset())));
            if (boundary != null) {
                void var2_2;
                for (Connection.KeyVal keyVal : data) {
                    w.write("--");
                    w.write(boundary);
                    w.write("\r\n");
                    w.write("Content-Disposition: form-data; name=\"");
                    w.write(HttpConnection.encodeMimeName(keyVal.key()));
                    w.write("\"");
                    InputStream input = keyVal.inputStream();
                    if (input != null) {
                        w.write("; filename=\"");
                        w.write(HttpConnection.encodeMimeName(keyVal.value()));
                        w.write("\"\r\nContent-Type: ");
                        String contentType = keyVal.contentType();
                        w.write(contentType != null ? contentType : HttpConnection.DefaultUploadType);
                        w.write("\r\n\r\n");
                        w.flush();
                        DataUtil.crossStreams(iterator, outputStream);
                        outputStream.flush();
                    } else {
                        w.write("\r\n\r\n");
                        w.write(keyVal.value());
                    }
                    w.write("\r\n");
                }
                w.write("--");
                w.write((String)var2_2);
                w.write("--");
            } else {
                String body = req.requestBody();
                if (body != null) {
                    w.write(body);
                } else {
                    boolean first = true;
                    iterator = iterator.iterator();
                    while (iterator.hasNext()) {
                        Connection.KeyVal keyVal = (Connection.KeyVal)iterator.next();
                        if (!first) {
                            w.append('&');
                        } else {
                            first = false;
                        }
                        w.write(URLEncoder.encode(keyVal.key(), req.postDataCharset()));
                        w.write(61);
                        w.write(URLEncoder.encode(keyVal.value(), req.postDataCharset()));
                    }
                }
            }
            w.close();
        }

        /*
         * WARNING - void declaration
         */
        private static void serialiseRequestUrl(Connection.Request req) throws IOException {
            Connection.Request request;
            void var2_2;
            URL in = req.url();
            StringBuilder url = StringUtil.borrowBuilder();
            boolean first = true;
            url.append(in.getProtocol()).append("://").append(in.getAuthority()).append(in.getPath()).append("?");
            if (in.getQuery() != null) {
                Iterator<Connection.KeyVal> iterator;
                url.append(((URL)((Object)iterator)).getQuery());
                first = false;
            }
            for (Connection.KeyVal keyVal : req.data()) {
                Validate.isFalse(keyVal.hasInputStream(), "InputStream data not supported in URL query string.");
                if (!first) {
                    url.append('&');
                } else {
                    first = false;
                }
                url.append(URLEncoder.encode(keyVal.key(), DataUtil.defaultCharsetName)).append('=').append(URLEncoder.encode(keyVal.value(), DataUtil.defaultCharsetName));
            }
            req.url(new URL(StringUtil.releaseBuilder((StringBuilder)var2_2)));
            request.data().clear();
        }
    }

    public static class KeyVal
    implements Connection.KeyVal {
        private String key;
        private String value;
        private InputStream stream;
        private String contentType;

        /*
         * WARNING - void declaration
         */
        public static KeyVal create(String key, String value) {
            void var1_1;
            String string;
            return new KeyVal(string, (String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public static KeyVal create(String key, String filename, InputStream stream) {
            void var2_2;
            void var1_1;
            String string;
            return new KeyVal(string, (String)var1_1).inputStream((InputStream)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        private KeyVal(String key, String value) {
            void var2_2;
            void var1_1;
            Validate.notEmptyParam(key, "key");
            Validate.notNullParam(value, "value");
            this.key = var1_1;
            this.value = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public KeyVal key(String key) {
            void var1_1;
            Validate.notEmptyParam(key, "key");
            this.key = var1_1;
            return this;
        }

        @Override
        public String key() {
            return this.key;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public KeyVal value(String value) {
            void var1_1;
            Validate.notNullParam(value, "value");
            this.value = var1_1;
            return this;
        }

        @Override
        public String value() {
            return this.value;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public KeyVal inputStream(InputStream inputStream) {
            void var1_1;
            Validate.notNullParam(this.value, "inputStream");
            this.stream = var1_1;
            return this;
        }

        @Override
        public InputStream inputStream() {
            return this.stream;
        }

        @Override
        public boolean hasInputStream() {
            return this.stream != null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Connection.KeyVal contentType(String contentType) {
            void var1_1;
            Validate.notEmpty(contentType);
            this.contentType = var1_1;
            return this;
        }

        @Override
        public String contentType() {
            return this.contentType;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    private static abstract class Base<T extends Connection.Base<T>>
    implements Connection.Base<T> {
        private static final URL UnsetUrl;
        URL url = UnsetUrl;
        Connection.Method method = Connection.Method.GET;
        Map<String, List<String>> headers;
        Map<String, String> cookies;

        private Base() {
            this.headers = new LinkedHashMap<String, List<String>>();
            this.cookies = new LinkedHashMap<String, String>();
        }

        /*
         * WARNING - void declaration
         */
        private Base(Base<T> copy) {
            void var1_1;
            this.url = copy.url;
            this.method = copy.method;
            this.headers = new LinkedHashMap<String, List<String>>();
            for (Map.Entry<String, List<String>> entry : copy.headers.entrySet()) {
                void var3_3;
                this.headers.put(entry.getKey(), new ArrayList((Collection)var3_3.getValue()));
            }
            this.cookies = new LinkedHashMap<String, String>();
            this.cookies.putAll(var1_1.cookies);
        }

        @Override
        public URL url() {
            if (this.url == UnsetUrl) {
                throw new IllegalArgumentException("URL not set. Make sure to call #url(...) before executing the request.");
            }
            return this.url;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public T url(URL url) {
            void var1_1;
            Validate.notNullParam(url, "url");
            this.url = HttpConnection.punyUrl((URL)var1_1);
            return (T)this;
        }

        @Override
        public Connection.Method method() {
            return this.method;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public T method(Connection.Method method) {
            void var1_1;
            Validate.notNullParam((Object)method, "method");
            this.method = var1_1;
            return (T)this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String header(String name) {
            Validate.notNullParam(name, "name");
            List<String> vals = this.getHeadersCaseInsensitive(name);
            if (vals.size() > 0) {
                void var1_1;
                return StringUtil.join(var1_1, ", ");
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public T addHeader(String name, String value) {
            void var2_2;
            void var3_3;
            Validate.notEmptyParam(name, "name");
            value = value == null ? "" : value;
            List<String> values = this.headers(name);
            if (values.isEmpty()) {
                void var1_1;
                values = new ArrayList<String>();
                this.headers.put((String)var1_1, values);
            }
            var3_3.add(Base.fixHeaderEncoding((String)var2_2));
            return (T)this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public List<String> headers(String name) {
            void var1_1;
            Validate.notEmptyParam(name, "name");
            return this.getHeadersCaseInsensitive((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private static String fixHeaderEncoding(String val) {
            void var1_1;
            byte[] bytes = val.getBytes(ISO_8859_1);
            if (!Base.looksLikeUtf8(bytes)) {
                String string;
                return string;
            }
            return new String((byte[])var1_1, UTF_8);
        }

        private static boolean looksLikeUtf8(byte[] input) {
            int i = 0;
            if (input.length >= 3 && (input[0] & 0xFF) == 239 && (input[1] & 0xFF) == 187 && (input[2] & 0xFF) == 191) {
                i = 3;
            }
            int j = input.length;
            while (i < j) {
                byte o = input[i];
                if ((o & 0x80) != 0) {
                    int end;
                    if ((o & 0xE0) == 192) {
                        end = i + 1;
                    } else if ((o & 0xF0) == 224) {
                        end = i + 2;
                    } else if ((o & 0xF8) == 240) {
                        end = i + 3;
                    } else {
                        return false;
                    }
                    if (end >= input.length) {
                        return false;
                    }
                    while (i < end) {
                        byte by;
                        if (((by = input[++i]) & 0xC0) == 128) continue;
                        return false;
                    }
                }
                ++i;
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public T header(String name, String value) {
            void var2_2;
            void var1_1;
            Validate.notEmptyParam(name, "name");
            this.removeHeader(name);
            this.addHeader((String)var1_1, (String)var2_2);
            return (T)this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean hasHeader(String name) {
            void var1_1;
            Validate.notEmptyParam(name, "name");
            return !this.getHeadersCaseInsensitive((String)var1_1).isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean hasHeaderWithValue(String name, String value) {
            Object object;
            Validate.notEmpty(name);
            Validate.notEmpty(value);
            object = this.headers((String)object);
            object = object.iterator();
            while (object.hasNext()) {
                void var3_3;
                String candidate = (String)object.next();
                if (!value.equalsIgnoreCase((String)var3_3)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public T removeHeader(String name) {
            Validate.notEmptyParam(name, "name");
            Map.Entry<String, List<String>> entry = this.scanHeaders(name);
            if (entry != null) {
                void var1_1;
                this.headers.remove(var1_1.getKey());
            }
            return (T)this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map<String, String> headers() {
            void var1_1;
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(this.headers.size());
            for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
                void var3_3;
                String header = entry.getKey();
                List<String> values = entry.getValue();
                if (values.size() <= 0) continue;
                map.put(header, (String)var3_3.get(0));
            }
            return var1_1;
        }

        @Override
        public Map<String, List<String>> multiHeaders() {
            return this.headers;
        }

        /*
         * WARNING - void declaration
         */
        private List<String> getHeadersCaseInsensitive(String name) {
            Validate.notNull(name);
            for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
                void var3_3;
                if (!name.equalsIgnoreCase(entry.getKey())) continue;
                return (List)var3_3.getValue();
            }
            return Collections.emptyList();
        }

        /*
         * WARNING - void declaration
         */
        private Map.Entry<String, List<String>> scanHeaders(String name) {
            String lc = Normalizer.lowerCase(name);
            for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
                void var3_3;
                if (!Normalizer.lowerCase(entry.getKey()).equals(lc)) continue;
                return var3_3;
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String cookie(String name) {
            void var1_1;
            Validate.notEmptyParam(name, "name");
            return this.cookies.get(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public T cookie(String name, String value) {
            void var2_2;
            void var1_1;
            Validate.notEmptyParam(name, "name");
            Validate.notNullParam(value, "value");
            this.cookies.put((String)var1_1, (String)var2_2);
            return (T)this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean hasCookie(String name) {
            void var1_1;
            Validate.notEmptyParam(name, "name");
            return this.cookies.containsKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public T removeCookie(String name) {
            void var1_1;
            Validate.notEmptyParam(name, "name");
            this.cookies.remove(var1_1);
            return (T)this;
        }

        @Override
        public Map<String, String> cookies() {
            return this.cookies;
        }

        /*
         * WARNING - void declaration
         */
        static {
            try {
                UnsetUrl = new URL("http://undefined/");
                return;
            }
            catch (MalformedURLException e) {
                void var0;
                throw new IllegalStateException((Throwable)var0);
            }
        }
    }
}

