/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.helper;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Locale;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.jsoup.UncheckedIOException;
import org.jsoup.helper.Validate;
import org.jsoup.internal.ConstrainableInputStream;
import org.jsoup.internal.Normalizer;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.XmlDeclaration;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;

public final class DataUtil {
    private static final Pattern charsetPattern = Pattern.compile("(?i)\\bcharset=\\s*(?:[\"'])?([^\\s,;\"']*)");
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    static final String defaultCharsetName = UTF_8.name();
    private static final int firstReadBufferSize = 5120;
    static final int bufferSize = 32768;
    private static final char[] mimeBoundaryChars = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    static final int boundaryLength = 32;

    private DataUtil() {
    }

    /*
     * WARNING - void declaration
     */
    public static Document load(File file, String charsetName, String baseUri) throws IOException {
        void var2_2;
        void var1_1;
        return DataUtil.load(file, (String)var1_1, (String)var2_2, Parser.htmlParser());
    }

    /*
     * WARNING - void declaration
     */
    public static Document load(File file, String charsetName, String baseUri, Parser parser) throws IOException {
        void var3_4;
        void var2_3;
        void var1_2;
        InputStream stream = new FileInputStream(file);
        String name = Normalizer.lowerCase(file.getName());
        if (name.endsWith(".gz") || name.endsWith(".z")) {
            File file2;
            boolean zipped;
            try {
                zipped = ((InputStream)stream).read() == 31 && ((InputStream)stream).read() == 139;
            }
            finally {
                ((InputStream)stream).close();
            }
            stream = zipped ? new GZIPInputStream(new FileInputStream(file)) : new FileInputStream(file2);
        }
        return DataUtil.parseInputStream(stream, (String)var1_2, (String)var2_3, (Parser)var3_4);
    }

    /*
     * WARNING - void declaration
     */
    public static Document load(InputStream in, String charsetName, String baseUri) throws IOException {
        void var2_2;
        void var1_1;
        return DataUtil.parseInputStream(in, (String)var1_1, (String)var2_2, Parser.htmlParser());
    }

    /*
     * WARNING - void declaration
     */
    public static Document load(InputStream in, String charsetName, String baseUri, Parser parser) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        return DataUtil.parseInputStream(in, (String)var1_1, (String)var2_2, (Parser)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static void crossStreams(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[32768];
        while ((len = in.read(buffer)) != -1) {
            void var3_3;
            out.write(buffer, 0, (int)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    static Document parseInputStream(InputStream input, String charsetName, String baseUri, Parser parser) throws IOException {
        Document doc;
        block27: {
            if (input == null) {
                return new Document(baseUri);
            }
            input = ConstrainableInputStream.wrap(input, 32768, 0);
            doc = null;
            try {
                input.mark(32768);
                ByteBuffer firstBytes = DataUtil.readToByteBuffer(input, 5119);
                boolean fullyRead = input.read() == -1;
                input.reset();
                BomCharset bomCharset = DataUtil.detectCharsetFromBom(firstBytes);
                if (bomCharset != null) {
                    charsetName = bomCharset.charset;
                }
                if (charsetName == null) {
                    Object defaultDecoded;
                    try {
                        defaultDecoded = UTF_8.decode(firstBytes);
                        doc = ((CharBuffer)defaultDecoded).hasArray() ? parser.parseInput(new CharArrayReader(((CharBuffer)defaultDecoded).array(), ((CharBuffer)defaultDecoded).arrayOffset(), ((Buffer)defaultDecoded).limit()), baseUri) : parser.parseInput(((CharBuffer)defaultDecoded).toString(), baseUri);
                    }
                    catch (UncheckedIOException uncheckedIOException) {
                        defaultDecoded = uncheckedIOException;
                        throw uncheckedIOException.ioException();
                    }
                    Elements metaElements = doc.select("meta[http-equiv=content-type], meta[charset]");
                    String foundCharset = null;
                    for (Element meta : metaElements) {
                        if (meta.hasAttr("http-equiv")) {
                            foundCharset = DataUtil.getCharsetFromContentType(meta.attr("content"));
                        }
                        if (foundCharset == null && meta.hasAttr("charset")) {
                            foundCharset = meta.attr("charset");
                        }
                        if (foundCharset == null) continue;
                    }
                    if (foundCharset == null && ((Node)doc).childNodeSize() > 0) {
                        Comment comment;
                        Node first = doc.childNode(0);
                        XmlDeclaration decl = null;
                        if (first instanceof XmlDeclaration) {
                            decl = (XmlDeclaration)first;
                        } else if (first instanceof Comment && (comment = (Comment)first).isXmlDeclaration()) {
                            decl = comment.asXmlDeclaration();
                        }
                        if (decl != null && decl.name().equalsIgnoreCase("xml")) {
                            foundCharset = ((Node)decl).attr("encoding");
                        }
                    }
                    if ((foundCharset = DataUtil.validateCharset(foundCharset)) != null && !foundCharset.equalsIgnoreCase(defaultCharsetName)) {
                        charsetName = foundCharset = foundCharset.trim().replaceAll("[\"']", "");
                        doc = null;
                    } else if (!fullyRead) {
                        doc = null;
                    }
                } else {
                    Validate.notEmpty(charsetName, "Must set charset arg to character set of file to parse. Set to null to attempt to detect from HTML");
                }
                if (doc != null) break block27;
                if (charsetName == null) {
                    charsetName = defaultCharsetName;
                }
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, Charset.forName(charsetName)), 32768);){
                    void var1_1;
                    if (bomCharset != null && bomCharset.offset) {
                        long foundCharset = reader.skip(1L);
                        Validate.isTrue(foundCharset == 1L);
                    }
                    try {
                        void var2_4;
                        void var3_5;
                        doc = var3_5.parseInput(reader, (String)var2_4);
                    }
                    catch (UncheckedIOException uncheckedIOException) {
                        UncheckedIOException foundCharset = uncheckedIOException;
                        throw uncheckedIOException.ioException();
                    }
                    Charset charset = charsetName.equals(defaultCharsetName) ? UTF_8 : Charset.forName((String)var1_1);
                    doc.outputSettings().charset(charset);
                    if (!charset.canEncode()) {
                        doc.charset(UTF_8);
                    }
                }
            }
            catch (Throwable throwable) {
                InputStream inputStream;
                inputStream.close();
                throw throwable;
            }
        }
        input.close();
        return doc;
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuffer readToByteBuffer(InputStream inStream, int maxSize) throws IOException {
        void var1_1;
        InputStream inputStream;
        Validate.isTrue(maxSize >= 0, "maxSize must be 0 (unlimited) or larger");
        inputStream = ConstrainableInputStream.wrap(inputStream, 32768, maxSize);
        return ((ConstrainableInputStream)inputStream).readToByteBuffer((int)var1_1);
    }

    static ByteBuffer emptyByteBuffer() {
        return ByteBuffer.allocate(0);
    }

    static String getCharsetFromContentType(String contentType) {
        if (contentType == null) {
            return null;
        }
        Matcher m = charsetPattern.matcher(contentType);
        if (m.find()) {
            Matcher matcher;
            matcher = matcher.group(1).trim();
            matcher = ((String)((Object)matcher)).replace("charset=", "");
            return DataUtil.validateCharset((String)((Object)matcher));
        }
        return null;
    }

    private static String validateCharset(String cs) {
        if (cs == null || cs.length() == 0) {
            return null;
        }
        cs = cs.trim().replaceAll("[\"']", "");
        try {
            if (Charset.isSupported(cs)) {
                return cs;
            }
            if (Charset.isSupported(cs = cs.toUpperCase(Locale.ENGLISH))) {
                String string;
                return string;
            }
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {}
        return null;
    }

    /*
     * WARNING - void declaration
     */
    static String mimeBoundary() {
        void var0;
        StringBuilder mime = StringUtil.borrowBuilder();
        Random rand = new Random();
        for (int i = 0; i < 32; ++i) {
            mime.append(mimeBoundaryChars[rand.nextInt(mimeBoundaryChars.length)]);
        }
        return StringUtil.releaseBuilder((StringBuilder)var0);
    }

    /*
     * WARNING - void declaration
     */
    private static BomCharset detectCharsetFromBom(ByteBuffer byteData) {
        void var2_2;
        ByteBuffer buffer = byteData;
        ((Buffer)buffer).mark();
        byte[] bom = new byte[4];
        if (byteData.remaining() >= bom.length) {
            void var1_1;
            ByteBuffer byteBuffer;
            byteBuffer.get(bom);
            var1_1.rewind();
        }
        if (bom[0] == 0 && bom[1] == 0 && bom[2] == -2 && bom[3] == -1 || bom[0] == -1 && bom[1] == -2 && bom[2] == 0 && bom[3] == 0) {
            return new BomCharset("UTF-32", false);
        }
        if (bom[0] == -2 && bom[1] == -1 || bom[0] == -1 && bom[1] == -2) {
            return new BomCharset("UTF-16", false);
        }
        if (bom[0] == -17 && bom[1] == -69 && var2_2[2] == -65) {
            return new BomCharset("UTF-8", true);
        }
        return null;
    }

    private static class BomCharset {
        private final String charset;
        private final boolean offset;

        /*
         * WARNING - void declaration
         */
        public BomCharset(String charset, boolean offset) {
            void var2_2;
            void var1_1;
            this.charset = var1_1;
            this.offset = var2_2;
        }
    }
}

