/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.helper;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jsoup.Connection;
import org.jsoup.helper.HttpConnection;
import org.jsoup.internal.StringUtil;

class CookieUtil {
    private static final Map<String, List<String>> EmptyRequestHeaders = Collections.unmodifiableMap(new HashMap());
    private static final String Sep = "; ";
    private static final String CookieName = "Cookie";
    private static final String Cookie2Name = "Cookie2";

    CookieUtil() {
    }

    /*
     * WARNING - void declaration
     */
    static void applyCookiesToRequest(HttpConnection.Request req, HttpURLConnection con) throws IOException {
        Iterator<Map.Entry<String, List<String>>> iterator;
        LinkedHashSet<String> cookieSet = CookieUtil.requestCookieSet(req);
        HashSet cookies2 = null;
        iterator = req.cookieManager().get(CookieUtil.asUri(((HttpConnection.Base)((Object)iterator)).url), EmptyRequestHeaders);
        for (Map.Entry<String, List<String>> entry : iterator.entrySet()) {
            HashSet set;
            List<String> cookies = entry.getValue();
            if (cookies == null || cookies.size() == 0) continue;
            String key = entry.getKey();
            if (CookieName.equals(key)) {
                set = cookieSet;
            } else {
                if (!Cookie2Name.equals(set)) continue;
                set = new HashSet();
                cookies2 = set;
            }
            set.addAll(cookies);
        }
        if (cookieSet.size() > 0) {
            void var2_2;
            con.addRequestProperty(CookieName, StringUtil.join(var2_2, Sep));
        }
        if (cookies2 != null && cookies2.size() > 0) {
            void var3_3;
            void var1_1;
            var1_1.addRequestProperty(Cookie2Name, StringUtil.join(var3_3, Sep));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static LinkedHashSet<String> requestCookieSet(Connection.Request req) {
        void var1_1;
        Object object;
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (Map.Entry entry : object.cookies().entrySet()) {
            set.add((String)entry.getKey() + "=" + (String)entry.getValue());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static URI asUri(URL url) throws IOException {
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            void var1_2;
            void var0_1;
            MalformedURLException ue = new MalformedURLException(e.getMessage());
            ue.initCause((Throwable)var0_1);
            throw var1_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    static void storeCookies(HttpConnection.Request req, URL url, Map<String, List<String>> resHeaders) throws IOException {
        void var2_2;
        void var1_1;
        req.cookieManager().put(CookieUtil.asUri((URL)var1_1), (Map<String, List<String>>)var2_2);
    }
}

