/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.ssl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.ToIntFunction;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.AbstractEndPoint;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.WriteFlusher;
import org.eclipse.jetty.io.ssl.SslHandshakeListener;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Invocable;

public class SslConnection
extends AbstractConnection
implements Connection.UpgradeTo {
    private static final Logger LOG = Log.getLogger(SslConnection.class);
    private static final String TLS_1_3 = "TLSv1.3";
    private final AtomicReference<HandshakeState> _handshake = new AtomicReference<HandshakeState>(HandshakeState.INITIAL);
    private final List<SslHandshakeListener> handshakeListeners = new ArrayList<SslHandshakeListener>();
    private final AtomicLong _bytesIn = new AtomicLong();
    private final AtomicLong _bytesOut = new AtomicLong();
    private final ByteBufferPool _bufferPool;
    private final SSLEngine _sslEngine;
    private final DecryptedEndPoint _decryptedEndPoint;
    private ByteBuffer _decryptedInput;
    private ByteBuffer _encryptedInput;
    private ByteBuffer _encryptedOutput;
    private final boolean _encryptedDirectBuffers;
    private final boolean _decryptedDirectBuffers;
    private boolean _renegotiationAllowed;
    private int _renegotiationLimit = -1;
    private boolean _closedOutbound;
    private boolean _requireCloseMessage;
    private FlushState _flushState = FlushState.IDLE;
    private FillState _fillState = FillState.IDLE;
    private boolean _underflown;
    private final Runnable _runFillable = new RunnableTask("runFillable"){
        {
            void var2_2;
            void var1_1;
            super((String)var2_2);
        }

        @Override
        public void run() {
            SslConnection.this._decryptedEndPoint.getFillInterest().fillable();
        }

        public Invocable.InvocationType getInvocationType() {
            return SslConnection.this._decryptedEndPoint.getFillInterest().getCallbackInvocationType();
        }
    };
    private final Callback _sslReadCallback = new Callback(this){
        final /* synthetic */ SslConnection this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        public void succeeded() {
            ((AbstractConnection)this.this$0).onFillable();
        }

        /*
         * WARNING - void declaration
         */
        public void failed(Throwable x) {
            void var1_1;
            this.this$0.onFillInterestedFailed((Throwable)var1_1);
        }

        public Invocable.InvocationType getInvocationType() {
            return this.this$0.getDecryptedEndPoint().getFillInterest().getCallbackInvocationType();
        }

        public String toString() {
            return String.format("SSLC.NBReadCB@%x{%s}", this.this$0.hashCode(), this.this$0);
        }
    };

    /*
     * WARNING - void declaration
     */
    public SslConnection(ByteBufferPool byteBufferPool, Executor executor, EndPoint endPoint, SSLEngine sslEngine) {
        this((ByteBufferPool)var1_1, (Executor)var2_2, (EndPoint)var3_3, sslEngine, false, false);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SslConnection(ByteBufferPool byteBufferPool, Executor executor, EndPoint endPoint, SSLEngine sslEngine, boolean useDirectBuffersForEncryption, boolean useDirectBuffersForDecryption) {
        super((EndPoint)var3_3, (Executor)var2_2);
        void var1_1;
        void var2_2;
        void var3_3;
        this._bufferPool = var1_1;
        this._sslEngine = sslEngine;
        this._decryptedEndPoint = this.newDecryptedEndPoint();
        this._encryptedDirectBuffers = useDirectBuffersForEncryption;
        this._decryptedDirectBuffers = useDirectBuffersForDecryption;
    }

    @Override
    public long getBytesIn() {
        return this._bytesIn.get();
    }

    @Override
    public long getBytesOut() {
        return this._bytesOut.get();
    }

    /*
     * WARNING - void declaration
     */
    public void addHandshakeListener(SslHandshakeListener listener) {
        void var1_1;
        this.handshakeListeners.add((SslHandshakeListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean removeHandshakeListener(SslHandshakeListener listener) {
        void var1_1;
        return this.handshakeListeners.remove(var1_1);
    }

    protected DecryptedEndPoint newDecryptedEndPoint() {
        return new DecryptedEndPoint(this);
    }

    public SSLEngine getSSLEngine() {
        return this._sslEngine;
    }

    public DecryptedEndPoint getDecryptedEndPoint() {
        return this._decryptedEndPoint;
    }

    public boolean isRenegotiationAllowed() {
        return this._renegotiationAllowed;
    }

    /*
     * WARNING - void declaration
     */
    public void setRenegotiationAllowed(boolean renegotiationAllowed) {
        void var1_1;
        this._renegotiationAllowed = var1_1;
    }

    public int getRenegotiationLimit() {
        return this._renegotiationLimit;
    }

    /*
     * WARNING - void declaration
     */
    public void setRenegotiationLimit(int renegotiationLimit) {
        void var1_1;
        this._renegotiationLimit = var1_1;
    }

    @Deprecated
    public boolean isAllowMissingCloseMessage() {
        return !this.isRequireCloseMessage();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setAllowMissingCloseMessage(boolean allowMissingCloseMessage) {
        void var1_1;
        this.setRequireCloseMessage(var1_1 == false);
    }

    public boolean isRequireCloseMessage() {
        return this._requireCloseMessage;
    }

    /*
     * WARNING - void declaration
     */
    public void setRequireCloseMessage(boolean requireCloseMessage) {
        void var1_1;
        this._requireCloseMessage = var1_1;
    }

    private boolean isHandshakeInitial() {
        return this._handshake.get() == HandshakeState.INITIAL;
    }

    private boolean isHandshakeSucceeded() {
        return this._handshake.get() == HandshakeState.SUCCEEDED;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isHandshakeComplete() {
        void var1_1;
        HandshakeState state = this._handshake.get();
        return state == HandshakeState.SUCCEEDED || var1_1 == HandshakeState.FAILED;
    }

    private int getApplicationBufferSize() {
        return this.getBufferSize(SSLSession::getApplicationBufferSize);
    }

    private int getPacketBufferSize() {
        return this.getBufferSize(SSLSession::getPacketBufferSize);
    }

    /*
     * WARNING - void declaration
     */
    private int getBufferSize(ToIntFunction<SSLSession> bufferSizeFn) {
        void var2_3;
        void var1_1;
        void var3_4;
        SSLSession hsSession = this._sslEngine.getHandshakeSession();
        SSLSession session = this._sslEngine.getSession();
        int size = bufferSizeFn.applyAsInt(session);
        if (hsSession == null || hsSession == var3_4) {
            return size;
        }
        int n = var1_1.applyAsInt(var2_3);
        return Math.max(n, size);
    }

    private void acquireEncryptedInput() {
        if (this._encryptedInput == null) {
            this._encryptedInput = this._bufferPool.acquire(this.getPacketBufferSize(), this._encryptedDirectBuffers);
        }
    }

    private void acquireEncryptedOutput() {
        if (this._encryptedOutput == null) {
            this._encryptedOutput = this._bufferPool.acquire(this.getPacketBufferSize(), this._encryptedDirectBuffers);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onUpgradeTo(ByteBuffer buffer) {
        void var1_1;
        this.acquireEncryptedInput();
        BufferUtil.append((ByteBuffer)this._encryptedInput, (ByteBuffer)var1_1);
    }

    @Override
    public void onOpen() {
        super.onOpen();
        this.getDecryptedEndPoint().getConnection().onOpen();
    }

    @Override
    public void onClose() {
        this._decryptedEndPoint.getConnection().onClose();
        super.onClose();
    }

    @Override
    public void close() {
        this.getDecryptedEndPoint().getConnection().close();
    }

    @Override
    public boolean onIdleExpired() {
        return this.getDecryptedEndPoint().getConnection().onIdleExpired();
    }

    @Override
    public void onFillable() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">c.onFillable {}", new Object[]{this});
        }
        if (((AbstractEndPoint)this._decryptedEndPoint).isInputShutdown()) {
            this._decryptedEndPoint.close();
        }
        this._decryptedEndPoint.onFillable();
        if (LOG.isDebugEnabled()) {
            LOG.debug("<c.onFillable {}", new Object[]{this});
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onFillInterestedFailed(Throwable cause) {
        void var1_1;
        this._decryptedEndPoint.onFillableFail((Throwable)(cause == null ? new IOException() : var1_1));
    }

    /*
     * WARNING - void declaration
     */
    protected SSLEngineResult wrap(SSLEngine sslEngine, ByteBuffer[] input, ByteBuffer output) throws SSLException {
        void var3_3;
        void var2_2;
        return sslEngine.wrap((ByteBuffer[])var2_2, (ByteBuffer)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected SSLEngineResult unwrap(SSLEngine sslEngine, ByteBuffer input, ByteBuffer output) throws SSLException {
        void var3_3;
        void var2_2;
        return sslEngine.unwrap((ByteBuffer)var2_2, (ByteBuffer)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toConnectionString() {
        void var1_2;
        void var3_4;
        void var2_3;
        ByteBuffer b = this._encryptedInput;
        int ei = b == null ? -1 : b.remaining();
        b = this._encryptedOutput;
        int eo = b == null ? -1 : b.remaining();
        b = this._decryptedInput;
        int di = b == null ? -1 : b.remaining();
        Connection connection = this._decryptedEndPoint.getConnection();
        return String.format("%s@%x{%s,eio=%d/%d,di=%d,fill=%s,flush=%s}~>%s=>%s", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this._sslEngine.getHandshakeStatus(), (int)var2_3, (int)var3_4, (int)var1_2, this._fillState, this._flushState, this._decryptedEndPoint.toEndPointString(), connection instanceof AbstractConnection ? ((AbstractConnection)connection).toConnectionString() : connection});
    }

    private void releaseEncryptedInputBuffer() {
        if (this._encryptedInput != null && !this._encryptedInput.hasRemaining()) {
            this._bufferPool.release(this._encryptedInput);
            this._encryptedInput = null;
        }
    }

    protected void releaseDecryptedInputBuffer() {
        if (this._decryptedInput != null && !this._decryptedInput.hasRemaining()) {
            this._bufferPool.release(this._decryptedInput);
            this._decryptedInput = null;
        }
    }

    private void releaseEncryptedOutputBuffer() {
        if (!Thread.holdsLock(this._decryptedEndPoint)) {
            throw new IllegalStateException();
        }
        if (this._encryptedOutput != null && !this._encryptedOutput.hasRemaining()) {
            this._bufferPool.release(this._encryptedOutput);
            this._encryptedOutput = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected int networkFill(ByteBuffer input) throws IOException {
        void var1_1;
        return this.getEndPoint().fill((ByteBuffer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean networkFlush(ByteBuffer output) throws IOException {
        void var1_1;
        return this.getEndPoint().flush(new ByteBuffer[]{var1_1});
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ FillState access$302(SslConnection x0, FillState x1) {
        void var1_1;
        x0._fillState = var1_1;
        return x0._fillState;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ FlushState access$402(SslConnection x0, FlushState x1) {
        void var1_1;
        x0._flushState = var1_1;
        return x0._flushState;
    }

    static /* synthetic */ void access$800(SslConnection x0) {
        x0.acquireEncryptedInput();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ ByteBuffer access$602(SslConnection x0, ByteBuffer x1) {
        void var1_1;
        x0._decryptedInput = var1_1;
        return x0._decryptedInput;
    }

    static /* synthetic */ boolean access$900(SslConnection x0) {
        return x0._decryptedDirectBuffers;
    }

    static /* synthetic */ ByteBufferPool access$1000(SslConnection x0) {
        return x0._bufferPool;
    }

    static /* synthetic */ AtomicLong access$1200(SslConnection x0) {
        return x0._bytesIn;
    }

    static /* synthetic */ boolean access$1300(SslConnection x0) {
        return x0.isHandshakeInitial();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$1602(SslConnection x0, boolean x1) {
        void var1_1;
        x0._underflown = var1_1;
        return x0._underflown;
    }

    static /* synthetic */ Executor access$1700(SslConnection x0) {
        return x0.getExecutor();
    }

    static /* synthetic */ void access$1800(SslConnection x0) {
        x0.releaseEncryptedInputBuffer();
    }

    static /* synthetic */ Executor access$1900(SslConnection x0) {
        return x0.getExecutor();
    }

    static /* synthetic */ AtomicLong access$2500(SslConnection x0) {
        return x0._bytesOut;
    }

    static /* synthetic */ int access$2600(SslConnection x0) {
        return x0.getPacketBufferSize();
    }

    static /* synthetic */ void access$2700(SslConnection x0) {
        x0.acquireEncryptedOutput();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$2902(SslConnection x0, boolean x1) {
        void var1_1;
        x0._closedOutbound = var1_1;
        return x0._closedOutbound;
    }

    public class DecryptedEndPoint
    extends AbstractEndPoint {
        private final Callback _incompleteWriteCallback;
        private Throwable _failure;
        final /* synthetic */ SslConnection this$0;

        /*
         * WARNING - void declaration
         */
        public DecryptedEndPoint(SslConnection this$0) {
            void var1_1;
            this.this$0 = var1_1;
            super(null);
            this._incompleteWriteCallback = new IncompleteWriteCallback();
            super.setIdleTimeout(-1L);
        }

        @Override
        public long getIdleTimeout() {
            return this.this$0.getEndPoint().getIdleTimeout();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void setIdleTimeout(long idleTimeout) {
            void var1_1;
            this.this$0.getEndPoint().setIdleTimeout((long)var1_1);
        }

        @Override
        public boolean isOpen() {
            return this.this$0.getEndPoint().isOpen();
        }

        @Override
        public InetSocketAddress getLocalAddress() {
            return this.this$0.getEndPoint().getLocalAddress();
        }

        @Override
        public InetSocketAddress getRemoteAddress() {
            return this.this$0.getEndPoint().getRemoteAddress();
        }

        @Override
        public WriteFlusher getWriteFlusher() {
            return super.getWriteFlusher();
        }

        /*
         * WARNING - void declaration
         */
        protected void onFillable() {
            try {
                boolean waitingForFill;
                DecryptedEndPoint decryptedEndPoint = this.this$0._decryptedEndPoint;
                synchronized (decryptedEndPoint) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("onFillable {}", new Object[]{this.this$0});
                    }
                    SslConnection.access$302(this.this$0, FillState.IDLE);
                    waitingForFill = this.this$0._flushState == FlushState.WAIT_FOR_FILL;
                }
                this.getFillInterest().fillable();
                if (waitingForFill) {
                    decryptedEndPoint = this.this$0._decryptedEndPoint;
                    synchronized (decryptedEndPoint) {
                        waitingForFill = this.this$0._flushState == FlushState.WAIT_FOR_FILL;
                    }
                    if (waitingForFill) {
                        this.fill(BufferUtil.EMPTY_BUFFER);
                    }
                }
                return;
            }
            catch (Throwable e) {
                void var1_5;
                this.close((Throwable)var1_5);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        protected void onFillableFail(Throwable failure) {
            void var2_3;
            boolean fail = false;
            DecryptedEndPoint decryptedEndPoint = this.this$0._decryptedEndPoint;
            synchronized (decryptedEndPoint) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("onFillableFail {}", new Object[]{this.this$0, failure});
                }
                SslConnection.access$302(this.this$0, FillState.IDLE);
                if (this.this$0._flushState == FlushState.WAIT_FOR_FILL) {
                    SslConnection.access$402(this.this$0, FlushState.IDLE);
                    fail = true;
                }
            }
            this.getFillInterest().onFail(failure);
            if (var2_3 != false && !((AbstractEndPoint)this).getWriteFlusher().onFail(failure)) {
                void var1_1;
                this.close((Throwable)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void setConnection(Connection connection) {
            void var1_1;
            if (connection instanceof AbstractConnection) {
                AbstractConnection c = (AbstractConnection)connection;
                int appBufferSize = this.this$0.getApplicationBufferSize();
                if (c.getInputBufferSize() < appBufferSize) {
                    void var3_3;
                    void var2_2;
                    var2_2.setInputBufferSize((int)var3_3);
                }
            }
            super.setConnection((Connection)var1_1);
        }

        public SslConnection getSslConnection() {
            return this.this$0;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int fill(ByteBuffer buffer) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 24[MONITOR]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void needsFillInterest() {
            block17: {
                try {
                    void var3_2;
                    boolean fillable;
                    ByteBuffer write = null;
                    boolean interest = false;
                    DecryptedEndPoint decryptedEndPoint = this.this$0._decryptedEndPoint;
                    synchronized (decryptedEndPoint) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(">needFillInterest s={}/{} uf={} ei={} di={} {}", new Object[]{this.this$0._flushState, this.this$0._fillState, this.this$0._underflown, BufferUtil.toDetailString((ByteBuffer)this.this$0._encryptedInput), BufferUtil.toDetailString((ByteBuffer)this.this$0._decryptedInput), this.this$0});
                        }
                        if (this.this$0._fillState != FillState.IDLE) {
                            return;
                        }
                        fillable = BufferUtil.hasContent((ByteBuffer)this.this$0._decryptedInput) || BufferUtil.hasContent((ByteBuffer)this.this$0._encryptedInput) && !this.this$0._underflown;
                        SSLEngineResult.HandshakeStatus status = this.this$0._sslEngine.getHandshakeStatus();
                        switch (status) {
                            case NEED_TASK: {
                                fillable = true;
                                break;
                            }
                            case NEED_UNWRAP: 
                            case NOT_HANDSHAKING: {
                                if (fillable) break;
                                interest = true;
                                SslConnection.access$302(this.this$0, FillState.INTERESTED);
                                if (this.this$0._flushState != FlushState.IDLE || !BufferUtil.hasContent((ByteBuffer)this.this$0._encryptedOutput)) break;
                                SslConnection.access$402(this.this$0, FlushState.WRITING);
                                write = this.this$0._encryptedOutput;
                                break;
                            }
                            case NEED_WRAP: {
                                if (fillable) break;
                                SslConnection.access$302(this.this$0, FillState.WAIT_FOR_FLUSH);
                                if (this.this$0._flushState != FlushState.IDLE) break;
                                SslConnection.access$402(this.this$0, FlushState.WRITING);
                                write = BufferUtil.hasContent((ByteBuffer)this.this$0._encryptedOutput) ? this.this$0._encryptedOutput : BufferUtil.EMPTY_BUFFER;
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unexpected HandshakeStatus " + (Object)((Object)status));
                            }
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("<needFillInterest s={}/{} f={} i={} w={}", new Object[]{this.this$0._flushState, this.this$0._fillState, fillable, interest, BufferUtil.toDetailString((ByteBuffer)write)});
                        }
                    }
                    if (write != null) {
                        void var2_1;
                        this.this$0.getEndPoint().write(this._incompleteWriteCallback, new ByteBuffer[]{var2_1});
                        break block17;
                    }
                    if (fillable) {
                        this.this$0.getExecutor().execute(this.this$0._runFillable);
                        break block17;
                    }
                    if (var3_2 != false) {
                        this.ensureFillInterested();
                    }
                    return;
                }
                catch (Throwable x) {
                    void var1_6;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(this.this$0.toString(), x);
                    }
                    this.close(x);
                    throw var1_6;
                }
            }
        }

        private void handshakeSucceeded() throws SSLException {
            if (this.this$0._handshake.compareAndSet(HandshakeState.HANDSHAKE, HandshakeState.SUCCEEDED)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("handshake succeeded {} {} {}/{}", new Object[]{this.this$0, this.this$0._sslEngine.getUseClientMode() ? "client" : "resumed server", this.this$0._sslEngine.getSession().getProtocol(), this.this$0._sslEngine.getSession().getCipherSuite()});
                }
                DecryptedEndPoint decryptedEndPoint = this;
                decryptedEndPoint.notifyHandshakeSucceeded(decryptedEndPoint.this$0._sslEngine);
                return;
            }
            if (this.this$0.isHandshakeSucceeded() && this.this$0._renegotiationLimit > 0) {
                this.this$0._renegotiationLimit--;
            }
        }

        /*
         * WARNING - void declaration
         */
        private Throwable handshakeFailed(Throwable failure) {
            void var1_1;
            if (this.this$0._handshake.compareAndSet(HandshakeState.HANDSHAKE, HandshakeState.FAILED)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("handshake failed {} {}", new Object[]{this.this$0, failure});
                }
                if (!(failure instanceof SSLHandshakeException)) {
                    failure = new SSLHandshakeException(failure.getMessage()).initCause(failure);
                }
                DecryptedEndPoint decryptedEndPoint = this;
                decryptedEndPoint.notifyHandshakeFailed(decryptedEndPoint.this$0._sslEngine, failure);
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private void terminateInput() {
            try {
                this.this$0._sslEngine.closeInbound();
                return;
            }
            catch (Throwable x) {
                void var1_1;
                LOG.ignore((Throwable)var1_1);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        private Throwable closeInbound() throws SSLException {
            SSLEngineResult.HandshakeStatus handshakeStatus = this.this$0._sslEngine.getHandshakeStatus();
            try {
                this.this$0._sslEngine.closeInbound();
                return null;
            }
            catch (SSLException x) {
                void var1_1;
                if (var1_1 == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && this.this$0.isRequireCloseMessage()) {
                    throw x;
                }
                LOG.ignore((Throwable)x);
                return x;
            }
            catch (Throwable x) {
                void var2_3;
                LOG.ignore(x);
                return var2_3;
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public boolean flush(ByteBuffer ... appOuts) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 23[MONITOR]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void onIncompleteFlush() {
            try {
                void var2_4;
                boolean fillInterest = false;
                ByteBuffer write = null;
                DecryptedEndPoint decryptedEndPoint = this.this$0._decryptedEndPoint;
                synchronized (decryptedEndPoint) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(">onIncompleteFlush {} {}", new Object[]{this.this$0, BufferUtil.toDetailString((ByteBuffer)this.this$0._encryptedOutput)});
                    }
                    if (this.this$0._flushState != FlushState.IDLE) {
                        return;
                    }
                    block11: while (true) {
                        SSLEngineResult.HandshakeStatus status = this.this$0._sslEngine.getHandshakeStatus();
                        switch (status) {
                            case NOT_HANDSHAKING: 
                            case NEED_TASK: 
                            case NEED_WRAP: {
                                write = BufferUtil.hasContent((ByteBuffer)this.this$0._encryptedOutput) ? this.this$0._encryptedOutput : BufferUtil.EMPTY_BUFFER;
                                SslConnection.access$402(this.this$0, FlushState.WRITING);
                                break block11;
                            }
                            case NEED_UNWRAP: {
                                if (BufferUtil.hasContent((ByteBuffer)this.this$0._encryptedOutput)) {
                                    write = this.this$0._encryptedOutput;
                                    SslConnection.access$402(this.this$0, FlushState.WRITING);
                                    break block11;
                                }
                                if (this.this$0._fillState != FillState.IDLE) {
                                    SslConnection.access$402(this.this$0, FlushState.WAIT_FOR_FILL);
                                    break block11;
                                }
                                try {
                                    int filled = this.fill(BufferUtil.EMPTY_BUFFER);
                                    if (this.this$0._sslEngine.getHandshakeStatus() != status) continue block11;
                                    if (filled < 0) {
                                        throw new IOException("Broken pipe");
                                    }
                                }
                                catch (IOException e) {
                                    LOG.debug((Throwable)e);
                                    this.close(e);
                                    write = BufferUtil.EMPTY_BUFFER;
                                    SslConnection.access$402(this.this$0, FlushState.WRITING);
                                    break block11;
                                }
                                fillInterest = true;
                                SslConnection.access$302(this.this$0, FillState.INTERESTED);
                                SslConnection.access$402(this.this$0, FlushState.WAIT_FOR_FILL);
                                break block11;
                            }
                            default: {
                                throw new IllegalStateException("Unexpected HandshakeStatus " + (Object)((Object)status));
                            }
                        }
                        break;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("<onIncompleteFlush s={}/{} fi={} w={}", new Object[]{this.this$0._flushState, this.this$0._fillState, fillInterest, BufferUtil.toDetailString((ByteBuffer)write)});
                    }
                }
                if (write == null) {
                    if (fillInterest) {
                        this.ensureFillInterested();
                    }
                    return;
                }
                this.this$0.getEndPoint().write(this._incompleteWriteCallback, new ByteBuffer[]{var2_4});
            }
            catch (Throwable x) {
                void var1_3;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.this$0.toString(), x);
                }
                this.close(x);
                throw var1_3;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void doShutdownOutput() {
            EndPoint endPoint = this.this$0.getEndPoint();
            try {
                void var3_2;
                boolean close;
                boolean flush = false;
                DecryptedEndPoint decryptedEndPoint = this.this$0._decryptedEndPoint;
                synchronized (decryptedEndPoint) {
                    boolean ishut = endPoint.isInputShutdown();
                    boolean oshut = endPoint.isOutputShutdown();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("shutdownOutput: {} oshut={}, ishut={}", new Object[]{this.this$0, oshut, ishut});
                    }
                    this.closeOutbound();
                    if (!this.this$0._closedOutbound) {
                        SslConnection.access$2902(this.this$0, true);
                        flush = !oshut;
                    }
                    close = ishut;
                }
                if (var3_2 != false && !this.flush(BufferUtil.EMPTY_BUFFER) && !close) {
                    ByteBuffer write = null;
                    DecryptedEndPoint decryptedEndPoint2 = this.this$0._decryptedEndPoint;
                    synchronized (decryptedEndPoint2) {
                        if (BufferUtil.hasContent((ByteBuffer)this.this$0._encryptedOutput)) {
                            write = this.this$0._encryptedOutput;
                            SslConnection.access$402(this.this$0, FlushState.WRITING);
                        }
                    }
                    if (write != null) {
                        endPoint.write(Callback.from(() -> {
                            DecryptedEndPoint decryptedEndPoint = this.this$0._decryptedEndPoint;
                            synchronized (decryptedEndPoint) {
                                SslConnection.access$402(this.this$0, FlushState.IDLE);
                                this.this$0.releaseEncryptedOutputBuffer();
                                return;
                            }
                        }, t -> endPoint.close()), write);
                    }
                }
                if (!close) {
                    this.ensureFillInterested();
                    return;
                }
                endPoint.close();
            }
            catch (Throwable x) {
                void var1_1;
                void var2_9;
                LOG.ignore((Throwable)var2_9);
                var1_1.close();
            }
        }

        /*
         * WARNING - void declaration
         */
        private void closeOutbound() {
            try {
                this.this$0._sslEngine.closeOutbound();
                return;
            }
            catch (Throwable x) {
                if (LOG.isDebugEnabled()) {
                    void var1_1;
                    LOG.debug((Throwable)var1_1);
                }
                return;
            }
        }

        private void ensureFillInterested() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ensureFillInterested {}", new Object[]{this.this$0});
            }
            this.this$0.tryFillInterested(this.this$0._sslReadCallback);
        }

        @Override
        public boolean isOutputShutdown() {
            return this.isOutboundDone() || this.this$0.getEndPoint().isOutputShutdown();
        }

        /*
         * WARNING - void declaration
         */
        private boolean isOutboundDone() {
            try {
                return this.this$0._sslEngine.isOutboundDone();
            }
            catch (Throwable x) {
                void var1_1;
                LOG.ignore((Throwable)var1_1);
                return true;
            }
        }

        @Override
        public void doClose() {
            this.doShutdownOutput();
            this.this$0.getEndPoint().close();
            super.doClose();
        }

        @Override
        public Object getTransport() {
            return this.this$0.getEndPoint();
        }

        @Override
        public boolean isInputShutdown() {
            return BufferUtil.isEmpty((ByteBuffer)this.this$0._decryptedInput) && (this.this$0.getEndPoint().isInputShutdown() || this.isInboundDone());
        }

        /*
         * WARNING - void declaration
         */
        private boolean isInboundDone() {
            try {
                return this.this$0._sslEngine.isInboundDone();
            }
            catch (Throwable x) {
                void var1_1;
                LOG.ignore((Throwable)var1_1);
                return true;
            }
        }

        private void notifyHandshakeSucceeded(SSLEngine sslEngine) throws SSLException {
            SslHandshakeListener.Event event = null;
            for (SslHandshakeListener listener : this.this$0.handshakeListeners) {
                if (event == null) {
                    event = new SslHandshakeListener.Event(sslEngine);
                }
                try {
                    listener.handshakeSucceeded(event);
                }
                catch (SSLException sSLException) {
                    SSLException sSLException2 = sSLException;
                    throw sSLException;
                }
                catch (Throwable x) {
                    LOG.info("Exception while notifying listener " + listener, x);
                }
            }
        }

        private void notifyHandshakeFailed(SSLEngine sslEngine, Throwable failure) {
            SslHandshakeListener.Event event = null;
            for (SslHandshakeListener listener : this.this$0.handshakeListeners) {
                if (event == null) {
                    event = new SslHandshakeListener.Event(sslEngine);
                }
                try {
                    listener.handshakeFailed(event, failure);
                }
                catch (Throwable x) {
                    LOG.info("Exception while notifying listener " + listener, x);
                }
            }
        }

        private boolean isRenegotiating() {
            if (!this.this$0.isHandshakeComplete()) {
                return false;
            }
            if (this.isTLS13()) {
                return false;
            }
            return this.this$0._sslEngine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
        }

        private boolean allowRenegotiate() {
            if (!this.this$0.isRenegotiationAllowed()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Renegotiation denied {}", new Object[]{this.this$0});
                }
                this.terminateInput();
                return false;
            }
            if (this.this$0.getRenegotiationLimit() == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Renegotiation limit exceeded {}", new Object[]{this.this$0});
                }
                this.terminateInput();
                return false;
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private boolean isTLS13() {
            void var1_1;
            String protocol = this.this$0._sslEngine.getSession().getProtocol();
            return SslConnection.TLS_1_3.equals(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private Throwable handleException(Throwable x, String context) {
            DecryptedEndPoint decryptedEndPoint = this.this$0._decryptedEndPoint;
            synchronized (decryptedEndPoint) {
                if (this._failure == null) {
                    this._failure = x;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(this + " stored " + context + " exception", x);
                    }
                } else if (x != this._failure) {
                    this._failure.addSuppressed(x);
                    if (LOG.isDebugEnabled()) {
                        void var1_1;
                        void var2_3;
                        LOG.debug(this + " suppressed " + (String)var2_3 + " exception", (Throwable)var1_1);
                    }
                }
                return this._failure;
            }
        }

        /*
         * WARNING - void declaration
         */
        private void rethrow(Throwable x) throws IOException {
            void var1_1;
            if (x instanceof RuntimeException) {
                throw (RuntimeException)x;
            }
            if (x instanceof Error) {
                throw (Error)x;
            }
            if (x instanceof IOException) {
                throw (IOException)x;
            }
            throw new IOException((Throwable)var1_1);
        }

        @Override
        public String toString() {
            return super.toEndPointString();
        }

        private /* synthetic */ void lambda$fill$1() {
            ((AbstractEndPoint)this.this$0._decryptedEndPoint).getWriteFlusher().completeWrite();
        }

        /*
         * WARNING - void declaration
         */
        private /* synthetic */ void lambda$fill$0(Throwable failure) {
            void var1_1;
            ((AbstractEndPoint)this.this$0._decryptedEndPoint).getWriteFlusher().onFail((Throwable)var1_1);
        }

        private final class IncompleteWriteCallback
        implements Callback,
        Invocable {
            private IncompleteWriteCallback() {
            }

            /*
             * WARNING - void declaration
             */
            public final void succeeded() {
                void var1_3;
                void var2_2;
                DecryptedEndPoint decryptedEndPoint = DecryptedEndPoint.this.this$0._decryptedEndPoint;
                synchronized (decryptedEndPoint) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("IncompleteWriteCB succeeded {}", new Object[]{DecryptedEndPoint.this.this$0});
                    }
                    DecryptedEndPoint.this.this$0.releaseEncryptedOutputBuffer();
                    SslConnection.access$402(DecryptedEndPoint.this.this$0, FlushState.IDLE);
                    boolean interested = DecryptedEndPoint.this.this$0._fillState == FillState.INTERESTED;
                    boolean fillable = DecryptedEndPoint.this.this$0._fillState == FillState.WAIT_FOR_FLUSH;
                    if (fillable) {
                        SslConnection.access$302(DecryptedEndPoint.this.this$0, FillState.IDLE);
                    }
                }
                if (var2_2 != false) {
                    DecryptedEndPoint.this.ensureFillInterested();
                } else if (var1_3 != false) {
                    DecryptedEndPoint.this.this$0._decryptedEndPoint.getFillInterest().fillable();
                }
                ((AbstractEndPoint)DecryptedEndPoint.this.this$0._decryptedEndPoint).getWriteFlusher().completeWrite();
            }

            /*
             * WARNING - void declaration
             */
            public final void failed(Throwable x) {
                void var1_1;
                void var2_4;
                DecryptedEndPoint decryptedEndPoint = DecryptedEndPoint.this.this$0._decryptedEndPoint;
                synchronized (decryptedEndPoint) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("IncompleteWriteCB failed {}", new Object[]{DecryptedEndPoint.this.this$0, x});
                    }
                    BufferUtil.clear((ByteBuffer)DecryptedEndPoint.this.this$0._encryptedOutput);
                    DecryptedEndPoint.this.this$0.releaseEncryptedOutputBuffer();
                    SslConnection.access$402(DecryptedEndPoint.this.this$0, FlushState.IDLE);
                    boolean failFillInterest = DecryptedEndPoint.this.this$0._fillState == FillState.WAIT_FOR_FLUSH || DecryptedEndPoint.this.this$0._fillState == FillState.INTERESTED;
                    if (failFillInterest) {
                        SslConnection.access$302(DecryptedEndPoint.this.this$0, FillState.IDLE);
                    }
                }
                DecryptedEndPoint.this.this$0.getExecutor().execute(() -> this.lambda$failed$0((boolean)var2_4, (Throwable)var1_1));
            }

            public final Invocable.InvocationType getInvocationType() {
                return ((AbstractEndPoint)DecryptedEndPoint.this.this$0._decryptedEndPoint).getWriteFlusher().getCallbackInvocationType();
            }

            public final String toString() {
                return String.format("SSL@%h.DEP.writeCallback", DecryptedEndPoint.this.this$0);
            }

            /*
             * WARNING - void declaration
             */
            private /* synthetic */ void lambda$failed$0(boolean failFillInterest, Throwable x) {
                void var2_2;
                if (failFillInterest) {
                    DecryptedEndPoint.this.this$0._decryptedEndPoint.getFillInterest().onFail(x);
                }
                ((AbstractEndPoint)DecryptedEndPoint.this.this$0._decryptedEndPoint).getWriteFlusher().onFail((Throwable)var2_2);
            }
        }
    }

    private abstract class RunnableTask
    implements Runnable,
    Invocable {
        private final String _operation;

        /*
         * WARNING - void declaration
         */
        protected RunnableTask(String op) {
            void var2_2;
            this._operation = var2_2;
        }

        public String toString() {
            return String.format("SSL:%s:%s:%s", SslConnection.this, this._operation, this.getInvocationType());
        }
    }

    private static enum FlushState {
        IDLE,
        WRITING,
        WAIT_FOR_FILL;

    }

    private static enum FillState {
        IDLE,
        INTERESTED,
        WAIT_FOR_FLUSH;

    }

    private static enum HandshakeState {
        INITIAL,
        HANDSHAKE,
        SUCCEEDED,
        FAILED;

    }
}

