/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.ssl;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.io.ssl.SslHandshakeListener;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class SslClientConnectionFactory
implements ClientConnectionFactory {
    public static final String SSL_CONTEXT_FACTORY_CONTEXT_KEY = "ssl.context.factory";
    public static final String SSL_PEER_HOST_CONTEXT_KEY = "ssl.peer.host";
    public static final String SSL_PEER_PORT_CONTEXT_KEY = "ssl.peer.port";
    public static final String SSL_ENGINE_CONTEXT_KEY = "ssl.engine";
    private final SslContextFactory sslContextFactory;
    private final ByteBufferPool byteBufferPool;
    private final Executor executor;
    private final ClientConnectionFactory connectionFactory;
    private boolean _directBuffersForEncryption = true;
    private boolean _directBuffersForDecryption = true;
    private boolean _requireCloseMessage;

    /*
     * WARNING - void declaration
     */
    public SslClientConnectionFactory(SslContextFactory sslContextFactory, ByteBufferPool byteBufferPool, Executor executor, ClientConnectionFactory connectionFactory) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.sslContextFactory = (SslContextFactory)Objects.requireNonNull(var1_1, "Missing SslContextFactory");
        this.byteBufferPool = var2_2;
        this.executor = var3_3;
        this.connectionFactory = connectionFactory;
    }

    /*
     * WARNING - void declaration
     */
    public void setDirectBuffersForEncryption(boolean useDirectBuffers) {
        void var1_1;
        this._directBuffersForEncryption = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setDirectBuffersForDecryption(boolean useDirectBuffers) {
        void var1_1;
        this._directBuffersForDecryption = var1_1;
    }

    public boolean isDirectBuffersForDecryption() {
        return this._directBuffersForDecryption;
    }

    public boolean isDirectBuffersForEncryption() {
        return this._directBuffersForEncryption;
    }

    @Deprecated
    public boolean isAllowMissingCloseMessage() {
        return !this.isRequireCloseMessage();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setAllowMissingCloseMessage(boolean allowMissingCloseMessage) {
        void var1_1;
        this.setRequireCloseMessage(var1_1 == false);
    }

    public boolean isRequireCloseMessage() {
        return this._requireCloseMessage;
    }

    /*
     * WARNING - void declaration
     */
    public void setRequireCloseMessage(boolean requireCloseMessage) {
        void var1_1;
        this._requireCloseMessage = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        void var1_1;
        void var2_2;
        void var3_3;
        String host = (String)context.get(SSL_PEER_HOST_CONTEXT_KEY);
        int port = (Integer)context.get(SSL_PEER_PORT_CONTEXT_KEY);
        SSLEngine engine = this.sslContextFactory instanceof SslEngineFactory ? ((SslEngineFactory)this.sslContextFactory).newSslEngine(host, port, context) : this.sslContextFactory.newSSLEngine(host, port);
        engine.setUseClientMode(true);
        context.put(SSL_ENGINE_CONTEXT_KEY, engine);
        SslClientConnectionFactory sslClientConnectionFactory = this;
        SslConnection sslConnection = sslClientConnectionFactory.newSslConnection(sslClientConnectionFactory.byteBufferPool, this.executor, endPoint, engine);
        SslConnection.DecryptedEndPoint appEndPoint = sslConnection.getDecryptedEndPoint();
        appEndPoint.setConnection(this.connectionFactory.newConnection((EndPoint)var3_3, context));
        sslConnection.addHandshakeListener(new HTTPSHandshakeListener(context));
        this.customize(sslConnection, (Map<String, Object>)var2_2);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected SslConnection newSslConnection(ByteBufferPool byteBufferPool, Executor executor, EndPoint endPoint, SSLEngine engine) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new SslConnection((ByteBufferPool)var1_1, (Executor)var2_2, (EndPoint)var3_3, engine, this.isDirectBuffersForEncryption(), this.isDirectBuffersForDecryption());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Connection customize(Connection connection, Map<String, Object> context) {
        void var2_2;
        void var1_1;
        if (connection instanceof SslConnection) {
            void var3_3;
            SslConnection sslConnection = (SslConnection)connection;
            sslConnection.setRenegotiationAllowed(this.sslContextFactory.isRenegotiationAllowed());
            sslConnection.setRenegotiationLimit(this.sslContextFactory.getRenegotiationLimit());
            sslConnection.setRequireCloseMessage(this.isRequireCloseMessage());
            ContainerLifeCycle containerLifeCycle = (ContainerLifeCycle)context.get("client.connector");
            containerLifeCycle.getBeans(SslHandshakeListener.class).forEach(((SslConnection)var3_3)::addHandshakeListener);
        }
        return ClientConnectionFactory.super.customize((Connection)var1_1, (Map<String, Object>)var2_2);
    }

    private class HTTPSHandshakeListener
    implements SslHandshakeListener {
        private final Map<String, Object> context;

        /*
         * WARNING - void declaration
         */
        private HTTPSHandshakeListener(Map<String, Object> context) {
            void var2_2;
            this.context = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void handshakeSucceeded(SslHandshakeListener.Event event) throws SSLException {
            HostnameVerifier verifier = SslClientConnectionFactory.this.sslContextFactory.getHostnameVerifier();
            if (verifier != null) {
                String host = (String)this.context.get(SslClientConnectionFactory.SSL_PEER_HOST_CONTEXT_KEY);
                try {
                    void var2_3;
                    if (!var2_3.verify(host, event.getSSLEngine().getSession())) {
                        throw new SSLPeerUnverifiedException("Host name verification failed for host: " + host);
                    }
                    return;
                }
                catch (SSLException sSLException) {
                    event = sSLException;
                    throw sSLException;
                }
                catch (Throwable x) {
                    void var1_2;
                    void var3_4;
                    throw (SSLException)new SSLPeerUnverifiedException("Host name verification failed for host: " + (String)var3_4).initCause((Throwable)var1_2);
                }
            }
        }
    }

    public static interface SslEngineFactory {
        public SSLEngine newSslEngine(String var1, int var2, Map<String, Object> var3);
    }
}

