/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritePendingException;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Invocable;

public abstract class WriteFlusher {
    private static final Logger LOG = Log.getLogger(WriteFlusher.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();
    private static final ByteBuffer[] EMPTY_BUFFERS = new ByteBuffer[]{BufferUtil.EMPTY_BUFFER};
    private static final EnumMap<StateType, Set<StateType>> __stateTransitions = new EnumMap(StateType.class);
    private static final State __IDLE = new IdleState();
    private static final State __WRITING = new WritingState();
    private static final State __COMPLETING = new CompletingState();
    private final EndPoint _endPoint;
    private final AtomicReference<State> _state = new AtomicReference();

    /*
     * WARNING - void declaration
     */
    protected WriteFlusher(EndPoint endPoint) {
        void var1_1;
        this._state.set(__IDLE);
        this._endPoint = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private boolean updateState(State previous, State next) {
        void var3_3;
        if (!this.isTransitionAllowed(previous, next)) {
            throw new IllegalStateException();
        }
        boolean updated = this._state.compareAndSet(previous, next);
        if (DEBUG) {
            void var2_2;
            void var1_1;
            LOG.debug("update {}:{}{}{}", new Object[]{this, var1_1, updated ? "-->" : "!->", var2_2});
        }
        return (boolean)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isTransitionAllowed(State currentState, State newState) {
        Set<StateType> set = __stateTransitions.get((Object)currentState.getType());
        if (!set.contains((Object)newState.getType())) {
            void var2_2;
            void var1_1;
            LOG.warn("{}: {} -> {} not allowed", new Object[]{this, var1_1, var2_2});
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public Invocable.InvocationType getCallbackInvocationType() {
        State s = this._state.get();
        if (s instanceof PendingState) {
            void var1_1;
            return ((PendingState)var1_1).getCallbackInvocationType();
        }
        return Invocable.InvocationType.BLOCKING;
    }

    protected abstract void onIncompleteFlush();

    /*
     * WARNING - void declaration
     */
    public void write(Callback callback, ByteBuffer ... buffers) throws WritePendingException {
        Objects.requireNonNull(callback);
        if (this.isFailed()) {
            this.fail(callback, new Throwable[0]);
            return;
        }
        if (DEBUG) {
            LOG.debug("write: {} {}", new Object[]{this, BufferUtil.toDetailString((ByteBuffer[])buffers)});
        }
        if (!this.updateState(__IDLE, __WRITING)) {
            throw new WritePendingException();
        }
        try {
            buffers = this.flush(buffers);
            if (buffers != null) {
                PendingState pending;
                if (DEBUG) {
                    LOG.debug("flushed incomplete", new Object[0]);
                }
                if (this.updateState(__WRITING, pending = new PendingState(buffers, callback))) {
                    this.onIncompleteFlush();
                    return;
                }
                this.fail(callback, new Throwable[0]);
                return;
            }
            if (!this.updateState(__WRITING, __IDLE)) {
                this.fail(callback, new Throwable[0]);
                return;
            }
            callback.succeeded();
        }
        catch (Throwable e) {
            void var2_3;
            void var1_1;
            if (DEBUG) {
                LOG.debug("write exception", e);
            }
            if (this.updateState(__WRITING, new FailedState(e))) {
                callback.failed(e);
                return;
            }
            this.fail((Callback)var1_1, new Throwable[]{var2_3});
        }
    }

    /*
     * WARNING - void declaration
     */
    private void fail(Callback callback, Throwable ... suppressed2) {
        void var3_8;
        void var2_2;
        void var1_1;
        Throwable cause;
        block4: while (true) {
            State state = this._state.get();
            switch (state.getType()) {
                case FAILED: {
                    Object object = (FailedState)state;
                    cause = object.getCause();
                    break block4;
                }
                case IDLE: {
                    Object object = suppressed2;
                    int suppressed2 = suppressed2.length;
                    for (int i = 0; i < suppressed2; ++i) {
                        Throwable t = object[i];
                        LOG.warn((Throwable)var1_1);
                    }
                    return;
                }
                default: {
                    IllegalStateException t;
                    if (!this._state.compareAndSet(state, new FailedState(t = new IllegalStateException()))) continue block4;
                    cause = t;
                }
            }
            break;
        }
        for (void t : var2_2) {
            if (t == cause) continue;
            cause.addSuppressed((Throwable)t);
        }
        var1_1.failed((Throwable)var3_8);
    }

    /*
     * WARNING - void declaration
     */
    public void completeWrite() {
        State previous;
        if (DEBUG) {
            LOG.debug("completeWrite: {}", new Object[]{this});
        }
        if ((previous = this._state.get()).getType() != StateType.PENDING) {
            return;
        }
        PendingState pending = (PendingState)previous;
        if (!this.updateState(pending, __COMPLETING)) {
            return;
        }
        Callback callback = pending._callback;
        try {
            ByteBuffer[] buffers = pending.getBuffers();
            buffers = this.flush(buffers);
            if (buffers != null) {
                void var1_1;
                if (DEBUG) {
                    LOG.debug("flushed incomplete {}", new Object[]{BufferUtil.toDetailString((ByteBuffer[])buffers)});
                }
                if (buffers != pending.getBuffers()) {
                    pending = new PendingState(buffers, callback);
                }
                if (this.updateState(__COMPLETING, (State)var1_1)) {
                    this.onIncompleteFlush();
                    return;
                }
                this.fail(callback, new Throwable[0]);
                return;
            }
            if (!this.updateState(__COMPLETING, __IDLE)) {
                this.fail(callback, new Throwable[0]);
                return;
            }
            callback.succeeded();
        }
        catch (Throwable e) {
            void var3_4;
            void var2_2;
            if (DEBUG) {
                LOG.debug("completeWrite exception", e);
            }
            if (this.updateState(__COMPLETING, new FailedState(e))) {
                callback.failed(e);
                return;
            }
            this.fail((Callback)var2_2, new Throwable[]{var3_4});
        }
    }

    /*
     * WARNING - void declaration
     */
    protected ByteBuffer[] flush(ByteBuffer[] buffers) throws IOException {
        void var1_1;
        boolean progress = true;
        while (progress && buffers != null) {
            void var3_3;
            boolean bl;
            Connection connection;
            long before = BufferUtil.remaining((ByteBuffer[])buffers);
            boolean flushed = this._endPoint.flush(buffers);
            long after = BufferUtil.remaining((ByteBuffer[])buffers);
            long written = before - after;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Flushed={} written={} remaining={} {}", new Object[]{flushed, written, after, this});
            }
            if (written > 0L && (connection = this._endPoint.getConnection()) instanceof Listener) {
                ((Listener)((Object)connection)).onFlushed(written);
            }
            if (bl) {
                return null;
            }
            bl = written > 0L;
            int index = 0;
            while (true) {
                if (index == buffers.length) {
                    buffers = null;
                    index = 0;
                    break;
                }
                int n = buffers[index].remaining();
                if (n > 0) break;
                ++index;
                bl = true;
            }
            if (index <= 0) continue;
            buffers = Arrays.copyOfRange(buffers, (int)var3_3, buffers.length);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("!fully flushed {}", new Object[]{this});
        }
        if (buffers == null) {
            return EMPTY_BUFFERS;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onFail(Throwable cause) {
        block5: while (true) {
            State current = this._state.get();
            switch (current.getType()) {
                case FAILED: 
                case IDLE: {
                    if (!DEBUG) return false;
                    LOG.debug("ignored: " + this, cause);
                    return false;
                }
                case PENDING: {
                    void var2_2;
                    PendingState pending;
                    if (DEBUG) {
                        LOG.debug("failed: " + this, cause);
                    }
                    if (!this.updateState(pending = (PendingState)current, new FailedState(cause))) continue block5;
                    ((PendingState)var2_2)._callback.failed(cause);
                    return true;
                }
                case WRITING: 
                case COMPLETING: {
                    void var2_2;
                    if (DEBUG) {
                        LOG.debug("failed: " + this, cause);
                    }
                    if (this.updateState((State)var2_2, new FailedState(cause))) return true;
                    continue block5;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    public void onClose() {
        switch (this._state.get().getType()) {
            case FAILED: 
            case IDLE: {
                return;
            }
        }
        this.onFail(new ClosedChannelException());
    }

    boolean isFailed() {
        return this.isState(StateType.FAILED);
    }

    boolean isIdle() {
        return this.isState(StateType.IDLE);
    }

    public boolean isPending() {
        return this.isState(StateType.PENDING);
    }

    /*
     * WARNING - void declaration
     */
    private boolean isState(StateType type) {
        void var1_1;
        return this._state.get().getType() == var1_1;
    }

    public String toStateString() {
        switch (this._state.get().getType()) {
            case WRITING: {
                return "W";
            }
            case PENDING: {
                return "P";
            }
            case COMPLETING: {
                return "C";
            }
            case IDLE: {
                return "-";
            }
            case FAILED: {
                return "F";
            }
        }
        return "?";
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        State s = this._state.get();
        return String.format("WriteFlusher@%x{%s}->%s", this.hashCode(), s, s instanceof PendingState ? ((PendingState)var1_1)._callback : null);
    }

    static {
        __stateTransitions.put(StateType.IDLE, EnumSet.of(StateType.WRITING));
        __stateTransitions.put(StateType.WRITING, EnumSet.of(StateType.IDLE, StateType.PENDING, StateType.FAILED));
        __stateTransitions.put(StateType.PENDING, EnumSet.of(StateType.COMPLETING, StateType.IDLE, StateType.FAILED));
        __stateTransitions.put(StateType.COMPLETING, EnumSet.of(StateType.IDLE, StateType.PENDING, StateType.FAILED));
        __stateTransitions.put(StateType.FAILED, EnumSet.noneOf(StateType.class));
    }

    public static interface Listener {
        public void onFlushed(long var1) throws IOException;
    }

    private class PendingState
    extends State {
        private final Callback _callback;
        private final ByteBuffer[] _buffers;

        /*
         * WARNING - void declaration
         */
        private PendingState(ByteBuffer[] buffers, Callback callback) {
            void var3_3;
            void var2_2;
            super(StateType.PENDING);
            this._buffers = var2_2;
            this._callback = var3_3;
        }

        public ByteBuffer[] getBuffers() {
            return this._buffers;
        }

        Invocable.InvocationType getCallbackInvocationType() {
            return Invocable.getInvocationType((Object)this._callback);
        }
    }

    private static class CompletingState
    extends State {
        private CompletingState() {
            super(StateType.COMPLETING);
        }
    }

    private static class FailedState
    extends State {
        private final Throwable _cause;

        /*
         * WARNING - void declaration
         */
        private FailedState(Throwable cause) {
            super(StateType.FAILED);
            void var1_1;
            this._cause = var1_1;
        }

        public Throwable getCause() {
            return this._cause;
        }
    }

    private static class WritingState
    extends State {
        private WritingState() {
            super(StateType.WRITING);
        }
    }

    private static class IdleState
    extends State {
        private IdleState() {
            super(StateType.IDLE);
        }
    }

    private static class State {
        private final StateType _type;

        /*
         * WARNING - void declaration
         */
        private State(StateType stateType) {
            void var1_1;
            this._type = var1_1;
        }

        public StateType getType() {
            return this._type;
        }

        public String toString() {
            return String.format("%s", new Object[]{this._type});
        }
    }

    private static enum StateType {
        IDLE,
        WRITING,
        PENDING,
        COMPLETING,
        FAILED;

    }
}

